/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.user;

import com.tridium.authn.BDigestAuthenticationScheme;
import com.tridium.hx.ErrorDialog;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.ConfirmDialog;
import com.tridium.smartTableHx.SaveCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsecHx.BHxAccessProfile;
import java.math.BigInteger;
import java.security.SecureRandom;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordCache;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"entsec:ChangePasskey"}, requiredPermissions="rR")})
@NiagaraSingleton
public class BHxChangePasskey
extends BHxView {
    public static final BHxChangePasskey INSTANCE = new BHxChangePasskey();
    public static final Type TYPE = Sys.loadType(BHxChangePasskey.class);
    private BPassword newPasskey = BPassword.make((String)"");
    public static final BIcon ICON = BIcon.std((String)"keys.png");
    private RestartStation restartStation;
    private SmartCommand save = new Save(this);
    private SmartCommand validate;
    protected static final Lexicon lex = Lexicon.make((String)Sys.getModuleForClass(BHxChangePasskey.class).getModuleName());

    public Type getType() {
        return TYPE;
    }

    protected BHxChangePasskey() {
        this.registerEvent((Event)this.save);
        this.validate = new Validate(this);
        this.registerEvent((Event)this.validate);
        this.restartStation = new RestartStation(this);
        this.registerEvent((Event)this.restartStation);
    }

    public void write(HxOp op) throws Exception {
        op.addStyleSheet(BOrd.make((String)"module://smartTableHx/rc/smartTable.css"));
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/smartTable.js"));
        op.addJavaScript(BOrd.make((String)"module://web/com/tridium/web/rc/loginN4.js"));
        HtmlWriter out = op.getHtmlWriter();
        op.addHeadTag("<script type='text/javascript' src='/login/core/auth.min.js'></script>");
        SmartCommand command = BHxChangePasskey.isDigest(op) ? this.save : this.validate;
        HxTabUtil.writeHeader((String)lex.getText("changePasskey"), (SmartCommand[])new SmartCommand[]{this.save}, (HxOp)op);
        HxTabUtil.getSpacerDiv((HxOp)op);
        HxTabUtil.startTable((HtmlWriter)out, (HxOp)op);
        HxTabUtil.startRow((String)lex.getText("userPassword"), (HtmlWriter)out, (HxOp)op);
        out.w((Object)"<input type='password' size='16' name='userPassword'");
        out.attr("autocomplete", "off");
        out.w((Object)">");
        HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
        HxTabUtil.endTable((HtmlWriter)out, (HxOp)op);
    }

    public static boolean isDigest(HxOp op) {
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        return userService.getAuthenticationSchemeForUser(op.getUser()) instanceof BDigestAuthenticationScheme;
    }

    private class RestartStation
    extends SmartCommand {
        private ConfirmDialog dialog;

        public String getName(HxOp hxOp) {
            return this.lexModule.getText("jaceMaintenance.restartStation", (Context)hxOp);
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public RestartStation(BHxView bHxView) {
            super(bHxView);
            this.dialog = new ConfirmDialog(this.lexModule.getText("jaceMaintenance.restartStation", null), (Command)this, "A station restart is required to change the passkey, do you want to continue?");
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dialog.isSubmit(op)) {
                try {
                    this.dialog.open(op);
                }
                catch (ServiceNotFoundException e) {
                    this.dialog.open(this.lexModule.getText("serverMaintenance.restartQuestion", (Context)op), op);
                }
                return;
            }
            ((BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE)).setModifiedPassKey(BHxChangePasskey.this.newPasskey);
            ((BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE)).restartStation();
            if (op.getProfile().getType().is(BHxAccessProfile.TYPE)) {
                BHxAccessProfile.disconnect(op);
            }
        }

        public boolean isAvailable(HxOp op) {
            return LocalSessionUtil.localDaemonIsAvailable();
        }
    }

    private class Validate
    extends SaveCommand {
        public Validate(BHxView view) {
            super(view);
        }

        public boolean registerOnInputs() {
            return false;
        }

        public void onHandle(HxOp op) throws Exception {
            String userPassword = op.getFormValue("userPassword");
            String message = null;
            if (!((BPasswordCache)op.getUser().getAuthenticator()).validate(userPassword == null ? "" : userPassword)) {
                message = "The user password was incorrect.";
            }
            if (message != null) {
                new ErrorDialog("Error", (Command)this, (Throwable)new Exception(message)).open(op);
                return;
            }
            if (!BHxChangePasskey.this.restartStation.isAvailable(op)) {
                new ErrorDialog("Error", (Command)this, (Throwable)new Exception("Local Daemon is not available, re-encryption cannot be performed.")).open(op);
                return;
            }
            HtmlWriter out = op.getHtmlWriter();
            BHxChangePasskey.this.newPasskey = BPassword.make((String)new BigInteger(60, new SecureRandom()).toString(32));
            out.w((Object)SmartCommand.getInvokeCode((Command)BHxChangePasskey.this.restartStation, (String)"'", (HxOp)op));
        }
    }

    private class Save
    extends SaveCommand {
        public Save(BHxView view) {
            super(view);
        }

        public String getDisplayName(HxOp op) {
            return "Generate New Passkey";
        }

        public BImage getIcon(HxOp op) {
            return BImage.make((BIcon)ICON);
        }

        public boolean registerOnInputs() {
            return true;
        }

        public void onHandle(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)SmartCommand.getInvokeCode((Command)BHxChangePasskey.this.validate, (String)"'", (HxOp)op));
        }
    }
}

