/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.threat;

import com.tridium.bql.filter.BFilterEntry;
import com.tridium.bql.filter.BStringFilter;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.hx.progress.HxProgressJobDialog;
import com.tridium.hx.util.HxUtils;
import com.tridium.nd.BNiagaraStation;
import com.tridium.orion.BIMappable;
import com.tridium.orion.BIOrionDatabaseObject;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionScheme;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.DynamicDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.BHxTabbedView;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.orionTools.BIOrdMappable;
import com.tridiumx.entsec.orionTools.BRefList;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsec.threat.BRetrieveThreatLevelActivationStatusJob;
import com.tridiumx.entsec.threat.BThreatLevelActivationJob;
import com.tridiumx.entsec.threat.BThreatLevelEntry;
import com.tridiumx.entsec.threat.BThreatLevelGroup;
import com.tridiumx.entsec.threat.BThreatLevelGroupRec;
import com.tridiumx.entsec.threat.BThreatLevelGroupRecs;
import com.tridiumx.entsec.threat.BThreatLevelSetup;
import com.tridiumx.entsecHx.orionHx.BHxDynamicTableView;
import com.tridiumx.entsecHx.orionToolsHx.BHxAddAppView;
import com.tridiumx.entsecHx.orionToolsHx.BHxAppTableView;
import com.tridiumx.entsecHx.orionToolsHx.BHxSmartRefFE;
import com.tridiumx.entsecHx.orionToolsHx.Delete;
import com.tridiumx.entsecHx.orionToolsHx.FilteredRedirectCommand;
import com.tridiumx.entsecHx.orionToolsHx.OrionBatchEditCommand;
import com.tridiumx.entsecHx.securityUtilHx.job.BHxAbstractJobView;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxBatchEditFieldSheet;
import com.tridiumx.entsecHx.threat.BHxActiveThreatLevelRangeFE;
import com.tridiumx.entsecHx.threat.BHxThreatLevelGroupRecView;
import java.net.ConnectException;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.table.BTable;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

@NiagaraType(agent={@AgentOn(types={"entsec:ThreatLevelGroupRecs"}, requiredPermissions="rR")})
@NiagaraSingleton
public class BHxThreatLevelGroupsView
extends BHxAppTableView
implements HxProgressJobDialog.IHxProgressDialogParent {
    public static final BHxThreatLevelGroupsView INSTANCE = new BHxThreatLevelGroupsView();
    public static final Type TYPE = Sys.loadType(BHxThreatLevelGroupsView.class);
    protected SmartCommand retrieveStatusCommand;
    protected SmartCommand threatLevelGroupBatchEditCommand;
    protected SmartCommand matchCommand;
    protected SmartCommand activeLevelCommand;
    protected SmartCommand addThreatLevelChildCommand;
    protected SmartCommand goInto;
    protected SmartCommand moveCommand;
    protected SmartCommand showTopLevel;
    protected SmartCommand threatDeleteCommand;
    public HxProgressJobDialog.ProgressEvent progressEvent = HxProgressJobDialog.makeProgress((String)lex.getText("working"), (BHxView)this, (HxProgressJobDialog.IHxProgressDialogParent)this);
    public ProgressCommand progressCommand;

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxThreatLevelGroupsView() {
        this.registerEvent((Event)this.progressEvent);
        this.progressCommand = new ProgressCommand((BHxView)this, this.progressEvent);
        this.registerEvent((Event)this.progressCommand);
        this.progressEvent.setJobCompleteHandler((HxProgressJobDialog.IJobCompleteHandler)this.progressCommand);
        this.activeLevelCommand = new ActiveLevelCommand((BHxView)this, this.progressCommand);
        this.registerEvent((Event)this.activeLevelCommand);
        this.retrieveStatusCommand = new RetrieveStatusCommand((BHxView)this, this.progressCommand);
        this.registerEvent((Event)this.retrieveStatusCommand);
        this.addThreatLevelChildCommand = new AddThreatLevelChildCommand((BHxView)this);
        this.registerEvent((Event)this.addThreatLevelChildCommand);
        this.goInto = new GoInto((BHxView)this);
        this.registerEvent((Event)this.goInto);
        this.moveCommand = new MoveCommand((BHxView)this);
        this.registerEvent((Event)this.moveCommand);
        this.showTopLevel = new ShowTopLevel((BHxView)this);
        this.registerEvent((Event)this.showTopLevel);
        this.threatDeleteCommand = new ThreatDelete((BHxView)this);
        this.registerEvent((Event)this.threatDeleteCommand);
        this.threatLevelGroupBatchEditCommand = new ThreatLevelGroupBatchEditCommand((BHxView)this);
        this.registerEvent((Event)this.threatLevelGroupBatchEditCommand);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        Array a = new Array((Object[])super.getButtonCommands(op));
        a.add(1, (Object)this.showTopLevel);
        a.add(2, (Object)this.addThreatLevelChildCommand);
        a.add(3, (Object)this.goInto);
        a.add(4, (Object)this.moveCommand);
        a.add(6, (Object)this.activeLevelCommand);
        a.add(7, (Object)this.retrieveStatusCommand);
        a.set(a.indexOf((Object)this.delete), (Object)this.threatDeleteCommand);
        a.add((Object)this.threatLevelGroupBatchEditCommand);
        return (SmartCommand[])a.trim();
    }

    public void update(HxOp op) throws Exception {
        super.update(op);
        String name = op.scope("job");
        String ordStr = op.getFormValue(name);
        if (ordStr != null) {
            HxUtils.forceUpdate((BRelTime)BRelTime.make((long)750L), (HxOp)op);
        }
        this.progressEvent.getDialog().updateContent(op);
    }

    public BJob submitJob(HxProgressJobDialog dialog, HxOp op) {
        BThreatLevelActivationJob job = (BThreatLevelActivationJob)op.getRequest().getAttribute("job");
        op.getRequest().removeAttribute("job");
        BThreatLevelSetup threatLevelSetup = (BThreatLevelSetup)Sys.getService((Type)BThreatLevelSetup.TYPE);
        BOrd jobOrd = (BOrd)threatLevelSetup.invoke(BThreatLevelSetup.submit, (BValue)job, (Context)op);
        return (BJob)BOrd.make((String)("station:|" + jobOrd)).get();
    }

    @Override
    public String getRowKey(BTable table, int i, String handle, Property[] rowKeys, HxOp op) {
        BIOrionObject o = (BIOrionObject)table.getModel().getSubject(i);
        return handle + BOrionScheme.encodePropertiesToString((BIOrionObject)o, (Property[])rowKeys) + "~" + o.get(BThreatLevelGroupRec.activeLevel.getName());
    }

    @Override
    public Object getSubject(HxOp op) {
        return this.getSubject(false, op);
    }

    @Override
    public Object getSubject(boolean allowMultipleSelect, HxOp op) {
        String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
        if (selectionList.length == 1 || allowMultipleSelect && selectionList.length > 0) {
            String rowId = selectionList[0];
            rowId = this.scopeRowIds(op) ? TextUtil.split((String)rowId, (char)'~')[1] : TextUtil.split((String)rowId, (char)'~')[0];
            BDynamicTable dt = (BDynamicTable)op.get();
            return BOrd.make((String)rowId).get((BObject)dt.getOrionDatabase());
        }
        if (selectionList.length > 1) {
            throw new IllegalStateException("only one subject allowed");
        }
        return null;
    }

    @Override
    public Object[] getSubjects(HxOp op) {
        String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
        Object[] orionObjects = new BIOrionObject[selectionList.length];
        for (int i = 0; i < selectionList.length; ++i) {
            String rowId = selectionList[i];
            rowId = this.scopeRowIds(op) ? TextUtil.split((String)rowId, (char)'~')[1] : TextUtil.split((String)rowId, (char)'~')[0];
            BOrd ord = BOrd.make((String)rowId);
            BDynamicTable dt = (BDynamicTable)op.get();
            orionObjects[i] = (BIOrionObject)ord.get((BObject)dt.getOrionDatabase());
        }
        return orionObjects;
    }

    public void getThreatLevelDescendants(BThreatLevelGroupRec rec, OrionSession session, Array<BIOrionObject> a) {
        for (int i = 0; i < a.size(); ++i) {
            if (!rec.getUuid().equals((Object)((BThreatLevelGroupRec)a.get(i)).getUuid())) continue;
            return;
        }
        a.add((Object)rec);
        BIOrionObject[] children = rec.getChildObjects(session);
        for (int j = 0; j < children.length; ++j) {
            this.getThreatLevelDescendants((BThreatLevelGroupRec)children[j], session, a);
        }
    }

    public class ThreatLevelGroupBatchEditCommand
    extends OrionBatchEditCommand {
        public ThreatLevelGroupBatchEditCommand(BHxView view) {
            super(view);
        }

        @Override
        public BHxTabbedView.PropertyTab getPropertyTab(BOrionObject o, HxOp op) throws Exception {
            Tab tab = this.getTab(o, op);
            BHxThreatLevelGroupRecView view = (BHxThreatLevelGroupRecView)tab.view;
            BHxTabbedView.PropertyTab propertyTab = view.getOrionPropertyTab(tab.op);
            propertyTab.view = BHxBatchEditFieldSheet.INSTANCE;
            String[] fieldList = this.getProperties((BComponent)o, propertyTab.op);
            if (fieldList != null) {
                BFacets facets = BHxFieldSheet.getFieldsProvidedFacets((String[])fieldList);
                propertyTab.op = propertyTab.op.mergeFacets(facets);
            }
            return propertyTab;
        }

        @Override
        public BOrionObject getBatchTemplate(HxOp op) {
            BThreatLevelGroupRec rec = (BThreatLevelGroupRec)super.getBatchTemplate(op);
            rec.add("addAccessRights", (BValue)BRefList.make((BOrionTypeId)BAccessRight.ORION_TYPE.getOrionTypeId()), 0, BFacets.make((String)"allowNull", (boolean)true), null);
            rec.add("removeAccessRights", (BValue)BRefList.make((BOrionTypeId)BAccessRight.ORION_TYPE.getOrionTypeId()), 0, BFacets.make((String)"allowNull", (boolean)true), null);
            return rec;
        }

        @Override
        public void saveRow(BComponent saved, BOrionObject subject, BOrionObject template, OrionSession session, HxOp op) throws Exception {
            BAccessRight accessRight;
            BRef ref;
            int i;
            super.saveRow(saved, subject, template, session, op);
            BRef recRef = BRef.make((BIOrionObject)((BIOrionObject)saved));
            BRefList refList = (BRefList)template.get("addAccessRights");
            BSimple[] values = refList.getIds();
            if (values != null) {
                for (i = 0; i < values.length; ++i) {
                    ref = BRef.make((BTypeSpec)BAccessRight.ORION_TYPE.getTypeSpec(), (BSimple)values[i]);
                    accessRight = (BAccessRight)ref.getTarget(session);
                    if (accessRight.getThreatLevelGroup().equals((Object)recRef)) continue;
                    accessRight.setThreatLevelGroup(recRef);
                    session.update((BIOrionObject)accessRight);
                }
            }
            if ((values = (refList = (BRefList)template.get("removeAccessRights")).getIds()) != null) {
                for (i = 0; i < values.length; ++i) {
                    ref = BRef.make((BTypeSpec)BAccessRight.ORION_TYPE.getTypeSpec(), (BSimple)values[i]);
                    accessRight = (BAccessRight)ref.getTarget(session);
                    if (!accessRight.getThreatLevelGroup().equals((Object)recRef)) continue;
                    accessRight.setThreatLevelGroup(BRef.make((BTypeSpec)BThreatLevelGroupRec.ORION_TYPE.getTypeSpec()));
                    session.update((BIOrionObject)accessRight);
                }
            }
        }

        @Override
        public String[] getProperties(BComponent o, HxOp op) {
            Array a = new Array(String.class);
            a.addAll((Object[])new String[]{BThreatLevelGroupRec.tenant.getName()});
            Property[] props = o.getDynamicPropertiesArray();
            for (int i = 0; i < props.length; ++i) {
                a.add((Object)props[i].getName());
            }
            return (String[])a.trim();
        }
    }

    public class ThreatDelete
    extends Delete {
        public ThreatDelete(BHxView view) {
            super(view);
        }

        @Override
        public boolean readonlyEnablePolicy(HxOp op) {
            BDynamicTable dt = (BDynamicTable)op.get();
            if (!dt.getPermissions((Context)op).hasAdminWrite()) {
                return false;
            }
            Type rowType = dt.getRowType().getTypeSpec().getResolvedType();
            return rowType.is(BIMappable.TYPE);
        }

        @Override
        public String makeReferences(Object[] subjects, OrionSession session, HxOp op) throws Exception {
            String result;
            boolean subordinate = RemoteUtil.isSubordinate();
            if (subordinate) {
                BNiagaraStation station = RemoteUtil.getSupervisorStation();
                if (station.isDown() || station.isDisabled() || station.isFault()) {
                    throw new IllegalStateException("Cannot Delete Threat Level Group on subordinate if supervisor is not available");
                }
                BFoxSession foxSession = RemoteUtil.getFoxSession((BNiagaraStation)station);
                String interest = TYPE + ".makeReference." + BUuid.make();
                try {
                    foxSession.engageNoRetry(interest);
                    BEnterpriseSecurityService service = (BEnterpriseSecurityService)foxSession.getService(BEnterpriseSecurityService.TYPE);
                    service.lease();
                    for (int i = 0; i < subjects.length; ++i) {
                        if (service.remoteOrionRead((BOrionObject)subjects[i]) == null) continue;
                        throw new IllegalStateException("Cannot Delete Threat Level Group on subordinate if record is still on supervisor: " + ((BIOrionObject)subjects[i]).toDisplayString(null));
                    }
                }
                catch (ConnectException e) {
                    throw new RuntimeException("Cannot Delete Threat Level Group on subordinate if supervisor is not available", e);
                }
                finally {
                    foxSession.disengage(interest);
                }
            }
            if ((result = super.makeReferences(subjects, session, op)) != null && result.length() > 0 && subordinate) {
                throw new IllegalStateException("Cannot delete Threat Level Groups on subordinate if they are still in use:" + result);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] getSubjects(HxOp op) {
            Object[] subjects = ((BHxDynamicTableView)this.getView()).getSubjects(op);
            BDynamicTable dt = (BDynamicTable)op.get();
            OrionSession session = null;
            try {
                session = dt.getOrionDatabase().createSession(null);
                Array a = new Array(BIOrionObject.class);
                for (int i = 0; i < subjects.length; ++i) {
                    BHxThreatLevelGroupsView.this.getThreatLevelDescendants((BThreatLevelGroupRec)subjects[i], session, (Array<BIOrionObject>)a);
                }
                Object[] objectArray = a.trim();
                return objectArray;
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
        }
    }

    public static class GoInto
    extends FilteredRedirectCommand {
        public GoInto(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "goInto";
        }

        @Override
        public BDynamicTable getReport(HxOp op) {
            return (BDynamicTable)op.get();
        }

        @Override
        public boolean alterFilterEntry(BFilterEntry entry, HxOp op) {
            if (entry.getName().endsWith(BThreatLevelGroupRec.path.getName())) {
                entry.setActive(true);
                BStringFilter filter = (BStringFilter)entry.getFilter();
                BIOrionObject[] subjects = (BIOrionObject[])((BHxDynamicTableView)this.getView()).getSubjects(op);
                StringBuffer b = new StringBuffer();
                for (int i = 0; i < subjects.length; ++i) {
                    if (b.length() > 0) {
                        b.append(" || ");
                    }
                    BThreatLevelGroupRec rec = (BThreatLevelGroupRec)subjects[i];
                    b.append(rec.getPath() + "%");
                }
                filter.setPattern(b.toString());
                filter.setExact(false);
                filter.setMatchCase(false);
                filter.setInclude(true);
                return true;
            }
            return false;
        }
    }

    public static class ShowTopLevel
    extends FilteredRedirectCommand {
        public ShowTopLevel(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "showTopLevel";
        }

        @Override
        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        @Override
        public BDynamicTable getReport(HxOp op) {
            return (BDynamicTable)op.get();
        }

        @Override
        public boolean alterFilterEntry(BFilterEntry entry, HxOp op) {
            if (entry.getName().endsWith(BThreatLevelGroupRec.path.getName())) {
                entry.setActive(true);
                BStringFilter filter = (BStringFilter)entry.getFilter();
                filter.setPattern("/%/%/");
                filter.setExact(false);
                filter.setMatchCase(false);
                filter.setInclude(false);
                return true;
            }
            return false;
        }
    }

    public class MoveCommand
    extends SmartCommand {
        private MoveDialog dlg;

        public MoveCommand(BHxView view) {
            super(view);
            this.dlg = new MoveDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "moveCommand";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public BIOrionObject[] getResolvedSubjects(HxOp op) {
            return (BIOrionObject[])((BHxDynamicTableView)this.getView()).getSubjects(op);
        }

        public boolean process(HxOp op) throws Exception {
            if (super.process(op)) {
                return true;
            }
            return this.getNewParentTab(op).process();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.checkForDescendants(op);
                this.dlg.open(op);
                return;
            }
            BRef ref = (BRef)this.getNewParentTab(op).save();
            OrionSession session = null;
            try {
                BDynamicTable dt = (BDynamicTable)op.get();
                session = dt.getOrionDatabase().createSession((Context)op);
                BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
                BThreatLevelGroupRecs newParent = service.getThreatLevelGroups();
                BThreatLevelGroupRec newParentRec = (BThreatLevelGroupRec)ref.getTarget(session);
                if (newParentRec != null) {
                    newParent = (BThreatLevelGroup)newParentRec.getMappedOrd().get();
                }
                Mark mark = new Mark((BObject[])this.getThreatLevelGroups(op));
                mark.moveTo((BObject)newParent, (Context)op);
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
            BHxThreatLevelGroupsView.this.reloadTable(op);
        }

        public void checkForDescendants(HxOp op) {
            BThreatLevelGroup[] groups = this.getThreatLevelGroups(op);
            for (int i = 0; i < groups.length; ++i) {
                for (int j = groups.length - 1; j > i; --j) {
                    if (groups[i].getSlotPath().toString().indexOf(groups[j].getSlotPath().toString()) <= -1) continue;
                    throw new IllegalStateException("Ancestors cannot be moved at the same time.");
                }
            }
        }

        public BThreatLevelGroup[] getThreatLevelGroups(HxOp op) {
            BIOrionObject[] subjects = (BIOrionObject[])BHxThreatLevelGroupsView.this.getSubjects(op);
            BThreatLevelGroup[] newChildren = new BThreatLevelGroup[subjects.length];
            for (int i = 0; i < subjects.length; ++i) {
                newChildren[i] = (BThreatLevelGroup)((BIOrdMappable)subjects[i]).getMappedOrd().get();
            }
            return newChildren;
        }

        public Tab getNewParentTab(HxOp op) {
            BRef ref = BRef.make((BTypeSpec)BThreatLevelGroupRec.TYPE.getTypeSpec());
            return new Tab((BHxView)BHxSmartRefFE.INSTANCE, "newParent", op.make("newParent", (BObject)ref, BFacets.make((String)"allowNull", (boolean)true)), op);
        }

        public class MoveDialog
        extends DynamicDialog {
            public MoveDialog(String title, Command handler) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                HtmlWriter out = op.getHtmlWriter();
                HxTabUtil.startTable((HtmlWriter)out, (HxOp)op);
                HxTabUtil.startRow((String)MoveCommand.this.lexModule.getText("newParent", (Context)op), (HtmlWriter)out, (HxOp)op);
                MoveCommand.this.getNewParentTab(op).write();
                HxTabUtil.endTable((HtmlWriter)out, (HxOp)op);
            }
        }
    }

    public static class AddThreatLevelChildCommand
    extends SmartCommand {
        public AddThreatLevelChildCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "addThreatLevelChild";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public BThreatLevelGroupRec getParentSubject(HxOp op) {
            return (BThreatLevelGroupRec)((BHxDynamicTableView)this.getView()).getSubject(op);
        }

        public BOrd getTableOrd(HxOp op) {
            return op.getOrd();
        }

        public void handle(HxOp op) throws Exception {
            BThreatLevelGroupRec rec = this.getParentSubject(op);
            BOrd ord = BOrd.make((String)(this.getTableOrd(op) + "|view:" + BHxAddAppView.TYPE + "?parent=" + rec.getUuid()));
            this.redirect(op, op.toUri(ord));
        }
    }

    public static class ActiveLevelCommand
    extends SmartCommand {
        private ActiveLevelDialog dlg = new ActiveLevelDialog(this.getDisplayName(null), (Command)this);
        private Command progressCommand;

        public ActiveLevelCommand(BHxView view, Command progressCommand) {
            super(view);
            this.progressCommand = progressCommand;
        }

        public String getName(HxOp op) {
            return "activeLevelCommand";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            BDynamicTable dt = (BDynamicTable)op.get();
            if (!dt.getPermissions((Context)op).hasAdminWrite()) {
                return false;
            }
            Type rowType = dt.getRowType().getTypeSpec().getResolvedType();
            return rowType.is(BIMappable.TYPE);
        }

        public BIOrionObject[] getResolvedSubjects(HxOp op) {
            return (BIOrionObject[])((BHxDynamicTableView)this.getView()).getSubjects(op);
        }

        public Object getSubject(HxOp op) {
            return ((BHxDynamicTableView)this.getView()).getSubject(true, op);
        }

        public boolean chooseLevelRequired(HxOp op) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(HxOp op) throws Exception {
            BThreatLevelEntry activeLevelEntry = BThreatLevelEntry.DEFAULT;
            if (this.chooseLevelRequired(op)) {
                if (!this.dlg.isSubmit(op)) {
                    this.dlg.open(op);
                    return;
                }
                BValue value = (BValue)this.getGroupTab(op).save();
                activeLevelEntry = (BThreatLevelEntry)value;
            }
            BIOrionDatabaseObject dt = (BIOrionDatabaseObject)op.get();
            OrionSession session = null;
            try {
                BIOrionObject[] subjects = this.getResolvedSubjects(op);
                session = dt.getOrionDatabase().createSession((Context)op);
                BOrd[] ordList = new BOrd[subjects.length];
                for (int i = 0; i < subjects.length; ++i) {
                    BThreatLevelGroupRec threatLevelGroupRec = (BThreatLevelGroupRec)subjects[i];
                    ordList[i] = threatLevelGroupRec.getMappedOrd();
                }
                BThreatLevelActivationJob job = this.getJob(BOrdList.make((BOrd[])ordList), activeLevelEntry, Sys.getStation().getStationName(), op);
                op.getRequest().setAttribute("job", (Object)job);
                this.progressCommand.handle(op);
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
        }

        public BThreatLevelActivationJob getJob(BOrdList ordList, BThreatLevelEntry entry, String stationName, HxOp op) {
            return new BThreatLevelActivationJob(ordList, entry, stationName, op.getUser().getUsername());
        }

        public Tab getGroupTab(HxOp op) {
            BThreatLevelGroupRec group = (BThreatLevelGroupRec)this.getSubject(op);
            BThreatLevelEntry value = group.getActiveLevel();
            return new Tab((BHxView)BHxActiveThreatLevelRangeFE.INSTANCE, "active", op.make("active", (BObject)value, group.getSlotFacets((Slot)BThreatLevelGroupRec.activeLevel)));
        }

        public class ActiveLevelDialog
        extends DynamicDialog {
            public ActiveLevelDialog(String title, Command handler) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                ActiveLevelCommand.this.getGroupTab(op).write();
            }
        }
    }

    public static class RetrieveStatusCommand
    extends ActiveLevelCommand {
        public RetrieveStatusCommand(BHxView view, Command progressCommand) {
            super(view, progressCommand);
        }

        @Override
        public String getName(HxOp op) {
            return "retrieveActiveStatus";
        }

        @Override
        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        @Override
        public BThreatLevelActivationJob getJob(BOrdList ordList, BThreatLevelEntry activeLevelEntry, String stationName, HxOp op) {
            BThreatLevelGroup group = (BThreatLevelGroup)ordList.get(0).get();
            return new BRetrieveThreatLevelActivationStatusJob(ordList, group.getActiveLevel(), stationName);
        }

        @Override
        public boolean chooseLevelRequired(HxOp op) {
            return false;
        }
    }

    public static class ProgressCommand
    extends Command
    implements HxProgressJobDialog.IJobCompleteHandler {
        HxProgressJobDialog.ProgressEvent progressEvent;

        public ProgressCommand(BHxView view, HxProgressJobDialog.ProgressEvent progressEvent) {
            super(view);
            this.progressEvent = progressEvent;
        }

        public void invoke(BJob job, HxOp op) throws Exception {
            if (job.getJobState().equals((Object)BJobState.failed) || job.getJobState().equals((Object)BJobState.canceled)) {
                BHxAbstractJobView.openErrorDialog(job, this, op);
            } else if (job.getJobState().equals((Object)BJobState.success)) {
                BHxAbstractJobView.openSuccessDialog(job, this, op);
            }
        }

        public void handle(HxOp op) throws Exception {
            this.progressEvent.handle(op);
        }
    }
}

