/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.setup;

import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.platform.daemon.NiagaraPlatformDaemon;
import com.tridium.platform.daemon.RemotePlatformStation;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.UpdateStationMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.hx.BHxTcpIpHostEditor;
import com.tridium.platform.tcpip.BTcpIpPlatformService;
import com.tridium.smartTableHx.ConfirmDialog;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.sys.Nre;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsec.securityUtil.BSupervisorRenameJob;
import com.tridiumx.entsecHx.BHxAccessProfile;
import com.tridiumx.entsecHx.access.maintenance.BHxMaintenanceView;
import java.security.AccessController;
import javax.baja.file.FilePath;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.platform.RemoteStation;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"entsec:PlatformSetup"}, requiredPermissions="W")})
@NiagaraSingleton
public class BPlatformSetupView
extends BHxView {
    public static final BPlatformSetupView INSTANCE = new BPlatformSetupView();
    public static final Type TYPE = Sys.loadType(BPlatformSetupView.class);
    private static final String SERVER_HOST_MODEL = "Workstation";
    private UpdateDisplayCommand updateDisplayCommand = new UpdateDisplayCommand(this);
    private SaveStationNameCommand saveStationNameCommand;
    private SaveCommand saveCommand;
    private ResetCommand resetCommand;
    private boolean protectFromDoubleRestart = false;
    private boolean protectFromDoubleReboot = false;

    public Type getType() {
        return TYPE;
    }

    protected BPlatformSetupView() {
        this.registerEvent((Event)this.updateDisplayCommand);
        this.saveCommand = new SaveCommand(this);
        this.registerEvent((Event)this.saveCommand);
        this.saveStationNameCommand = new SaveStationNameCommand(this);
        this.registerEvent((Event)this.saveStationNameCommand);
        this.resetCommand = new ResetCommand(this);
        this.registerEvent((Event)this.resetCommand);
    }

    public String getPageTitle(HxOp op) {
        return Lexicon.make((String)"entsec", (Context)op).getText("nav.platform.setup");
    }

    public void write(HxOp op) throws Exception {
        op.setDynamic();
        boolean supervisor = BEnterpriseSecurityService.isWorkstation();
        BComponent setup = (BComponent)op.get();
        HtmlWriter out = op.getHtmlWriter();
        op.addStyleSheet(BOrd.make((String)"module://entsecHx/rc/platSetup.css"));
        Lexicon lex = Lexicon.make((String)"entsecHx");
        BEnterpriseSecurityService accessService = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        if (accessService.getInitRequired()) {
            this.writeWelcome(op);
        }
        this.writeSectionHeader(lex.getText("plat.setup.displayNames"), null, op);
        out.w((Object)"<table cellspacing='0' cellpadding='0'>");
        String stationDisplayName = this.getStationDisplayName((Context)op);
        out.w((Object)"<tr>");
        out.w((Object)"<td class='plat-setup-form-label'>").safe((Object)lex.getText("plat.setup.stationDisplayName")).w((Object)"</td>");
        out.w((Object)"<td class='plat-setup-form-value'>").w((Object)"<input type='text' size='30' name='").w((Object)op.scope("stationDisplayName")).w((Object)"' value='").safe((Object)stationDisplayName).w((Object)"'/>");
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        String systemName = this.getSystemName((Context)op);
        out.w((Object)"<tr>");
        out.w((Object)"<td class='plat-setup-form-label'>").safe((Object)lex.getText("plat.setup.systemName")).w((Object)"</td>");
        out.w((Object)"<td class='plat-setup-form-value'>").w((Object)"<input type='text' size='30' name='").w((Object)op.scope("systemName")).w((Object)"' value='").safe((Object)systemName).w((Object)"'/>");
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"</table>");
        out.w((Object)"<div style='padding-left: 5px; padding-top: 5px;'>");
        this.writeCommandButton(this.updateDisplayCommand, op);
        out.w((Object)"</div>");
        this.writeSectionHeader(lex.getText("plat.setup.stationNameSetting"), lex.getText("plat.setup.restartRequired"), op);
        String stationName = Sys.getStation().getStationName();
        out.w((Object)"<table cellspacing='0' cellpadding='0'>");
        out.w((Object)"<tr>");
        out.w((Object)"<td class='plat-setup-form-label' style='padding-right: 8px;'>").safe((Object)lex.getText("plat.setup.stationName")).w((Object)"</td>");
        out.w((Object)"<td class='plat-setup-form-value'>");
        if (supervisor) {
            out.w((Object)"<input type='text' size='30' disabled='disabled' name='").w((Object)op.scope("stationName")).w((Object)"' value='").safe((Object)stationName).w((Object)"'/>");
        } else {
            out.w((Object)"<input type='text' size='30' name='").w((Object)op.scope("stationName")).w((Object)"' value='").safe((Object)stationName).w((Object)"'/>");
        }
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"</table>");
        if (!supervisor) {
            out.w((Object)"<div style='padding-left: 5px; padding-top: 5px;'>");
            this.writeCommandButton(this.saveStationNameCommand, op);
            out.w((Object)"</div>");
        }
        this.writeSectionHeader(lex.getText("plat.setup.networkSettings"), lex.getText("plat.setup.rebootRequired"), op);
        BTcpIpPlatformService tcpIpService = (BTcpIpPlatformService)Sys.getService((Type)BTcpIpPlatformService.TYPE);
        tcpIpService.checkPropertiesLoaded();
        HxOp hostEditorOp = op.make("hostEditor", new OrdTarget((OrdTarget)op, (BObject)tcpIpService.getSettings()));
        if (supervisor) {
            hostEditorOp.setReadonly(true);
        }
        BHxTcpIpHostEditor.INSTANCE.write(hostEditorOp);
        out.w((Object)"<div class='plat-setup-form-label' style='padding-bottom: 10px;'>");
        out.w((Object)"<img src='module://icons/x16/file.png'/>");
        out.w((Object)"&nbsp;");
        out.w((Object)"<a style='text-decoration: none;' href='").w((Object)setup.getSlotPathOrd().toString()).w((Object)"|view:entsecHx:HostsFileEditor").w((Object)"'>");
        out.w((Object)"<span class='plat-setup-label'>").safe((Object)lex.getText("plat.setup.edit.hosts.file")).w((Object)"</span>");
        out.w((Object)"</a>");
        out.w((Object)"</div>");
        if (!supervisor) {
            out.w((Object)"<div style='padding-left: 5px; padding-top: 5px; padding-bottom: 5px;' >");
            this.writeCommandButton(this.saveCommand, op);
            out.w((Object)"</div>");
        }
        out.w((Object)"<div class='plat-setup-commands' style='padding-left: 5px; padding-top: 5px;'>");
        out.w((Object)"<table cellspacing='0 cellpadding='0'>");
        out.w((Object)"<tr>");
        out.w((Object)"<td>");
        this.writeCommandButton(this.resetCommand, op);
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"</table>");
        out.w((Object)"</div>");
    }

    private void writeSectionHeader(String title, String subtext, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<div class='plat-setup-section'>");
        out.safe((Object)title);
        if (subtext != null) {
            out.w((Object)"<span class='plat-setup-subtext'>");
            out.safe((Object)" (").safe((Object)subtext).safe((Object)")");
            out.w((Object)"</span>");
        }
        out.w((Object)"</div>");
    }

    private void writeWelcome(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        Lexicon lex = Lexicon.make((String)"entsecHx", (Context)op);
        out.w((Object)"<div class='plat-setup-welcome'>");
        out.w((Object)"<img src='module://icons/x32/info.png' style='float: left; padding-right: 10px;'/>");
        out.safe((Object)lex.getText("plat.setup.welcome.l1")).w((Object)"&nbsp;&nbsp;");
        out.safe((Object)lex.getText("plat.setup.welcome.l2")).w((Object)"&nbsp;&nbsp;");
        Object[] args = new Object[]{lex.getText("plat.setup.keepConfig")};
        out.safe((Object)lex.getText("plat.setup.welcome.l3", args)).w((Object)"&nbsp;&nbsp;");
        out.w((Object)"</div>");
    }

    private void writeCommandButton(Command cmd, HxOp op) throws Exception {
        BIcon icon = BIcon.DEFAULT;
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<table class='plat-setup-command-button' cellspacing='0' cellpadding='0' onclick='").w((Object)cmd.getInvokeCode(op)).w((Object)"'>");
        out.w((Object)"<tr>");
        out.w((Object)"<td style='padding-right: 2px;'");
        if (icon == BIcon.DEFAULT) {
            out.w((Object)" class='plat-setup-command-no-icon'");
        }
        out.w((Object)">");
        if (icon != BIcon.DEFAULT) {
            out.w((Object)"<img src='").w((Object)icon.getOrdList().get(0).toString()).w((Object)"'/>");
        }
        out.w((Object)"</td>");
        out.w((Object)"<td>");
        out.safe((Object)cmd.getDisplayName(op));
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"</table>");
    }

    public void doSave(boolean commit, HxOp op) throws Exception {
        String systemName;
        boolean supervisor = BEnterpriseSecurityService.isWorkstation();
        BEnterpriseSecurityService entsecService = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        if (!commit) {
            if (entsecService.getInitRequired()) {
                entsecService.setInitRequired(false);
                entsecService.setShowGuidedTour(true);
                entsecService.setPopUpGuidedTour(true);
            }
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"window.location='/ord?station:|entsecnav:/'");
            return;
        }
        String stationDisplayName = op.getFormValue("stationDisplayName");
        if (stationDisplayName != null) {
            this.setStationDisplayName(stationDisplayName);
        }
        if ((systemName = op.getFormValue("systemName")) != null) {
            this.setSystemName(systemName);
        }
        if (!supervisor) {
            BTcpIpPlatformService service = (BTcpIpPlatformService)Sys.getService((Type)BTcpIpPlatformService.TYPE);
            service.checkPropertiesLoaded();
            HxOp hostEditorOp = op.make("hostEditor", new OrdTarget((OrdTarget)op, (BObject)service.getSettings()));
            BHxTcpIpHostEditor.INSTANCE.save(hostEditorOp);
            service.savePlatformServiceProperties();
        }
        try {
            Thread.sleep(5000L);
        }
        catch (Exception service) {
            // empty catch block
        }
        if (entsecService.getInitRequired()) {
            entsecService.setInitRequired(false);
            entsecService.setShowGuidedTour(true);
            entsecService.setPopUpGuidedTour(true);
        }
        HtmlWriter out = op.getHtmlWriter();
        if (op.getProfile().getType().is(BHxAccessProfile.TYPE)) {
            BHxAccessProfile.disconnect(op);
        }
        BSystemPlatformService service = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
        service.reboot();
    }

    public void doStationNameSave(boolean commit, HxOp op) throws Exception {
        String stationName;
        String systemName;
        boolean supervisor = BEnterpriseSecurityService.isWorkstation();
        BEnterpriseSecurityService entsecService = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        if (!commit) {
            if (entsecService.getInitRequired()) {
                entsecService.setInitRequired(false);
                entsecService.setShowGuidedTour(true);
                entsecService.setPopUpGuidedTour(true);
            }
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"window.location='/ord?station:|entsecnav:/'");
            return;
        }
        String stationDisplayName = op.getFormValue("stationDisplayName");
        if (stationDisplayName != null) {
            this.setStationDisplayName(stationDisplayName);
        }
        if ((systemName = op.getFormValue("systemName")) != null) {
            this.setSystemName(systemName);
        }
        if ((stationName = op.getFormValue("stationName")) != null) {
            if (!SlotPath.isValidName((String)stationName)) {
                throw new IllegalArgumentException("Invalid station name: " + stationName);
            }
            if (!stationName.equals(Sys.getStation().getStationName()) && !RemoteUtil.isNiagaraStandalone()) {
                throw new IllegalStateException("Cannot rename station if it is not stand alone.");
            }
        }
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (entsecService.getInitRequired()) {
            entsecService.setInitRequired(false);
            entsecService.setShowGuidedTour(true);
            entsecService.setPopUpGuidedTour(true);
        }
        HtmlWriter out = op.getHtmlWriter();
        if (op.getProfile().getType().is(BHxAccessProfile.TYPE)) {
            BHxAccessProfile.disconnect(op);
        }
        new CommitThread(Sys.getStation().getStationName(), stationName).start();
    }

    private String getStationDisplayName(Context cx) {
        BStation station = Sys.getStation();
        BValue nameFormat = station.get("displayName");
        if (nameFormat == null || !(nameFormat instanceof BFormat)) {
            return "";
        }
        return ((BFormat)nameFormat).getFormat();
    }

    private void setStationDisplayName(String displayName) {
        BStation station = Sys.getStation();
        Property displayProp = station.getProperty("displayName");
        if (displayProp == null) {
            displayProp = station.add("displayName", (BValue)BFormat.DEFAULT);
        }
        station.set(displayProp, (BValue)BFormat.make((String)displayName));
    }

    private String getSystemName(Context cx) {
        BComponent station = Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        BValue nameFormat = station.get("systemName");
        if (nameFormat == null || !(nameFormat instanceof BFormat)) {
            return "";
        }
        return ((BFormat)nameFormat).getFormat();
    }

    private void setSystemName(String systemName) {
        BComponent service = Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        Property sysNameProp = service.getProperty("systemName");
        if (sysNameProp == null) {
            sysNameProp = service.add("systemName", (BValue)BFormat.DEFAULT);
        }
        service.set(sysNameProp, (BValue)BFormat.make((String)systemName));
    }

    private class ResetCommand
    extends Command {
        public ResetCommand(BHxView owner) {
            super(owner);
        }

        public String getDisplayName(HxOp op) {
            BEnterpriseSecurityService accessService = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
            if (accessService.getInitRequired()) {
                return op.getLexicon("entsecHx").getText("plat.setup.keepConfig");
            }
            return op.getLexicon("entsecHx").getText("plat.setup.reset");
        }

        public void handle(HxOp op) throws Exception {
            BPlatformSetupView.this.doSave(false, op);
        }
    }

    private class SaveStationNameCommand
    extends Command {
        public SaveStationNameCommand(BHxView owner) {
            super(owner);
        }

        public String getDisplayName(HxOp op) {
            return op.getLexicon("entsecHx").getText("plat.setup.saveStationName");
        }

        public void handle(HxOp op) throws Exception {
            if (!BPlatformSetupView.this.protectFromDoubleRestart) {
                BPlatformSetupView.this.protectFromDoubleRestart = true;
                try {
                    BPlatformSetupView.this.doStationNameSave(true, op);
                }
                catch (Exception e) {
                    BPlatformSetupView.this.protectFromDoubleRestart = false;
                    throw e;
                }
            }
        }
    }

    private class SaveCommand
    extends Command {
        private ConfirmDialog dlg;

        public SaveCommand(BHxView owner) {
            super(owner);
            Lexicon lex = HxTabUtil.getLexicon(BHxMaintenanceView.class);
            this.dlg = new ConfirmDialog(lex.getText("plat.setup.saveNetworkSetting"), (Command)this, lex.getText("plat.setup.saveNetworkSettingAlert"));
        }

        public String getDisplayName(HxOp op) {
            return op.getLexicon("entsecHx").getText("plat.setup.save");
        }

        public void handle(HxOp op) throws Exception {
            String newStationName = op.getFormValue("stationName");
            String oldStationName = Sys.getStation().getStationName();
            if (!oldStationName.equals(newStationName) && this.dlg != null && !this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            if (!BPlatformSetupView.this.protectFromDoubleReboot) {
                BPlatformSetupView.this.protectFromDoubleReboot = true;
                try {
                    BPlatformSetupView.this.doSave(true, op);
                }
                catch (Exception e) {
                    BPlatformSetupView.this.protectFromDoubleReboot = false;
                    throw e;
                }
            }
        }
    }

    private class UpdateDisplayCommand
    extends Command {
        public UpdateDisplayCommand(BHxView owner) {
            super(owner);
        }

        public String getDisplayName(HxOp op) {
            return op.getLexicon("entsecHx").getText("plat.setup.updateDisplayNames");
        }

        public void handle(HxOp op) throws Exception {
            String systemName;
            String stationDisplayName = op.getFormValue("stationDisplayName");
            if (stationDisplayName != null) {
                BPlatformSetupView.this.setStationDisplayName(stationDisplayName);
            }
            if ((systemName = op.getFormValue("systemName")) != null) {
                BPlatformSetupView.this.setSystemName(systemName);
            }
            this.refresh(op);
        }
    }

    private class SupervisorRename
    extends Thread {
        private String oldStationName;
        private String newStationName;

        public SupervisorRename(String oldStationName, String newStationName) {
            this.oldStationName = oldStationName;
            this.newStationName = newStationName;
        }

        @Override
        public void run() {
            System.out.println("running station rename");
            this.finishRenameSupervisor();
        }

        public void finishRenameSupervisor() {
            if (this.oldStationName.equals(this.newStationName)) {
                return;
            }
            try {
                BDaemonSession daemon = LocalSessionUtil.getLocalSession();
                NiagaraPlatformDaemon naigaraDaemon = NiagaraPlatformDaemon.make((BDaemonSession)daemon, (DaemonSessionTaskListener)DaemonSessionTaskListener.NULL_TASK_LISTENER);
                RemoteStation[] stations = naigaraDaemon.getStationManager().getAllStations();
                for (int i = 0; i < stations.length; ++i) {
                    if (!stations[i].getName().equals(this.oldStationName)) continue;
                    System.out.println("waiting 10 seconds for lock to clear...");
                    Thread.sleep(10000L);
                    System.out.println("renaming station...");
                    RemotePlatformStation station = (RemotePlatformStation)stations[i];
                    BStationSurrogate stationSurrogate = BStationSurrogate.make((BDaemonSession)daemon, (String)this.oldStationName);
                    try {
                        DaemonFileUtil.transfer((BDaemonSession)daemon, (FileTransferMessage)FileTransferMessage.makeRename((FilePath)new FilePath("!stations/" + stationSurrogate.getStationName()), (String)this.newStationName, (BDaemonFileSpace)daemon.getFileSpace()), null, null);
                    }
                    catch (Exception e) {
                        System.out.println("Cannot rename station; station files must be in use by another process.");
                        stationSurrogate.restartStationAsync(true);
                        System.out.println("Restarting original station...");
                        return;
                    }
                    daemon.sendMessage((DaemonMessage)new UpdateStationMessage());
                    BStationSurrogate newStationSurrogate = BStationSurrogate.make((BDaemonSession)daemon, (String)this.newStationName);
                    daemon.sendMessage((DaemonMessage)new UpdateStationMessage(this.newStationName, false, true, true, true));
                    newStationSurrogate.startStationAsync();
                    daemon.sendMessage((DaemonMessage)new UpdateStationMessage(this.oldStationName, true, false, false, true));
                }
            }
            catch (Exception ex) {
                System.out.println("ERROR: Could not commit platform changes.");
                ex.printStackTrace();
            }
            System.out.println("station rename complete");
        }
    }

    private class CommitThread
    extends Thread {
        private String oldStationName;
        private String newStationName;

        public CommitThread(String oldStationName, String newStationName) {
            this.oldStationName = oldStationName;
            this.newStationName = newStationName;
        }

        @Override
        public void run() {
            String hostModel = Nre.getHostModel();
            if (hostModel.equals(BPlatformSetupView.SERVER_HOST_MODEL)) {
                this.renameSupervisor();
            } else {
                this.renameController();
            }
        }

        public void renameSupervisor() {
            if (this.oldStationName.equals(this.newStationName)) {
                return;
            }
            Runtime.getRuntime().addShutdownHook(new SupervisorRename(this.oldStationName, this.newStationName));
            BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
            BSupervisorRenameJob supervisorRenameJob = new BSupervisorRenameJob();
            supervisorRenameJob.setOldStationName(this.oldStationName);
            service.add(null, (BValue)supervisorRenameJob, 5);
            try {
                BDaemonSession daemon = LocalSessionUtil.getLocalSession();
                NiagaraPlatformDaemon naigaraDaemon = NiagaraPlatformDaemon.make((BDaemonSession)daemon, (DaemonSessionTaskListener)DaemonSessionTaskListener.NULL_TASK_LISTENER);
                RemoteStation[] stations = naigaraDaemon.getStationManager().getAllStations();
                for (int i = 0; i < stations.length; ++i) {
                    if (!stations[i].getName().equals(this.oldStationName)) continue;
                    RemotePlatformStation station = (RemotePlatformStation)stations[i];
                    BStationSurrogate stationSurrogate = BStationSurrogate.make((BDaemonSession)daemon, (String)this.oldStationName);
                    stationSurrogate.stopStation(null, null);
                }
            }
            catch (Exception ex) {
                System.out.println("ERROR: Could not commit platform changes.");
                ex.printStackTrace();
            }
        }

        public void renameController() {
            try {
                AccessController.doPrivileged(() -> {
                    BSystemPlatformService service = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
                    service.renameAndRestartStation(this.newStationName);
                    return null;
                });
            }
            catch (Exception ex) {
                System.out.println("ERROR: Could not commit platform changes.");
                ex.printStackTrace();
            }
        }
    }
}

