/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.setup;

import com.tridium.hx.fieldeditors.BHxRelTimeFE;
import com.tridium.hx.fieldeditors.BHxStringFE;
import com.tridium.nrio.BNrioDevice;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.BHxTabbedView;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.accessDriver.BAccess2ReaderModule;
import com.tridiumx.accessDriver.BAccessDoor;
import com.tridiumx.accessDriver.BAccessElevator;
import com.tridiumx.accessDriver.BAccessInputOutputModule;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.accessDriver.BAccessReader;
import com.tridiumx.accessDriver.BIAccessDevice;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.securityUtil.PermissionsFilter;
import com.tridiumx.entsecHx.setup.NetworkIdStatusPoll;
import com.tridiumx.entsecHx.setup.OutputOverride;
import com.tridiumx.entsecHx.setup.RenameIds;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.security.BPermissions;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"accessDriver:AccessNetwork"}, app="entsec", requiredPermissions="rR")})
@NiagaraSingleton
public class BHxNetworkIdView
extends BHxTabbedView {
    public static final BHxNetworkIdView INSTANCE = new BHxNetworkIdView();
    public static final Type TYPE = Sys.loadType(BHxNetworkIdView.class);
    private SmartCommand wink;
    private SmartCommand outputOverride;
    private SmartCommand rename;
    private SmartCommand fadeRate;
    private SmartCommand refresh;
    private SmartCommand hyperlink;
    private Command networkIdsStatusPoll = new NetworkIdStatusPoll((BHxView)this);
    private Lexicon lex;

    public Type getType() {
        return TYPE;
    }

    protected BHxNetworkIdView() {
        this.registerEvent((Event)this.networkIdsStatusPoll);
        this.refresh = new Refresh((BHxView)this);
        this.registerEvent((Event)this.refresh);
        this.fadeRate = new FadeRate((BHxView)this);
        this.registerEvent((Event)this.fadeRate);
        this.rename = new RenameIds((BHxView)this);
        this.registerEvent((Event)this.rename);
        this.wink = new Wink((BHxView)this);
        this.registerEvent((Event)this.wink);
        this.outputOverride = new OutputOverride((BHxView)this);
        this.registerEvent((Event)this.outputOverride);
        this.hyperlink = new Hyperlink((BHxView)this);
        this.registerEvent((Event)this.hyperlink);
        this.lex = Lexicon.make(BHxNetworkIdView.class);
    }

    public void write(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        BHxNetworkIdView.writeResources((HxOp)op);
        this.writeHeader(op);
        this.writeIds(op);
    }

    public String getPageTitle(HxOp op) throws Exception {
        return TYPE.getDisplayName((Context)op);
    }

    public Tab[] getTabs(HxOp op) throws Exception {
        return new Tab[0];
    }

    public static BAccess2ReaderModule[] getReaderModules(HxOp op) {
        BAccessNetwork accessNetwork = (BAccessNetwork)Sys.getService((Type)BAccessNetwork.TYPE);
        Object[] modules = (BAccess2ReaderModule[])accessNetwork.getChildren(BAccess2ReaderModule.class);
        Array array = new Array(modules);
        array = array.filter((IFilter)new PermissionsFilter(BPermissions.operatorRead, (Context)op));
        return (BAccess2ReaderModule[])array.trim();
    }

    public static BAccessInputOutputModule[] getIOModules(HxOp op) {
        BAccessNetwork accessNetwork = (BAccessNetwork)Sys.getService((Type)BAccessNetwork.TYPE);
        Object[] modules = (BAccessInputOutputModule[])accessNetwork.getChildren(BAccessInputOutputModule.class);
        Array array = new Array(modules);
        array = array.filter((IFilter)new PermissionsFilter(BPermissions.operatorRead, (Context)op));
        return (BAccessInputOutputModule[])array.trim();
    }

    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.fadeRate, this.refresh};
    }

    public void writeIds(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/color.js"));
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/smartTable.js"));
        StringBuffer b = new StringBuffer();
        b.append("hx.fireEvent(&quot;").append(op.getPath());
        b.append("&quot;,&quot;").append(this.networkIdsStatusPoll.getId()).append("&quot;);");
        op.addOnload(b.toString());
        out.w((Object)"<div class='setup-panel'>");
        out.w((Object)"<table>");
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        BAccess2ReaderModule[] readerModules = BHxNetworkIdView.getReaderModules(op);
        for (int i = 0; i < readerModules.length; ++i) {
            this.writeModule((BIAccessDevice)readerModules[i], service, op);
        }
        BAccessInputOutputModule[] ioModules = BHxNetworkIdView.getIOModules(op);
        for (int i = 0; i < ioModules.length; ++i) {
            this.writeModule((BIAccessDevice)ioModules[i], service, op);
        }
        out.w((Object)"</table>");
    }

    public void writeHyperlink(BComponent c, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<span ");
        out.attr("title", this.hyperlink.getDisplayName(op));
        out.attr("style", "cursor:pointer;");
        out.w((Object)"onclick='hx.setFormValue(&quot;handle&quot;,&quot;");
        out.w(c.getHandle()).w((Object)"&quot;);");
        out.w((Object)"").w((Object)this.hyperlink.getInvokeCode(op)).w((Object)"'>");
        HxUtil.makeImageJS((BImage)BImage.make((BIcon)c.getIcon()), (HxOp)op);
        out.w((Object)"</span>");
    }

    public void writeModule(BIAccessDevice module, BAccessControlService service, HxOp op) throws Exception {
        BNrioDevice device = (BNrioDevice)module;
        BPermissions permission = device.getPermissions((Context)op);
        if (!permission.hasAdminRead()) {
            return;
        }
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<tr><td class='smartTable-setup-label'>");
        out.safe((Object)device.getDeviceType().toString((Context)op)).w((Object)"</td>");
        out.w((Object)"<td>");
        this.writeHyperlink((BComponent)device, op);
        out.w((Object)"</td>");
        out.w((Object)"<td ");
        HxTabUtil.scope((String)(device.getHandle() + "Name"), (HtmlWriter)out, (HxOp)op);
        out.w((Object)">");
        out.safe((Object)device.getDisplayName((Context)op));
        out.w((Object)"</td><td>");
        out.w((Object)"<span ");
        out.attr("title", this.rename.getDisplayName(op));
        out.attr("style", "cursor:pointer;");
        out.w((Object)"onclick='hx.setFormValue(&quot;handle&quot;,&quot;");
        out.w(device.getHandle()).w((Object)"&quot;);");
        out.w((Object)"").w((Object)this.rename.getInvokeCode(op)).w((Object)"'>");
        HxUtil.makeImageJS((BImage)this.rename.getIcon(op), (HxOp)op);
        out.w((Object)"</span>");
        out.w((Object)"</td><td>");
        BHxNetworkIdView.writeStatus(device.getHandle().toString(), module.toStatusString((Context)op), out, op);
        out.w((Object)"</td><td>");
        if (permission.hasAdminWrite()) {
            this.writeWinkButton(module, op);
        }
        out.w((Object)"</td></tr>");
        this.writeReaders((BComponent)module.getPoints(), service, op);
        BAccessDoor[] doors = (BAccessDoor[])module.getPoints().getChildren(BAccessDoor.class);
        for (int i = 0; i < doors.length; ++i) {
            permission = doors[i].getPermissions((Context)op);
            if (!permission.hasAdminRead()) continue;
            out.w((Object)"<tr><td class='smartTable-setup-label'>");
            out.w((Object)"&nbsp;&nbsp;");
            out.safe((Object)BAccessDoor.TYPE.getDisplayName((Context)op));
            out.w((Object)" ").w(i + 1).w((Object)"</td>");
            out.w((Object)"<td>");
            this.writeHyperlink((BComponent)doors[i], op);
            out.w((Object)"</td>");
            out.w((Object)"<td");
            HxTabUtil.scope((String)(doors[i].getHandle().toString() + "Name"), (HtmlWriter)out, (HxOp)op);
            out.w((Object)">");
            out.safe((Object)doors[i].getDisplayName((Context)op));
            out.w((Object)"</td><td>");
            out.w((Object)"<span ");
            out.attr("title", this.rename.getDisplayName(op));
            out.attr("style", "cursor:pointer;");
            out.w((Object)"onclick='hx.setFormValue(&quot;handle&quot;,&quot;");
            out.w(doors[i].getHandle()).w((Object)"&quot;);");
            out.w((Object)"").w((Object)this.rename.getInvokeCode(op)).w((Object)"'>");
            HxUtil.makeImageJS((BImage)this.rename.getIcon(op), (HxOp)op);
            out.w((Object)"</span>");
            out.w((Object)"</td><td>");
            BHxNetworkIdView.writeStatus(doors[i].getHandle().toString(), doors[i].toStatusString((Context)op), out, op);
            out.w((Object)"</td></tr>");
            this.writeReaders((BComponent)doors[i], service, op);
        }
        BAccessElevator[] elevators = (BAccessElevator[])module.getPoints().getChildren(BAccessElevator.class);
        for (int i = 0; i < elevators.length; ++i) {
            permission = elevators[i].getPermissions((Context)op);
            if (!permission.hasAdminRead()) continue;
            out.w((Object)"<tr><td class='smartTable-setup-label'>");
            out.w((Object)"&nbsp;&nbsp;");
            out.safe((Object)BAccessElevator.TYPE.getDisplayName((Context)op));
            out.w((Object)" ").w(i + 1).w((Object)"</td>");
            out.w((Object)"<td>");
            this.writeHyperlink((BComponent)elevators[i], op);
            out.w((Object)"</td>");
            out.w((Object)"<td");
            HxTabUtil.scope((String)(elevators[i].getHandle() + "Name"), (HtmlWriter)out, (HxOp)op);
            out.w((Object)">");
            out.safe((Object)elevators[i].getDisplayName((Context)op));
            out.w((Object)"</td><td>");
            out.w((Object)"<span ");
            out.attr("title", this.rename.getDisplayName(op));
            out.attr("style", "cursor:pointer;");
            out.w((Object)"onclick='hx.setFormValue(&quot;handle&quot;,&quot;");
            out.w(elevators[i].getHandle()).w((Object)"&quot;);");
            out.w((Object)"").w((Object)this.rename.getInvokeCode(op)).w((Object)"'>");
            HxUtil.makeImageJS((BImage)this.rename.getIcon(op), (HxOp)op);
            out.w((Object)"</span>");
            out.w((Object)"</td><td>");
            BHxNetworkIdView.writeStatus(elevators[i].getHandle().toString(), elevators[i].toStatusString((Context)op), out, op);
            out.w((Object)"</td></tr>");
            this.writeReaders((BComponent)elevators[i], service, op);
        }
        out.w((Object)"<tr><td class='smartTable-setup-label'>&nbsp;</td>");
        out.w((Object)"<td> &nbsp; </td><td> &nbsp; </td></tr>");
    }

    private void writeReaders(BComponent parent, BAccessControlService service, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        BAccessReader[] readers = (BAccessReader[])parent.getChildren(BAccessReader.class);
        for (int i = 0; i < readers.length; ++i) {
            BPermissions permission = readers[i].getPermissions((Context)op);
            if (!permission.hasAdminRead()) continue;
            out.w((Object)"<tr><td class='smartTable-setup-label'>");
            out.w((Object)"&nbsp;&nbsp;&nbsp;&nbsp;");
            out.safe((Object)BAccessReader.TYPE.getDisplayName((Context)op));
            out.w((Object)" ").w(readers[i].getInstance()).w((Object)"</td>");
            out.w((Object)"<td>");
            this.writeHyperlink((BComponent)readers[i], op);
            out.w((Object)"</td>");
            out.w((Object)"<td");
            HxTabUtil.scope((String)(readers[i].getHandle() + "Name"), (HtmlWriter)out, (HxOp)op);
            out.w((Object)">");
            out.safe((Object)readers[i].getDisplayName((Context)op));
            out.w((Object)"</td><td>");
            out.w((Object)"<span ");
            out.attr("title", this.rename.getDisplayName(op));
            out.attr("style", "cursor:pointer;");
            out.w((Object)"onclick='hx.setFormValue(&quot;handle&quot;,&quot;");
            out.w(readers[i].getHandle()).w((Object)"&quot;);");
            out.w((Object)"").w((Object)this.rename.getInvokeCode(op)).w((Object)"'>");
            HxUtil.makeImageJS((BImage)this.rename.getIcon(op), (HxOp)op);
            out.w((Object)"</span>");
            out.w((Object)"</td><td>");
            String badgeInfo = NetworkIdStatusPoll.getBadgeInfo(readers[i], service);
            BHxNetworkIdView.writeStatus(readers[i].getHandle().toString(), badgeInfo, out, op);
            out.w((Object)"</td><td>");
            if (permission.hasAdminWrite()) {
                this.writeOutputButton(readers[i], op);
            }
            out.w((Object)"</td></tr>");
        }
    }

    private void writeOutputButton(BAccessReader reader, HxOp op) throws Exception {
        HxOp fieldOp = op.make("", (BObject)reader, null);
        HxTabUtil.writeCommand((SmartCommand)this.outputOverride, (HxOp)fieldOp);
    }

    private void writeWinkButton(BIAccessDevice module, HxOp op) throws Exception {
        HxOp fieldOp = op.make("", (BObject)((BComponent)module), null);
        HxTabUtil.writeCommand((SmartCommand)this.wink, (HxOp)fieldOp);
    }

    public static void writeStatus(String ioName, String value, HtmlWriter out, HxOp op) throws Exception {
        value = HxTabUtil.safeForFormValue((String)value);
        out.w((Object)"<input type='text' size='50'");
        out.w((Object)"style='background-color: #CCCCCC; color: #333333;'");
        out.w((Object)"value='").w((Object)value).w((Object)"'");
        out.w((Object)"name='").w((Object)ioName).w((Object)"'");
        out.w((Object)"id='").w((Object)ioName).w((Object)"' />");
        BHxSmartTableView.writeUnscopedFormValue((String)("hidden" + ioName), (String)value, (HxOp)op);
    }

    public class Hyperlink
    extends SmartCommand {
        public Hyperlink(BHxView view) {
            super(view, smartTableHxLexModule);
        }

        public String getName(HxOp op) {
            return "hyperlink";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            String handle = op.getFormValue("handle");
            this.redirect(op, BOrd.make((String)("station:|h:" + handle)));
        }
    }

    public class Refresh
    extends SmartCommand {
        public Refresh(BHxView view) {
            super(view, smartTableHxLexModule);
        }

        public String getName(HxOp op) {
            return "refresh";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            this.refresh(op);
        }
    }

    class WinkDialog
    extends Dialog {
        public WinkDialog(String title, Command handler) {
            super(title, handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            String handle = op.getFormValue("handle");
            BIAccessDevice module = (BIAccessDevice)HxTabUtil.getComponent((String)handle);
            BNrioDevice device = (BNrioDevice)module;
            if (!Flags.isHidden((BComplex)device, (Slot)BNrioDevice.winkCancel)) {
                out.w((Object)"<table>");
                out.w((Object)"<tr>");
                out.w((Object)"<td><span class='smartTable-setup-label'>");
                out.safe((Object)BHxNetworkIdView.this.lex.getText("cancelWink"));
                out.w((Object)"</span></td></tr></table>");
                out.w((Object)"<input type='hidden'");
                out.w((Object)"value='true'");
                out.w((Object)"name='").w((Object)"isCancel").w((Object)"'");
                out.w((Object)"id='").w((Object)"isCancel").w((Object)"' />");
                return;
            }
            out.w((Object)"<table>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><span class='smartTable-setup-label'>");
            out.safe((Object)BHxNetworkIdView.this.lex.getText("winkDuration"));
            out.w((Object)"</span></td><td>");
            OrdTarget target = new OrdTarget(op.getBaseOrdTarget(), (BObject)device.getWinkDuration());
            HxOp fieldOp = op.make("winkTime", target);
            fieldOp.mergeFacets(BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT, (String)"max", (BIDataValue)BRelTime.makeMinutes((int)59)));
            fieldOp.mergeFacets(BFacets.make((String)"showMilliseconds", (boolean)false));
            BHxRelTimeFE.INSTANCE.write(fieldOp);
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
        }
    }

    class Wink
    extends SmartCommand {
        private WinkDialog dialog;

        public Wink(BHxView view) {
            super(view);
            this.dialog = new WinkDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            if (!HxUtil.isPost((HxOp)op)) {
                BComponent c = (BComponent)op.get();
                return this.getLexName(op) + c.getHandle();
            }
            return this.getLexName(op);
        }

        public String getLexName(HxOp op) {
            return "wink";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public String getEnabledInvokeCode(HxOp op) {
            BComponent c = (BComponent)op.get();
            StringBuffer b = new StringBuffer();
            b.append("hx.setFormValue(&quot;handle&quot;,&quot;");
            b.append(c.getHandle()).append("&quot;);");
            b.append(super.getEnabledInvokeCode(op));
            return b.toString();
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dialog.isSubmit(op)) {
                this.dialog.open(op);
                return;
            }
            String handle = op.getFormValue("handle");
            BIAccessDevice module = (BIAccessDevice)HxTabUtil.getComponent((String)handle);
            BNrioDevice device = (BNrioDevice)module;
            if (Flags.isHidden((BComplex)device, (Slot)BNrioDevice.winkCancel)) {
                OrdTarget target = new OrdTarget(op.getBaseOrdTarget(), (BObject)device.getWinkDuration());
                device.set(BNrioDevice.winkDuration, (BValue)BHxRelTimeFE.INSTANCE.save(op.make("winkTime", target)));
                device.doWinkDevice();
            } else {
                device.doWinkCancel();
            }
        }
    }

    class FadeRateDialog
    extends Dialog {
        public FadeRateDialog(String title, Command handler) {
            super(title, handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            String fadeRate = op.getCookie("fadeRate");
            if (fadeRate == null) {
                fadeRate = "5";
            }
            out.w((Object)"<table>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><span class='smartTable-setup-label'>");
            out.w((Object)this.getTitle(op));
            out.w((Object)"</span></td><td>");
            out.w((Object)"<select ").attr("name", "fadeRate.value").w((Object)">");
            String value = "0";
            out.w((Object)"<option ").attr("value", value);
            if (fadeRate.equals(value)) {
                out.w((Object)" selected='selected'");
            }
            out.w((Object)">");
            out.safe((Object)BHxNetworkIdView.this.lex.getText("permanent"));
            out.w((Object)"</option>");
            value = "1";
            out.w((Object)"<option ").attr("value", value);
            if (fadeRate.equals(value)) {
                out.w((Object)" selected='selected'");
            }
            out.w((Object)">");
            out.safe((Object)BHxNetworkIdView.this.lex.getText("slow"));
            out.w((Object)"</option>");
            value = "5";
            out.w((Object)"<option ").attr("value", value);
            if (fadeRate.equals(value)) {
                out.w((Object)" selected='selected'");
            }
            out.w((Object)">");
            out.safe((Object)BHxNetworkIdView.this.lex.getText("normal"));
            out.w((Object)"</option>");
            value = "20";
            out.w((Object)"<option ").attr("value", value);
            if (fadeRate.equals(value)) {
                out.w((Object)" selected='selected'");
            }
            out.w((Object)">");
            out.safe((Object)BHxNetworkIdView.this.lex.getText("fast"));
            out.w((Object)"</option>");
            out.w((Object)"</select>");
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
        }
    }

    class FadeRate
    extends SmartCommand {
        private FadeRateDialog dialog;

        public FadeRate(BHxView view) {
            super(view);
            this.dialog = new FadeRateDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "fadeRate";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dialog.isSubmit(op)) {
                this.dialog.open(op);
                return;
            }
            OrdTarget target = new OrdTarget(op.getBaseOrdTarget(), (BObject)BString.make((String)""));
            BString string = (BString)BHxStringFE.INSTANCE.save(op.make("fadeRate", target));
            op.addCookie("fadeRate", string.toString());
        }
    }
}

