/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.query;

import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.TableContents;
import com.tridium.sys.schema.ComplexType;
import com.tridiumx.entsec.orionTools.MappingSupport;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BQuery;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraSingleton
public class BHxQueryProperty
extends BHxSmartTableView {
    public static final Lexicon lex = Lexicon.make(BHxQueryProperty.class);
    public static final BHxQueryProperty INSTANCE = new BHxQueryProperty();
    public static final Type TYPE = Sys.loadType(BHxQueryProperty.class);

    public Type getType() {
        return TYPE;
    }

    protected BHxQueryProperty() {
    }

    public void write(HxOp op) throws Exception {
        super.write(op);
    }

    public void writeTableHeader(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<th>");
        out.safe((Object)lex.getText("property"));
        out.w((Object)"</th>");
    }

    public static TypeSpecPath getTypeSpecPath(HxOp op) {
        String[] propNames = SmartCommand.getSelectionList((HxOp)op);
        if (propNames.length == 0) {
            return null;
        }
        String[] split = TextUtil.split((String)propNames[0], (char)'.');
        String propName = split[split.length - 1];
        TypeSpecPath typeSpecPath = TypeSpecPath.decodeFromString((String)propName.toString());
        return typeSpecPath;
    }

    public TableContents writeContents(HxOp op) throws Exception {
        TypeSpecPath tsp;
        TableContents contents = new TableContents(op.scope("records"));
        BQuery query = (BQuery)op.get();
        BQuery working = (BQuery)op.getRequest().getSession().getAttribute("working");
        BValue dependency = working.get("working_from");
        if (dependency == null) {
            return contents;
        }
        String selection = dependency.toString();
        if (selection.equals("columns")) {
            TypeSpecPath[] standard = QueryUtil.getStandardColumns();
            for (int i = 0; i < standard.length; ++i) {
                TableContents.Tr tr = new TableContents.Tr();
                tr.id = op.scope(standard[i].encodeToString());
                tr.td.add(new TableContents.Td(standard[i].toString()));
                contents.tr.add(tr);
            }
            return contents;
        }
        BTypeSpec typeSpec = BTypeSpec.make((String)selection);
        Type type = typeSpec.getResolvedType();
        if (type.is(BComplex.TYPE)) {
            Property[] props = null;
            if (type.isAbstract()) {
                if (type instanceof ComplexType) {
                    ComplexType complexType = (ComplexType)type;
                    Array complexProps = new Array((Object[])complexType.getFrozenProperties());
                    props = new Property[complexProps.size()];
                    for (int i = 0; i < complexProps.size(); ++i) {
                        props[i] = (Property)complexProps.get(i);
                    }
                }
            } else {
                BObject o = typeSpec.getInstance();
                if (o instanceof BComplex) {
                    props = ((BComplex)typeSpec.getInstance()).getPropertiesArray();
                }
            }
            if (props != null) {
                for (int i = 0; i < props.length; ++i) {
                    tsp = new TypeSpecPath(props[i]);
                    TableContents.Tr tr = new TableContents.Tr();
                    tr.id = op.scope(tsp.encodeToString());
                    tr.td.add(new TableContents.Td(tsp.toString()));
                    contents.tr.add(tr);
                }
            }
        }
        Type[] mixInTypes = MappingSupport.getMixIns((Type)type);
        for (int i = 0; i < mixInTypes.length; ++i) {
            tsp = new TypeSpecPath(mixInTypes[i].getTypeSpec(), MappingSupport.getMixInName((Type)mixInTypes[i]));
            TableContents.Tr tr = new TableContents.Tr();
            tr.id = op.scope(tsp.encodeToString());
            tr.td.add(new TableContents.Td(tsp.toString()));
            contents.tr.add(tr);
        }
        return contents;
    }
}

