/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.orion;

import com.tridium.bql.filter.BFilterSet;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.OrionSession;
import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.HxOptionsManager;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.nav.BEntsecNav;
import com.tridiumx.entsec.securityUtil.BActivityRecord;
import com.tridiumx.entsec.securityUtil.orion.BLocalHistoryQuery;
import com.tridiumx.entsec.securityUtil.orion.BSecurityHistoryConsolidator;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsec.securityUtil.ui.query.BQueryTableOptions;
import com.tridiumx.entsec.securityUtil.ui.query.BWbQueryConfig;
import com.tridiumx.entsecHx.EntsecReportCommand;
import com.tridiumx.entsecHx.access.fieldeditors.BHxPersonSummaryFE;
import com.tridiumx.entsecHx.orionToolsHx.BScheduledExport;
import com.tridiumx.entsecHx.orionToolsHx.SummaryCommand;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxQueryTableView;
import com.tridiumx.entsecHx.securityUtilHx.query.ColumnsCommand;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.collection.TableCursor;
import javax.baja.history.BCapacity;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BQuery;
import javax.baja.space.BSpace;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.options.BOptions;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;
import javax.baja.util.LexiconModule;

@NiagaraType(agent={@AgentOn(types={"entsec:SecurityHistoryConsolidator", "entsec:LocalHistoryQuery"}, requiredPermissions="rR")})
@NiagaraSingleton
public class BHxLocalHistoryTableView
extends BHxQueryTableView {
    public static final BHxLocalHistoryTableView INSTANCE = new BHxLocalHistoryTableView();
    public static final Type TYPE = Sys.loadType(BHxLocalHistoryTableView.class);
    protected SmartCommand configCommand;
    protected SmartCommand summaryCommand = new HistorySummaryCommand((BHxView)this);
    protected SmartCommand historyReportCommand;

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxLocalHistoryTableView() {
        this.registerEvent((Event)this.summaryCommand);
        this.columnsCommand = new HistoryColumnsCommand((BHxView)this);
        this.registerEvent((Event)this.columnsCommand);
        this.configCommand = new ConfigureCommand((BHxView)this);
        this.registerEvent((Event)this.configCommand);
        this.historyReportCommand = new HistoryReportCommand((BHxView)this);
        this.registerEvent((Event)this.historyReportCommand);
    }

    public static BSecurityHistoryConsolidator getSecurityHistoryConsolidator(HxOp op) {
        BObject obj = op.get();
        if (obj instanceof BSecurityHistoryConsolidator) {
            return (BSecurityHistoryConsolidator)obj;
        }
        if (obj instanceof BLocalHistoryQuery) {
            return (BSecurityHistoryConsolidator)((BLocalHistoryQuery)obj).getParent();
        }
        return null;
    }

    public static BTypeSpec getRowType(HxOp op) {
        return BHxLocalHistoryTableView.getSecurityHistoryConsolidator(op).getHistoryRecordType();
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        if (BHxLocalHistoryTableView.getSecurityHistoryConsolidator(op).getPermissions((Context)op).hasAdminWrite()) {
            return new SmartCommand[]{this.summaryCommand, this.columnsCommand, this.filterCommand, this.refreshCommand, this.configCommand, this.historyReportCommand, this.exportCommand};
        }
        return new SmartCommand[]{this.summaryCommand, this.columnsCommand, this.filterCommand, this.refreshCommand, this.historyReportCommand, this.exportCommand};
    }

    public boolean supportsAutoRefresh(HxOp op) {
        return true;
    }

    @Override
    public BSpace getSpace(HxOp op) {
        BISession session = BHxLocalHistoryTableView.getSecurityHistoryConsolidator(op).getSession();
        BOrd ord = BOrd.make((BOrd)session.getAbsoluteOrd(), (String)"history:");
        return (BSpace)ord.get();
    }

    @Override
    public BObject getBase(HxOp op) {
        BSecurityHistoryConsolidator sHistory = BHxLocalHistoryTableView.getSecurityHistoryConsolidator(op);
        return sHistory.getQuery();
    }

    @Override
    public BQuery getQuery(HxOp op) {
        BSecurityHistoryConsolidator sHistory = BHxLocalHistoryTableView.getSecurityHistoryConsolidator(op);
        BLocalHistoryQuery query = sHistory.getQuery();
        query = QueryUtil.getWorkingCopy((BQuery)query, (BObject)this.getBase(op), (Context)op);
        return query;
    }

    @Override
    public String getRowKey(Type rowType, TableCursor<? extends BIObject> cursor, HxOp op) {
        try {
            BObject rec = (BObject)cursor.get();
            return BActivityRecord.encodeSourceRecord((BTypeSpec)rec.getType().getTypeSpec(), (BObject)rec);
        }
        catch (Exception e) {
            e.printStackTrace();
            return super.getRowKey(rowType, cursor, op);
        }
    }

    static BHistoryConfig findHistoryConfig(BComponent c) {
        if (c instanceof BHistoryConfig) {
            return (BHistoryConfig)c;
        }
        return ((BHistoryConfig[])c.getChildren(BHistoryConfig.class))[0];
    }

    public static BOrionDatabase getOrionDatabase(HxOp op) {
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        return service.getOrionDatabase();
    }

    public static Tab getPersonTab(BObject rec, HxOp op) {
        BComplex complex = (BComplex)rec;
        if (complex != null && complex.get("personId") != null) {
            BUuid personId = (BUuid)complex.get("personId");
            HxOp personOp = op.make("historySummary", (BObject)personId, null);
            return new Tab((BHxView)BHxPersonSummaryFE.INSTANCE, "Person", personOp, op);
        }
        return null;
    }

    public static class PersonSummaryCommand
    extends SummaryCommand {
        public PersonSummaryCommand(BHxView view) {
            super(view);
        }

        @Override
        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BObject getResolvedSubject(HxOp op) throws Exception {
            String personId = op.getFormValue("personId");
            BOrionDatabase db = BHxLocalHistoryTableView.getOrionDatabase(op);
            OrionSession session = null;
            try {
                session = db.createSession((Context)op);
                BObject bObject = (BObject)session.read(BPerson.ORION_TYPE, (BSimple)((BUuid)BUuid.DEFAULT.decodeFromString(personId)));
                return bObject;
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
        }
    }

    class HistoryReportCommand
    extends EntsecReportCommand {
        public HistoryReportCommand(BHxView view) {
            super(view);
        }

        @Override
        public BComponent getContainer(HxOp op) {
            BSecurityHistoryConsolidator currentReport = BHxLocalHistoryTableView.getSecurityHistoryConsolidator(op);
            while (Flags.isUserDefined4((BComplex)currentReport.getParent(), (Slot)currentReport.getPropertyInParent())) {
                currentReport = currentReport.getParent().asComponent();
            }
            return currentReport;
        }

        @Override
        public BComponent getSubject(HxOp op) {
            return BHxLocalHistoryTableView.getSecurityHistoryConsolidator(op);
        }

        @Override
        public BComponent getNewReport(HxOp op) {
            Type type;
            int i;
            BSecurityHistoryConsolidator consolidator = BHxLocalHistoryTableView.getSecurityHistoryConsolidator(op);
            BSecurityHistoryConsolidator consolidatorCopy = (BSecurityHistoryConsolidator)consolidator.newCopy();
            BLocalHistoryQuery query = consolidator.getQuery();
            BQuery copy = QueryUtil.getWorkingCopy((BQuery)query, (BObject)BHxLocalHistoryTableView.this.getBase(op), (Context)op);
            Property[] props = consolidatorCopy.getQuery().getDynamicPropertiesArray();
            for (i = 0; i < props.length; ++i) {
                type = props[i].getType();
                if (!type.is(BQuery.TYPE) && !type.is(BEntsecNav.TYPE) && !type.is(BLink.TYPE)) continue;
                consolidatorCopy.getQuery().remove(props[i].getName());
            }
            props = consolidatorCopy.getDynamicPropertiesArray();
            for (i = 0; i < props.length; ++i) {
                type = props[i].getType();
                if (!type.is(BDynamicTable.TYPE) && !type.is(BEntsecNav.TYPE) && !type.is(BLink.TYPE) && !type.is(BScheduledExport.TYPE)) continue;
                consolidatorCopy.remove(props[i].getName());
            }
            HxOptionsManager manager = new HxOptionsManager((BObject)copy, op);
            BQueryTableOptions options = (BQueryTableOptions)manager.load(BQueryTableOptions.TYPE);
            BQueryTableOptions newOptions = new BQueryTableOptions();
            BFilterSet set = options.getFilterSet((BQuery)query);
            if (set != null) {
                newOptions.setFilterSet((BQuery)query, (BFilterSet)set.newCopy());
            }
            consolidatorCopy.setQuery((BLocalHistoryQuery)copy);
            consolidatorCopy.setFlags((Slot)BSecurityHistoryConsolidator.query, consolidatorCopy.getFlags((Slot)BSecurityHistoryConsolidator.query) | Integer.MIN_VALUE);
            manager.saveMounted((BOptions)newOptions);
            return consolidatorCopy;
        }
    }

    static class ConfigureDialog
    extends Dialog {
        public ConfigureDialog(String title, Command handler) {
            super(title, handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            BHistoryId id = BHxLocalHistoryTableView.getSecurityHistoryConsolidator(op).getDefaultLocalHistory().fromShorthand(Sys.getStation().getStationName());
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase db = service.getDatabase();
            try (HistorySpaceConnection conn = db.getConnection(null);){
                BHistoryConfig config = BHxLocalHistoryTableView.findHistoryConfig(conn.getHistory(id).getConfig().getSource().get(0).get().asComponent());
                BInteger capacity = BInteger.make((int)config.getCapacity().getMaxRecords());
                BFacets facets = BFacets.makeInt((int)1, (int)Integer.MAX_VALUE);
                HtmlWriter out = op.getHtmlWriter();
                BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)capacity, (Context)op.make((OrdTarget)op).mergeFacets(facets));
                HxOp fieldOp = op.make("historyCapacity", (BObject)capacity, facets);
                out.w((Object)"<table><tr><td class='smartTable-setup-label'>");
                out.safe((Object)BHistoryConfig.capacity.getDefaultDisplayName((Context)op));
                out.w((Object)"</td><td>");
                editor.write(fieldOp);
                out.w((Object)"</td></tr></table>");
                String[] fieldNames = new String[]{BHistoryConfig.fullPolicy.getName()};
                facets = BFacets.make((BFacets)BHxFieldSheet.getFieldsProvidedFacets((String[])fieldNames));
                HxOp subOp = op.make("historyConfig", (BObject)config, facets);
                BHxFieldSheet.INSTANCE.write(subOp);
            }
        }
    }

    public class ConfigureCommand
    extends SmartCommand {
        ConfigureDialog dialog;

        public ConfigureCommand(BHxView view) {
            super(view);
            this.lexModule = LexiconModule.make(BHxLocalHistoryTableView.class);
            this.dialog = new ConfigureDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "configureHistory";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean isVisible(HxOp op) {
            return !BHxLocalHistoryTableView.getSecurityHistoryConsolidator(op).isSubReport();
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public boolean isDefaultAction() {
            return false;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dialog.isSubmit(op)) {
                this.dialog.open(op);
                return;
            }
            BHistoryId id = BHxLocalHistoryTableView.getSecurityHistoryConsolidator(op).getDefaultLocalHistory().fromShorthand(Sys.getStation().getStationName());
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase db = service.getDatabase();
            try (HistorySpaceConnection conn = db.getConnection(null);){
                BHistoryConfig config = BHxLocalHistoryTableView.findHistoryConfig(conn.getHistory(id).getConfig().getSource().get(0).get().asComponent());
                BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)BInteger.DEFAULT, (Context)op);
                int capacity = ((BInteger)editor.save(op.make("historyCapacity", new OrdTarget((OrdTarget)op, (BObject)BInteger.DEFAULT)))).getInt();
                if (capacity > 0) {
                    config.set(BHistoryConfig.capacity, (BValue)BCapacity.makeByRecordCount((int)capacity), (Context)op);
                }
                String[] fieldNames = new String[]{BHistoryConfig.fullPolicy.getName()};
                BFacets facets = BFacets.make((BFacets)BHxFieldSheet.getFieldsProvidedFacets((String[])fieldNames));
                HxOp subOp = op.make("historyConfig", (BObject)config, facets);
                BHxFieldSheet.INSTANCE.save(subOp);
                ((BHxLocalHistoryTableView)this.getView()).reloadTable(op);
            }
        }
    }

    public static class HistorySummaryCommand
    extends SmartCommand {
        DetailsDialog dialog = new DetailsDialog(this.getDisplayName(null), (Command)this);

        public HistorySummaryCommand(BHxView view) {
            super(view, smartTableHxLexModule);
        }

        public String getName(HxOp op) {
            return "historySummary";
        }

        public String getLexName(HxOp op) {
            return "summary";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public boolean isDefaultAction() {
            return true;
        }

        public boolean process(HxOp op) throws Exception {
            if (!this.matchesScope(op)) {
                return false;
            }
            if (super.process(op)) {
                return true;
            }
            BObject rec = this.getRecord(op);
            Tab personTab = BHxLocalHistoryTableView.getPersonTab(rec, op);
            if (personTab != null) {
                return personTab.process();
            }
            return false;
        }

        public BObject getRecord(HxOp op) throws Exception {
            return this.getRecord(false, op);
        }

        public BObject getRecord(boolean encodeBackup, HxOp op) throws Exception {
            String encoding = null;
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            if (selectionList != null && selectionList.length > 0) {
                encoding = selectionList[0];
                if (encodeBackup) {
                    BHxSmartTableView.writeFormValue((String)"recBackup", (String)encoding, (HxOp)op);
                }
            } else {
                encoding = op.getFormValue("recBackup");
            }
            BObject rec = BActivityRecord.decodeSourceRecord((String)encoding);
            return rec;
        }

        public void handle(HxOp op) throws Exception {
            if (this.dialog.isSubmit(op)) {
                return;
            }
            this.dialog.open(op);
        }

        public class DetailsDialog
        extends Dialog {
            public DetailsDialog(String title, Command handler) {
                super(title, handler);
            }

            public void open(HxOp op) throws Exception {
                super.open(op);
            }

            protected void writeContent(HxOp op) throws Exception {
                BObject rec = HistorySummaryCommand.this.getRecord(true, op);
                String[] fieldNames = null;
                String[] fieldEditors = null;
                if (rec instanceof BAlarmRecord) {
                    fieldNames = new String[]{"timestamp", "uuid", "sourceState", "ackState", "ackRequired", "source", "alarmClass", "priority", "normalTime", "ackTime", "user", "alarmData", "alarmTransition", "lastUpdate"};
                    fieldEditors = new String[]{"smartTableHx:HxSmartDefaultFE", "smartTableHx:HxSmartDefaultFE", "smartTableHx:HxSmartDefaultFE", "smartTableHx:HxSmartDefaultFE", "smartTableHx:HxSmartDefaultFE", "smartTableHx:HxSmartDefaultFE", "smartTableHx:HxSmartDefaultFE", "smartTableHx:HxSmartDefaultFE", "smartTableHx:HxSmartDefaultFE", "smartTableHx:HxSmartDefaultFE", "smartTableHx:HxSmartDefaultFE", "entsecHx:AlarmDataFE", "smartTableHx:HxSmartDefaultFE", "smartTableHx:HxSmartDefaultFE"};
                } else if (rec instanceof BComplex) {
                    BComplex complex = (BComplex)rec;
                    Property[] props = complex.getPropertiesArray();
                    int len = props != null ? props.length : 0;
                    fieldNames = new String[len];
                    fieldEditors = new String[len];
                    for (int i = 0; i < len; ++i) {
                        fieldNames[i] = props[i].getName();
                        fieldEditors[i] = "smartTableHx:HxSmartDefaultFE";
                    }
                }
                HtmlWriter out = op.getHtmlWriter();
                BFacets facets = BFacets.make((BFacets)BHxFieldSheet.getFieldsProvidedFacets(fieldNames), (BFacets)BHxFieldSheet.getFieldEditorsProvidedFacets(fieldEditors));
                facets = BFacets.make((BFacets)facets, (BFacets)BHxFieldSheet.noTableStart);
                HxOp subOp = op.make("historyRecord", rec, facets);
                HxTabUtil.startTable((HtmlWriter)out, (HxOp)op);
                BHxFieldSheet.INSTANCE.write(subOp);
                Tab personTab = BHxLocalHistoryTableView.getPersonTab(rec, op);
                if (personTab != null) {
                    HxTabUtil.startRow((String)"Person", (HtmlWriter)out, (HxOp)op);
                    personTab.write();
                    HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
                }
                HxTabUtil.endTable((HtmlWriter)out, (HxOp)op);
            }

            public Command[] getCommands() {
                return new Command[]{this.makeSubmitCommand()};
            }
        }
    }

    class HistoryColumnsCommand
    extends ColumnsCommand {
        public HistoryColumnsCommand(BHxView view) {
            super(view);
        }

        @Override
        public void handle(HxOp op) throws Exception {
            if (op.get() instanceof BSecurityHistoryConsolidator && op.getPath().length() == 0) {
                StringBuffer sb = new StringBuffer();
                sb.append(op.getOrd().toString());
                sb.append("|slot:").append(BSecurityHistoryConsolidator.query.getName());
                sb.append("|view:").append(BWbQueryConfig.TYPE.toString());
                this.redirect(op, op.toUri(BOrd.make((String)sb.toString())));
            } else {
                super.handle(op);
            }
        }
    }
}

