/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.manager.rdb;

import com.tridium.bql.cursor.BogCursor;
import com.tridium.hx.fieldeditors.BHxBooleanFE;
import com.tridium.hx.fieldeditors.BHxEnumFE;
import com.tridium.orion.BAbstractOrionApp;
import com.tridium.orion.BIOrionApp;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.rdb.BAbstractConnectionPool;
import com.tridium.rdb.hsqldb.BHsqlDatabase;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.ConfirmDialog;
import com.tridium.smartTableHx.DynamicDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.fieldeditors.BHxSmartDefaultFE;
import com.tridium.smartTableHx.tab.BHxTabbedView;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsecHx.BHxAccessProfile;
import com.tridiumx.entsecHx.access.maintenance.BHxMaintenanceView;
import com.tridiumx.entsecHx.securityUtilHx.UpLevelCommand;
import com.tridiumx.entsecHx.securityUtilHx.fieldeditors.BHxAWFieldSheet;
import com.tridiumx.entsecHx.securityUtilHx.fieldeditors.BHxExpandableFieldSheetFE;
import com.tridiumx.entsecHx.securityUtilHx.manager.BHxManageDevicesView;
import com.tridiumx.entsecHx.securityUtilHx.manager.ManageDevicesCommand;
import com.tridiumx.entsecHx.setup.BHxServiceSummary;
import java.util.logging.Level;
import javax.baja.driver.BDevice;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsNetwork;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"rdb:RdbmsNetwork"}, app="entsec", requiredPermissions="rR")})
@NiagaraSingleton
public class BHxRdbmsNetworkView
extends BHxManageDevicesView {
    public static Lexicon lex = HxTabUtil.getLexicon(BHxRdbmsNetworkView.class);
    public static final BHxRdbmsNetworkView INSTANCE = new BHxRdbmsNetworkView();
    public static final Type TYPE = Sys.loadType(BHxRdbmsNetworkView.class);
    protected SmartCommand setOrionDatabase = new SetOrionDatabase((BHxView)this);
    protected SmartCommand saveRestartCommand;
    protected BHxMaintenanceView.RestartStation restartCommand;

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxRdbmsNetworkView() {
        this.registerEvent((Event)this.setOrionDatabase);
        this.restartCommand = new BHxMaintenanceView.RestartStation((BHxView)this);
        this.registerEvent((Event)this.restartCommand);
        this.saveRestartCommand = new SaveRestartStation((BHxView)this);
        this.registerEvent((Event)this.saveRestartCommand);
    }

    public String getPageTitle(HxOp op) {
        return lex.getText("configureDatabase");
    }

    public void write(HxOp op) throws Exception {
        op.setDynamic();
        BRdbmsNetwork network = (BRdbmsNetwork)op.get();
        BRdbms[] rdbms = (BRdbms[])network.getChildren(BRdbms.class);
        for (int i = 0; i < rdbms.length; ++i) {
            BAbstractConnectionPool[] pools = (BAbstractConnectionPool[])rdbms[i].getChildren(BAbstractConnectionPool.class);
            for (int j = 0; j < pools.length; ++j) {
                pools[j].doUpdateConnectionStats();
            }
        }
        super.write(op);
    }

    @Override
    public BHxTabbedView.PropertyTab getPropertyTab(HxOp op) throws Exception {
        BComponent c = (BComponent)op.get();
        HxOp propOp = op.make("services", (OrdTarget)op);
        return new BHxTabbedView.PropertyTab((BHxTabbedView)this, (BHxView)BHxServiceSummary.INSTANCE, lex.getText("databaseServices"), propOp);
    }

    @Override
    public Tab[] getTabs(HxOp op) throws Exception {
        Tab[] tabs = super.getTabs(op);
        if (op.getSecurityTarget().canWrite((OrdTarget)op)) {
            for (int i = 0; i < tabs.length; ++i) {
                if (!tabs[i].view.getType().equals(BHxFieldSheet.TYPE)) continue;
                if (tabs[i].op.get().getType().is(BHsqlDatabase.TYPE)) {
                    this.updateFieldEditor(tabs[i]);
                }
                tabs[i].view = BHxAWFieldSheet.INSTANCE;
            }
        }
        return tabs;
    }

    private void updateFieldEditor(Tab tab) {
        String[] properties = this.getProperties(tab.op);
        if (properties.length > 0) {
            String dFE = BHxSmartDefaultFE.TYPE.toString();
            Array fieldEditors = new Array(String.class);
            for (int j = 0; j < properties.length; ++j) {
                if (properties[j].equals("alarmSourceInfo")) {
                    fieldEditors.add((Object)BHxExpandableFieldSheetFE.TYPE.toString());
                    continue;
                }
                if (properties[j].equals("defragOnSave")) {
                    fieldEditors.add((Object)BHxBooleanFE.TYPE.toString());
                    continue;
                }
                fieldEditors.add((Object)dFE);
            }
            BFacets fieldEditorsFacets = BFacets.make((BFacets)BHxFieldSheet.getFieldEditorsProvidedFacets((String[])((String[])fieldEditors.trim())));
            tab.op.mergeFacets(fieldEditorsFacets);
        }
    }

    public boolean process(HxOp op) throws Exception {
        op.setDynamic();
        return super.process(op);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        Array arr = new Array(SmartCommand.class);
        SmartCommand[] smartCommands = super.getButtonCommands(op);
        for (int i = 0; i < smartCommands.length; ++i) {
            boolean isManageDatbasesCommand = smartCommands[i] instanceof ManageDevicesCommand;
            if (smartCommands[i] instanceof UpLevelCommand || isManageDatbasesCommand && !BEnterpriseSecurityService.isWorkstation()) continue;
            arr.add((Object)super.getButtonCommands(op)[i]);
        }
        if (BEnterpriseSecurityService.isWorkstation()) {
            arr.add((Object)this.setOrionDatabase);
        }
        if (this.restartCommand.isAvailable(op)) {
            arr.add((Object)this.restartCommand);
        }
        return (SmartCommand[])arr.trim();
    }

    public void saved(HxOp op) throws Exception {
        BRdbmsNetwork network = (BRdbmsNetwork)op.get();
        BDevice[] devices = network.getDevices();
        for (int i = 0; i < devices.length; ++i) {
            devices[i].ping();
        }
        if (this.restartCommand.isAvailable(op) && BEnterpriseSecurityService.isWorkstation()) {
            this.saveRestartCommand.handle(op);
        } else {
            this.save.refresh(op);
        }
    }

    public static class SaveRestartStation
    extends SmartCommand {
        private ConfirmDialog dialog;

        public SaveRestartStation(BHxView view) {
            super(view);
            Lexicon lex = HxTabUtil.getLexicon(BHxMaintenanceView.class);
            this.dialog = new ConfirmDialog(lex.getText("RdbmsNetworkView.restartStation"), (Command)this, lex.getText("RdbmsNetworkView.restartQuestion"));
        }

        public String getName(HxOp op) {
            return "saveRestartStation";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dialog.isSubmit(op)) {
                this.dialog.open(op);
                return;
            }
            BSystemPlatformService service = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            service.restartStation();
            HtmlWriter out = op.getHtmlWriter();
            if (op.getProfile().getType().is(BHxAccessProfile.TYPE)) {
                BHxAccessProfile.disconnect(op);
            }
        }

        public boolean isAvailable(HxOp op) {
            try {
                BSystemPlatformService service = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
                return LocalSessionUtil.localDaemonIsAvailable();
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    public static class SetOrionDatabase
    extends SmartCommand {
        protected SetOrionDatabaseDialog dlg = new SetOrionDatabaseDialog((Command)this, this.getDisplayName(null));

        public SetOrionDatabase(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "setOrionDatabase";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            BOrd oldOrd;
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            BDynamicEnum dynamicEnum = (BDynamicEnum)this.getTab(op).save();
            String tag = dynamicEnum.getTag();
            BRdbmsNetwork network = (BRdbmsNetwork)op.get();
            BRdbms rdbms = (BRdbms)network.get(tag);
            BOrd newOrd = rdbms.getSlotPathOrd();
            if (!newOrd.equals((Object)(oldOrd = this.getDbOrd(op)))) {
                BIOrionApp[] apps = this.getOrionApps(op);
                for (int i = 0; i < apps.length; ++i) {
                    BComponent c = (BComponent)apps[i];
                    c.set(BAbstractOrionApp.dbOrd.getName(), (BValue)newOrd);
                }
            }
        }

        public BIOrionApp[] getOrionApps(HxOp op) {
            Array a = new Array(BIOrionApp.class);
            BogCursor c = new BogCursor((BComplex)Sys.getStation(), 99, new Type[]{BIOrionApp.TYPE}, false, null);
            while (c.next()) {
                a.add((Object)((BIOrionApp)c.get()));
            }
            return (BIOrionApp[])a.trim();
        }

        public BOrd getDbOrd(HxOp op) {
            BIOrionApp[] apps = this.getOrionApps(op);
            BOrd dbOrd = BOrd.NULL;
            for (int i = 0; i < apps.length; ++i) {
                BComponent c = (BComponent)apps[i];
                BOrd appOrd = (BOrd)c.get(BAbstractOrionApp.dbOrd.getName());
                if (!dbOrd.equals((Object)BOrd.NULL) && !dbOrd.equals((Object)appOrd)) {
                    BEnterpriseSecurityService.LOG.log(Level.SEVERE, "BAbstractOrionApp.dbOrds not consistent" + dbOrd + "!=" + appOrd);
                }
                dbOrd = appOrd;
            }
            return dbOrd;
        }

        public Tab getTab(HxOp op) {
            BOrd dbOrd = this.getDbOrd(op);
            BRdbms rdbms = null;
            try {
                rdbms = (BRdbms)dbOrd.get((BObject)Sys.getStation());
            }
            catch (Exception exception) {
                // empty catch block
            }
            BRdbmsNetwork network = (BRdbmsNetwork)op.get();
            BRdbms[] devices = (BRdbms[])network.getChildren(BRdbms.class);
            String[] tags = new String[devices.length];
            int dbOrdIndex = 0;
            for (int i = 0; i < devices.length; ++i) {
                tags[i] = devices[i].getName();
                if (rdbms == null || !devices[i].getName().equals(rdbms.getName())) continue;
                dbOrdIndex = i;
            }
            BEnumRange range = BEnumRange.make((String[])tags);
            BDynamicEnum dynamicEnum = BDynamicEnum.make((int)dbOrdIndex, (BEnumRange)range);
            BHxEnumFE fe = BHxEnumFE.INSTANCE;
            HxOp fieldOp = op.make("setOrionDatabase", (BObject)dynamicEnum, null);
            fieldOp.mergeFacets(BHxEnumFE.PREFER_FROZEN_EDITOR);
            Tab tab = new Tab((BHxView)fe, "", fieldOp);
            return tab;
        }

        protected class SetOrionDatabaseDialog
        extends DynamicDialog {
            SetOrionDatabaseDialog(Command handler, String title) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                String msg = SetOrionDatabase.this.lexModule.getText("setOrionDatabaseDialogWarning", (Context)op);
                ConfirmDialog.writeWarning((BImage)BImage.make((BIcon)BIcon.make((String)"module://icons/x32/warning.png")), (String)msg, (HxOp)op);
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)"<table><tr><td>");
                out.safe((Object)SetOrionDatabase.this.lexModule.getText("orionDatabase", (Context)op));
                out.w((Object)"</td><td>");
                SetOrionDatabase.this.getTab(op).write();
                out.w((Object)"</td></tr></table>");
            }
        }
    }
}

