/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.link;

import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.TableContents;
import com.tridium.smartTableHx.fieldeditors.BHxAssignmentFE;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsec.securityUtil.ui.link.BLinkTemplate;
import com.tridiumx.entsecHx.securityUtilHx.link.BHxQueryTableAssignedView;
import com.tridiumx.entsecHx.securityUtilHx.link.BHxQueryTableUnassignedView;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxQueryTableView;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BExpression;
import javax.baja.query.BPredicate;
import javax.baja.query.BQuery;
import javax.baja.query.util.ExpressionBuilder;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;

@NiagaraType
@NiagaraSingleton
public class BHxLinkFE
extends BHxAssignmentFE {
    public static final Lexicon linkLex = HxTabUtil.getLexicon(BHxLinkFE.class);
    public static final BHxLinkFE INSTANCE = new BHxLinkFE();
    public static final Type TYPE = Sys.loadType(BHxLinkFE.class);

    public Type getType() {
        return TYPE;
    }

    protected BHxLinkFE() {
    }

    public BHxSmartTableView getUnassignedView(HxOp op) {
        return BHxQueryTableUnassignedView.INSTANCE;
    }

    public BHxSmartTableView getAssignedView(HxOp op) {
        return BHxQueryTableAssignedView.INSTANCE;
    }

    public void saveNewlyUnassigned(String assignedId, HxOp op) throws Exception {
        BComponent source = (BComponent)BOrd.make((String)("station:|" + assignedId)).get();
        BComponent target = this.getComponent(op);
        BLinkTemplate linkTemplate = this.getLinkTemplate(op);
        BLink[] links = target.getLinks(linkTemplate.targetSlot);
        for (int i = 0; i < links.length; ++i) {
            if (!links[i].getSourceComponent().getSlotPathOrd().toString().equals(assignedId)) continue;
            links[i].getParent().asComponent().remove(links[i].getPropertyInParent());
        }
    }

    public void saveNewlyAssigned(String unassignedId, HxOp op) throws Exception {
        BComponent source = (BComponent)BOrd.make((String)("station:|" + unassignedId)).get();
        BComponent target = this.getComponent(op);
        BLinkTemplate linkTemplate = this.getLinkTemplate(op);
        LinkCheck linkCheck = target.checkLink(source, linkTemplate.sourceSlot, linkTemplate.targetSlot, null);
        if (!linkCheck.isValid()) {
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"var loading = $('").w((Object)op.scope("assigned.loading")).w((Object)"');");
            out.w((Object)"loading.style.color='red';");
            out.w((Object)"loading.textContent='").safe((Object)HxUtil.escapeJsStringLiteral((String)linkCheck.getInvalidReason())).w((Object)"';");
            out.w((Object)("tab.exception('" + op.scope("assigned") + "~" + unassignedId + "');"));
            throw new CannotSaveException(linkCheck.getInvalidReason());
        }
        BLink link = target.makeLink(source, linkTemplate.sourceSlot, linkTemplate.targetSlot, null);
        target.add(null, (BValue)link);
    }

    public BExpression getAssignedExpression(BComponent target, HxOp op) {
        BLinkTemplate linkTemplate = this.getLinkTemplate(op);
        return this.getAssignedExpression(linkTemplate, target, op);
    }

    public BExpression getAssignedExpression(BLinkTemplate linkTemplate, BComponent target, HxOp op) {
        return linkTemplate.getAssignedLinksExpression(target, (Context)op);
    }

    public BObject getUnassignedTable(BComponent target, HxOp op) {
        BQuery query = this.getQuery(op);
        BPredicate predicate = query.getPredicate();
        ExpressionBuilder b = new ExpressionBuilder();
        if (predicate != null && predicate.getPredicateExpr() != null) {
            b.and(predicate.getPredicateExpr().newExprCopy());
        }
        b.and(Predicates.not((BExpression)this.getAssignedExpression(target, op)));
        query.where(b.getExpression());
        if (query.getProjection().get("in") != null) {
            query.getProjection().remove("in");
        }
        return query;
    }

    public BObject getAssignedTable(BComponent target, HxOp op) {
        BQuery query = this.getQuery(op);
        BPredicate predicate = query.getPredicate();
        ExpressionBuilder b = new ExpressionBuilder();
        if (predicate != null && predicate.getPredicateExpr() != null) {
            b.and(predicate.getPredicateExpr().newExprCopy());
        }
        b.and(this.getAssignedExpression(target, op));
        query.where(b.getExpression());
        if (query.getProjection().get("in") != null) {
            query.getProjection().remove("in");
        }
        return query;
    }

    public BLinkTemplate getLinkTemplate(HxOp op) {
        BLinkTemplate linkTemplate = (BLinkTemplate)op.get();
        return linkTemplate;
    }

    public BQuery getQuery(HxOp op) {
        BLinkTemplate linkTemplate = this.getLinkTemplate(op);
        BQuery query = QueryUtil.makeQuery((BTypeSpec)linkTemplate.type.getTypeSpec());
        return query;
    }

    public static void validate(Type type, boolean exactType, int atLeastCount, BHxAssignmentFE linkFE, HxOp op) throws Exception {
        BComponent c;
        int i;
        linkFE.init(op);
        String values = op.getFormValue("valueAll");
        String[] selectOptions = new String[]{};
        if (values != null) {
            selectOptions = TextUtil.split((String)values, (char)'|');
        }
        int count = 0;
        Tab assignedTab = linkFE.getTabs(op)[0];
        BHxQueryTableView view = (BHxQueryTableView)assignedTab.view;
        TableContents contents = view.writeContents(assignedTab.op);
        for (i = 0; i < contents.tr.size(); ++i) {
            TableContents.Tr tr = (TableContents.Tr)contents.tr.get(i);
            BComponent c2 = (BComponent)BOrd.make((String)("station:|" + view.unscopeId(tr.id, op))).get();
            if ((!exactType || !c2.getType().equals(type)) && (exactType || !c2.getType().is(type))) continue;
            ++count;
        }
        if (!linkFE.isUnassignMode(op)) {
            for (i = 0; i < selectOptions.length; ++i) {
                c = (BComponent)BOrd.make((String)("station:|" + selectOptions[i])).get();
                if ((!exactType || !c.getType().equals(type)) && (exactType || !c.getType().is(type))) continue;
                --count;
            }
        } else {
            for (i = 0; i < selectOptions.length; ++i) {
                c = (BComponent)BOrd.make((String)("station:|" + selectOptions[i])).get();
                if ((!exactType || !c.getType().equals(type)) && (exactType || !c.getType().is(type))) continue;
                ++count;
            }
        }
        if (count < atLeastCount) {
            throw new IllegalStateException(linkLex.getText("LinkFE.validationCountError", new Object[]{HxTabUtil.getPluralDisplayName((Type)linkFE.getComponent(op).getType(), (Context)op), "" + atLeastCount, type.getDisplayName((Context)op)}));
        }
    }
}

