/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.job;

import com.tridium.hx.progress.HxProgressJobDialog;
import com.tridium.hx.util.HxUtils;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.JobLogDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.BHxTabbedView;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.access.BAccessControlService;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public abstract class BHxAbstractJobView
extends BHxTabbedView
implements HxProgressJobDialog.IHxProgressDialogParent {
    public static final Type TYPE = Sys.loadType(BHxAbstractJobView.class);
    static BImage unknown = BImage.make((String)"module://icons/x16/job/unknown.png");
    static BImage running = BImage.make((String)"module://icons/x16/job/running.png");
    static BImage success = BImage.make((String)"module://icons/x16/job/success.png");
    static BImage failed = BImage.make((String)"module://icons/x16/job/failed.png");
    static final int UNKNOWN = 1;
    static final int RUNNING = 2;
    static final int CANCELED = 4;
    static final int FAILED = 8;
    static final int SUCCESS = 16;
    private static int lastJobKey = -1;
    public HxProgressJobDialog.ProgressEvent progressEvent = HxProgressJobDialog.makeProgress((String)this.getJobTitle(), (BHxView)this, (HxProgressJobDialog.IHxProgressDialogParent)this);
    public ProgressCommand progressCommand;
    static final Lexicon lex = Lexicon.make(BHxAbstractJobView.class);
    public static final Logger log = Logger.getLogger("entsec");
    private static Object lock = new Object();

    public Type getType() {
        return TYPE;
    }

    protected BHxAbstractJobView() {
        this.registerEvent((Event)this.progressEvent);
        this.progressCommand = new ProgressCommand((BHxView)this);
        this.registerEvent((Event)this.progressCommand);
        this.progressEvent.setJobCompleteHandler((HxProgressJobDialog.IJobCompleteHandler)this.progressCommand);
    }

    public abstract String getJobTitle();

    public abstract Tab getTab(HxOp var1) throws Exception;

    public void write(HxOp op) throws Exception {
        this.checkProgress(op);
        super.write(op);
    }

    public void checkProgress(HxOp op) throws Exception {
        op.setDynamic();
        if (op.getRequest().getSession().getAttribute("info") != null) {
            log.fine("import info found");
            op.addOnload(this.progressCommand.getInvokeCode(op));
        }
    }

    public void update(HxOp op) throws Exception {
        super.update(op);
        String name = op.scope("job");
        String ordStr = op.getFormValue(name);
        if (ordStr != null) {
            HxUtils.forceUpdate((BRelTime)BRelTime.make((long)750L), (HxOp)op);
        }
        this.progressEvent.getDialog().updateContent(op);
    }

    public boolean needsFileSubmit(HxOp op) {
        return false;
    }

    public FilePath getFilePath(BComponent c, Property p, HxOp op) {
        return new FilePath("^temp/" + p.getName());
    }

    public BObject save(HxOp op) throws Exception {
        log.fine("save");
        boolean fileFound = false;
        boolean needsFileSubmit = this.needsFileSubmit(op);
        BComponent c = (BComponent)super.save(op);
        if (needsFileSubmit) {
            Property[] props = c.getPropertiesArray();
            BOrd[] ordChildren = (BOrd[])c.getChildren(BOrd.class);
            for (int i = 0; i < props.length; ++i) {
                BValue value = c.get(props[i]);
                log.fine("fileOrdValue:" + value);
                if (!(value instanceof BOrd) || value.toString().indexOf("file:") <= -1) continue;
                fileFound = true;
                BOrd ord = (BOrd)value;
                BIFile tempfile = (BIFile)ord.get();
                FilePath filePath = this.getFilePath(c, props[i], op);
                BIFile newFile = BFileSystem.INSTANCE.makeFile(filePath);
                BajaFileUtil.pipe((BIFile)tempfile, (BIFile)newFile);
                c.set(props[i], (BValue)BOrd.make((OrdQuery)filePath));
                log.fine("setting file:");
                File file = BFileSystem.INSTANCE.pathToLocalFile(filePath);
                file.deleteOnExit();
            }
        }
        if (!needsFileSubmit || fileFound) {
            log.fine("setting import info");
            op.getRequest().getSession().setAttribute("info", (Object)c);
        }
        return c;
    }

    public BComponent getSavedComponent(HxOp op) {
        BComponent c = (BComponent)op.getRequest().getSession().getAttribute("info");
        log.fine("getSavedComponent:" + c);
        op.getRequest().getSession().removeAttribute("info");
        log.fine("removing saved component:");
        return c;
    }

    public void saved(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"document.forms[0].submit();");
        log.fine("submit");
    }

    public Tab[] getTabs(HxOp op) throws Exception {
        return new Tab[]{this.getTab(op)};
    }

    public void jobSuccess(BJob job, Command progressCommand, HxOp op) throws Exception {
        BHxAbstractJobView.openSuccessDialog(job, progressCommand, op);
    }

    public void jobFailed(BJob job, Command progressCommand, HxOp op) throws Exception {
        BHxAbstractJobView.openErrorDialog(job, progressCommand, op);
    }

    public static void openErrorDialog(BJob job, Command command, HxOp op) throws Exception {
        BHxAbstractJobView.openErrorDialog(job, command, null, op);
    }

    public static void openErrorDialog(BJob job, Command command, String title, HxOp op) throws Exception {
        if (BHxAbstractJobView.shouldOpenDialog(job)) {
            new JobLogDialog.JobLogDialogRefresh(command, job, title, null).open(op);
        }
    }

    public static void openSuccessDialog(BJob job, Command command, HxOp op) throws Exception {
        BHxAbstractJobView.openSuccessDialog(job, command, null, op);
    }

    public static void openSuccessDialog(BJob job, Command command, BOrd redirectOrd, HxOp op) throws Exception {
        if (BHxAbstractJobView.shouldOpenDialog(job)) {
            new JobLogDialog.JobLogDialogRefresh(command, job, null, redirectOrd).open(op);
        }
    }

    public static BImage getJobStateImage(BJobState jobState) {
        int state = 0;
        switch (jobState.getOrdinal()) {
            case 0: {
                state |= 1;
                break;
            }
            case 1: {
                state |= 2;
                break;
            }
            case 2: 
            case 3: {
                state |= 4;
                break;
            }
            case 5: {
                state |= 8;
                break;
            }
            case 4: {
                state |= 0x10;
            }
        }
        if (state == 0) {
            return null;
        }
        if ((state & 0x10) != 0) {
            return success;
        }
        if ((state & 2) != 0) {
            return running;
        }
        if ((state & 4) != 0) {
            return failed;
        }
        if ((state & 8) != 0) {
            return failed;
        }
        if ((state & 1) != 0) {
            return unknown;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openNextJobDialog() {
        Object object = lock;
        synchronized (object) {
            lastJobKey = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldOpenDialog(BJob job) {
        Object object = lock;
        synchronized (object) {
            int jobKey = System.identityHashCode(job);
            if (lastJobKey == jobKey) {
                return false;
            }
            lastJobKey = jobKey;
            return true;
        }
    }

    public class ProgressCommand
    extends Command
    implements HxProgressJobDialog.IJobCompleteHandler {
        public ProgressCommand(BHxView view) {
            super(view);
        }

        public void invoke(BJob job, HxOp op) throws Exception {
            if (job.getJobState().equals((Object)BJobState.failed) || job.getJobState().equals((Object)BJobState.canceled)) {
                BHxAbstractJobView.this.jobFailed(job, this, op);
            } else if (job.getJobState().equals((Object)BJobState.success)) {
                BHxAbstractJobView.this.jobSuccess(job, this, op);
            }
        }

        public void handle(HxOp op) throws Exception {
            try {
                BHxAbstractJobView.this.progressEvent.handle(op);
            }
            catch (NullPointerException e) {
                BAccessControlService.LOG.log(Level.FINE, "Progress Event Error", e);
            }
        }
    }

    public class SubmitCommand
    extends SmartCommand {
        public SubmitCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "submitCommand";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            op.getHtmlWriter().w((Object)"document.forms[0].submit();");
        }
    }
}

