/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.history;

import com.tridium.smartTableHx.SmartCommand;
import com.tridiumx.entsec.securityUtil.query.BEmptyExtent;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsecHx.factory.SmartCommandArray;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxQueryTableView;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.history.BHistoryId;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryNotFoundException;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.hx.HxOp;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BExtent;
import javax.baja.query.BQuery;
import javax.baja.sys.BIObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
public abstract class BHxHistoryView
extends BHxQueryTableView {
    public static final Type TYPE = Sys.loadType(BHxHistoryView.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    protected abstract Type getTrendRecordType();

    @Override
    public BQuery getQuery(HxOp op) {
        BIHistory history = this.getHistory(op);
        BTypeSpec recType = history.getRecordType();
        BQuery query = QueryUtil.makeQuery((BTypeSpec)recType);
        BHistoryId id = history.getId();
        query.add("base", (BValue)BOrd.make((String)("history:" + id)));
        query.from((BExtent)new BEmptyExtent(recType));
        return QueryUtil.getWorkingCopy((BQuery)query, (Context)op);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        SmartCommandArray commandArray = SmartCommandArray.make(super.getButtonCommands(op));
        commandArray.removeCommand(this.addCommand);
        commandArray.removeCommand(this.deleteCommand);
        commandArray.removeCommand(this.hyperlinkCommand);
        commandArray.removeCommand(this.renameCommand);
        commandArray.removeCommand(this.columnsCommand);
        return commandArray.getCommands();
    }

    @Override
    public String getRowKey(Type rowType, TableCursor<? extends BIObject> cursor, HxOp op) {
        BITable table = cursor.getTable();
        return cursor.cell(table.getColumns().get("timestamp")).toString();
    }

    public boolean supportsAutoRefresh(HxOp op) {
        return true;
    }

    private BIHistory getHistory(HxOp op) {
        BHistoryExt ext = (BHistoryExt)op.get();
        BIHistory history = ext.getHistory();
        if (history == null) {
            throw new HistoryNotFoundException(ext.getHistoryConfig().getId());
        }
        return history;
    }
}

