/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.graphics;

import com.tridium.hx.ErrorDialog;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.ConfirmDialog;
import com.tridium.smartTableHx.DynamicDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.nav.BEntsecNav;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxQueryTableView;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.baja.agent.BPxView;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.BTypeSpec;

@NiagaraType(agent={@AgentOn(types={"entsec:PxGraphics"}, requiredPermissions="r")})
@NiagaraSingleton
public class BHxPxGraphicsView
extends BHxQueryTableView {
    public static final BHxPxGraphicsView INSTANCE = new BHxPxGraphicsView();
    public static final Type TYPE = Sys.loadType(BHxPxGraphicsView.class);
    private static BFacets options = BFacets.make((String)"lexicon", (String)Sys.getModuleForClass(BHxPxGraphicsView.class).getModuleName());
    public static BEnumRange mediaRange = BEnumRange.make(null, (int[])new int[]{0, 1}, (String[])new String[]{"WorkbenchPxMedia", "HxPxMedia"}, (int)2, (BFacets)options);
    protected SmartCommand addCommand = new AddCommand((BHxView)this);
    protected SmartCommand hyperlinkCommand;
    protected SmartCommand editGraphic;
    protected SmartCommand graphicSettings;
    protected SmartCommand deleteCommand;
    protected SmartCommand editNav;
    protected SmartCommand removeNav;

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxPxGraphicsView() {
        this.registerEvent((Event)this.addCommand);
        this.hyperlinkCommand = new HyperlinkCommand((BHxView)this);
        this.registerEvent((Event)this.hyperlinkCommand);
        this.editGraphic = new EditGraphic((BHxView)this);
        this.registerEvent((Event)this.editGraphic);
        this.graphicSettings = new GraphicSettings((BHxView)this);
        this.registerEvent((Event)this.graphicSettings);
        this.deleteCommand = new DeleteCommand((BHxView)this);
        this.registerEvent((Event)this.deleteCommand);
        this.removeNav = new RemoveNav((BHxView)this);
        this.registerEvent((Event)this.removeNav);
        this.editNav = new EditNav((BHxView)this);
        this.registerEvent((Event)this.editNav);
    }

    @Override
    public void write(HxOp op) throws Exception {
        super.write(op);
    }

    public boolean process(HxOp op) throws Exception {
        return super.process(op);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.addCommand, this.hyperlinkCommand, this.editGraphic, this.graphicSettings, this.editNav, this.deleteCommand, this.removeNav, this.filterCommand, this.columnsCommand, this.refreshCommand, this.reportCommand, this.exportCommand};
    }

    @Override
    public BImage getRowIcon(TableCursor<? extends BIObject> cursor, HxOp op) {
        BITable table = cursor.getTable();
        Column keyColumn1 = table.getColumns().get(table.getColumns().size() - 4);
        String slotPath = cursor.cell(keyColumn1).toString();
        return BImage.make((BIcon)BIcon.make((String)slotPath));
    }

    private byte[] getDefaultPxPage(BTypeSpec media) throws Exception {
        StringBuffer b = new StringBuffer();
        b.append("<?xml version='1.0' encoding='UTF-8'?>\n");
        b.append("<!-- Niagara Presentation XML -->\n");
        b.append("<px version='1.0' media='").append(media).append("'>\n\n");
        b.append("<import>\n");
        b.append("<module name='baja'/>\n");
        b.append("<module name='gx'/>\n");
        b.append("<module name='bajaui'/>\n");
        b.append("</import>\n\n");
        b.append("<content>\n");
        b.append("<ScrollPane>\n");
        b.append("  <CanvasPane name='content' viewSize='500,400' background='white'/>\n");
        b.append("</ScrollPane>\n");
        b.append("</content>\n\n");
        b.append("</px>");
        return b.toString().getBytes("UTF-8");
    }

    public class EditNav
    extends SmartCommand {
        protected EditNavDialog dlg;

        public EditNav(BHxView view) {
            super(view);
            this.dlg = new EditNavDialog((Command)this, this.getDisplayName(null));
        }

        public String getName(HxOp op) {
            return "editNav";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            this.save(op);
        }

        public BObject save(HxOp op) throws Exception {
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            BOrd ord = BOrd.make((String)("station:|" + selectionList[0]));
            BPxView pxView = (BPxView)ord.get();
            BComponent parent = pxView.getParent().asComponent();
            Property p = null;
            BEntsecNav[] navs = (BEntsecNav[])parent.getChildren(BEntsecNav.class);
            if (navs.length > 0) {
                p = navs[0].getPropertyInParent();
            }
            BEntsecNav nav = (BEntsecNav)this.getTab(op).save();
            if (p == null) {
                p = parent.add(null, (BValue)nav);
            } else {
                parent.set(p, (BValue)nav);
            }
            try {
                BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
                service.doRebuildDefaultNav();
                this.refresh(op);
            }
            catch (Exception e) {
                try {
                    BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
                    nav.setParentPath(BEntsecNav.parentPath.getDefaultValue().toString());
                    service.doRebuildDefaultNav();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    parent.remove(p);
                    BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
                    service.doRebuildDefaultNav();
                    new ErrorDialog("Error", (Command)this, (Throwable)e, "Navigation not able to be rebuilt. Removing nav hint and rebuilding.").open(op);
                }
            }
            return op.get();
        }

        public boolean process(HxOp op) throws Exception {
            if (!this.matchesScope(op)) {
                return false;
            }
            if (super.process(op)) {
                return true;
            }
            return this.getTab(op).process();
        }

        public Tab getTab(HxOp op) {
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            BOrd ord = BOrd.make((String)("station:|" + selectionList[0]));
            BPxView pxView = (BPxView)ord.get();
            BComponent parent = pxView.getParent().asComponent();
            BEntsecNav nav = new BEntsecNav();
            nav.setFlags((Slot)BEntsecNav.isGroup, 4);
            nav.setFlags((Slot)BEntsecNav.childTypes, 4);
            nav.setFlags((Slot)BEntsecNav.navView, 4);
            nav.setFlags((Slot)BEntsecNav.iconOverride, 4);
            nav.setIconOverride(pxView.getIcon());
            BEntsecNav[] navs = (BEntsecNav[])parent.getChildren(BEntsecNav.class);
            if (navs.length > 0) {
                nav = navs[0];
            }
            HxOp fieldOp = op.make(this.getName(op), (BObject)nav, null);
            Tab tab = new Tab((BHxView)BHxFieldSheet.INSTANCE, fieldOp);
            return tab;
        }

        protected class EditNavDialog
        extends DynamicDialog {
            EditNavDialog(Command handler, String title) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                EditNav.this.getTab(op).write();
            }
        }
    }

    public class RemoveNav
    extends SmartCommand {
        protected ConfirmDialog dlg;

        public RemoveNav(BHxView view) {
            super(view);
            this.dlg = new ConfirmDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "removeNav";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            this.save(op);
        }

        public BObject save(HxOp op) throws Exception {
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            boolean useful = false;
            for (int i = 0; i < selectionList.length; ++i) {
                BOrd ord = BOrd.make((String)("station:|" + selectionList[i]));
                BPxView pxView = (BPxView)ord.get();
                BComponent parent = pxView.getParent().asComponent();
                Property p = null;
                BEntsecNav[] navs = (BEntsecNav[])parent.getChildren(BEntsecNav.class);
                if (navs.length <= 0) continue;
                p = navs[0].getPropertyInParent();
                parent.remove(p);
                useful = true;
            }
            if (useful) {
                BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
                service.doRebuildDefaultNav();
                this.refresh(op);
            }
            return op.get();
        }

        public boolean process(HxOp op) throws Exception {
            if (!this.matchesScope(op)) {
                return false;
            }
            return super.process(op);
        }
    }

    public class GraphicSettings
    extends SmartCommand {
        protected GraphicSettingsDialog dlg;

        public GraphicSettings(BHxView view) {
            super(view);
            this.dlg = new GraphicSettingsDialog((Command)this, this.getDisplayName(null));
        }

        public String getName(HxOp op) {
            return "graphicSettings";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            this.save(op);
            BHxSmartTableView sView = (BHxSmartTableView)this.getView();
            if (sView.isEnabled(op)) {
                sView.reloadTable(op);
            }
        }

        public BObject save(HxOp op) throws Exception {
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            BOrd ord = BOrd.make((String)("station:|" + selectionList[0]));
            BPxView pxView = (BPxView)ord.get();
            BComponent c = (BComponent)this.getTab(op).save();
            String viewName = c.get(SlotPath.escape((String)this.lexModule.getText("viewName", (Context)op))).toString();
            viewName = SlotPath.escape((String)viewName);
            String viewIcon = c.get(SlotPath.escape((String)this.lexModule.getText("viewIcon", (Context)op))).toString();
            BDynamicEnum media = (BDynamicEnum)c.get(SlotPath.escape((String)this.lexModule.getText("targetMedia", (Context)op)));
            BTypeSpec mediaTypeSpec = media.getOrdinal() == 0 ? BTypeSpec.make((String)"workbench:WbPxMedia") : BTypeSpec.make((String)"hx:HxPxMedia");
            if (!pxView.getName().equals(viewName)) {
                File dir = new File(Sys.getStationHome(), "px");
                dir.mkdirs();
                File file = new File(dir, pxView.getName() + ".px");
                File file2 = new File(dir, viewName + ".px");
                FileUtil.move((File)file, (File)file2);
                BOrd newOrd = BOrd.make((String)("file:^px/" + viewName + ".px"));
                pxView.getParent().asComponent().rename(pxView.getPropertyInParent(), viewName);
                pxView.setPxFile(newOrd);
            }
            if (!mediaTypeSpec.equals((Object)pxView.getMedia())) {
                pxView.setMedia(mediaTypeSpec);
            }
            if (!viewIcon.equals(pxView.getIcon().toString())) {
                pxView.setIcon(BIcon.make((String)viewIcon));
            }
            return op.get();
        }

        public boolean process(HxOp op) throws Exception {
            if (!this.matchesScope(op)) {
                return false;
            }
            if (super.process(op)) {
                return true;
            }
            return this.getTab(op).process();
        }

        public Tab getTab(HxOp op) {
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            BOrd ord = BOrd.make((String)("station:|" + selectionList[0]));
            BPxView pxView = (BPxView)ord.get();
            BComponent c = new BComponent();
            String viewName = pxView.getName();
            String viewIcon = pxView.getIcon().toString();
            BDynamicEnum media = BDynamicEnum.make((int)0, (BEnumRange)mediaRange);
            BTypeSpec mediaTypeSpec = pxView.getMedia();
            if (mediaTypeSpec.toString().equals("hx:HxPxMedia")) {
                media = BDynamicEnum.make((int)1, (BEnumRange)mediaRange);
            }
            c.add(this.lexModule.getText("viewName", (Context)op), (BValue)BString.make((String)viewName));
            c.add(this.lexModule.getText("viewIcon", (Context)op), (BValue)BOrd.make((String)viewIcon));
            c.add(this.lexModule.getText("targetMedia", (Context)op), (BValue)media);
            HxOp fieldOp = op.make(this.getName(op), (BObject)c, null);
            Tab tab = new Tab((BHxView)BHxFieldSheet.INSTANCE, fieldOp);
            return tab;
        }

        protected class GraphicSettingsDialog
        extends DynamicDialog {
            GraphicSettingsDialog(Command handler, String title) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                GraphicSettings.this.getTab(op).write();
            }
        }
    }

    public class AddCommand
    extends SmartCommand {
        protected AddDialog dlg;

        public AddCommand(BHxView view) {
            super(view);
            this.dlg = new AddDialog((Command)this, this.getDisplayName(null));
        }

        public String getName(HxOp op) {
            return "add";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            this.save(op);
            BHxSmartTableView sView = (BHxSmartTableView)this.getView();
            if (sView.isEnabled(op)) {
                sView.reloadTable(op);
            }
        }

        public BObject save(HxOp op) throws Exception {
            BComponent c = (BComponent)this.getTab(op).save();
            String viewName = c.get(SlotPath.escape((String)this.lexModule.getText("viewName", (Context)op))).toString();
            viewName = SlotPath.escape((String)viewName);
            String viewIcon = c.get(SlotPath.escape((String)this.lexModule.getText("viewIcon", (Context)op))).toString();
            BDynamicEnum media = (BDynamicEnum)c.get(SlotPath.escape((String)this.lexModule.getText("targetMedia", (Context)op)));
            BTypeSpec mediaTypeSpec = media.getOrdinal() == 0 ? BTypeSpec.make((String)"workbench:WbPxMedia") : BTypeSpec.make((String)"hx:HxPxMedia");
            byte[] bytes = BHxPxGraphicsView.this.getDefaultPxPage(mediaTypeSpec);
            BOrd pxOrd = this.addPxPage(viewName, bytes, op);
            BPxView view = new BPxView(pxOrd);
            view.setIcon(BIcon.make((BOrd)BOrd.make((String)viewIcon)));
            view.setMedia(mediaTypeSpec);
            if (Sys.getStation().get("Graphics") == null) {
                Sys.getStation().add("Graphics", (BValue)new BFolder());
            }
            BComponent folder = (BComponent)Sys.getStation().get("Graphics");
            BComponent viewContainer = new BComponent();
            viewContainer.add(viewName, (BValue)view);
            folder.add(viewName, (BValue)viewContainer);
            return op.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BOrd addPxPage(String name, byte[] bytes, HxOp op) throws Exception {
            File dir = new File(Sys.getStationHome(), "px");
            dir.mkdirs();
            File file = new File(dir, name + ".px");
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
                out.write(bytes);
            }
            return BOrd.make((String)("file:^px/" + name + ".px"));
        }

        public boolean process(HxOp op) throws Exception {
            if (!this.matchesScope(op)) {
                return false;
            }
            if (super.process(op)) {
                return true;
            }
            return this.getTab(op).process();
        }

        public Tab getTab(HxOp op) {
            BComponent c = new BComponent();
            c.add(this.lexModule.getText("viewName", (Context)op), (BValue)BString.make((String)"Graphic"));
            c.add(this.lexModule.getText("viewIcon", (Context)op), (BValue)BOrd.make((String)"module://icons/x16/views/view.png"));
            c.add(this.lexModule.getText("targetMedia", (Context)op), (BValue)BDynamicEnum.make((int)0, (BEnumRange)mediaRange));
            HxOp fieldOp = op.make(this.getName(op), (BObject)c, null);
            Tab tab = new Tab((BHxView)BHxFieldSheet.INSTANCE, fieldOp);
            return tab;
        }

        protected class AddDialog
        extends DynamicDialog {
            AddDialog(Command handler, String title) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                AddCommand.this.getTab(op).write();
            }
        }
    }

    public class EditGraphic
    extends SmartCommand {
        public EditGraphic(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "editGraphic";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public void handle(HxOp op) throws Exception {
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            BOrd ord = BOrd.make((String)("station:|" + selectionList[0]));
            BComplex c = (BComplex)ord.get();
            BComponent parent = c.getParentComponent();
            ord = BOrd.make((String)("station:|" + parent.getSlotPath() + "|view:" + c.getName() + "/editor"));
            this.redirect(op, op.toUri(ord));
        }
    }

    public class DeleteCommand
    extends SmartCommand {
        private ConfirmDialog dlg;

        public DeleteCommand(BHxView view) {
            super(view);
            this.dlg = new ConfirmDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "delete";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            boolean rebuildNav = false;
            for (int i = 0; i < selectionList.length; ++i) {
                BOrd ord = BOrd.make((String)("station:|" + selectionList[i]));
                BPxView pxView = (BPxView)ord.get();
                BComponent parent = pxView.getParentComponent();
                if (((BEntsecNav[])parent.getChildren(BEntsecNav.class)).length > 0) {
                    rebuildNav = true;
                }
                BOrd pxOrd = pxView.getPxFile();
                try {
                    BIFile file = (BIFile)pxOrd.get();
                    file.delete();
                }
                catch (UnresolvedException unresolvedException) {
                    // empty catch block
                }
                if (parent.getType().equals(BComponent.TYPE)) {
                    parent.getParent().asComponent().remove(parent.getPropertyInParent());
                    continue;
                }
                parent.remove(pxView.getPropertyInParent());
            }
            if (rebuildNav) {
                BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
                service.doRebuildDefaultNav();
                this.refresh(op);
            } else {
                BHxSmartTableView sView = (BHxSmartTableView)this.getView();
                if (sView.isEnabled(op)) {
                    sView.reloadTable(op);
                }
            }
        }
    }

    public class HyperlinkCommand
    extends SmartCommand {
        public HyperlinkCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "viewGraphic";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public boolean isDefaultAction() {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            BOrd ord = BOrd.make((String)("station:|" + selectionList[0]));
            BComplex c = (BComplex)ord.get();
            BComponent parent = c.getParentComponent();
            ord = BOrd.make((String)("station:|" + parent.getSlotPath()));
            this.redirect(op, op.toUri(ord));
        }
    }
}

