/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.graphics;

import com.tridium.hx.fieldeditors.BHxStringFE;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.SaveCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridiumx.entsecHx.securityUtilHx.graphics.BHxImageFileTableView;
import java.io.File;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"entsec:ImageFileTable"}, requiredPermissions="rR")})
@NiagaraSingleton
public class BHxImageFileView
extends BHxView {
    public static final Lexicon lex = Lexicon.make(BHxImageFileTableView.class);
    public static final BHxImageFileView INSTANCE = new BHxImageFileView();
    public static final Type TYPE = Sys.loadType(BHxImageFileView.class);
    private SmartCommand saveCommand;
    private SmartCommand tableCommand = new TableCommand(this);

    public Type getType() {
        return TYPE;
    }

    protected BHxImageFileView() {
        this.registerEvent((Event)this.tableCommand);
        this.saveCommand = new Save(this);
        this.registerEvent((Event)this.saveCommand);
    }

    public void write(HxOp op) throws Exception {
        op.addStyleSheet(BOrd.make((String)"module://smartTableHx/rc/smartTable.css"));
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/smartTable.js"));
        Object o = op.getRequest().getSession().getAttribute("uploadedImage");
        if (o instanceof BOrd) {
            op.getRequest().getSession().removeAttribute("uploadedImage");
            BOrd ord = (BOrd)o;
            BIFile field = (BIFile)ord.get();
            String text = ord.toString();
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<div ");
            out.attr("class", "smartTable-setup-panel").w((Object)">");
            HxTabUtil.writeTitle((String)text, (HxOp)op);
            HxTabUtil.writeCommands((SmartCommand[])new SmartCommand[]{this.tableCommand}, (boolean)true, (HxOp)op);
            out.w((Object)"</div>");
            out.w((Object)"&nbsp;");
            out.w((Object)"<div>");
            HxUtil.makeImageJS((BImage)BImage.make((BOrd)ord), (HxOp)op);
            out.w((Object)"</div>");
        } else {
            op.setMultiPartForm();
            String name = "Image";
            String text = lex.getText("addNew.label", new Object[]{name});
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<div ");
            out.attr("class", "smartTable-setup-panel").w((Object)">");
            HxTabUtil.writeTitle((String)text, (HxOp)op);
            HxTabUtil.writeCommands((SmartCommand[])new SmartCommand[]{this.saveCommand, this.tableCommand}, (boolean)true, (HxOp)op);
            out.w((Object)"</div>");
            out.w((Object)"&nbsp;");
            out.w((Object)"<div ");
            out.attr("class", "smartTable-setup-panel").w((Object)">");
            out.w((Object)"<table>");
            out.w((Object)"<tr ");
            out.w((Object)"><td class='smartTable-setup-label'>");
            out.safe((Object)lex.getText("filePath"));
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            HxOp fieldOp = op.make("filePath", (BObject)BString.make((String)"^images"), null);
            BHxStringFE.INSTANCE.write(fieldOp);
            out.w((Object)"</td></tr>");
            out.w((Object)"<tr ");
            out.w((Object)"><td class='smartTable-setup-label'>");
            out.safe((Object)lex.getText("fileToUpload"));
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            BHxImageFileView.writeFileBrowser(op);
            out.w((Object)"</td></tr>");
            out.w((Object)"</table>");
            out.w((Object)"</div>");
        }
    }

    public static void writeFileBrowser(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<input type='file'");
        out.w((Object)"id='fileName' name='fileName' size='40'");
        out.w((Object)"onchange='");
        SaveCommand.setModified((HxOp)op);
        out.w((Object)"var ext = this.value.toLowerCase();  ext = ext.substring(ext.length-3,ext.length);");
        out.w((Object)"if(ext != &quot;jpg&quot; && ext !=&quot;gif&quot; && ext != &quot;png&quot; && ext != &quot;svg&quot;) {");
        out.w((Object)"alert(&quot;You selected a .&quot;+ext+&quot; file. ");
        out.w((Object)"Please select a .jpg, .gif, .svg or .png file instead.&quot;);");
        out.w((Object)"this.value=&quot;&quot;;}'");
        out.w((Object)"/>");
    }

    public boolean process(HxOp op) throws Exception {
        return super.process(op);
    }

    public BObject save(HxOp op) throws Exception {
        BIFile file = op.getFile("fileName");
        String filename = op.getFormValue("fileName");
        if (file == null) {
            throw new IllegalStateException("File Not Found");
        }
        int index = filename.lastIndexOf("\\");
        if (index != -1) {
            filename = filename.substring(index + 1, filename.length());
        }
        HxOp fieldOp = op.make("filePath", (BObject)BString.make((String)"file:^images"), null);
        String newPath = BHxStringFE.INSTANCE.save(fieldOp).toString();
        String body = file.getFilePath().getBody();
        File f = BFileSystem.INSTANCE.pathToLocalFile(file.getFilePath());
        FilePath parentPath = new FilePath(newPath);
        File parent = BFileSystem.INSTANCE.pathToLocalFile(parentPath);
        if (!parent.exists()) {
            parent.mkdirs();
        } else if (!parent.isDirectory()) {
            throw new IllegalStateException("File path must be a directory");
        }
        File newFile = new File(parent, filename);
        FileUtil.copyFile((File)f, (File)newFile);
        BOrd newOrd = BOrd.make((String)("file:" + newPath + "/" + filename));
        op.getRequest().getSession().setAttribute("uploadedImage", (Object)newOrd);
        return op.get();
    }

    public static class TableCommand
    extends SmartCommand {
        public TableCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "upTable";
        }

        public String getDisplayName(HxOp op) {
            BComponent c = (BComponent)op.get();
            return c.getDisplayName((Context)op);
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            BComponent c = (BComponent)op.get();
            this.redirect(op, op.toUri(BOrd.make((String)("station:|" + c.getSlotPath()))));
        }
    }

    public static class Save
    extends SaveCommand {
        public Save(BHxView view) {
            super(view);
        }

        public void onHandle(HxOp op) throws Exception {
            String filename = op.getFormValue("fileName");
            if (filename == null || filename.length() == 0) {
                throw new IllegalStateException("File Not Found");
            }
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"document.forms[0].submit();");
        }

        public boolean registerOnInputs() {
            return true;
        }
    }
}

