/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.fieldeditors;

import com.tridium.hx.fieldeditors.BHxAbsTimeFE;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsecHx.BHxAccessProfile;
import com.tridiumx.entsecHx.securityUtilHx.fieldeditors.BHxTimeZoneFE;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraSingleton
public class BHxSystemClockFE
extends BHxFieldEditor {
    public static final BHxSystemClockFE INSTANCE = new BHxSystemClockFE();
    public static final Type TYPE = Sys.loadType(BHxSystemClockFE.class);
    MonthConverter monthConverter = new MonthConverter();
    MonthTagConverter monthTagConverter = new MonthTagConverter();
    HourConverter hourConverter = new HourConverter();
    AmPmConverter ampmConverter = new AmPmConverter();
    SimplePadConverter padConverter = new SimplePadConverter();

    public Type getType() {
        return TYPE;
    }

    protected BHxSystemClockFE() {
    }

    public void enable(String name, HtmlWriter out, HxOp op) {
        out.w((Object)"var e = $$('").w((Object)op.scope(name)).w((Object)"'); if(e!= null) e.disabled='';");
    }

    public void disable(String name, HtmlWriter out, HxOp op) {
        out.w((Object)"var e = $$('").w((Object)op.scope(name)).w((Object)"'); if(e!= null) e.disabled='disabled';");
    }

    public void readonly(String name, HtmlWriter out, HxOp op) {
        out.w((Object)"var e = $$('").w((Object)op.scope(name)).w((Object)"'); if(e!= null) e.readOnly='readOnly';");
    }

    public void writable(String name, HtmlWriter out, HxOp op) {
        out.w((Object)"var e = $$('").w((Object)op.scope(name)).w((Object)"'); if(e!= null) e.readOnly='';");
    }

    public void write(HxOp op) throws Exception {
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/smartTable.js"));
        BAbsTime time = (BAbsTime)op.get();
        HtmlWriter out = op.getHtmlWriter();
        boolean readonly = !op.canWrite();
        op.setReadonly(true);
        Tab timeTab = this.getTimeTab(op);
        Tab timeZoneTab = this.getTimeZoneTab(op);
        out.w((Object)"<input ");
        out.attr("name", op.scope("changeTime"));
        out.attr("id", op.scope("changeTime"));
        if (readonly) {
            out.w((Object)" disabled=disabled ");
        } else {
            out.w((Object)" onclick=\" if(this.checked) {if(!confirm('");
            out.safe((Object)Lexicon.make((String)"entsecHx").getText("ensureTimeChange")).w((Object)"')) this.checked='';");
            out.w((Object)"else{");
            this.writable("year", out, timeTab.op);
            this.enable("month", out, timeTab.op);
            this.enable("timeZone", out, timeZoneTab.op);
            this.enable("day", out, timeTab.op);
            this.enable("min", out, timeTab.op);
            this.enable("ampm", out, timeTab.op);
            this.enable("twelveHour", out, timeTab.op);
            this.enable("hour", out, timeTab.op);
            out.w((Object)"}}else{");
            this.readonly("year", out, timeTab.op);
            this.disable("month", out, timeTab.op);
            this.disable("timeZone", out, timeZoneTab.op);
            this.disable("day", out, timeTab.op);
            this.disable("min", out, timeTab.op);
            this.disable("ampm", out, timeTab.op);
            this.disable("twelveHour", out, timeTab.op);
            this.disable("hour", out, timeTab.op);
            out.w((Object)"}");
            out.w((Object)"\"");
        }
        out.w((Object)" type='checkbox'>");
        out.w((Object)"<span style='white-space:nowrap;'>");
        timeTab.write();
        out.w((Object)" ");
        timeZoneTab.write();
        out.w((Object)"</span>");
    }

    public Tab getTimeTab(HxOp op) {
        BAbsTime time = (BAbsTime)op.get();
        return new Tab((BHxView)BHxAbsTimeFE.INSTANCE, op.make("absTime", (BObject)time, BFacets.make((String)"showTimeZone", (boolean)false)), op);
    }

    public Tab getTimeZoneTab(HxOp op) {
        BAbsTime time = (BAbsTime)op.get();
        return new Tab((BHxView)BHxTimeZoneFE.INSTANCE, op.make("timeZone", (BObject)time.getTimeZone(), BSystemPlatformService.timeZone.getFacets()), op);
    }

    public BObject save(HxOp op) throws Exception {
        String changeTime = op.getFormValue("changeTime");
        if (changeTime == null || !changeTime.equals("on")) {
            return op.get();
        }
        BSystemPlatformService service = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
        BTimeZone zone = (BTimeZone)this.getTimeZoneTab(op).save();
        BAbsTime time = (BAbsTime)this.getTimeTab(op).save();
        time = BAbsTime.make((int)time.getYear(), (BMonth)time.getMonth(), (int)time.getDay(), (int)time.getHour(), (int)time.getMinute(), (int)0, (int)0, (BTimeZone)zone);
        boolean timeZoneChange = false;
        service.setSystemTime(time);
        if (!zone.getId().equals(service.getTimeZone().getId())) {
            service.setTimeZone(zone);
            timeZoneChange = true;
        }
        service.savePlatformServiceProperties();
        if (timeZoneChange) {
            service.restartStation();
            HtmlWriter out = op.getHtmlWriter();
            if (op.getProfile().getType().is(BHxAccessProfile.TYPE)) {
                BHxAccessProfile.disconnect(op);
            }
        }
        return time;
    }

    class SimplePadConverter
    extends Converter {
        SimplePadConverter() {
        }

        @Override
        public String convert(int index, Context cx) {
            if (index < 10) {
                return "0" + Integer.toString(index);
            }
            return Integer.toString(index);
        }
    }

    class AmPmConverter
    extends Converter {
        AmPmConverter() {
        }

        @Override
        public String convert(int index, Context cx) {
            return index == 0 ? "AM" : "PM";
        }
    }

    class HourConverter
    extends Converter {
        HourConverter() {
        }

        @Override
        public String convert(int index, Context cx) {
            if (index == 0) {
                return "12";
            }
            if (index < 10) {
                return "0" + Integer.toString(index);
            }
            return Integer.toString(index);
        }
    }

    class MonthTagConverter
    extends Converter {
        MonthTagConverter() {
        }

        @Override
        public String convert(int index, Context cx) {
            return BMonth.make((int)index).getShortDisplayTag(cx);
        }
    }

    class MonthConverter
    extends Converter {
        MonthConverter() {
        }

        @Override
        public String convert(int index, Context cx) {
            if (++index < 10) {
                return "0" + Integer.toString(index);
            }
            return Integer.toString(index);
        }
    }

    abstract class Converter {
        Converter() {
        }

        public abstract String convert(int var1, Context var2);
    }
}

