/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.fieldeditors;

import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.fieldeditors.BHxComponentNamePickerFE;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.workbench.fieldeditors.BComponentNamePickerFE;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.securityUtil.ui.BSecAlarmClassFE;
import com.tridiumx.entsecHx.securityUtilHx.alarm.VideoCommand;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.data.BIDataValue;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"alarm:AlarmClassFE", "entsec:SecAlarmClassFE"}, app="entsec", requiredPermissions="r")})
@NiagaraSingleton
public class BHxSecAlarmClassFE
extends BHxComponentNamePickerFE {
    public static final BHxSecAlarmClassFE INSTANCE = new BHxSecAlarmClassFE();
    public static final Type TYPE = Sys.loadType(BHxSecAlarmClassFE.class);
    public static final BComponentNamePickerFE picker = (BComponentNamePickerFE)BSecAlarmClassFE.TYPE.getInstance();
    VideoCmd videoCmd = new VideoCmd((BHxView)this);
    boolean videoEnabled = false;
    public static final String NO_VIDEO = "noVideo";
    public static final BFacets noVideo = BFacets.make((String)"noVideo", (boolean)true);

    public Type getType() {
        return TYPE;
    }

    protected BHxSecAlarmClassFE() {
        this.registerEvent((Event)this.videoCmd);
    }

    private String facetsAttribute(HxOp op) {
        String attribute = SmartCommand.universalScope((String)"facets", (HxOp)op);
        return TextUtil.replace((String)attribute, (String)"properties.alarmClass", (String)"properties.metaData");
    }

    public void write(HxOp op) throws Exception {
        op.getRequest().getSession().removeAttribute(this.facetsAttribute(op));
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<table cellpadding='0' cellspacing='0'><tr><td>");
        super.write(op);
        out.w((Object)"</td>");
        if (BEnterpriseSecurityService.isVideoDriverAvailable() && this.isValidExtension(op) && !op.getFacets().getb(NO_VIDEO, false)) {
            this.videoEnabled = true;
            out.w((Object)"<td width='10'>&nbsp;</td><td>");
            HxTabUtil.writeCommand((SmartCommand)this.videoCmd, (boolean)true, (HxOp)op);
            out.w((Object)"</td>");
        }
        out.w((Object)"</tr></table>");
        BComponent ext = this.videoCmd.getAlarmSourceExts(op)[0];
        BFacets existingFacets = (BFacets)ext.get("metaData");
        if (existingFacets.get("cameraHandleOrd") != null) {
            String cameraHandleOrd = existingFacets.gets("cameraHandleOrd", BOrd.DEFAULT.toString());
            try {
                BComponent camera = BOrd.make((String)cameraHandleOrd).get((BObject)ext).asComponent();
                BFacets cameraFacet = BFacets.make((String)"cameraOrd", (BIDataValue)BString.make((String)camera.getSlotPathOrd().toString()));
                ext.set("metaData", (BValue)BFacets.make((BFacets)existingFacets, (BFacets)cameraFacet));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean isValidExtension(HxOp op) {
        Type extensionType = op.getBaseOrdTarget().getBaseOrdTarget().get().getType();
        return extensionType.is(BAlarmSourceExt.TYPE) || extensionType.is(BAlarmSourceInfo.TYPE);
    }

    private boolean isValidPoint(HxOp op) {
        for (BComponent component = op.getComponent(); component != null; component = component.getParent()) {
            if (!component.getType().is(BBooleanPoint.TYPE) && !component.getType().is(BNumericPoint.TYPE)) continue;
            return true;
        }
        return false;
    }

    public BObject save(HxOp op) throws Exception {
        HxOp metaDataOp;
        BObject alarmClassName = super.save(op);
        BComponent alarmExt = op.getComponent();
        BFacets currentMetaData = (BFacets)alarmExt.get("metaData");
        BObject newMetaData = BHxFieldEditor.makeFor((BObject)currentMetaData, (Context)(metaDataOp = op.make(new OrdTarget((OrdTarget)op, (BObject)currentMetaData)))).save(op);
        if (newMetaData.getType().is(BFacets.TYPE)) {
            alarmExt.set("metaData", newMetaData.asValue());
        }
        if (this.videoEnabled(alarmExt)) {
            VideoCommand.configureVideoRecipient(alarmExt, alarmClassName.toString(), op);
        }
        return alarmClassName;
    }

    private boolean videoEnabled(BComponent alarmExt) throws Exception {
        BFacets metaData = (BFacets)alarmExt.get("metaData");
        BString cameraHandleOrd = (BString)metaData.get("cameraHandleOrd");
        return cameraHandleOrd != null && !cameraHandleOrd.isNull() && !cameraHandleOrd.getString().equals("");
    }

    public boolean process(HxOp op) throws Exception {
        boolean retVal = super.process(op);
        if (!retVal && this.videoEnabled) {
            retVal = this.videoCmd.process(op);
        }
        return retVal;
    }

    public BComponentNamePickerFE getPicker() {
        return picker;
    }

    public class VideoCmd
    extends VideoCommand {
        public VideoCmd(BHxView view) {
            super(view);
        }

        @Override
        public BComponent[] getAlarmSourceExts(HxOp op) {
            try {
                BComponent ext = (BComponent)op.getBaseOrdTarget().getBaseOrdTarget().get();
                return new BComponent[]{ext};
            }
            catch (Exception e) {
                return new BComponent[0];
            }
        }
    }
}

