/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.discover.nd;

import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BNiagaraSysDefDeviceExt;
import com.tridiumx.entsec.securityUtil.query.BColumnsProvider;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import com.tridiumx.entsecHx.securityUtilHx.discover.nd.BHxNiagaraNetworkView;
import javax.baja.nd.BStationRole;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.query.expression.BFunctionExpression;
import javax.baja.query.util.Exprs;
import javax.baja.query.util.Funcs;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
public class BStationColumnsProvider
extends BColumnsProvider {
    public static final Type TYPE = Sys.loadType(BStationColumnsProvider.class);

    public Type getType() {
        return TYPE;
    }

    public TypeSpecPath[] getDefaultColumns(BQuery query) {
        boolean supervisor = BHxNiagaraNetworkView.isSupervisor();
        TypeSpecPath[] result = new TypeSpecPath[supervisor ? 12 : 7];
        Lexicon lex = BHxNiagaraNetworkView.secUtilLex;
        result[0] = new TypeSpecPath(BString.TYPE.getTypeSpec(), "stationName", lex.getText("stationView.stationNameCol"));
        result[1] = new TypeSpecPath(BString.TYPE.getTypeSpec(), "remoteHost.hostname", lex.getText("stationView.hostNameCol"));
        result[2] = new TypeSpecPath(BString.TYPE.getTypeSpec(), "scheme", lex.getText("stationView.scheme"));
        result[3] = new TypeSpecPath(BInteger.TYPE.getTypeSpec(), "foxPort", lex.getText("stationView.foxPortCol"));
        result[4] = new TypeSpecPath(BStatus.TYPE.getTypeSpec(), "status", lex.getText("stationView.statusCol"));
        result[5] = new TypeSpecPath(BStationRole.TYPE.getTypeSpec(), "sysDef.roleManager.actualRole", lex.getText("stationView.roleCol"));
        BFunctionExpression function = Funcs.make((String)(TYPE + ".getRoleStatus"), (Type)BString.TYPE, (BExpression)Exprs.simple((BSimple)BString.DEFAULT));
        result[6] = new TypeSpecPath(BTypeSpec.make((String)"baja:String"), "stationView.roleStatus", lex.getText("stationView.roleStatus"), (BExpression)function);
        if (supervisor) {
            result[7] = new TypeSpecPath(BBoolean.TYPE.getTypeSpec(), "entsec_NiagaraReplicationDeviceExt.joined", lex.getText("stationView.joinedCol"));
            result[8] = new TypeSpecPath(BBoolean.TYPE.getTypeSpec(), "entsec_NiagaraReplicationDeviceExt.automaticReplicationEnabled", lex.getText("stationView.autoRepCol"));
            result[9] = new TypeSpecPath(BStatus.TYPE.getTypeSpec(), "entsec_NiagaraReplicationDeviceExt.status", lex.getText("stationView.repStatusCol"));
            result[10] = new TypeSpecPath(BAbsTime.TYPE.getTypeSpec(), "entsec_NiagaraReplicationDeviceExt.lastReplication", lex.getText("stationView.lastRepCol"));
            result[11] = new TypeSpecPath(BStatus.TYPE.getTypeSpec(), "users.status", lex.getText("stationView.userStatusCol"));
        }
        return result;
    }

    public static BObject getRoleStatus(BObject target, BString useless) {
        if (!(target instanceof BNiagaraStation)) {
            return null;
        }
        BNiagaraStation niagaraStation = (BNiagaraStation)target;
        BNiagaraSysDefDeviceExt ext = (BNiagaraSysDefDeviceExt)niagaraStation.get("sysDef");
        if (!ext.getSyncTask().getStatus().isOk()) {
            String message = ext.getSyncTask().getStatus().toString();
            if (ext.getSyncTask().getFaultCause().length() > 0) {
                message = message + " " + ext.getSyncTask().getFaultCause();
            }
            return BString.make((String)message);
        }
        String message = ext.getRoleManager().getStatus().toString();
        if (ext.getRoleManager().getFaultCause().length() > 0) {
            message = message + " " + ext.getRoleManager().getFaultCause();
        }
        return BString.make((String)message);
    }

    public int getDefaultSortColumnIndex(BQuery query) {
        return 0;
    }
}

