/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.discover.nd;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxService;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.BLearnStation;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.hx.progress.HxProgressJobDialog;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BProviderStation;
import com.tridium.nd.sysdef.BRoleManager;
import com.tridium.security.BServerCertificateHealth;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.ConfirmDialog;
import com.tridium.smartTableHx.JobLogDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.util.HtmlUtils;
import com.tridium.util.StringEscapeUtils;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsec.orionTools.replicate.BNiagaraReplicationDeviceExt;
import com.tridiumx.entsec.orionTools.replicate.BReplicationJob;
import com.tridiumx.entsec.orionTools.replicate.BReplicationService;
import com.tridiumx.entsec.securityUtil.query.BNiagaraStationQuery;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import com.tridiumx.entsec.securityUtil.ui.query.BWbQueryConfig;
import com.tridiumx.entsecHx.orionToolsHx.HxRemoteUtil;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BForceBatchSysJoinJob;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SubordinateConnection;
import com.tridiumx.entsecHx.securityUtilHx.RedirectCommand;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractDiscoverView;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractManagerView;
import com.tridiumx.entsecHx.securityUtilHx.discover.nd.BAddStationsJob;
import com.tridiumx.entsecHx.securityUtilHx.discover.nd.BEditStationsJob;
import com.tridiumx.entsecHx.securityUtilHx.discover.nd.BHxNiagaraNetworkDiscoverView;
import com.tridiumx.entsecHx.securityUtilHx.discover.nd.BRemoteConfigJob;
import com.tridiumx.entsecHx.securityUtilHx.discover.nd.BStationColumnsProvider;
import com.tridiumx.entsecHx.securityUtilHx.discover.nd.BStationConnectJob;
import com.tridiumx.entsecHx.securityUtilHx.discover.nd.BSyncTimeJob;
import com.tridiumx.entsecHx.securityUtilHx.job.BHxAbstractJobView;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxQueryTableView;
import com.tridiumx.entsecHx.securityUtilHx.query.ColumnsCommand;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.firewall.BServerPort;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nd.BStationRole;
import javax.baja.nd.SysDefSession;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BExtent;
import javax.baja.query.BProjection;
import javax.baja.query.BQuery;
import javax.baja.query.BSingleExtent;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BClientCredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconModule;
import javax.baja.util.LexiconText;
import javax.baja.util.Version;
import javax.baja.web.BWebService;
import javax.bajax.timesync.BTimeSyncClient;
import javax.bajax.timesync.BTimeSyncService;
import javax.servlet.http.HttpServletRequest;

@NiagaraType(agent={@AgentOn(types={"niagaraDriver:NiagaraNetwork", "entsec:NiagaraStationQuery"}, app="entsec", requiredPermissions="rR")})
@NiagaraSingleton
public class BHxNiagaraNetworkView
extends BHxAbstractManagerView {
    static final Lexicon secUtilLex = Lexicon.make(BHxNiagaraNetworkView.class);
    public static final BHxNiagaraNetworkView INSTANCE = new BHxNiagaraNetworkView();
    public static final Type TYPE = Sys.loadType(BHxNiagaraNetworkView.class);
    public static final String REPLICATION = "replication";
    public static final String SERVICE_ENTSEC_REPLICATION_SERVICE = "service:entsec:ReplicationService";
    static String[] STATION_FIELDS = new String[]{"stationName", "remoteHost.hostname", "scheme", "foxPort", "status", "sysDef.roleManager.actualRole"};
    static String[] LEARN_FIELDS = new String[]{"stationName", "hostName", "scheme", "foxPort"};
    static BTypeSpec[] LEARN_FIELD_TYPES = new BTypeSpec[]{BString.TYPE.getTypeSpec(), BString.TYPE.getTypeSpec(), BString.TYPE.getTypeSpec(), BInteger.TYPE.getTypeSpec()};
    static String[] LEX_KEYS = new String[]{"stationView.stationNameCol", "stationView.hostNameCol", "stationView.scheme", "stationView.foxPortCol", "stationView.statusCol", "stationView.roleCol"};
    AddStation add;
    EditStation edit;
    DeleteStation delete;
    PingStation ping;
    ReplicateCommand replicate;
    EnableReplicationCommand enableReplication;
    AutoReplicateCommand autoReplicate;
    private JoinCommand join;
    private JoinCommand forceJoin;
    WebSettingsCommand settingsCommand;
    StationRedirectCommand redirect;
    AddDiscovered addDiscovered;
    JoinProgressCommand joinProgress;
    ReplicateProgressCommand replicateProgress;
    RemoteTimeSyncCommand remoteTimeSync;
    HxProgressJobDialog.ProgressEvent stationConnectEvent;
    HxProgressJobDialog.ProgressEvent remoteConfigEvent;
    HxProgressJobDialog.ProgressEvent editStationEvent;
    HxProgressJobDialog.ProgressEvent remoteEditEvent;
    HxProgressJobDialog.ProgressEvent deleteStationEvent;
    HxProgressJobDialog.ProgressEvent pingStationEvent;
    HxProgressJobDialog.ProgressEvent addDiscoveredEvent;
    HxProgressJobDialog.ProgressEvent batchEditEvent;
    HxProgressJobDialog.ProgressEvent replicateEvent;
    HxProgressJobDialog.ProgressEvent batchJoinEvent;
    HxProgressJobDialog.ProgressEvent syncTimeEvent;
    static boolean lastSupervisorState = false;
    static boolean flag = true;
    static boolean remoteConfigDialogFlag = true;
    private static final String FOXS = "foxs";
    private static final String ACCESS_SERVICE_ORD = "service:entsec:AccessControlService";
    private static final String AX_SOFTWARE_VERSION = "2.3.0";

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxNiagaraNetworkView() {
        this.hyperlinkCommand = new StationSummaryHyperlink((BHxView)this);
        this.registerEvent((Event)this.hyperlinkCommand);
        this.addDiscovered = new AddDiscovered((BHxView)this);
        this.registerEvent((Event)this.addDiscovered);
        this.add = new AddStation((BHxView)this);
        this.registerEvent((Event)this.add);
        this.edit = new EditStation((BHxView)this);
        this.registerEvent((Event)this.edit);
        this.delete = new DeleteStation((BHxView)this);
        this.registerEvent((Event)this.delete);
        this.ping = new PingStation((BHxView)this);
        this.registerEvent((Event)this.ping);
        this.replicate = new ReplicateCommand((BHxView)this);
        this.registerEvent((Event)this.replicate);
        this.enableReplication = new EnableReplicationCommand((BHxView)this);
        this.registerEvent((Event)this.enableReplication);
        this.replicateProgress = new ReplicateProgressCommand((BHxView)this);
        this.registerEvent((Event)this.replicateProgress);
        this.autoReplicate = new AutoReplicateCommand((BHxView)this);
        this.registerEvent((Event)this.autoReplicate);
        this.join = new JoinCommand((BHxView)this, false);
        this.registerEvent((Event)this.join);
        this.forceJoin = new JoinCommand((BHxView)this, true);
        this.registerEvent((Event)this.forceJoin);
        this.joinProgress = new JoinProgressCommand((BHxView)this);
        this.registerEvent((Event)this.joinProgress);
        this.redirect = new StationRedirectCommand((BHxView)this);
        this.registerEvent((Event)this.redirect);
        this.settingsCommand = new WebSettingsCommand((BHxView)this);
        this.registerEvent((Event)this.settingsCommand);
        this.columnsCommand = new StationColumnsCommand((BHxView)this);
        this.registerEvent((Event)this.columnsCommand);
        this.remoteTimeSync = new RemoteTimeSyncCommand((BHxView)this);
        this.registerEvent((Event)this.remoteTimeSync);
        this.addDiscoveredEvent = HxProgressJobDialog.makeProgress((String)secUtilLex.getText("stationView.addDiscoveredStations"), (BHxView)this, (HxProgressJobDialog.IHxProgressDialogParent)this);
        this.registerEvent((Event)this.addDiscoveredEvent);
        this.stationConnectEvent = HxProgressJobDialog.makeProgress((String)secUtilLex.getText("stationView.stationConnect"), (BHxView)this, (HxProgressJobDialog.IHxProgressDialogParent)this);
        this.registerEvent((Event)this.stationConnectEvent);
        this.remoteConfigEvent = HxProgressJobDialog.makeProgress((String)secUtilLex.getText("stationView.remoteConfigEvent"), (BHxView)this, (HxProgressJobDialog.IHxProgressDialogParent)this);
        this.registerEvent((Event)this.remoteConfigEvent);
        this.batchEditEvent = HxProgressJobDialog.makeProgress((String)secUtilLex.getText("stationView.batchEditStations"), (BHxView)this, (HxProgressJobDialog.IHxProgressDialogParent)this);
        this.registerEvent((Event)this.batchEditEvent);
        this.editStationEvent = HxProgressJobDialog.makeProgress((String)secUtilLex.getText("stationView.stationConnect"), (BHxView)this, (HxProgressJobDialog.IHxProgressDialogParent)this);
        this.registerEvent((Event)this.editStationEvent);
        this.remoteEditEvent = HxProgressJobDialog.makeProgress((String)secUtilLex.getText("stationView.remoteConfigEvent"), (BHxView)this, (HxProgressJobDialog.IHxProgressDialogParent)this);
        this.registerEvent((Event)this.remoteEditEvent);
        this.deleteStationEvent = HxProgressJobDialog.makeProgress((String)secUtilLex.getText("stationView.deleteStation"), (BHxView)this, (HxProgressJobDialog.IHxProgressDialogParent)this);
        this.registerEvent((Event)this.deleteStationEvent);
        this.pingStationEvent = HxProgressJobDialog.makeProgress((String)secUtilLex.getText("ping.label"), (BHxView)this, (HxProgressJobDialog.IHxProgressDialogParent)this);
        this.registerEvent((Event)this.pingStationEvent);
        this.replicateEvent = HxProgressJobDialog.makeProgress((String)secUtilLex.getText("stationView.replicateEvent"), (BHxView)this, (HxProgressJobDialog.IHxProgressDialogParent)this);
        this.registerEvent((Event)this.replicateEvent);
        this.batchJoinEvent = HxProgressJobDialog.makeProgress((String)secUtilLex.getText("stationView.batchForceJoinEvent"), (BHxView)this, (HxProgressJobDialog.IHxProgressDialogParent)this);
        this.registerEvent((Event)this.batchJoinEvent);
        this.syncTimeEvent = HxProgressJobDialog.makeProgress((String)secUtilLex.getText("stationView.syncTimeEvent"), (BHxView)this, (HxProgressJobDialog.IHxProgressDialogParent)this);
        this.registerEvent((Event)this.syncTimeEvent);
        this.stationConnectEvent.setJobCompleteHandler((HxProgressJobDialog.IJobCompleteHandler)this.add);
        this.remoteConfigEvent.setJobCompleteHandler((HxProgressJobDialog.IJobCompleteHandler)this.add);
        this.addDiscoveredEvent.setJobCompleteHandler((HxProgressJobDialog.IJobCompleteHandler)this.addDiscovered);
        this.batchEditEvent.setJobCompleteHandler((HxProgressJobDialog.IJobCompleteHandler)this.edit);
        this.editStationEvent.setJobCompleteHandler((HxProgressJobDialog.IJobCompleteHandler)this.edit);
        this.remoteEditEvent.setJobCompleteHandler((HxProgressJobDialog.IJobCompleteHandler)this.edit);
        this.deleteStationEvent.setJobCompleteHandler((HxProgressJobDialog.IJobCompleteHandler)this.delete);
        this.pingStationEvent.setJobCompleteHandler((HxProgressJobDialog.IJobCompleteHandler)this.ping);
        this.replicateEvent.setJobCompleteHandler((HxProgressJobDialog.IJobCompleteHandler)this.replicateProgress);
        this.batchJoinEvent.setJobCompleteHandler((HxProgressJobDialog.IJobCompleteHandler)this.joinProgress);
        this.syncTimeEvent.setJobCompleteHandler((HxProgressJobDialog.IJobCompleteHandler)this.remoteTimeSync);
    }

    public boolean supportsAutoRefresh(HxOp op) {
        return true;
    }

    @Override
    public HxProgressJobDialog.ProgressEvent[] getProgressEvents() {
        return new HxProgressJobDialog.ProgressEvent[]{this.discoveryEvent, this.stationConnectEvent, this.remoteConfigEvent, this.editStationEvent, this.remoteEditEvent, this.deleteStationEvent, this.pingStationEvent, this.addDiscoveredEvent, this.batchEditEvent, this.replicateEvent, this.batchJoinEvent, this.syncTimeEvent};
    }

    @Override
    public BHxAbstractDiscoverView getDiscoverView(HxOp op) {
        return BHxNiagaraNetworkDiscoverView.INSTANCE;
    }

    @Override
    public BTypeSpec getDeviceTypeSpec(HxOp op) {
        return BNiagaraStation.TYPE.getTypeSpec();
    }

    @Override
    public BTypeSpec getLearnRowTypeSpec(HxOp op) {
        return BLearnStation.TYPE.getTypeSpec();
    }

    @Override
    public BQuery getDiscoverQuery(HxOp op) {
        BObject o;
        BOrd jobOrd;
        BQuery query = new BQuery();
        query.from((BExtent)new BSingleExtent(this.getLearnRowTypeSpec(op)));
        query.select(new BProjection());
        for (int i = 0; i < LEARN_FIELDS.length; ++i) {
            QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(LEARN_FIELD_TYPES[i], LEARN_FIELDS[i], secUtilLex.getText(LEX_KEYS[i])));
        }
        QueryUtil.addSlotFacetColumn((BQuery)query, (Type)BBoolean.TYPE, (String)"dbExistence", (String)secUtilLex.getText("stationView.stationExists"));
        QueryUtil.addHiddenColumns((BQuery)query);
        String jobOrdStr = op.getFormValue("discover.discoverJobOrd");
        if (jobOrdStr != null && (jobOrd = BOrd.make((String)jobOrdStr)) != null && (o = jobOrd.get()) instanceof BJob) {
            BJob job = (BJob)o;
            BHxNiagaraNetworkView.updateExistenceFacets(job);
            query.add("base", (BValue)job.getAbsoluteOrd());
        }
        query.add("stationColumnsProvider", (BValue)new BStationColumnsProvider());
        return query;
    }

    @Override
    public BQuery getQuery(HxOp op) {
        BNiagaraStationQuery query = null;
        try {
            boolean supervisor;
            lastSupervisorState = supervisor = BHxNiagaraNetworkView.isSupervisor();
            query = ((BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE)).getStationsQuery();
            if (!supervisor) {
                query = (BQuery)query.get("standaloneStationsQuery");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (query == null) {
            query = new BQuery();
            query.add("base", (BValue)BHxNiagaraNetworkView.getNiagaraNetwork().getAbsoluteOrd());
            query.add("stationColumnsProvider", (BValue)new BStationColumnsProvider());
            QueryUtil.makeQuery((BQuery)query, (BTypeSpec)this.getDeviceTypeSpec(op));
        } else if (query.get("stationColumnsProvider") == null) {
            query.add("stationColumnsProvider", (BValue)new BStationColumnsProvider());
        }
        query = QueryUtil.getWorkingCopy((BQuery)query, (Context)op);
        return query;
    }

    @Override
    public void write(HxOp op) throws Exception {
        BHxSmartTableView.writeFormValue((String)"editStations", (String)"", (HxOp)op);
        BHxSmartTableView.writeFormValue((String)"discoveredStations", (String)"", (HxOp)op);
        BHxSmartTableView.writeFormValue((String)"remoteStation", (String)"", (HxOp)op);
        super.write(op);
    }

    @Override
    public void reloadTables(HxOp op) throws Exception {
        boolean supervisor = BHxNiagaraNetworkView.isSupervisor();
        if (lastSupervisorState == supervisor) {
            super.reloadTables(op);
        } else {
            lastSupervisorState = supervisor;
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"window.location.reload(true);");
        }
    }

    public void reloadTable(HxOp op) throws Exception {
        boolean supervisor = BHxNiagaraNetworkView.isSupervisor();
        if (lastSupervisorState == supervisor) {
            super.reloadTable(op);
        } else {
            lastSupervisorState = supervisor;
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"window.location.reload(true);");
        }
    }

    @Override
    public BJob submitJob(HxProgressJobDialog dialog, HxOp op) {
        BJob job = super.submitJob(dialog, op);
        if (job != null) {
            return job;
        }
        BNiagaraNetwork network = BHxNiagaraNetworkView.getNiagaraNetwork();
        if (dialog.getTitle().equals(this.pingStationEvent.getDialog().getTitle())) {
            BOrd ord = new BStationConnectJob(BHxNiagaraNetworkView.getSelectedStations(op), (Context)op).submit(null);
            return (BJob)ord.get((BObject)network);
        }
        if (dialog.getTitle().equals(this.addDiscoveredEvent.getDialog().getTitle())) {
            int discoveredStationsLength;
            BLearnStation[] addStations = null;
            String discoveredStationsLengthStr = op.getFormValue(op.scope("discoveredStations"));
            if (discoveredStationsLengthStr != null && !discoveredStationsLengthStr.isEmpty() && (discoveredStationsLength = Integer.parseInt(discoveredStationsLengthStr)) > 0) {
                addStations = new BLearnStation[discoveredStationsLength];
                for (int i = 0; i < addStations.length; ++i) {
                    try {
                        addStations[i] = (BLearnStation)ValueDocDecoder.unmarshal((String)StringEscapeUtils.unescapeJava((String)op.getUnsafeFormValue("discoveredStations" + i)));
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            boolean stationEnabled = ((BBoolean)BHxNiagaraNetworkView.readProperty("stationEnabled", op, BNiagaraStation.enabled)).getBoolean();
            BClientCredentials stationUserCred = (BClientCredentials)BHxNiagaraNetworkView.readProperty("stationUserCred", op, BFoxClientConnection.credentialStore);
            boolean useFoxs = ((BBoolean)BHxNiagaraNetworkView.readProperty("stationFoxs", op, BFoxClientConnection.useFoxs)).getBoolean();
            int stationPort = ((BInteger)BHxNiagaraNetworkView.readProperty("stationPort", op, BFoxClientConnection.port)).getInt();
            boolean remoteStationEnabled = ((BBoolean)BHxNiagaraNetworkView.readProperty("remoteStationEnabled", op, BNiagaraStation.enabled)).getBoolean();
            BClientCredentials remoteUserCred = (BClientCredentials)BHxNiagaraNetworkView.readProperty("remoteUserCred", op, BFoxClientConnection.credentialStore);
            boolean remoteUseFoxs = ((BBoolean)BHxNiagaraNetworkView.readProperty("remoteStationFoxs", op, BFoxClientConnection.useFoxs)).getBoolean();
            int remoteStationPort = ((BInteger)BHxNiagaraNetworkView.readProperty("remoteStationPort", op, BFoxClientConnection.port)).getInt();
            BStationRole stationRole = (BStationRole)BHxNiagaraNetworkView.readProperty("stationRole", op, BRoleManager.desiredRole);
            BOrd ord = new BAddStationsJob(network, addStations, stationEnabled, stationUserCred, useFoxs, stationPort, remoteStationEnabled, remoteUserCred, remoteUseFoxs, remoteStationPort, stationRole, (Context)op).submit(null);
            return (BJob)ord.get((BObject)network);
        }
        if (dialog.getTitle().equals(this.batchEditEvent.getDialog().getTitle())) {
            int editStationsLength;
            BNiagaraStation[] stations = null;
            String editStationsLengthStr = op.getFormValue(op.scope("editStations"));
            if (editStationsLengthStr != null && !editStationsLengthStr.isEmpty() && (editStationsLength = Integer.parseInt(editStationsLengthStr)) > 0) {
                stations = new BNiagaraStation[editStationsLength];
                for (int i = 0; i < stations.length; ++i) {
                    try {
                        stations[i] = (BNiagaraStation)ValueDocDecoder.unmarshal((String)StringEscapeUtils.unescapeJava((String)op.getUnsafeFormValue("editStations" + i)));
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            BBoolean stationEnabled = (BBoolean)BHxNiagaraNetworkView.readProperty("stationEnabled", op, (BObject)stations[0].get(BNiagaraStation.enabled), true);
            BClientCredentials stationUserCred = (BClientCredentials)BHxNiagaraNetworkView.readProperty("stationUserCred", op, (BObject)stations[0].getClientConnection().get(BFoxClientConnection.credentialStore), false);
            BBoolean useFoxs = (BBoolean)BHxNiagaraNetworkView.readProperty("stationFoxs", op, (BObject)stations[0].getClientConnection().get(BFoxClientConnection.useFoxs));
            BInteger stationPort = (BInteger)BHxNiagaraNetworkView.readProperty("stationPort", op, (BObject)stations[0].getClientConnection().get(BFoxClientConnection.port));
            BBoolean remoteStationEnabled = (BBoolean)BHxNiagaraNetworkView.readProperty("remoteStationEnabled", op, BNiagaraStation.enabled, true);
            BClientCredentials remoteUserCred = (BClientCredentials)BHxNiagaraNetworkView.readProperty("remoteUserCred", op, BFoxClientConnection.credentialStore, true);
            BBoolean remoteUseFoxs = (BBoolean)BHxNiagaraNetworkView.readProperty("remoteStationFoxs", op, BFoxClientConnection.useFoxs);
            BInteger remoteStationPort = (BInteger)BHxNiagaraNetworkView.readProperty("remoteStationPort", op, BFoxClientConnection.port);
            BStationRole stationRole = (BStationRole)BHxNiagaraNetworkView.readProperty("stationRole", op, BRoleManager.desiredRole, true);
            BOrd ord = new BEditStationsJob(network, stations, stationEnabled, stationUserCred, useFoxs, stationPort, remoteStationEnabled, remoteUserCred, remoteUseFoxs, remoteStationPort, stationRole, (Context)op).submit(null);
            return (BJob)ord.get((BObject)network);
        }
        if (dialog.getTitle().equals(this.stationConnectEvent.getDialog().getTitle())) {
            BNiagaraStation[] stations = BHxNiagaraNetworkView.getSelectedStations(op);
            BClientCredentials stationUserCred = null;
            if (stations != null && stations.length > 0) {
                BClientCredentials clientCredentials = stations[0].getClientConnection().getCredentialStore();
                stationUserCred = (BClientCredentials)BHxNiagaraNetworkView.readProperty("stationUserCred", op, (BObject)clientCredentials);
            } else {
                stationUserCred = (BClientCredentials)BHxNiagaraNetworkView.readProperty("stationUserCred", op, BFoxClientConnection.credentialStore);
            }
            String stationName = ((BString)BHxNiagaraNetworkView.readProperty("stationName", op, (BObject)BString.DEFAULT)).getString();
            boolean stationEnabled = ((BBoolean)BHxNiagaraNetworkView.readProperty("stationEnabled", op, BNiagaraStation.enabled)).getBoolean();
            String stationAddress = ((BString)BHxNiagaraNetworkView.readProperty("stationAddress", op, (BObject)BString.DEFAULT)).getString();
            boolean useFoxs = ((BBoolean)BHxNiagaraNetworkView.readProperty("stationFoxs", op, BFoxClientConnection.useFoxs)).getBoolean();
            int stationPort = ((BInteger)BHxNiagaraNetworkView.readProperty("stationPort", op, BFoxClientConnection.port)).getInt();
            BUsernameAndPassword usPwd = (BUsernameAndPassword)stationUserCred.getCredentials();
            BOrd ord = new BStationConnectJob(network, stationName, stationEnabled, stationAddress, stationUserCred, useFoxs, stationPort, op.getFormValue("editExistingStation") != null, (Context)op).submit(null);
            return (BJob)ord.get((BObject)network);
        }
        if (dialog.getTitle().equals(this.remoteConfigEvent.getDialog().getTitle())) {
            boolean editStation = false;
            BNiagaraStation[] stations = BHxNiagaraNetworkView.getSelectedStations(op);
            if (stations != null && stations.length > 0) {
                editStation = true;
            }
            BNiagaraStation remoteStation = null;
            String remoteStationsStr = op.getUnsafeFormValue(op.scope("remoteStation"));
            if (remoteStationsStr != null && !remoteStationsStr.isEmpty()) {
                try {
                    remoteStation = (BNiagaraStation)ValueDocDecoder.unmarshal((String)StringEscapeUtils.unescapeJava((String)remoteStationsStr), (Context)op);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String stationName = op.getFormValue("stationName");
            boolean stationEnabled = ((BBoolean)BHxNiagaraNetworkView.readProperty("stationEnabled", op, (BObject)remoteStation.get(BNiagaraStation.enabled))).getBoolean();
            BClientCredentials clientCredentials = remoteStation.getClientConnection().getCredentialStore();
            BClientCredentials stationUserCred = (BClientCredentials)BHxNiagaraNetworkView.readProperty("stationUserCred", op, (BObject)clientCredentials);
            boolean userCredEdited = this.checkUserCredEdited("stationUserCred", op);
            boolean useFoxs = ((BBoolean)BHxNiagaraNetworkView.readProperty("stationFoxs", op, (BObject)remoteStation.getClientConnection().get(BFoxClientConnection.useFoxs))).getBoolean();
            int stationPort = ((BInteger)BHxNiagaraNetworkView.readProperty("stationPort", op, (BObject)remoteStation.getClientConnection().get(BFoxClientConnection.port))).getInt();
            BStationRole stationRole = (BStationRole)BHxNiagaraNetworkView.readProperty("stationRole", op, BRoleManager.desiredRole);
            BOrd ord = new BRemoteConfigJob(network, stationName, stationEnabled, stationUserCred, useFoxs, stationPort, stationRole, userCredEdited, (Context)op).submit(null);
            return (BJob)ord.get((BObject)network);
        }
        if (dialog.getTitle().equals(this.deleteStationEvent.getDialog().getTitle())) {
            BOrd ord = new BRemoteConfigJob(BHxNiagaraNetworkView.getSelectedStations(op), (Context)op).submit(null);
            return (BJob)ord.get((BObject)network);
        }
        if (dialog.getTitle().equals(this.replicateEvent.getDialog().getTitle())) {
            BOrd ord = new BReplicationJob().submit((Context)op);
            return (BJob)ord.get((BObject)network);
        }
        if (dialog.getTitle().equals(this.batchJoinEvent.getDialog().getTitle())) {
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            BOrd ord = new BForceBatchSysJoinJob(selectionList, op).submit((Context)op);
            return (BJob)ord.get((BObject)network);
        }
        if (dialog.getTitle().equals(this.syncTimeEvent.getDialog().getTitle())) {
            BNiagaraStation[] selectedStations = BHxNiagaraNetworkView.getSelectedStations(op);
            BOrd ord = new BSyncTimeJob(selectedStations).submit((Context)op);
            return (BJob)ord.get((BObject)network);
        }
        return null;
    }

    @Override
    public BJob submitDiscoveryJob(HxOp op) {
        BNiagaraNetwork network = BHxNiagaraNetworkView.getNiagaraNetwork();
        BOrd ord = network.submitStationDiscoveryJob();
        return (BJob)ord.get((BObject)network);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        Array cmds = new Array(SmartCommand.class);
        boolean hasAdminWrite = BHxNiagaraNetworkView.getNiagaraNetwork().getPermissions((Context)op).hasAdminWrite();
        boolean hasAdminInvoke = BHxNiagaraNetworkView.getNiagaraNetwork().getPermissions((Context)op).hasAdminInvoke();
        if (hasAdminWrite) {
            cmds.add((Object)this.discover);
            cmds.add((Object)this.add);
            cmds.add((Object)this.edit);
        }
        if (hasAdminInvoke) {
            cmds.add((Object)this.ping);
        }
        if (hasAdminWrite) {
            cmds.add((Object)this.delete);
            cmds.add((Object)this.learnMode);
            if (BHxNiagaraNetworkView.isSupervisor()) {
                cmds.add((Object)this.remoteTimeSync);
                cmds.add((Object)this.replicate);
                cmds.add((Object)this.autoReplicate);
                cmds.add((Object)this.join);
                cmds.add((Object)this.forceJoin);
            }
            cmds.add((Object)this.settingsCommand);
        }
        cmds.add((Object)this.refresh);
        cmds.add((Object)this.filterCommand);
        cmds.add((Object)this.columnsCommand);
        cmds.add((Object)this.hyperlinkCommand);
        cmds.add((Object)this.redirect);
        cmds.add((Object)this.exportCommand);
        return (SmartCommand[])cmds.trim();
    }

    @Override
    public String getPageTitle(HxOp op) {
        return secUtilLex.getText("stationView.title") + " - " + secUtilLex.getText("database");
    }

    static boolean isSupervisor() {
        try {
            BEnterpriseSecurityService entsecService = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
            return entsecService.getMonitorSysDefSecurity().getHasSecuritySubordinate();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static boolean isSubordinate() {
        try {
            BEnterpriseSecurityService entsecService = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
            return entsecService.getMonitorSysDefSecurity().getHasSecuritySupervisor();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static void updateExistenceFacets(BJob job) {
        BNiagaraNetwork network = BHxNiagaraNetworkView.getNiagaraNetwork();
        SlotCursor c = job.getProperties();
        while (c.next(BLearnStation.class)) {
            Property prop = c.property();
            BFacets facets = job.getSlotFacets((Slot)prop);
            BLearnStation station = (BLearnStation)job.get(prop);
            BBoolean exists = BBoolean.make((network.getNiagaraStation(station.getStationName()) != null ? 1 : 0) != 0);
            job.setFacets((Slot)prop, BFacets.make((BFacets)facets, (String)"dbExistence", (BIDataValue)exists));
        }
    }

    static BNiagaraNetwork getNiagaraNetwork() {
        return (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
    }

    static BNiagaraStation[] getSelectedStations(HxOp op) {
        Object[] selectionList = BHxNiagaraNetworkView.getSubjects(op);
        if (selectionList != null && selectionList.length > 0) {
            int len = selectionList.length;
            BNiagaraStation[] stations = new BNiagaraStation[len];
            for (int i = 0; i < len; ++i) {
                stations[i] = (BNiagaraStation)selectionList[i];
            }
            return stations;
        }
        return null;
    }

    static BObject readProperty(String name, HxOp op, Property prop) {
        return BHxNiagaraNetworkView.readProperty(name, op, prop, false);
    }

    static BObject readProperty(String name, HxOp op, Property prop, boolean checkEdit) {
        return BHxNiagaraNetworkView.readProperty(name, op, (BObject)prop.getDefaultValue(), checkEdit);
    }

    static BObject readProperty(String name, HxOp op, BObject defaultVal) {
        return BHxNiagaraNetworkView.readProperty(name, op, defaultVal, false);
    }

    static BObject readProperty(String name, HxOp op, BObject defaultVal, boolean checkEdit) {
        try {
            if (checkEdit && op.getFormValue(name.substring(0, 1) + "_edit_" + name.substring(1, name.length())) == null) {
                return null;
            }
            BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)defaultVal, (Context)op);
            BObject saved = editor.save(op.make(name, new OrdTarget((OrdTarget)op, defaultVal)));
            return saved;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static void writeProperty(String name, HxOp op, BComplex obj, Property prop, Lexicon lex) throws Exception {
        BHxNiagaraNetworkView.writeProperty(name, op, obj, prop, lex, false);
    }

    static void writeProperty(String name, HxOp op, BComplex obj, Property prop, Lexicon lex, boolean editCheckbox) throws Exception {
        if (lex == null) {
            lex = Lexicon.make(obj.getClass());
        }
        BHxNiagaraNetworkView.writeProperty(name, op, (BObject)obj.get(prop), lex.get(prop.getName(), TextUtil.toFriendly((String)prop.getName())), obj.getSlotFacets((Slot)prop), false, editCheckbox);
    }

    static void writeProperty(String name, HxOp op, BObject defaultVal, String displayName, BFacets facets, boolean readonly) throws Exception {
        BHxNiagaraNetworkView.writeProperty(name, op, defaultVal, displayName, facets, readonly, false);
    }

    static void writeProperty(String name, HxOp op, BObject defaultVal, String displayName, BFacets facets, boolean readonly, boolean editCheckbox) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)defaultVal, (Context)op.make((OrdTarget)op).mergeFacets(facets));
        OrdTarget target = new OrdTarget((OrdTarget)op, defaultVal);
        HxOp fieldOp = op.make(name, defaultVal, facets);
        fieldOp.setReadonly(readonly || editCheckbox);
        out.w((Object)"<tr>");
        if (editCheckbox) {
            op.addStyleSheet(BOrd.make((String)"module://smartTableHx/rc/smartTable.css"));
            op.addStyleSheet(BOrd.make((String)"module://entsecHx/rc/join.css"));
            BOrd ord = BOrd.make((String)"module://smartTableHx/rc/smartTable.js");
            op.addJavaScript(ord);
            String checkBoxName = name.substring(0, 1) + "_edit_" + name.substring(1, name.length());
            out.w((Object)"<td>");
            out.w((Object)"<input type='checkbox'");
            out.w((Object)" ").attr("name", op.scope(checkBoxName));
            out.w((Object)" ").attr("id", op.scope(checkBoxName));
            out.w((Object)" onclick='smartTable.disable(&quot;").w((Object)op.scope(name));
            out.w((Object)"&quot;, this.checked);'");
            out.w((Object)"/>");
            out.w((Object)"</td>");
        }
        out.w((Object)"<td class='smartTable-setup-label'>");
        out.safe((Object)displayName);
        out.w((Object)"</td>");
        out.w((Object)"<td>");
        editor.write(fieldOp);
        out.w((Object)"</td></tr>");
    }

    public static void writeCredProperty(String name, HxOp op, BObject defaultVal, String displayName, BFacets facets, boolean readonly, boolean editCheckbox) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)defaultVal, (Context)op.make((OrdTarget)op).mergeFacets(facets));
        OrdTarget target = new OrdTarget((OrdTarget)op, defaultVal);
        HxOp fieldOp = op.make(name, defaultVal, facets);
        fieldOp.setReadonly(readonly || editCheckbox);
        out.w((Object)"<tr>");
        op.addStyleSheet(BOrd.make((String)"module://entsecHx/rc/join.css"));
        out.w((Object)"<td colspan='2'>");
        out.w((Object)"<fieldset class='-t-Station-Fieldset-style'>");
        out.w((Object)("<legend class='-t-Station-Legend-style'>" + displayName + "</legend>"));
        if (editCheckbox) {
            op.addStyleSheet(BOrd.make((String)"module://smartTableHx/rc/smartTable.css"));
            op.addStyleSheet(BOrd.make((String)"module://entsecHx/rc/join.css"));
            BOrd ord = BOrd.make((String)"module://smartTableHx/rc/smartTable.js");
            op.addJavaScript(ord);
            String checkBoxName = name.substring(0, 1) + "_edit_" + name.substring(1, name.length());
            out.w((Object)"<div>");
            out.w((Object)"<input type='checkbox'");
            out.w((Object)" ").attr("name", op.scope(checkBoxName));
            out.w((Object)" ").attr("id", op.scope(checkBoxName));
            out.w((Object)" onclick='smartTable.disable(&quot;").w((Object)op.scope(name));
            out.w((Object)"&quot;, this.checked);'");
            out.w((Object)"/>");
            out.w((Object)"</div>");
        }
        out.w((Object)"<div>");
        editor.write(fieldOp);
        out.w((Object)"</fieldset>");
        out.w((Object)"</div>");
        out.w((Object)"</td></tr>");
    }

    public static void writeCredProperty(String name, HxOp op, BComplex obj, Property prop, Lexicon lex, boolean editCheckbox) throws Exception {
        if (lex == null) {
            lex = Lexicon.make(obj.getClass());
        }
        BValue defaultVal = obj.get(prop);
        String displayName = lex.get(prop.getName(), TextUtil.toFriendly((String)prop.getName()));
        BFacets facets = obj.getSlotFacets((Slot)prop);
        boolean readonly = false;
        HtmlWriter out = op.getHtmlWriter();
        BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)defaultVal, (Context)op.make((OrdTarget)op).mergeFacets(facets));
        HxOp fieldOp = op.make(name, (BObject)defaultVal, facets);
        fieldOp.setReadonly(readonly || editCheckbox);
        out.w((Object)"<tr>");
        op.addStyleSheet(BOrd.make((String)"module://entsecHx/rc/join.css"));
        if (editCheckbox) {
            op.addStyleSheet(BOrd.make((String)"module://smartTableHx/rc/smartTable.css"));
            op.addStyleSheet(BOrd.make((String)"module://entsecHx/rc/join.css"));
            BOrd ord = BOrd.make((String)"module://smartTableHx/rc/smartTable.js");
            op.addJavaScript(ord);
            String checkBoxName = name.substring(0, 1) + "_edit_" + name.substring(1, name.length());
            out.w((Object)"<td>");
            out.w((Object)"<input type='checkbox'");
            out.w((Object)" ").attr("name", op.scope(checkBoxName));
            out.w((Object)" ").attr("id", op.scope(checkBoxName));
            out.w((Object)" onclick='smartTable.disable(&quot;").w((Object)op.scope(name));
            out.w((Object)"&quot;, this.checked);'");
            out.w((Object)"/>");
            out.w((Object)"</td>");
        }
        out.w((Object)"<td colspan='2'>");
        out.w((Object)"<fieldset class='-t-Station-Fieldset-style'>");
        out.w((Object)("<legend class='-t-Station-Legend-style'>" + displayName + "</legend>"));
        editor.write(fieldOp);
        out.w((Object)"</fieldset>");
        out.w((Object)"</td></tr>");
    }

    public static String getStationCertURL(BJob job, HxOp op) {
        String jobName = job.getClass().getName();
        String redirectURL = null;
        if (jobName.indexOf("BRemoteConfigJob") > -1) {
            BRemoteConfigJob stationJob = (BRemoteConfigJob)job;
            if (stationJob.isCertApprovalNeeded()) {
                BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
                NiagaraStation ng = nn.getStation(stationJob.remoteStation);
                if (stationJob.certStationName.equals(stationJob.remoteStation)) {
                    redirectURL = "service:platCrypto:CertManagerService";
                } else {
                    redirectURL = BHxNiagaraNetworkView.constructURL(op, ng.getRemoteHost().getHostname(), stationJob.remoteStation);
                    redirectURL = redirectURL + "/ord?service:platCrypto:CertManagerService";
                }
                return redirectURL;
            }
            return null;
        }
        if (jobName.indexOf("BStationConnectJob") > -1) {
            BStationConnectJob stationJob = (BStationConnectJob)job;
            if (stationJob.isCertApprovalNeeded()) {
                if (stationJob.certStationName.equals(stationJob.remoteStation1)) {
                    redirectURL = "service:platCrypto:CertManagerService";
                } else {
                    BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
                    NiagaraStation ngStn = nn.getStation(stationJob.remoteStation1);
                    redirectURL = BHxNiagaraNetworkView.constructURL(op, ngStn.getRemoteHost().getHostname(), stationJob.remoteStation1);
                    redirectURL = redirectURL + "/ord?service:platCrypto:CertManagerService";
                }
                return redirectURL;
            }
            return null;
        }
        if (jobName.indexOf("BEditStationsJob") > -1) {
            BEditStationsJob stationJob = (BEditStationsJob)job;
            if (stationJob.isCertApprovalNeeded()) {
                BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
                NiagaraStation ng = nn.getStation(stationJob.remoteStation);
                if (stationJob.certStationName.equals(stationJob.remoteStation)) {
                    redirectURL = "service:platCrypto:CertManagerService";
                } else {
                    redirectURL = BHxNiagaraNetworkView.constructURL(op, ng.getRemoteHost().getHostname(), stationJob.remoteStation);
                    redirectURL = redirectURL + "/ord?service:platCrypto:CertManagerService";
                }
                return redirectURL;
            }
            return null;
        }
        if (jobName.indexOf("BAddStationsJob") > -1) {
            BAddStationsJob stationJob = (BAddStationsJob)job;
            if (stationJob.isCertApprovalNeeded()) {
                BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
                NiagaraStation ng = nn.getStation(stationJob.remoteStation);
                if (stationJob.certStationName.equals(stationJob.remoteStation)) {
                    redirectURL = "service:platCrypto:CertManagerService";
                } else {
                    redirectURL = BHxNiagaraNetworkView.constructURL(op, ng.getRemoteHost().getHostname(), stationJob.remoteStation);
                    redirectURL = redirectURL + "/ord?service:platCrypto:CertManagerService";
                }
                return redirectURL;
            }
            return null;
        }
        return null;
    }

    static BTimeSyncClient getTimeSyncClient(HxOp op) {
        BTimeSyncService remoteTimeSyncService = (BTimeSyncService)Sys.getService((Type)BTimeSyncService.TYPE);
        BNiagaraStation supervisorStation = RemoteUtil.getSupervisorStation();
        if (supervisorStation == null) {
            return null;
        }
        BOrd addressOrd = supervisorStation.getAddress();
        String supervisorAddress = addressOrd.parse()[0].getBody();
        BTimeSyncClient[] timeSyncClients = (BTimeSyncClient[])remoteTimeSyncService.getChildren(BTimeSyncClient.class);
        if (timeSyncClients.length > 0) {
            return timeSyncClients[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String constructURL(HxOp op, String hostName, String jobStationName) {
        int defaultPort;
        Boolean tunnelRedirects = (Boolean)op.getRequest().getSession().getAttribute("tunnelRedirects");
        BWebService webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
        BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        Object niagaraStation = null;
        HttpServletRequest req = op.getRequest();
        boolean useHttps = req.isSecure();
        BNiagaraStation remStation = (BNiagaraStation)network.getNiagaraStation(jobStationName);
        String scheme = "http";
        boolean useFoxs = remStation.getClientConnection().getUseFoxs();
        if (useFoxs) {
            useHttps = true;
            scheme = "https";
        } else {
            useHttps = false;
            scheme = "http";
        }
        int port = defaultPort = useHttps ? 443 : 80;
        SysDefSession session = null;
        try {
            session = network.createSysDefSession((Context)op);
            BProviderStation station = (BProviderStation)session.getStation(jobStationName);
            if (station != null) {
                port = useHttps ? station.getHttpsPort() : station.getHttpPort();
            } else {
                BWebService remoteWebService = (BWebService)HxRemoteUtil.getRemoteComponent(BOrd.make((String)"service:web:WebService"), jobStationName, op);
                if (remoteWebService != null) {
                    remoteWebService.lease(1);
                    port = useHttps ? remoteWebService.getHttpsPort().getPublicServerPort() : remoteWebService.getHttpPort().getPublicServerPort();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append(scheme);
        sb.append("://");
        sb.append(hostName);
        if (port != defaultPort) {
            sb.append(":").append(Integer.toString(port));
        }
        return sb.toString();
    }

    private boolean checkUserCredEdited(String userCredName, HxOp op) {
        String checkedValue = op.getFormValue(userCredName.substring(0, 1) + "_edit_" + userCredName.substring(1, userCredName.length()));
        return checkedValue != null && checkedValue.equals("on");
    }

    private boolean isLegacySubordinateFoxsConnection(String remoteStation) {
        BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BNiagaraStation remStation = (BNiagaraStation)network.getNiagaraStation(remoteStation);
        String scheme = remStation.getScheme();
        return scheme.equalsIgnoreCase(FOXS);
    }

    private boolean isLegacySubordinateConnection(HxOp op, String stationName) {
        BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BNiagaraStation remStation = (BNiagaraStation)network.getNiagaraStation(stationName);
        BIpHost host = (BIpHost)remStation.getRemoteHost();
        BFoxSession remoteSession = BFoxSession.make((String)stationName, (BHost)host, (int)remStation.getFoxPort(), (boolean)remStation.getClientConnection().getUseFoxs());
        return remoteSession.getConnection().session().isLegacyConnection();
    }

    private Version getLocalVersion() {
        BAccessControlService localService = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        Version localVersion = new Version(localService.getSoftwareVersion());
        return localVersion;
    }

    private synchronized boolean validateN4SoftwareVersion(HxOp op, String stationName) throws Exception {
        return this.getLocalVersion().equals((Object)this.getRemoteVersion(op, stationName));
    }

    private Version getRemoteVersion(HxOp op, String stationName) {
        BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BNiagaraStation remoteStation = (BNiagaraStation)network.getNiagaraStation(stationName);
        SubordinateConnection conn = new SubordinateConnection(remoteStation, BOrd.make((String)ACCESS_SERVICE_ORD));
        BAccessControlService remoteService = (BAccessControlService)BOrd.make((String)ACCESS_SERVICE_ORD).get((BObject)conn.getProxy());
        remoteService.lease();
        Version remoteVersion = new Version(remoteService.getSoftwareVersion());
        return remoteVersion;
    }

    static class CancelDialog
    extends Dialog {
        String msg;

        public CancelDialog(String title, Command handler, String msg) {
            super(title, handler);
            this.msg = msg;
        }

        public Command[] getCommands() {
            return new Command[]{new Dialog.Submit(){

                public String getInvokeCode(HxOp op) {
                    return "hx.closeDialog(null,null,null);";
                }
            }};
        }

        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<table>");
            out.w((Object)"<tr><td>");
            String text = TextUtil.replace((String)this.msg, (String)"\n", (String)"<br/>");
            text = TextUtil.replace((String)text, (String)"\r", (String)"");
            out.w((Object)"<b>").w((Object)HxTabUtil.safeWithBreaks((String)text)).w((Object)"&nbsp;</b>");
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
        }
    }

    static class ErrorDialog
    extends Dialog {
        String msg;
        String details;

        public ErrorDialog(String title, Command handler, String msg, String details) {
            super(title, handler);
            this.msg = msg;
            this.details = details;
        }

        public Command[] getCommands() {
            return new Command[]{new Dialog.Submit((Dialog)this)};
        }

        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            BHxSmartTableView.writeUnscopedFormValue((String)"step", (String)"errorDialog", (HxOp)op);
            out.w((Object)"<table>");
            out.w((Object)"<tr><td>");
            out.w((Object)"<td>");
            if (this.details != null) {
                StringWriter w = new StringWriter();
                HtmlWriter h = new HtmlWriter((Writer)w);
                h.w((Object)"<pre><code>");
                h.safe((Object)this.details);
                h.w((Object)"</code></pre>");
                String ex = TextUtil.replace((String)w.toString(), (String)"\n", (String)"<br/>");
                ex = TextUtil.replace((String)ex, (String)"\r", (String)"");
                out.w((Object)ex);
            }
            out.w((Object)"");
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
        }
    }

    public class RemoteTimeSyncCommand
    extends SmartCommand
    implements HxProgressJobDialog.IJobCompleteHandler {
        private Dialog confirmDialog;

        public RemoteTimeSyncCommand(BHxView view) {
            super(view);
            this.confirmDialog = new ConfirmDialog(this.getDisplayName(null), (Command)this, secUtilLex.getText("stationView.syncTimeJob"));
        }

        public void invoke(BJob job, HxOp op) throws Exception {
            if (job.getJobState().equals((Object)BJobState.failed) || job.getJobState().equals((Object)BJobState.canceled)) {
                BHxAbstractJobView.openErrorDialog(job, (Command)this, op);
            } else if (job.getJobState().equals((Object)BJobState.success)) {
                BHxAbstractJobView.openSuccessDialog(job, (Command)this, op);
            }
        }

        public void handle(HxOp op) throws Exception {
            if (!this.confirmDialog.isSubmit(op)) {
                this.confirmDialog.open(op);
                return;
            }
            BHxNiagaraNetworkView.this.syncTimeEvent.handle(op);
        }

        public String getName(HxOp op) {
            return "syncTime";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }
    }

    public class JoinProgressCommand
    extends Command
    implements HxProgressJobDialog.IJobCompleteHandler {
        public JoinProgressCommand(BHxView view) {
            super(view);
        }

        public void invoke(BJob job, HxOp op) throws Exception {
            Lexicon lex = Lexicon.make(BHxNiagaraNetworkView.class);
            if (job.getJobState().equals((Object)BJobState.failed) || job.getJobState().equals((Object)BJobState.canceled)) {
                BHxAbstractJobView.openErrorDialog(job, this, op);
            } else if (job.getJobState().equals((Object)BJobState.success)) {
                BHxAbstractJobView.openSuccessDialog(job, this, op);
            }
        }

        public void handle(HxOp op) throws Exception {
            BHxNiagaraNetworkView.this.batchJoinEvent.handle(op);
        }
    }

    static class BatchForceJoinDialog
    extends Dialog {
        public BatchForceJoinDialog(String title, Command handler) {
            super(title, handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            BHxSmartTableView.writeUnscopedFormValue((String)"step", (String)"batchForceJoin", (HxOp)op);
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<table><tr><td>");
            HxUtil.makeImageJS((BImage)BImage.make((BIcon)BIcon.make((String)Lexicon.make(SmartCommand.class).get("question.icon"))), (HxOp)op);
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"<table><tr><td><b>");
            out.safe((Object)secUtilLex.getText("stationView.batchJoinJob.warning"));
            out.w((Object)"<b></td></td>");
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            for (int i = 0; i < selectionList.length; ++i) {
                BNiagaraStation station = (BNiagaraStation)BOrd.make((String)("station:|" + selectionList[i])).get();
                out.w((Object)"<tr><td>");
                out.safe((Object)station.getName());
                out.w((Object)"</td></td>");
            }
            out.w((Object)"</table>");
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
        }
    }

    public class JoinCommand
    extends SmartCommand
    implements HxProgressJobDialog.IJobCompleteHandler {
        private final boolean isForced;
        private ConfirmDialog confirmLegacyDialog;
        private CancelDialog confirmLegacyFoxsDialog;
        private CancelDialog cancelN4SoftwareMismatchDialog;

        public JoinCommand(BHxView view, boolean isForced) {
            super(view, LexiconModule.make((BModule)BHxNiagaraNetworkView.secUtilLex.module));
            this.isForced = isForced;
            this.confirmLegacyDialog = new ConfirmDialog(this.getDisplayName(null), (Command)this);
            this.confirmLegacyFoxsDialog = new CancelDialog(this.getDisplayName(null), (Command)this, secUtilLex.getText("join.legacyFoxsConnection"));
            this.cancelN4SoftwareMismatchDialog = new CancelDialog(this.getDisplayName(null), (Command)this, null);
        }

        public String getName(HxOp op) {
            return this.isForced ? "forceJoin" : "join";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            if (this.isForced) {
                return BCommandEnablePolicy.anySelection;
            }
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public boolean isDefaultAction() {
            return false;
        }

        public void handle(HxOp op) throws Exception {
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            if (selectionList.length == 1) {
                String rowId = selectionList[0];
                String stationName = rowId.substring(rowId.lastIndexOf("/") + 1);
                String localSoftwareVersion = BHxNiagaraNetworkView.this.getLocalVersion().toString();
                String remoteSoftwareVersion = BHxNiagaraNetworkView.this.getRemoteVersion(op, stationName).toString();
                if (BHxNiagaraNetworkView.this.isLegacySubordinateConnection(op, stationName)) {
                    if (!BHxNiagaraNetworkView.this.isLegacySubordinateFoxsConnection(stationName)) {
                        this.confirmLegacyFoxsDialog.msg = secUtilLex.getText("join.legacyFoxsConnection", new Object[]{remoteSoftwareVersion});
                        if (!this.confirmLegacyFoxsDialog.isSubmit(op)) {
                            this.confirmLegacyFoxsDialog.open(op);
                            return;
                        }
                    } else if (!this.confirmLegacyDialog.isSubmit(op)) {
                        this.confirmLegacyDialog.open(secUtilLex.getText("join.softwareAXNotification", new Object[]{remoteSoftwareVersion, localSoftwareVersion}), op);
                        return;
                    }
                } else if (!BHxNiagaraNetworkView.this.validateN4SoftwareVersion(op, stationName)) {
                    this.cancelN4SoftwareMismatchDialog.msg = secUtilLex.getText("join.softwareNotification", new Object[]{remoteSoftwareVersion, localSoftwareVersion});
                    if (!this.cancelN4SoftwareMismatchDialog.isSubmit(op)) {
                        this.cancelN4SoftwareMismatchDialog.open(op);
                        return;
                    }
                }
                if (BHxNiagaraNetworkView.this.scopeRowIds(op)) {
                    rowId = TextUtil.split((String)rowId, (char)'~')[1];
                }
                BNiagaraReplicationDeviceExt ext = (BNiagaraReplicationDeviceExt)BOrd.make((String)("station:|" + rowId + "|slot:entsec_NiagaraReplicationDeviceExt")).resolve().getComponent();
                String view = this.isForced ? "ForceSysJoinManager" : "SysJoinManager";
                BOrd ord = BOrd.make((String)("station:|" + rowId + "|slot:entsec_NiagaraReplicationDeviceExt|view:entsecHx:" + view));
                this.redirect(op, op.toUri(ord));
            } else {
                System.out.println("Batch Edit ....................... ");
                String lastStep = op.getFormValue("step");
                if (lastStep == null) {
                    new BatchForceJoinDialog(secUtilLex.getText("stationView.batchJoinJob"), (Command)this).open(op);
                } else {
                    ((BHxNiagaraNetworkView)this.getView()).batchJoinEvent.handle(op);
                }
            }
        }

        public void invoke(BJob job, HxOp op) throws Exception {
            if (job.getJobState().equals((Object)BJobState.failed) || job.getJobState().equals((Object)BJobState.canceled)) {
                BHxAbstractJobView.openErrorDialog(job, (Command)this, secUtilLex.getText("stationView.batchJoinJobError"), op);
                return;
            }
            ((BHxAbstractManagerView)this.getView()).reloadTables(op);
        }
    }

    public class StationSummaryHyperlink
    extends BHxQueryTableView.HyperlinkCommand {
        public StationSummaryHyperlink(BHxView view) {
            super(view);
        }

        @Override
        public String getName(HxOp op) {
            return "summary";
        }
    }

    static class StationRedirectCommand
    extends RedirectCommand {
        public StationRedirectCommand(BHxView view) {
            super(view);
        }

        @Override
        public String getPath(HxOp op) {
            return "";
        }

        @Override
        public String getStationName(HxOp op) {
            int len;
            BNiagaraStation[] stations = BHxNiagaraNetworkView.getSelectedStations(op);
            int n = len = stations != null ? stations.length : 0;
            if (len < 1) {
                return null;
            }
            return stations[0].getStationName();
        }

        @Override
        public String getHostName(HxOp op) {
            int len;
            BNiagaraStation[] stations = BHxNiagaraNetworkView.getSelectedStations(op);
            int n = len = stations != null ? stations.length : 0;
            if (len < 1) {
                return null;
            }
            return stations[0].getRemoteHost().getHostname();
        }
    }

    static class WebSettingsDialog
    extends Dialog {
        public WebSettingsDialog(Command handler) {
            super(secUtilLex.getText("settings.label"), handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            String text = TextUtil.replace((String)secUtilLex.getText("stationView.localSettingsDescription"), (String)"\n", (String)"<br/>");
            text = TextUtil.replace((String)text, (String)"\r", (String)"");
            out.w((Object)text);
            out.w((Object)"<br/>");
            out.w((Object)"<br/>");
            BHxSmartTableView.writeUnscopedFormValue((String)"step", (String)"webSettings", (HxOp)op);
            BWebService webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
            BFoxService foxService = (BFoxService)Sys.getService((Type)BFoxService.TYPE);
            out.w((Object)"<table>");
            Lexicon lex = Lexicon.make(BHxNiagaraNetworkView.class);
            out.w((Object)"<tr><td class='smartTable-setup-label'>");
            BBoolean foxEnabled = BBoolean.make((boolean)foxService.getFoxEnabled());
            BHxFieldEditor foxEnabledEditor = BHxFieldEditor.makeFor((BObject)foxEnabled, (Context)op);
            HxOp foxEnabledFieldOp = op.make("foxEnabled", (BObject)foxEnabled, null);
            out.safe((Object)lex.getText("foxEnabled"));
            out.w((Object)"</td><td>");
            foxEnabledEditor.write(foxEnabledFieldOp);
            out.w((Object)"</td></tr>");
            out.w((Object)"<tr><td class='smartTable-setup-label'>");
            BInteger foxPort = BInteger.make((int)foxService.getFoxPort().getBindingPort());
            BHxFieldEditor foxPortEditor = BHxFieldEditor.makeFor((BObject)foxPort, (Context)op);
            HxOp foxPortFieldOp = op.make("foxPort", (BObject)foxPort, null);
            out.safe((Object)lex.getText("foxPort"));
            out.w((Object)"</td><td>");
            foxPortEditor.write(foxPortFieldOp);
            out.w((Object)"</td></tr>");
            out.w((Object)"<tr><td class='smartTable-setup-label'>");
            BBoolean foxsEnabled = BBoolean.make((boolean)foxService.getFoxsEnabled());
            BHxFieldEditor foxsEnabledEditor = BHxFieldEditor.makeFor((BObject)foxsEnabled, (Context)op);
            HxOp foxsEnabledFieldOp = op.make("foxsEnabled", (BObject)foxsEnabled, null);
            out.safe((Object)lex.getText("foxsEnabled"));
            out.w((Object)"</td><td>");
            foxsEnabledEditor.write(foxsEnabledFieldOp);
            out.w((Object)"</td></tr>");
            out.w((Object)"<tr><td class='smartTable-setup-label'>");
            BInteger foxsPort = BInteger.make((int)foxService.getFoxsPort().getBindingPort());
            BHxFieldEditor foxsPortEditor = BHxFieldEditor.makeFor((BObject)foxsPort, (Context)op);
            HxOp foxsPortFieldOp = op.make("foxsPort", (BObject)foxsPort, null);
            out.safe((Object)lex.getText("foxsPort"));
            out.w((Object)"</td><td>");
            foxsPortEditor.write(foxsPortFieldOp);
            out.w((Object)"</td></tr>");
            out.w((Object)"<tr><td class='smartTable-setup-label'>");
            BBoolean foxsOnly = BBoolean.make((boolean)foxService.getFoxsOnly());
            BHxFieldEditor foxsOnlyEditor = BHxFieldEditor.makeFor((BObject)foxsOnly, (Context)op);
            HxOp foxsOnlyFieldOp = op.make("foxsOnly", (BObject)foxsOnly, null);
            out.safe((Object)lex.getText("foxsOnly"));
            out.w((Object)"</td><td>");
            foxsOnlyEditor.write(foxsOnlyFieldOp);
            out.w((Object)"</td></tr>");
            out.w((Object)"<tr><td class='smartTable-setup-label'>");
            BCertificateAliasAndPassword certificateAliasAndPassword = foxService.getCertAliasAndPassword();
            BHxFieldEditor foxsCertEditor = BHxFieldEditor.makeFor((BObject)certificateAliasAndPassword, (Context)op);
            HxOp foxsCertFieldOp = op.make("foxsCert", (BObject)certificateAliasAndPassword, null);
            out.safe((Object)lex.getText("foxsCert"));
            out.w((Object)"</td><td>");
            foxsCertEditor.write(foxsCertFieldOp);
            out.w((Object)"</td></tr>");
            out.w((Object)"<tr><td class='smartTable-setup-label'>");
            BServerCertificateHealth serverCertificateHealth = foxService.getServerCertificateHealth();
            BHxFieldEditor serverCertificateHealthEditor = BHxFieldSheet.INSTANCE.makeFor((BComplex)foxService, BFoxService.serverCertificateHealth, (BValue)serverCertificateHealth, null, op);
            HxOp serverCertificateHealthOp = op.make("serverCertificateHealth", (BObject)serverCertificateHealth, null);
            out.safe((Object)lex.getText("serverCertificateHealth"));
            out.w((Object)"</td><td>");
            serverCertificateHealthEditor.write(serverCertificateHealthOp);
            out.w((Object)"</td></tr>");
            try {
                boolean showTimeSync = true;
                BTimeSyncService timeSyncService = (BTimeSyncService)Sys.getService((Type)BTimeSyncService.TYPE);
                BTimeSyncClient client = BHxNiagaraNetworkView.getTimeSyncClient(op);
                BInteger valInt = null;
                if (BHxNiagaraNetworkView.isSupervisor()) {
                    valInt = (BInteger)timeSyncService.get(BTimeSyncService.serverPort);
                } else if (client != null) {
                    BBoolean boolVal = BBoolean.make((boolean)timeSyncService.getEnabled());
                    BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)boolVal, (Context)op);
                    HxOp fieldOp = op.make("timeSyncServerEnabled", (BObject)boolVal, null);
                    out.w((Object)"<tr><td class='smartTable-setup-label'>");
                    out.safe((Object)lex.getText("timeSyncEnabled"));
                    out.w((Object)"</td><td>");
                    editor.write(fieldOp);
                    out.w((Object)"</td></tr>");
                    BString stringVal = BString.make((String)(client.getStatus() + " " + client.getFaultCause()));
                    editor = BHxFieldEditor.makeFor((BObject)stringVal, (Context)op);
                    fieldOp = op.make("timeSyncStatus", (BObject)stringVal, null);
                    fieldOp.setReadonly(true);
                    out.w((Object)"<tr><td class='smartTable-setup-label'>");
                    out.safe((Object)lex.getText("timeSyncStatus"));
                    out.w((Object)"</td><td>");
                    editor.write(fieldOp);
                    out.w((Object)"</td></tr>");
                    stringVal = BString.make((String)client.getServerName());
                    editor = BHxFieldEditor.makeFor((BObject)stringVal, (Context)op);
                    fieldOp = op.make("timeSyncServerName", (BObject)stringVal, null);
                    out.w((Object)"<tr><td class='smartTable-setup-label'>");
                    out.safe((Object)lex.getText("timeSyncServerName"));
                    out.w((Object)"</td><td>");
                    editor.write(fieldOp);
                    out.w((Object)"</td></tr>");
                    valInt = BInteger.make((int)client.getServerPort());
                } else {
                    showTimeSync = false;
                }
                if (showTimeSync) {
                    BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)valInt, (Context)op);
                    HxOp fieldOp = op.make("timeSyncPort", (BObject)valInt, null);
                    out.w((Object)"<tr><td class='smartTable-setup-label'>");
                    out.safe((Object)lex.getText("timeSyncPort"));
                    out.w((Object)"</td><td>");
                    editor.write(fieldOp);
                    out.w((Object)"</td></tr>");
                }
            }
            catch (Exception e) {
                BEnterpriseSecurityService.LOG.log(Level.FINE, "Cannot Display TimeSync Properties", e);
            }
            out.w((Object)"</table>");
        }
    }

    static class WebSettingsCommand
    extends SmartCommand {
        public WebSettingsCommand(BHxView view) {
            super(view, LexiconModule.make((BModule)BHxNiagaraNetworkView.secUtilLex.module));
        }

        public String getName(HxOp op) {
            return "settings";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean isDefaultAction() {
            return false;
        }

        public void handle(HxOp op) throws Exception {
            String lastStep = op.getFormValue("step");
            if (lastStep == null) {
                try {
                    new WebSettingsDialog((Command)this).open(op);
                }
                catch (Exception ex) {
                    new com.tridium.hx.ErrorDialog(secUtilLex.getText("stationView.settingsError"), (Command)this, (Throwable)ex).open(op);
                }
                return;
            }
            if (lastStep.equals("webSettings")) {
                BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)BBoolean.DEFAULT, (Context)op);
                BFoxService foxService = (BFoxService)Sys.getService((Type)BFoxService.TYPE);
                BWebService webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
                try {
                    BTimeSyncService timeSyncService = (BTimeSyncService)Sys.getService((Type)BTimeSyncService.TYPE);
                    BTimeSyncClient client = BHxNiagaraNetworkView.getTimeSyncClient(op);
                    BInteger valInt = null;
                    if (BHxNiagaraNetworkView.isSupervisor()) {
                        HxOp fieldOp;
                        valInt = (BInteger)timeSyncService.get(BTimeSyncService.serverPort);
                        editor = BHxFieldEditor.makeFor((BObject)valInt, (Context)op);
                        BInteger savedIntValue = (BInteger)editor.save(fieldOp = op.make("timeSyncPort", (BObject)valInt, null));
                        if (!savedIntValue.equals((Object)fieldOp.get())) {
                            timeSyncService.set(BTimeSyncService.serverPort, (BValue)savedIntValue, (Context)op);
                        }
                    } else if (client != null) {
                        BInteger savedIntValue;
                        HxOp fieldOp;
                        BBoolean boolVal = BBoolean.make((boolean)timeSyncService.getEnabled());
                        editor = BHxFieldEditor.makeFor((BObject)boolVal, (Context)op);
                        BBoolean savedBoolVal = (BBoolean)editor.save(fieldOp = op.make("timeSyncServerEnabled", (BObject)boolVal, null));
                        if (!savedBoolVal.equals((Object)fieldOp.get())) {
                            timeSyncService.set(BTimeSyncService.enabled, (BValue)savedBoolVal, (Context)op);
                        }
                        BString stringVal = BString.make((String)client.getServerName());
                        editor = BHxFieldEditor.makeFor((BObject)stringVal, (Context)op);
                        fieldOp = op.make("timeSyncServerName", (BObject)stringVal, null);
                        BString savedStringVal = (BString)editor.save(fieldOp);
                        if (!savedBoolVal.equals((Object)fieldOp.get())) {
                            client.set(BTimeSyncClient.serverName, (BValue)savedStringVal, (Context)op);
                        }
                        if (!(savedIntValue = (BInteger)(editor = BHxFieldEditor.makeFor((BObject)(valInt = BInteger.make((int)client.getServerPort())), (Context)op)).save(fieldOp = op.make("timeSyncPort", (BObject)valInt, null))).equals((Object)fieldOp.get())) {
                            client.set(BTimeSyncClient.serverPort, (BValue)savedIntValue, (Context)op);
                        }
                        timeSyncService.forceSync();
                    }
                }
                catch (Exception e) {
                    BEnterpriseSecurityService.LOG.log(Level.FINE, "Cannot Save TimeSync Properties", e);
                }
                try {
                    BCertificateAliasAndPassword foxsCert;
                    BCertificateAliasAndPassword savedfoxsCert;
                    BBoolean foxsOnlyVal;
                    BBoolean savedFoxsOnlyVal;
                    BServerPort serverPorts;
                    BInteger foxsPortVal;
                    BInteger savedFoxsPort;
                    BBoolean foxsEnabledVal;
                    BBoolean savedFoxsEnabledVal;
                    BServerPort serverPort;
                    BInteger foxPortVal;
                    BInteger savedFoxPort;
                    BBoolean foxEnabledVal = (BBoolean)foxService.get(BFoxService.foxEnabled);
                    editor = BHxFieldEditor.makeFor((BObject)foxEnabledVal, (Context)op);
                    HxOp fieldOp = op.make("foxEnabled", (BObject)foxEnabledVal, null);
                    BBoolean savedFoxEnabledVal = (BBoolean)editor.save(fieldOp);
                    if (!savedFoxEnabledVal.equals((Object)fieldOp.get())) {
                        foxService.set(BFoxService.foxEnabled, (BValue)savedFoxEnabledVal, (Context)op);
                    }
                    if (!(savedFoxPort = (BInteger)(editor = BHxFieldEditor.makeFor((BObject)(foxPortVal = BInteger.make((int)(serverPort = foxService.getFoxPort()).getBindingPort())), (Context)op)).save(fieldOp = op.make("foxPort", (BObject)foxPortVal, null))).equals((Object)fieldOp.get())) {
                        foxService.set(BFoxService.foxPort, (BValue)new BServerPort(savedFoxPort.getInt()), (Context)op);
                    }
                    if (!(savedFoxsEnabledVal = (BBoolean)(editor = BHxFieldEditor.makeFor((BObject)(foxsEnabledVal = (BBoolean)foxService.get(BFoxService.foxsEnabled)), (Context)op)).save(fieldOp = op.make("foxsEnabled", (BObject)foxsEnabledVal, null))).equals((Object)fieldOp.get())) {
                        foxService.set(BFoxService.foxsEnabled, (BValue)savedFoxsEnabledVal, (Context)op);
                    }
                    if (!(savedFoxsPort = (BInteger)(editor = BHxFieldEditor.makeFor((BObject)(foxsPortVal = BInteger.make((int)(serverPorts = foxService.getFoxsPort()).getBindingPort())), (Context)op)).save(fieldOp = op.make("foxsPort", (BObject)foxsPortVal, null))).equals((Object)fieldOp.get())) {
                        foxService.set(BFoxService.foxsPort, (BValue)new BServerPort(savedFoxsPort.getInt()), (Context)op);
                    }
                    if (!(savedFoxsOnlyVal = (BBoolean)(editor = BHxFieldEditor.makeFor((BObject)(foxsOnlyVal = (BBoolean)foxService.get(BFoxService.foxsOnly)), (Context)op)).save(fieldOp = op.make("foxsOnly", (BObject)foxsOnlyVal, null))).equals((Object)fieldOp.get())) {
                        foxService.set(BFoxService.foxsOnly, (BValue)savedFoxsOnlyVal, (Context)op);
                    }
                    if (!(savedfoxsCert = (BCertificateAliasAndPassword)(editor = BHxFieldEditor.makeFor((BObject)(foxsCert = (BCertificateAliasAndPassword)foxService.get(BFoxService.certAliasAndPassword)), (Context)op)).save(fieldOp = op.make("foxsCert", (BObject)foxsCert, foxService.getSlotFacets((Slot)BFoxService.certAliasAndPassword)))).equals((Object)fieldOp.get())) {
                        foxService.set(BFoxService.certAliasAndPassword, (BValue)savedfoxsCert, (Context)op);
                    }
                }
                catch (Exception e) {
                    new com.tridium.hx.ErrorDialog(secUtilLex.getText("stationView.settingsError"), (Command)this, (Throwable)e).open(op);
                }
            }
        }
    }

    static class AutoReplicateDialog
    extends Dialog {
        boolean defaultValue;

        public AutoReplicateDialog(Command handler, boolean defaultValue) {
            super(secUtilLex.getText("stationView.autoReplicate"), handler);
            this.defaultValue = defaultValue;
        }

        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            BHxSmartTableView.writeUnscopedFormValue((String)"step", (String)"autoReplicate", (HxOp)op);
            BBoolean val = BBoolean.make((boolean)this.defaultValue);
            BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)val, (Context)op);
            HxOp fieldOp = op.make("setAutoReplicate", (BObject)val, null);
            out.w((Object)"<table><tr><td class='smartTable-setup-label'>");
            out.safe((Object)BNiagaraReplicationDeviceExt.automaticReplicationEnabled.getDefaultDisplayName((Context)op));
            out.w((Object)"</td><td>");
            editor.write(fieldOp);
            out.w((Object)"</td></tr></table>");
        }
    }

    static class AutoReplicateCommand
    extends SmartCommand {
        public AutoReplicateCommand(BHxView view) {
            super(view, LexiconModule.make((BModule)BHxNiagaraNetworkView.secUtilLex.module));
        }

        public String getName(HxOp op) {
            return "autoReplicate";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public boolean isDefaultAction() {
            return false;
        }

        public void handle(HxOp op) throws Exception {
            int len;
            BNiagaraStation[] stations = BHxNiagaraNetworkView.getSelectedStations(op);
            int n = len = stations != null ? stations.length : 0;
            if (len < 1) {
                return;
            }
            String lastStep = op.getFormValue("step");
            if (lastStep == null) {
                try {
                    BNiagaraReplicationDeviceExt deviceExt = (BNiagaraReplicationDeviceExt)stations[0].get("entsec_NiagaraReplicationDeviceExt");
                    new AutoReplicateDialog((Command)this, deviceExt.getAutomaticReplicationEnabled()).open(op);
                }
                catch (Exception ex) {
                    new com.tridium.hx.ErrorDialog(secUtilLex.getText("stationView.autoReplicationError"), (Command)this, (Throwable)ex).open(op);
                }
                return;
            }
            if (lastStep.equals("autoReplicate")) {
                BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)BBoolean.DEFAULT, (Context)op);
                BBoolean autoEnabled = (BBoolean)editor.save(op.make("setAutoReplicate", new OrdTarget((OrdTarget)op, (BObject)BBoolean.DEFAULT)));
                Exception e = null;
                for (int i = 0; i < stations.length; ++i) {
                    try {
                        BNiagaraReplicationDeviceExt deviceExt = (BNiagaraReplicationDeviceExt)stations[i].get("entsec_NiagaraReplicationDeviceExt");
                        deviceExt.set(deviceExt.getProperty("automaticReplicationEnabled"), (BValue)autoEnabled, (Context)op);
                        continue;
                    }
                    catch (Exception ex) {
                        e = ex;
                    }
                }
                if (e != null) {
                    new com.tridium.hx.ErrorDialog(secUtilLex.getText("stationView.autoReplicationError"), (Command)this, (Throwable)e).open(op);
                }
                ((BHxAbstractManagerView)this.getView()).reloadTable(op);
            }
        }
    }

    public class ReplicateProgressCommand
    extends Command
    implements HxProgressJobDialog.IJobCompleteHandler {
        public ReplicateProgressCommand(BHxView view) {
            super(view);
        }

        public void invoke(BJob job, HxOp op) throws Exception {
            Lexicon lex = Lexicon.make(BHxNiagaraNetworkView.class);
            if (job.getJobState().equals((Object)BJobState.failed) || job.getJobState().equals((Object)BJobState.canceled)) {
                BHxAbstractJobView.openErrorDialog(job, this, op);
            } else if (job.getJobState().equals((Object)BJobState.success)) {
                BHxAbstractJobView.openSuccessDialog(job, this, op);
            }
        }

        public void handle(HxOp op) throws Exception {
            BHxNiagaraNetworkView.this.replicateEvent.handle(op);
        }
    }

    class EnableReplicationDialog
    extends Dialog {
        public EnableReplicationDialog(String title, Command handler) {
            super(title, handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<b>").safe((Object)secUtilLex.get("stationView.enableReplicationConfirmation.message")).w((Object)"</b>");
            super.writeContent(op);
        }
    }

    class EnableReplicationCommand
    extends Command {
        private EnableReplicationDialog dlg;

        public EnableReplicationCommand(BHxView view) {
            super(view);
            this.dlg = new EnableReplicationDialog(secUtilLex.getText("stationView.enableReplicationConfirmation.title"), this);
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
            } else {
                BReplicationService replicationService = (BReplicationService)Sys.getService((Type)BReplicationService.TYPE);
                if (replicationService.getPermissions((Context)op).hasAdminWrite()) {
                    replicationService.setEnabled(true);
                    BHxNiagaraNetworkView.INSTANCE.replicate.handle(op);
                } else {
                    new com.tridium.hx.ErrorDialog(secUtilLex.getText("stationView.error.enableReplication.title"), (Throwable)new Exception(secUtilLex.getText("stationView.error.enableReplication.message"))).open(op);
                }
            }
            super.handle(op);
        }
    }

    public static class CertificateJobLogDialog
    extends JobLogDialog.JobLogDialogRefresh {
        private String redirect;

        public CertificateJobLogDialog(Command command, BJob job, String title, String redirect, HxOp op) {
            super(command, job, title, null);
            this.redirect = redirect;
        }

        public Command[] getCommands() {
            return new Command[]{new JobLogDialog.JobLogDialogRefresh.DoneRefresh((JobLogDialog.JobLogDialogRefresh)this), new JobLogDialog.Export((JobLogDialog)this), new Approve()};
        }

        protected class Approve
        extends Dialog.Cancel {
            public Approve() {
                super((Dialog)CertificateJobLogDialog.this);
            }

            public String getDisplayName(HxOp op) {
                return Lexicon.make(((Object)((Object)this)).getClass()).getText("CertMgr");
            }

            public String getInvokeCode(HxOp op) {
                StringBuffer b = new StringBuffer();
                b.append("hx.closeDialog(null,null,null);");
                if (!CertificateJobLogDialog.this.redirect.startsWith("http")) {
                    b.append("window.location=&quot;").append(op.toUri(BOrd.make((String)"service:platCrypto:CertManagerService"))).append("&quot;;");
                } else {
                    BOrd urll = BOrd.make((String)CertificateJobLogDialog.this.redirect);
                    b.append("window.location=&quot;").append(op.toUri(urll)).append("&quot;;");
                }
                return b.toString();
            }
        }
    }

    static class ReplicateCommand
    extends SmartCommand {
        ConfirmDialog dlg = new ConfirmDialog(this.getDisplayName(null), (Command)this);

        public ReplicateCommand(BHxView view) {
            super(view, LexiconModule.make((BModule)BHxNiagaraNetworkView.secUtilLex.module));
        }

        public String getName(HxOp op) {
            return "replicate";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean isDefaultAction() {
            return false;
        }

        public void handle(HxOp op) throws Exception {
            BReplicationService replicationService = (BReplicationService)Sys.getService((Type)BReplicationService.TYPE);
            if (!replicationService.getEnabled()) {
                BHxNiagaraNetworkView.INSTANCE.enableReplication.handle(op);
                return;
            }
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(secUtilLex.getText("stationView.replicateConfirmation"), op);
                return;
            }
            ((BHxNiagaraNetworkView)this.getView()).replicateEvent.handle(op);
        }
    }

    static class DeleteStation
    extends SmartCommand
    implements HxProgressJobDialog.IJobCompleteHandler {
        ConfirmDialog dlg = new ConfirmDialog(this.getDisplayName(null), (Command)this);

        public DeleteStation(BHxView view) {
            super(view, LexiconModule.make((BModule)BHxNiagaraNetworkView.secUtilLex.module));
        }

        public String getName(HxOp op) {
            return "delete";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public boolean isDefaultAction() {
            return false;
        }

        public void handle(HxOp op) throws Exception {
            String message = secUtilLex.getText("stationView.deleteConfirmation");
            Array joinedStations = new Array(String.class);
            BNiagaraStation[] stations = BHxNiagaraNetworkView.getSelectedStations(op);
            for (int i = 0; i < stations.length; ++i) {
                BNiagaraReplicationDeviceExt ext = (BNiagaraReplicationDeviceExt)stations[i].getMixIn(BNiagaraReplicationDeviceExt.TYPE);
                if (ext == null || !ext.getJoined()) continue;
                joinedStations.add((Object)stations[i].getStationName());
            }
            if (joinedStations.size() > 0) {
                message = secUtilLex.getText("stationView.deleteJoinConfirmation");
            }
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(message, op);
                return;
            }
            ((BHxNiagaraNetworkView)this.getView()).deleteStationEvent.handle(op);
        }

        public void invoke(BJob job, HxOp op) throws Exception {
            if (job.getJobState().equals((Object)BJobState.failed) || job.getJobState().equals((Object)BJobState.canceled)) {
                BHxAbstractJobView.openErrorDialog(job, (Command)this, secUtilLex.getText("stationView.stationError"), op);
                return;
            }
            if (job.getJobState().equals((Object)BJobState.success)) {
                BHxAbstractJobView.openSuccessDialog(job, (Command)this, op.mergeFacets(JobLogDialog.forceDetailsFacets));
            }
            ((BHxAbstractManagerView)this.getView()).reloadTables(op);
        }
    }

    static class PingStation
    extends SmartCommand
    implements HxProgressJobDialog.IJobCompleteHandler {
        public PingStation(BHxView view) {
            super(view, LexiconModule.make((BModule)BHxNiagaraNetworkView.secUtilLex.module));
        }

        public String getName(HxOp op) {
            return "ping";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public boolean isDefaultAction() {
            return false;
        }

        public void handle(HxOp op) throws Exception {
            String lastStep = op.getFormValue("step");
            if (lastStep == null) {
                ((BHxNiagaraNetworkView)this.getView()).pingStationEvent.handle(op);
                return;
            }
            ((BHxAbstractManagerView)this.getView()).reloadTable(op);
        }

        public void invoke(BJob job, HxOp op) throws Exception {
            if (job.getJobState().equals((Object)BJobState.failed) || job.getJobState().equals((Object)BJobState.canceled)) {
                String redirectURL = BHxNiagaraNetworkView.getStationCertURL(job, op);
                if (redirectURL != null) {
                    new CertificateJobLogDialog((Command)this, job, null, redirectURL, op).open(op);
                    return;
                }
                BHxAbstractJobView.openErrorDialog(job, (Command)this, secUtilLex.getText("stationView.stationError"), op);
                return;
            }
            ((BHxAbstractManagerView)this.getView()).reloadTable(op);
        }
    }

    static class EditStation
    extends SmartCommand
    implements HxProgressJobDialog.IJobCompleteHandler {
        public EditStation(BHxView view) {
            super(view, LexiconModule.make((BModule)BHxNiagaraNetworkView.secUtilLex.module));
        }

        public String getName(HxOp op) {
            return "edit";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public boolean isDefaultAction() {
            return false;
        }

        public void handle(HxOp op) throws Exception {
            String lastStep = op.getFormValue("step");
            if (lastStep == null) {
                BNiagaraStation[] stations = BHxNiagaraNetworkView.getSelectedStations(op);
                if (stations.length > 1) {
                    new AddDiscoveredDialog(secUtilLex.getText("stationView.batchEdit"), (Command)this, stations).open(op);
                } else {
                    new AddStationDialog(this.getDisplayName(null), (Command)this, stations[0]).open(op);
                }
                return;
            }
            if (lastStep.equals("batchEditStations")) {
                ((BHxNiagaraNetworkView)this.getView()).batchEditEvent.handle(op);
                return;
            }
            if (lastStep.equals("addStation")) {
                flag = true;
                ((BHxNiagaraNetworkView)this.getView()).editStationEvent.handle(op);
                return;
            }
            if (lastStep.equals("remoteConfig")) {
                flag = true;
                ((BHxNiagaraNetworkView)this.getView()).remoteEditEvent.handle(op);
                return;
            }
            ((BHxQueryTableView)this.getView()).reloadTable(op);
        }

        public void invoke(BJob job, HxOp op) throws Exception {
            if (job.getJobState().equals((Object)BJobState.failed) || job.getJobState().equals((Object)BJobState.canceled)) {
                String redirectURL = BHxNiagaraNetworkView.getStationCertURL(job, op);
                if (redirectURL != null) {
                    new CertificateJobLogDialog((Command)this, job, null, redirectURL, op).open(op);
                    return;
                }
                BHxAbstractJobView.openErrorDialog(job, (Command)this, secUtilLex.getText("stationView.stationError"), op);
                return;
            }
            if (job.getJobState().equals((Object)BJobState.success) && job instanceof BStationConnectJob && flag) {
                flag = false;
                BNiagaraStation remoteStation = ((BStationConnectJob)job).remoteStation;
                String stationName = ((BStationConnectJob)job).stationName;
                BNiagaraStation station = (BNiagaraStation)BHxNiagaraNetworkView.getNiagaraNetwork().getNiagaraStation(stationName);
                new RemoteConfigDialog(secUtilLex.getText("stationView.remoteConfig"), (Command)this, stationName, remoteStation, station.getSysDef().getRoleManager(), true).open(op);
                return;
            }
            ((BHxQueryTableView)this.getView()).reloadTable(op);
        }
    }

    static class RemoteConfigDialog
    extends Dialog {
        String stationName;
        BNiagaraStation defaultStation = new BNiagaraStation();
        BFoxClientConnection defaultConn = new BFoxClientConnection();
        BRoleManager defaultRole = null;
        boolean editStation = false;

        public RemoteConfigDialog(Command handler, String stationName, boolean editStation) {
            super(secUtilLex.getText("stationView.remoteConfig"), handler);
            this.stationName = stationName;
            this.defaultRole = new BRoleManager();
            this.defaultRole.setDesiredRole(BStationRole.subordinate);
            this.editStation = editStation;
        }

        public RemoteConfigDialog(String title, Command handler, String stationName, BNiagaraStation station, BRoleManager role, boolean editStation) {
            super(title, handler);
            this.stationName = stationName;
            this.defaultStation = station;
            this.defaultConn = station.getClientConnection();
            this.defaultRole = role;
            this.editStation = editStation;
        }

        protected void writeContent(HxOp op) throws Exception {
            if (this.defaultStation != null) {
                BHxSmartTableView.writeFormValue((String)"remoteStation", (String)StringEscapeUtils.escapeJava((String)ValueDocEncoder.marshal((BValue)this.defaultStation, (Context)op)), (HxOp)op);
            }
            HtmlWriter out = op.getHtmlWriter();
            BHxSmartTableView.writeUnscopedFormValue((String)"step", (String)"remoteConfig", (HxOp)op);
            BHxSmartTableView.writeUnscopedFormValue((String)"stationName", (String)this.stationName, (HxOp)op);
            String text = HtmlUtils.getLimitedHtml((String)secUtilLex.getText("stationView.remoteConfigDescription"));
            text = MessageFormat.format(text, Sys.getStation().getStationName());
            text = TextUtil.replace((String)text, (String)"\n", (String)"<br/>");
            text = TextUtil.replace((String)text, (String)"\r", (String)"");
            String localStationName = Sys.getStation().getStationName();
            localStationName = localStationName == null || localStationName.isEmpty() ? secUtilLex.getHtmlSafeText("stationView.localStation.name") : localStationName;
            out.w((Object)("<fieldset class='-t-Station-Fieldset-style'><legend class='-t-Station-Legend-style'>" + localStationName + "</legend>"));
            out.w((Object)"<br/>");
            out.w((Object)text);
            out.w((Object)"<br/>");
            out.w((Object)"<br/>");
            out.w((Object)"<table>");
            Lexicon lex = Lexicon.make(BDevice.class);
            BHxNiagaraNetworkView.writeProperty("stationEnabled", op, (BComplex)this.defaultStation, BNiagaraStation.enabled, lex);
            if (!this.editStation) {
                this.defaultConn.setFacets((Slot)BFoxClientConnection.credentialStore, BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"entsexHx:HxCredentialStoreFE")));
                BHxNiagaraNetworkView.writeCredProperty("stationUserCred", op, (BComplex)this.defaultConn, BFoxClientConnection.credentialStore, null, false);
            } else {
                BClientCredentials newCred = new BClientCredentials();
                BClientCredentials prevCred = this.defaultConn.getCredentialStore();
                newCred.setCredentials((BIUserCredentials)new BUsernameAndPassword(prevCred.getCredentials().getUsername(), BPassword.make((String)"")));
                String credDisplayName = secUtilLex.get("credentialStore", TextUtil.toFriendly((String)"credentialStore"));
                BHxNiagaraNetworkView.writeCredProperty("stationUserCred", op, (BObject)newCred, credDisplayName, this.defaultConn.getSlotFacets((Slot)BFoxClientConnection.credentialStore), false, true);
            }
            Property useFoxsProp = BFoxClientConnection.useFoxs;
            BHxNiagaraNetworkView.writeProperty("stationFoxs", op, (BObject)this.defaultConn.get(useFoxsProp), secUtilLex.getText("stationView.useFoxs"), this.defaultConn.getSlotFacets((Slot)useFoxsProp), false, false);
            Property foxProp = BFoxClientConnection.port;
            BHxNiagaraNetworkView.writeProperty("stationPort", op, (BObject)this.defaultConn.get(foxProp), secUtilLex.getText("stationView.foxPort"), this.defaultConn.getSlotFacets((Slot)foxProp), false, false);
            out.w((Object)"</table>");
            out.w((Object)"</fieldset>");
            text = TextUtil.replace((String)secUtilLex.getText("stationView.desiredRoleDescription"), (String)"\n", (String)"<br/>");
            text = TextUtil.replace((String)text, (String)"\r", (String)"");
            out.w((Object)"<br/>");
            out.w((Object)text);
            out.w((Object)"<br/>");
            out.w((Object)"<table>");
            BHxNiagaraNetworkView.writeProperty("stationRole", op, (BComplex)this.defaultRole, BRoleManager.desiredRole, null);
            out.w((Object)"</table>");
        }
    }

    static class AddStationDialog
    extends Dialog {
        BString stationName = BString.DEFAULT;
        BString stationAddress = BString.DEFAULT;
        BNiagaraStation defaultStation = new BNiagaraStation();
        BFoxClientConnection defaultConn = new BFoxClientConnection();
        boolean editExistingStation = false;

        public AddStationDialog(String title, Command handler) {
            super(title, handler);
        }

        public AddStationDialog(String title, Command handler, BNiagaraStation station) {
            super(title, handler);
            this.stationName = BString.make((String)station.getStationName());
            this.stationAddress = BString.make((String)station.getAddress().parse()[0].getBody());
            this.defaultStation = station;
            this.defaultConn = station.getClientConnection();
            this.editExistingStation = true;
        }

        public Command[] getCommands() {
            return new Command[]{this.makeSubmitCommand(LexiconText.make((BModule)Sys.getModuleForClass(BHxNiagaraNetworkView.class), (String)"stationView.continueRemoteConfig")), this.makeCancelCommand()};
        }

        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            BHxSmartTableView.writeUnscopedFormValue((String)"step", (String)"addStation", (HxOp)op);
            if (this.editExistingStation) {
                BHxSmartTableView.writeUnscopedFormValue((String)"editExistingStation", (String)"true", (HxOp)op);
            }
            String text = HtmlUtils.getLimitedHtml((String)secUtilLex.getText("stationView.localConfigDescription"));
            text = TextUtil.replace((String)text, (String)"\n", (String)"<br/>");
            text = TextUtil.replace((String)text, (String)"\r", (String)"");
            out.w((Object)"<fieldset class='-t-Station-Fieldset-style'>");
            String remoteStationName = this.stationName != null && !this.stationName.toString().isEmpty() ? this.stationName.toString() : secUtilLex.getHtmlSafeText("stationView.remoteStation.name");
            out.w((Object)("<legend class='-t-Station-Legend-style'> " + remoteStationName + " </legend>"));
            out.w((Object)"<br/>");
            out.w((Object)text);
            out.w((Object)"<br/>");
            out.w((Object)"<br/>");
            out.w((Object)"<table>");
            Lexicon lex = Lexicon.make(BFoxClientConnection.class);
            BHxNiagaraNetworkView.writeProperty("stationName", op, (BObject)this.stationName, lex.get("stationName", TextUtil.toFriendly((String)"stationName")), BFacets.DEFAULT, this.editExistingStation);
            lex = Lexicon.make(BDevice.class);
            BHxNiagaraNetworkView.writeProperty("stationEnabled", op, (BComplex)this.defaultStation, BNiagaraStation.enabled, lex);
            lex = Lexicon.make(BNiagaraStation.class);
            BHxNiagaraNetworkView.writeProperty("stationAddress", op, (BObject)this.stationAddress, lex.get(BNiagaraStation.address.getName(), TextUtil.toFriendly((String)BNiagaraStation.address.getName())), BFacets.DEFAULT, false);
            this.defaultConn.setFacets((Slot)BFoxClientConnection.credentialStore, BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"entsexHx:HxCredentialStoreFE")));
            BHxNiagaraNetworkView.writeCredProperty("stationUserCred", op, (BComplex)this.defaultConn, BFoxClientConnection.credentialStore, null, false);
            Property useFoxsProp = BFoxClientConnection.useFoxs;
            BHxNiagaraNetworkView.writeProperty("stationFoxs", op, (BObject)this.defaultConn.get(useFoxsProp), secUtilLex.getText("useFoxs"), this.defaultConn.getSlotFacets((Slot)useFoxsProp), false, false);
            Property foxProp = BFoxClientConnection.port;
            BHxNiagaraNetworkView.writeProperty("stationPort", op, (BObject)this.defaultConn.get(foxProp), secUtilLex.getText("foxPort"), this.defaultConn.getSlotFacets((Slot)foxProp), false, false);
            out.w((Object)"</fieldset>");
            out.w((Object)"</table>");
        }
    }

    static class AddStation
    extends SmartCommand
    implements HxProgressJobDialog.IJobCompleteHandler {
        AddStationDialog addStationDlg = new AddStationDialog(this.getDisplayName(null), (Command)this);

        public AddStation(BHxView view) {
            super(view, LexiconModule.make((BModule)BHxNiagaraNetworkView.secUtilLex.module));
        }

        public String getName(HxOp op) {
            return "new";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean isDefaultAction() {
            return false;
        }

        public void handle(HxOp op) throws Exception {
            String lastStep = op.getFormValue("step");
            if (lastStep == null) {
                this.addStationDlg.open(op);
                return;
            }
            if (lastStep.equals("addStation")) {
                remoteConfigDialogFlag = true;
                ((BHxNiagaraNetworkView)this.getView()).stationConnectEvent.handle(op);
                return;
            }
            if (lastStep.equals("remoteConfig")) {
                remoteConfigDialogFlag = true;
                ((BHxNiagaraNetworkView)this.getView()).remoteConfigEvent.handle(op);
                return;
            }
            ((BHxAbstractManagerView)this.getView()).reloadTables(op);
        }

        public void invoke(BJob job, HxOp op) throws Exception {
            if (job.getJobState().equals((Object)BJobState.failed) || job.getJobState().equals((Object)BJobState.canceled)) {
                String redirectURL = BHxNiagaraNetworkView.getStationCertURL(job, op);
                if (redirectURL != null) {
                    new CertificateJobLogDialog((Command)this, job, null, redirectURL, op).open(op);
                    return;
                }
                BHxAbstractJobView.openErrorDialog(job, (Command)this, secUtilLex.getText("stationView.stationError"), op);
                return;
            }
            if (job.getJobState().equals((Object)BJobState.success) && job instanceof BStationConnectJob && remoteConfigDialogFlag) {
                remoteConfigDialogFlag = false;
                new RemoteConfigDialog((Command)this, ((BStationConnectJob)job).stationName, false).open(op);
                return;
            }
            ((BHxAbstractManagerView)this.getView()).reloadTables(op);
        }
    }

    static class AddDiscoveredDialog
    extends Dialog {
        BLearnStation[] addStations = null;
        BNiagaraStation[] editStations = null;

        public AddDiscoveredDialog(String title, Command handler, BLearnStation[] addStations) {
            super(title, handler);
            this.addStations = addStations;
        }

        public AddDiscoveredDialog(String title, Command handler, BNiagaraStation[] editStations) {
            super(title, handler);
            this.editStations = editStations;
        }

        protected void writeContent(HxOp op) throws Exception {
            int i;
            boolean edit = this.editStations != null;
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<table><tr><td>");
            out.w((Object)"<fieldset class='-t-Station-Fieldset-style'>");
            BHxSmartTableView.writeUnscopedFormValue((String)"step", (String)(edit ? "batchEditStations" : "addDiscoveredStations"), (HxOp)op);
            String outboundStationName = secUtilLex.getHtmlSafeText("stationView.remoteStation.name");
            if (edit) {
                if (this.editStations.length > 0) {
                    BHxSmartTableView.writeFormValue((String)"editStations", (String)new Integer(this.editStations.length).toString(), (HxOp)op);
                    String stationNames = Arrays.stream(this.editStations).map(station -> station.getStationName()).collect(Collectors.joining(","));
                    outboundStationName = stationNames == null || stationNames.isEmpty() ? outboundStationName : stationNames;
                }
                for (i = 0; i < this.editStations.length; ++i) {
                    BHxSmartTableView.writeFormValue((String)("editStations" + i), (String)StringEscapeUtils.escapeJava((String)ValueDocEncoder.marshal((BValue)this.editStations[i])), (HxOp)op);
                }
            } else {
                if (this.addStations.length > 0) {
                    BHxSmartTableView.writeFormValue((String)"discoveredStations", (String)new Integer(this.addStations.length).toString(), (HxOp)op);
                    String stationNames = Arrays.stream(this.addStations).map(station -> station.getStationName()).collect(Collectors.joining(","));
                    outboundStationName = stationNames == null || stationNames.isEmpty() ? outboundStationName : stationNames;
                }
                for (i = 0; i < this.addStations.length; ++i) {
                    BHxSmartTableView.writeFormValue((String)("discoveredStations" + i), (String)StringEscapeUtils.escapeJava((String)ValueDocEncoder.marshal((BValue)this.addStations[i])), (HxOp)op);
                }
            }
            out.w((Object)("<legend class='-t-Station-Legend-style'>" + outboundStationName + "</legend>"));
            String text = HtmlUtils.getLimitedHtml((String)secUtilLex.getText("stationView.localConfigDescriptionWithNameOfSelectedStation"));
            text = MessageFormat.format(text, this.addStations[0].getStationName());
            text = TextUtil.replace((String)text, (String)"\n", (String)"<br/>");
            text = TextUtil.replace((String)text, (String)"\r", (String)"");
            out.w((Object)text);
            out.w((Object)"<br/>");
            out.w((Object)"<table>");
            BNiagaraStation defaultStation = new BNiagaraStation();
            Lexicon lex = Lexicon.make(BDevice.class);
            BHxNiagaraNetworkView.writeProperty("stationEnabled", op, (BComplex)defaultStation, BNiagaraStation.enabled, lex, edit);
            BFoxClientConnection defaultConn = new BFoxClientConnection();
            defaultConn.setFacets((Slot)BFoxClientConnection.credentialStore, BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"entsexHx:HxCredentialStoreFE")));
            BHxNiagaraNetworkView.writeCredProperty("stationUserCred", op, (BComplex)defaultConn, BFoxClientConnection.credentialStore, null, edit);
            BBoolean useFoxs = BBoolean.make((boolean)false);
            if (this.addStations[0].getScheme().equals(BHxNiagaraNetworkView.FOXS)) {
                useFoxs = BBoolean.make((boolean)true);
            }
            BHxNiagaraNetworkView.writeProperty("stationFoxs", op, (BObject)useFoxs, secUtilLex.getText("useFoxs"), defaultConn.getSlotFacets((Slot)BFoxClientConnection.useFoxs), false, false);
            BInteger foxPort = BInteger.make((int)this.addStations[0].getFoxPort());
            BHxNiagaraNetworkView.writeProperty("stationPort", op, (BObject)foxPort, secUtilLex.getText("foxPort"), defaultConn.getSlotFacets((Slot)BFoxClientConnection.port), false, false);
            out.w((Object)"</table>");
            String inboundStationName = Sys.getStation().getStationName();
            inboundStationName = inboundStationName == null || inboundStationName.isEmpty() ? secUtilLex.getHtmlSafeText("stationView.localStation.name") : inboundStationName;
            out.w((Object)("</td></fieldset><td><fieldset class='-t-Station-Fieldset-style'><legend class='-t-Station-Legend-style'>" + inboundStationName + "</legend>"));
            text = HtmlUtils.getLimitedHtml((String)secUtilLex.getText("stationView.remoteConfigDescription"));
            text = MessageFormat.format(text, Sys.getStation().getStationName());
            text = TextUtil.replace((String)text, (String)"\n", (String)"<br/>");
            text = TextUtil.replace((String)text, (String)"\r", (String)"");
            out.w((Object)text);
            out.w((Object)"<br/>");
            out.w((Object)"<table>");
            BBoolean remUseFoxs = null;
            BInteger remFoxPort = null;
            BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
            BFoxService niagFoxService = (BFoxService)BOrd.make((String)"service:fox:FoxService").get((BObject)nn);
            if (niagFoxService.getFoxServer().isFoxsRunning()) {
                remUseFoxs = BBoolean.make((boolean)true);
                remFoxPort = BInteger.make((int)niagFoxService.getFoxsPort().getBindingPort());
            } else {
                remUseFoxs = BBoolean.make((boolean)false);
                remFoxPort = BInteger.make((int)niagFoxService.getFoxPort().getBindingPort());
            }
            BHxNiagaraNetworkView.writeProperty("remoteStationEnabled", op, (BComplex)defaultStation, BNiagaraStation.enabled, lex, edit);
            BHxNiagaraNetworkView.writeCredProperty("remoteUserCred", op, (BComplex)defaultConn, BFoxClientConnection.credentialStore, null, edit);
            BHxNiagaraNetworkView.writeProperty("remoteStationFoxs", op, (BObject)remUseFoxs, secUtilLex.getText("useFoxs"), defaultConn.getSlotFacets((Slot)BFoxClientConnection.useFoxs), false, false);
            BHxNiagaraNetworkView.writeProperty("remoteStationPort", op, (BObject)remFoxPort, secUtilLex.getText("foxPort"), defaultConn.getSlotFacets((Slot)BFoxClientConnection.port), false, false);
            out.w((Object)"</table>");
            out.w((Object)"</td></fieldset></tr></table>");
            text = TextUtil.replace((String)secUtilLex.getText("stationView.desiredRoleDescription"), (String)"\n", (String)"<br/>");
            text = TextUtil.replace((String)text, (String)"\r", (String)"");
            out.w((Object)"<br/>");
            out.w((Object)text);
            out.w((Object)"<br/>");
            out.w((Object)"<table>");
            BRoleManager defaultRole = new BRoleManager();
            defaultRole.setDesiredRole(BStationRole.subordinate);
            BHxNiagaraNetworkView.writeProperty("stationRole", op, (BComplex)defaultRole, BRoleManager.desiredRole, null, edit);
            out.w((Object)"</table>");
        }
    }

    static class AddDiscovered
    extends SmartCommand
    implements HxProgressJobDialog.IJobCompleteHandler {
        public AddDiscovered(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "add";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public void handle(HxOp op) throws Exception {
            String lastStep = op.getFormValue("step");
            if (lastStep == null) {
                Object[] selectionList = BHxNiagaraNetworkDiscoverView.getSubjects(op.make("discover", (OrdTarget)op));
                if (selectionList != null && selectionList.length > 0) {
                    int len = selectionList.length;
                    BLearnStation[] addStations = new BLearnStation[len];
                    for (int i = 0; i < len; ++i) {
                        addStations[i] = (BLearnStation)selectionList[i];
                    }
                    new AddDiscoveredDialog(secUtilLex.getText("stationView.addDiscovered"), (Command)this, addStations).open(op);
                }
                return;
            }
            if (lastStep.equals("addDiscoveredStations")) {
                ((BHxNiagaraNetworkView)this.getView()).addDiscoveredEvent.handle(op);
                return;
            }
            ((BHxAbstractManagerView)this.getView()).reloadTables(op);
        }

        public void invoke(BJob job, HxOp op) throws Exception {
            if (job.getJobState().equals((Object)BJobState.failed) || job.getJobState().equals((Object)BJobState.canceled)) {
                String redirectURL = BHxNiagaraNetworkView.getStationCertURL(job, op);
                if (redirectURL != null) {
                    new CertificateJobLogDialog((Command)this, job, null, redirectURL, op).open(op);
                    return;
                }
                BHxAbstractJobView.openErrorDialog(job, (Command)this, secUtilLex.getText("stationView.discoveryError"), op);
                return;
            }
            ((BHxAbstractManagerView)this.getView()).reloadTables(op);
        }
    }

    class StationColumnsCommand
    extends ColumnsCommand {
        public StationColumnsCommand(BHxView view) {
            super(view);
        }

        @Override
        public boolean isVisible(HxOp op) {
            return true;
        }

        @Override
        public void handle(HxOp op) throws Exception {
            if (op.getPath().length() == 0) {
                StringBuffer sb = new StringBuffer();
                BNiagaraStationQuery query = ((BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE)).getStationsQuery();
                if (!BHxNiagaraNetworkView.isSupervisor()) {
                    try {
                        query = (BQuery)query.get("standaloneStationsQuery");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                sb.append(query.getNavOrd().toString());
                sb.append("|view:").append(BWbQueryConfig.TYPE.toString());
                this.redirect(op, op.toUri(BOrd.make((String)sb.toString())));
            } else {
                super.handle(op);
            }
        }
    }
}

