/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.discover.nd;

import com.tridium.authn.AuthenticationClient;
import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BRoleManager;
import com.tridiumx.entsecHx.securityUtilHx.HxLocalizableExceptionTranslator;
import com.tridiumx.entsecHx.securityUtilHx.discover.nd.BAddStationsJob;
import com.tridiumx.entsecHx.securityUtilHx.discover.nd.BRemoteConfigJob;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.nd.BStationRole;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BClientCredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BEditStationsJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BEditStationsJob.class);
    public boolean sslApprovalNeeded = false;
    public String remoteStation = null;
    public String certStationName = null;
    static Lexicon lex = Lexicon.make(BEditStationsJob.class);
    BNiagaraNetwork network;
    BNiagaraStation[] stations;
    BBoolean stationEnabled;
    BString stationUser;
    BPassword stationPassword;
    BBoolean useFoxs;
    BInteger stationPort;
    BString remoteUser;
    BPassword remotePassword;
    BBoolean remoteUseFoxs;
    BInteger remoteStationPort;
    BBoolean remoteStationEnabled;
    BStationRole stationRole;
    BClientCredentials stationUserCred;
    BClientCredentials remoteUserCred;
    String interest;
    Context context;

    public Type getType() {
        return TYPE;
    }

    public BEditStationsJob(BNiagaraNetwork network, BNiagaraStation[] stations, BBoolean stationEnabled, BString stationUser, BPassword stationPassword, BBoolean useFoxs, BInteger stationPort, BBoolean remoteStationEnabled, BString remoteUser, BPassword remotePassword, BBoolean remoteUseFoxs, BInteger remoteStationPort, BStationRole stationRole, Context context) {
        this.network = network;
        this.stations = stations;
        this.stationEnabled = stationEnabled;
        this.stationUser = stationUser;
        this.stationPassword = stationPassword;
        this.useFoxs = useFoxs;
        this.stationPort = stationPort;
        this.remoteUser = remoteUser;
        this.remotePassword = remotePassword;
        this.remoteUseFoxs = remoteUseFoxs;
        this.remoteStationPort = remoteStationPort;
        this.remoteStationEnabled = remoteStationEnabled;
        this.stationRole = stationRole;
        this.interest = "SecurityBatchEditStations" + System.identityHashCode((Object)this);
        this.context = context;
    }

    public BEditStationsJob(BNiagaraNetwork network, BNiagaraStation[] stations, BBoolean stationEnabled, BClientCredentials stationUserCred, BBoolean useFoxs, BInteger stationPort, BBoolean remoteStationEnabled, BClientCredentials remoteUserCred, BBoolean remoteUseFoxs, BInteger remoteStationPort, BStationRole stationRole, Context context) {
        this.network = network;
        this.stations = stations;
        this.stationEnabled = stationEnabled;
        this.stationUserCred = stationUserCred;
        this.useFoxs = useFoxs;
        this.stationPort = stationPort;
        this.remoteUserCred = remoteUserCred;
        this.remoteUseFoxs = remoteUseFoxs;
        this.remoteStationPort = remoteStationPort;
        this.remoteStationEnabled = remoteStationEnabled;
        this.stationRole = stationRole;
        this.interest = "SecurityBatchEditStations" + System.identityHashCode((Object)this);
        this.context = context;
    }

    public BEditStationsJob() {
    }

    public boolean isCertApprovalNeeded() {
        return this.sslApprovalNeeded;
    }

    public String getRemoteStation() {
        return this.remoteStation;
    }

    public String getCertStationName() {
        return this.certStationName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) throws Exception {
        if (this.network == null) {
            throw new BajaRuntimeException(lex.getText("stationView.error.noNetwork"));
        }
        int len = this.stations != null ? this.stations.length : 0;
        this.log().start("Batch editing " + len + " stations...");
        if (len > 0) {
            BAddStationsJob.Counter counter = new BAddStationsJob.Counter(len);
            EditStationWork[] workers = new EditStationWork[len];
            for (int i = 0; i < len; ++i) {
                workers[i] = new EditStationWork(this, this.stations[i], counter, this.context);
                this.stations[i].postAsync((Runnable)workers[i]);
            }
            BAddStationsJob.Counter i = counter;
            synchronized (i) {
                while (counter.count > 0) {
                    counter.wait(60000L);
                }
            }
            for (int i2 = 0; i2 < len; ++i2) {
                if (workers[i2].e == null) continue;
                throw workers[i2].e;
            }
        }
        this.progress(100);
    }

    static class EditStationWork
    implements Runnable {
        BEditStationsJob job;
        BAddStationsJob.Counter counter;
        BNiagaraStation station;
        Context cx;
        Exception e = null;

        EditStationWork(BEditStationsJob job, BNiagaraStation station, BAddStationsJob.Counter counter, Context cx) {
            this.job = job;
            this.station = station;
            this.counter = counter;
            this.cx = cx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String stationName = null;
            try {
                this.job.remoteStation = this.station.getStationName();
                stationName = this.station.getStationName();
                this.job.log().message("Editing station '" + stationName + "'...");
                if (this.job.stationEnabled != null && this.station.getEnabled() != this.job.stationEnabled.getBoolean()) {
                    this.station.set(BNiagaraStation.enabled, (BValue)this.job.stationEnabled, this.cx);
                }
                if (this.job.stationUserCred != null && !this.station.getClientConnection().getCredentialStore().equals((Object)this.job.stationUserCred)) {
                    this.station.getClientConnection().set(BFoxClientConnection.credentialStore, (BValue)this.job.stationUserCred, this.cx);
                }
                if (this.job.useFoxs != null && this.station.getClientConnection().getUseFoxs() != this.job.useFoxs.getBoolean()) {
                    this.station.getClientConnection().set(BFoxClientConnection.useFoxs, (BValue)this.job.useFoxs, this.cx);
                }
                if (this.job.stationPassword != null && this.station.getClientConnection().getPort() != this.job.stationPort.getInt()) {
                    this.station.getClientConnection().set(BFoxClientConnection.port, (BValue)this.job.stationPort, this.cx);
                }
                this.station.doPing();
                if (this.job.remoteStationEnabled == null && this.job.remoteUser == null && this.job.remotePassword == null && this.job.stationRole == null) {
                    return;
                }
                if (this.station.isDisabled()) {
                    String msg = lex.getText("stationView.error.disableFailure", new Object[]{stationName});
                    this.job.log().failed(msg);
                    this.e = new BajaRuntimeException(msg);
                    return;
                }
                BAddStationsJob.Counter remoteSession = null;
                try {
                    BIpHost host = (BIpHost)this.station.getRemoteHost();
                    BUsernameAndPassword credentials = (BUsernameAndPassword)this.station.getClientConnection().getCredentialStore().getCredentials();
                    remoteSession = BFoxSession.make((String)stationName, (BHost)host, (int)this.station.getFoxPort(), (boolean)this.station.getClientConnection().getUseFoxs());
                    remoteSession.getConnection().setCredentials((BIUserCredentials)credentials);
                    remoteSession.getConnection().setPort(this.station.getFoxPort());
                    remoteSession.getConnection().setUseFoxs(this.station.getClientConnection().getUseFoxs());
                    remoteSession.getConnection().setAuthenticationClient((AuthenticationClient)this.station.getClientConnection());
                    remoteSession.getConnection().setCheckBrandCompatibility(false);
                    remoteSession.engageNoRetry(this.job.interest);
                    BNiagaraNetwork remoteNetwork = (BNiagaraNetwork)remoteSession.getService(BNiagaraNetwork.TYPE);
                    BNiagaraStation remoteStation = BRemoteConfigJob.findStation((BComponent)remoteNetwork, Sys.getStation().getStationName(), remoteSession.getConnection().session().isLegacyConnection());
                    remoteStation.lease();
                    if (this.job.remoteStationEnabled != null) {
                        remoteStation.setEnabled(this.job.remoteStationEnabled.getBoolean());
                    }
                    remoteStation.getClientConnection().lease();
                    BUsernameAndPassword remoteStationCredentials = (BUsernameAndPassword)remoteStation.getClientConnection().getCredentialStore().getCredentials();
                    BUsernameAndPassword remoteJobCredentials = (BUsernameAndPassword)this.job.remoteUserCred.getCredentials();
                    if (this.job.remoteUserCred != null) {
                        remoteStation.getClientConnection().setCredentialStore(this.job.remoteUserCred);
                        remoteStation.getClientConnection().setCredentials(this.job.remoteUserCred.getCredentials());
                    }
                    if (this.job.stationPort != null) {
                        remoteStation.getClientConnection().setPort(this.job.stationPort.getInt());
                    }
                    if (this.job.useFoxs != null) {
                        remoteStation.getClientConnection().setUseFoxs(this.job.useFoxs.getBoolean());
                    }
                    if (remoteStation.getEnabled()) {
                        // empty if block
                    }
                    Object roleEx = null;
                    if (this.job.stationRole != null) {
                        roleEx = this.job.stationRole.equals((Object)BStationRole.supervisor) ? new BajaRuntimeException(lex.getText("stationView.misConfig.duplicateSup")) : BRemoteConfigJob.checkRoleAssignment((BFoxSession)remoteSession, this.job.stationRole, stationName, this.station);
                        if (roleEx == null) {
                            this.station.getSysDef().getRoleManager().set(BRoleManager.desiredRole, (BValue)this.job.stationRole, this.cx);
                            this.station.getSysDef().getRoleManager().doExecute();
                        } else {
                            this.e = roleEx;
                        }
                    }
                }
                catch (Exception ex) {
                    this.displayFailureMessage(ex, "stationView.error.connectFailure", stationName);
                }
                finally {
                    if (remoteSession != null) {
                        remoteSession.disengage(this.job.interest);
                    }
                }
            }
            catch (Exception ex) {
                this.displayFailureMessage(ex, "stationView.error.connectFailure", stationName);
            }
            finally {
                BAddStationsJob.Counter counter = this.counter;
                synchronized (counter) {
                    --this.counter.count;
                    if (this.counter.count < 1) {
                        this.counter.notifyAll();
                    } else {
                        this.job.progress((int)((float)(this.counter.length - this.counter.count) / (float)this.counter.length * 100.0f));
                    }
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void displayFailureMessage(Exception ex, String failureMsg, String stationName) {
            if (ex instanceof FoxAuthenticationException || ex instanceof AuthenticationException) {
                this.job.log().failed(lex.getText("stationView.error.authentication", new Object[]{stationName}));
                this.e = HxLocalizableExceptionTranslator.localize(ex);
                return;
            }
            if (ex instanceof ConnectException) {
                this.job.log().failed(lex.getText("stationView.error.port", new Object[]{stationName}));
                this.e = HxLocalizableExceptionTranslator.localize(ex);
                return;
            }
            if (ex instanceof UnknownHostException) {
                this.job.log().failed(lex.getText("stationView.error.HostName", new Object[]{stationName}));
                this.e = HxLocalizableExceptionTranslator.localize(new UnknownHostException("UnknownHostException: Invalid HostName. "));
                return;
            }
            if (ex instanceof IOException) {
                if (ex.getClass().getName().equals("javax.net.ssl.SSLHandshakeException") || ex.getClass().getName().equals("javax.net.ssl.SSLException") || ex.getClass().getName().equals("org.bouncycastle.tls.TlsFatalAlert")) {
                    this.job.sslApprovalNeeded = true;
                    this.job.certStationName = stationName;
                    this.job.log().failed(lex.getText("stationView.error.certificate", new Object[]{stationName}));
                    this.e = HxLocalizableExceptionTranslator.localize(new IOException("SSLHandshakeException: Failed certificate validation "));
                    return;
                }
                if (ex.getMessage().equals("Expected 'f', got '0x15'")) {
                    this.job.log().failed(lex.getText("stationView.error.foxs", new Object[]{stationName}));
                    this.e = HxLocalizableExceptionTranslator.localize(new IOException("Exception: fox/foxs connection failed.. "));
                    return;
                }
                this.job.log().failed(lex.getText(failureMsg));
                this.e = HxLocalizableExceptionTranslator.localize(ex);
                return;
            }
            if (ex instanceof ActionInvokeException) {
                Throwable tExcep = ex.getCause();
                if (tExcep != null) {
                    if (tExcep.getMessage().indexOf("SSLHandshakeException") > -1) {
                        this.job.sslApprovalNeeded = true;
                        this.job.certStationName = stationName;
                        this.job.log().failed(lex.getText("stationView.error.certificate", new Object[]{stationName}));
                        this.e = HxLocalizableExceptionTranslator.localize(new IOException("SSLHandshakeException: Failed certificate validation "));
                        return;
                    }
                    if (tExcep.getMessage().indexOf("FoxAuthenticationException") > -1) {
                        this.job.log().failed(lex.getText("stationView.error.authentication", new Object[]{stationName}));
                        this.e = HxLocalizableExceptionTranslator.localize((Exception)new FoxAuthenticationException("Authentication failed", null));
                        return;
                    }
                    if (tExcep.getMessage().indexOf("Expected 'f', got '0x15'") > -1) {
                        this.job.log().failed(lex.getText("stationView.error.foxs", new Object[]{stationName}));
                        this.e = HxLocalizableExceptionTranslator.localize(new IOException("Exception: fox/foxs connection failed.. "));
                        return;
                    }
                    if (tExcep.getMessage().indexOf("java.net.ConnectException") <= -1) return;
                    this.job.log().failed(lex.getText("stationView.error.port", new Object[]{stationName}));
                    this.e = HxLocalizableExceptionTranslator.localize(new IOException("Exception: Invalid Port "));
                    return;
                }
                this.job.log().failed("Failure during remote configuration of station " + stationName, (Throwable)ex);
                this.e = HxLocalizableExceptionTranslator.localize(ex);
                return;
            }
            this.job.log().failed("Failure during remote configuration of station " + stationName, (Throwable)ex);
            this.e = HxLocalizableExceptionTranslator.localize((Exception)new BajaRuntimeException("Failed"));
        }
    }
}

