/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.alarm;

import com.tridium.alarm.ui.BAlarmClassDef;
import com.tridium.alarm.ui.BAlarmClassMapping;
import com.tridium.alarm.ui.BAlarmConsole;
import com.tridium.alarm.ui.BAlarmDetailsDialog;
import com.tridium.alarm.ui.BTimeZoneDisplay;
import com.tridium.alarm.ui.ConsoleTableModel;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.ui.theme.Theme;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.orionTools.ui.BOrionSummary;
import com.tridiumx.entsec.photoID.orion.BPersonPortrait;
import com.tridiumx.entsecHx.securityUtilHx.alarm.BSecurityAlarmConsole;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.TextRenderer;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;

@NiagaraType
public class BSecAlarmDetailsDialog
extends BAlarmDetailsDialog {
    public static final Type TYPE = Sys.loadType(BSecAlarmDetailsDialog.class);
    BAlarmConsole console;
    BGridPane alarmPane = new BGridPane(2);
    protected BAlarmRecord alarm;
    Command ackCmd;
    Command closeCmd;
    Command hyperlinkCmd;
    Command notesCmd;
    Command showVideoCmd;
    public static final BFacets TIME_FACETS = BFacets.make((String)"showSeconds", (boolean)true);
    public static final UiLexicon lex = UiLexicon.makeUiLexicon(BSecAlarmDetailsDialog.class);

    public Type getType() {
        return TYPE;
    }

    public BSecAlarmDetailsDialog(BAlarmConsole console, BAlarmRecord alarm) {
        super(console, console.options.getTimeZoneDisplay(), alarm, (ConsoleTableModel)((DynamicTableModel)console.getExportTable().getModel()).getRootModel());
        BOrd videoCameraOrd;
        String alarmSourceExtCamera;
        this.console = console;
        this.alarm = alarm;
        this.hyperlinkCmd = new HyperlinkCommand((BWidget)this);
        BButton urlBtn = new BButton(this.hyperlinkCmd, true, true);
        this.ackCmd = new AckCommand((BWidget)this);
        BButton ackBtn = new BButton(this.ackCmd, true, true);
        this.notesCmd = new NotesCommand((BWidget)this);
        BButton notesBtn = new BButton(this.notesCmd, true, true);
        this.showVideoCmd = new ShowVideoCommand((BWidget)this);
        BButton showVideoBtn = new BButton(this.showVideoCmd, true, true);
        this.closeCmd = new CloseCommand((BWidget)this);
        BButton closeBtn = new BButton(this.closeCmd, true, true);
        this.createAlarmPane();
        BGridPane toolBar = new BGridPane();
        toolBar.setColumnAlign(BHalign.fill);
        toolBar.setUniformColumnWidth(true);
        BAlarmClass alarmClass = console.getAlarmService().lookupAlarmClass(alarm.getAlarmClass());
        if (alarmClass.getPermissions(console.getCurrentContext()).hasAdminWrite()) {
            toolBar.add("ack", (BValue)ackBtn);
        }
        toolBar.add("url", (BValue)urlBtn);
        toolBar.add("notes", (BValue)notesBtn);
        if (BSecurityAlarmConsole.isVideoDriverAvailable() && (alarmSourceExtCamera = alarm.getAlarmData().gets("cameraOrd", null)) != null && !(videoCameraOrd = BOrd.make((String)alarmSourceExtCamera)).equals((Object)BOrd.NULL)) {
            toolBar.add("showVideo", (BValue)showVideoBtn);
        }
        toolBar.add("close", (BValue)closeBtn);
        toolBar.setColumnCount(toolBar.getChildWidgets().length);
        BEdgePane pane = new BEdgePane();
        pane.setCenter((BWidget)new BBorderPane((BWidget)this.alarmPane));
        pane.setBottom((BWidget)new BBorderPane((BWidget)toolBar));
        this.setContent((BWidget)pane);
    }

    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createAlarmPane() {
        Property[] props = this.alarm.loadSlots().getPropertiesArray();
        int rows = props.length;
        this.alarmPane.removeAll();
        this.alarmPane.setColorRows(true);
        this.alarmPane.setRowAlign(BValign.top);
        this.alarmPane.setColumnGap(9.0);
        for (int i = 0; i < rows; ++i) {
            if (Flags.isHidden((BComplex)this.alarm, (Slot)props[i])) continue;
            BLabel label = new BLabel(this.alarm.getDisplayName((Slot)props[i], this.console.getCurrentContext()), BHalign.left);
            label.setFont(Theme.label().getBoldText());
            this.alarmPane.add(null, (BValue)label, null);
            if (props[i].getName().equals("alarmData")) {
                BFacets alarmData = (BFacets)this.alarm.get(props[i]);
                BGridPane dataPane = new BGridPane(2);
                dataPane.setHalign(BHalign.fill);
                dataPane.setColumnGap(5.0);
                dataPane.setRowAlign(BValign.top);
                Object[] keys = alarmData.list();
                SortUtil.sort((Object[])keys, (Object[])keys, (Comparator)new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareToIgnoreCase(o2);
                    }
                });
                for (int k = 0; k < keys.length; ++k) {
                    String value;
                    BLabel facetLabel = new BLabel(lex.get("alarmData." + (String)keys[k], (String)keys[k]), BHalign.left);
                    facetLabel.setFont(Theme.label().getBoldText());
                    dataPane.add(null, (BValue)facetLabel, null);
                    if (((String)keys[k]).equals("notes")) {
                        Command cmd = new Command((BWidget)this, "", BImage.make((BIcon)BIcon.std((String)"doubleArrowRight.png")), null, ""){

                            public CommandArtifact doInvoke() {
                                try {
                                    BSecAlarmDetailsDialog.this.notesCmd.doInvoke();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return null;
                            }
                        };
                        BToolBar toolBar = new BToolBar();
                        toolBar.add("eb", (BValue)new BButton(cmd, false, true));
                        dataPane.add(null, (BValue)toolBar, null);
                        continue;
                    }
                    if (((String)keys[k]).equals(BPersonPortrait.person.getName())) {
                        final Lexicon localLex = Lexicon.make(BSecAlarmDetailsDialog.class);
                        String value2 = alarmData.getFacet((String)keys[k]).toString();
                        try {
                            BUuid uuid = (BUuid)BUuid.DEFAULT.decodeFromString(value2);
                            BFoxSession session = (BFoxSession)this.console.getCurrentValueSession();
                            BAccessControlService service = (BAccessControlService)session.getService(BAccessControlService.TYPE);
                            service.lease();
                            OrionSession orionSession = null;
                            try {
                                orionSession = service.createSession(this.console.getCurrentContext());
                                final BPerson person = (BPerson)orionSession.read(BPerson.ORION_TYPE, (BSimple)uuid);
                                if (person != null) {
                                    Command cmd = new Command((BWidget)this, person.toDisplayString(this.console.getCurrentContext()), BImage.make((BIcon)person.getIcon()), null, person.toDisplayString(this.console.getCurrentContext())){

                                        public CommandArtifact doInvoke() {
                                            BOrionSummary orionSummary = new BOrionSummary();
                                            orionSummary.setReadonly(true);
                                            orionSummary.loadValue((BObject)person, BSecAlarmDetailsDialog.this.console.getCurrentContext());
                                            BDialog.open((BWidget)BSecAlarmDetailsDialog.this, (String)localLex.getText("summary"), (Object)orionSummary, (int)1);
                                            return null;
                                        }
                                    };
                                    BToolBar toolBar = new BToolBar();
                                    toolBar.add("person", (BValue)new BButton(cmd, true, true));
                                    dataPane.add(null, (BValue)toolBar, null);
                                    continue;
                                }
                                if (uuid.isNull()) {
                                    value2 = localLex.getText("none");
                                } else {
                                    BRef ref = BRef.make((BTypeSpec)BPerson.ORION_TYPE.getTypeSpec(), (BSimple)uuid);
                                    value2 = localLex.getText("unavailablRef", new Object[]{ref});
                                }
                                BTextEditor editor = new BTextEditor(value2, false);
                                dataPane.add(null, (BValue)editor);
                            }
                            finally {
                                if (orionSession != null) {
                                    orionSession.close();
                                    orionSession = null;
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            BTextEditor editor = new BTextEditor(value2, false);
                            editor.setRenderer(new TextRenderer(){

                                public BBrush getBackground() {
                                    return BBrush.NULL;
                                }
                            });
                            dataPane.add(null, (BValue)editor);
                        }
                        continue;
                    }
                    if (((String)keys[k]).equals("msgText")) {
                        BFormat text = BFormat.make((String)alarmData.getFacet((String)keys[k]).toString());
                        value = text.format((Object)this.alarm, this.console.getCurrentContext());
                    } else {
                        value = ((String)keys[k]).equals("instructions") ? BFormat.make((String)alarmData.getFacet((String)keys[k]).toString()).format((Object)this, this.console.getCurrentContext()) : alarmData.getFacet((String)keys[k]).toString();
                    }
                    BTextEditor editor = new BTextEditor(value, false);
                    editor.setRenderer(new TextRenderer(){

                        public BBrush getBackground() {
                            return BBrush.NULL;
                        }
                    });
                    dataPane.add(null, (BValue)editor);
                }
                this.alarmPane.add(null, (BValue)dataPane, null);
                continue;
            }
            if (props[i].getType().is(BOrdList.TYPE)) {
                try {
                    BOrdList src = (BOrdList)this.alarm.get(props[i]);
                    StringBuffer source = new StringBuffer();
                    for (int k = src.size() - 1; k >= 0; --k) {
                        source.append(SlotPath.unescape((String)src.get(k).encodeToString()).toString());
                        if (k - 1 < 0) continue;
                        source.append("\n");
                    }
                    BTextEditor textEditor = new BTextEditor(source.toString(), false);
                    textEditor.setRenderer(new TextRenderer(){

                        public BBrush getBackground() {
                            return BBrush.NULL;
                        }
                    });
                    this.alarmPane.add(null, (BValue)textEditor, null);
                }
                catch (Exception e) {
                    this.alarmPane.add(null, (BValue)new BLabel("unknown"), null);
                }
                continue;
            }
            if (props[i].getType().is(BAbsTime.TYPE)) {
                BAbsTime ts = this.alarm.getTimestamp();
                String value = "";
                value = this.console.options.getTimeZoneDisplay() == BTimeZoneDisplay.source ? ts.toString((Context)BFacets.make((BFacets)this.alarm.getAlarmData(), (BFacets)TIME_FACETS)) : ts.toString((Context)BFacets.make((BFacets)TIME_FACETS, (String)"TimeZone", (BIDataValue)BTimeZone.getLocal()));
                BTextEditor editor = new BTextEditor(value, false);
                editor.setRenderer(new TextRenderer(){

                    public BBrush getBackground() {
                        return BBrush.NULL;
                    }
                });
                this.alarmPane.add(null, (BValue)editor);
                continue;
            }
            String value = SlotPath.unescape((String)this.alarm.get(props[i].getName()).toString());
            BTextEditor editor = new BTextEditor(value, false);
            editor.setRenderer(new TextRenderer(){

                public BBrush getBackground() {
                    return BBrush.NULL;
                }
            });
            this.alarmPane.add(null, (BValue)editor);
        }
        BString str = (BString)this.alarm.getAlarmData().get("hyperlinkOrd");
        BOrd hyperlink = BOrd.NULL;
        if (str != null) {
            hyperlink = BOrd.make((String)str.toString());
        }
        if (hyperlink == null || hyperlink.isNull()) {
            BAlarmClassMapping mapping = this.console.options.getAlarmClassMapping();
            BAlarmClassDef acDef = mapping.getAlarmClassDefFor(this.alarm.getAlarmClass());
            hyperlink = acDef.getAlarmUrl();
        }
        if (hyperlink != null && !hyperlink.isNull()) {
            this.hyperlinkCmd.setEnabled(true);
        } else {
            this.hyperlinkCmd.setEnabled(false);
        }
    }

    protected void alarmCleared() {
        this.notesCmd.setEnabled(false);
        this.ackCmd.setEnabled(false);
        this.hyperlinkCmd.setEnabled(false);
    }

    private class ShowVideoCommand
    extends Command {
        public ShowVideoCommand(BWidget owner) {
            super(owner, (Lexicon)BAlarmConsole.lexicon, "commands.showVideo");
        }

        public CommandArtifact doInvoke() {
            block8: {
                try {
                    Class videoAlmConsoleExt = Sys.loadClass((String)"videoDriver", (String)"com.tridium.videoDriver.ui.alarm.AlarmConsoleExt");
                    if (videoAlmConsoleExt != null) {
                        Method doShowVideoMethod = videoAlmConsoleExt.getMethod("doShowVideo", BAlarmConsole.class, BAlarmRecord.class);
                        if (doShowVideoMethod != null) {
                            doShowVideoMethod.invoke((Object)videoAlmConsoleExt, BSecAlarmDetailsDialog.this.console, BSecAlarmDetailsDialog.this.alarm);
                        } else {
                            System.out.println("The 'doShowVideo' method was not found on class AlarmConsoleExt in videoDriver.jar. Please have my program fixed");
                        }
                        break block8;
                    }
                    throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound");
                }
                catch (ClassNotFoundException cnfe) {
                    throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound", (Throwable)cnfe);
                }
                catch (NoSuchMethodException nsme) {
                    throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound", (Throwable)nsme);
                }
                catch (InvocationTargetException ite) {
                    throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound", (Throwable)ite);
                }
                catch (IllegalAccessException iae) {
                    throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound", (Throwable)iae);
                }
            }
            return null;
        }
    }

    private class CloseCommand
    extends Command {
        public CloseCommand(BWidget owner) {
            super(owner, (Lexicon)UiLexicon.bajaui(), "commands.close");
        }

        public CommandArtifact doInvoke() {
            BSecAlarmDetailsDialog.this.close();
            return null;
        }
    }

    private class HyperlinkCommand
    extends Command {
        public HyperlinkCommand(BWidget owner) {
            super(owner, (Lexicon)BAlarmConsole.lexicon, "commands.hyperlink");
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    private class NotesCommand
    extends Command {
        public NotesCommand(BWidget owner) {
            super(owner, (Lexicon)BAlarmConsole.lexicon, "commands.notes");
        }

        public CommandArtifact doInvoke() {
            BSecAlarmDetailsDialog.this.console.showNotes((BWidget)BSecAlarmDetailsDialog.this.alarmPane, new BAlarmRecord[]{BSecAlarmDetailsDialog.this.alarm});
            return null;
        }
    }

    private class AckCommand
    extends Command {
        public AckCommand(BWidget owner) {
            super(owner, (Lexicon)BAlarmConsole.lexicon, "commands.acknowledge");
        }

        public CommandArtifact doInvoke() {
            BSecAlarmDetailsDialog.this.console.acknowledgeAlarms(new BAlarmRecord[]{BSecAlarmDetailsDialog.this.alarm});
            return null;
        }
    }
}

