/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.alarm;

import com.tridium.alarm.ui.BAlarmDbView;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"alarm:RemoteStationFE"}, app="entsec", requiredPermissions="rR")})
@NiagaraSingleton
public class BHxRemoteStationFE
extends BHxFieldEditor {
    public static final BHxRemoteStationFE INSTANCE = new BHxRemoteStationFE();
    public static final Type TYPE = Sys.loadType(BHxRemoteStationFE.class);
    private static Lexicon lex = Lexicon.make(BAlarmDbView.class);

    public Type getType() {
        return TYPE;
    }

    protected BHxRemoteStationFE() {
    }

    public void write(HxOp op) throws Exception {
        BString b = (BString)op.get();
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)("<select name='" + op.scope("remoteStation") + "'"));
        if (!op.canWrite()) {
            out.w((Object)" disabled='disabled'");
        }
        out.w((Object)">");
        if (b == null || b.isNull() || b.toString().equals("")) {
            out.w((Object)"<option value='none'>").safe((Object)lex.getText("stationRecipient.selectStation")).w((Object)"</option>");
        }
        try {
            BComponent niagaraNetwork = Sys.getService((Type)BNiagaraNetwork.TYPE);
            this.loadStations(niagaraNetwork, b, op);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        out.w((Object)"</select>");
    }

    private void loadStations(BComponent comp, BString b, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        comp.lease();
        BComponent[] c = comp.getChildComponents();
        for (int i = 0; i < c.length; ++i) {
            BComponent nc = c[i];
            if (nc instanceof NiagaraStation && this.accept((NiagaraStation)((BNiagaraStation)nc), op)) {
                out.w((Object)("<option value='" + nc.getName() + "'"));
                if (b.toString().equals(nc.getName())) {
                    out.w((Object)" selected='selected'");
                }
                out.w((Object)">").safe((Object)nc.getDisplayName((Context)op)).w((Object)"</option>");
                continue;
            }
            if (!(nc instanceof BFolder)) continue;
            this.loadStations(nc, b, op);
        }
    }

    protected boolean accept(NiagaraStation station, HxOp op) {
        return true;
    }

    public BObject save(HxOp op) throws Exception {
        BString b = (BString)op.get();
        String val = op.getFormValue("remoteStation");
        if (val.equals("none")) {
            return BString.make((String)"");
        }
        return BString.make((String)val);
    }
}

