/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.securityUtilHx.alarm;

import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.securityUtil.ui.link.BLinkTemplate;
import com.tridiumx.entsecHx.securityUtilHx.alarm.BHxAlarmRecipientKnobFE;
import com.tridiumx.entsecHx.securityUtilHx.fieldeditors.BHxAlarmClassRelaysFE;
import com.tridiumx.entsecHx.securityUtilHx.link.BHxKnobFE;
import com.tridiumx.entsecHx.securityUtilHx.manager.BHxManageDevicesView;
import com.tridiumx.entsecHx.securityUtilHx.query.TableCommand;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.hx.BHxView;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"alarm:AlarmClass"}, app="entsec", requiredPermissions="rR")})
@NiagaraSingleton
public class BHxAlarmClassView
extends BHxManageDevicesView {
    static final Lexicon entsecHxLex = Lexicon.make(BHxAlarmClassView.class);
    public static final BHxAlarmClassView INSTANCE = new BHxAlarmClassView();
    public static final Type TYPE = Sys.loadType(BHxAlarmClassView.class);
    protected SmartCommand tableCommand = new TableCommand((BHxView)this);

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxAlarmClassView() {
        this.registerEvent((Event)this.tableCommand);
    }

    public void write(HxOp op) throws Exception {
        BAlarmClass alarmClass = (BAlarmClass)op.get();
        if (!alarmClass.isMounted()) {
            alarmClass.setAckRequired(BAlarmTransitionBits.make((int)11));
        }
        op.setDynamic();
        super.write(op);
    }

    @Override
    public BObject save(HxOp op) throws Exception {
        Tab validateTab = this.getTabs(op)[1];
        ((BHxAlarmRecipientKnobFE)validateTab.view).validate(validateTab.op);
        return super.save(op);
    }

    public boolean process(HxOp op) throws Exception {
        op.setDynamic();
        return super.process(op);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.save, this.tableCommand};
    }

    @Override
    public Tab[] getTabs(HxOp op) throws Exception {
        BAlarmClass ac = (BAlarmClass)op.get();
        BLinkTemplate linkTemplate = new BLinkTemplate(BAlarmRecipient.TYPE, (Slot)BAlarmClass.alarm, (Slot)BAlarmRecipient.routeAlarm);
        Tab alarmConsoles = new Tab((BHxView)BHxAlarmRecipientKnobFE.INSTANCE, entsecHxLex.getText("recipients"), op.make("recipients", (BObject)linkTemplate, null), op);
        Object[] defaultTabs = super.getTabs(op);
        Array a = new Array(defaultTabs);
        a.add((Object)alarmConsoles);
        if (ac.getEscalationLevel1Enabled()) {
            BLinkTemplate linkTemplate1 = new BLinkTemplate(BAlarmRecipient.TYPE, (Slot)BAlarmClass.escalatedAlarm1, (Slot)BAlarmRecipient.routeAlarm);
            Tab level1 = new Tab((BHxView)BHxKnobFE.INSTANCE, entsecHxLex.getText("escalationLevel", new Object[]{"1"}), op.make("level1", (BObject)linkTemplate1, null), op);
            a.add((Object)level1);
        }
        if (ac.getEscalationLevel2Enabled()) {
            BLinkTemplate linkTemplate2 = new BLinkTemplate(BAlarmRecipient.TYPE, (Slot)BAlarmClass.escalatedAlarm2, (Slot)BAlarmRecipient.routeAlarm);
            Tab level2 = new Tab((BHxView)BHxKnobFE.INSTANCE, entsecHxLex.getText("escalationLevel", new Object[]{"2"}), op.make("level2", (BObject)linkTemplate2, null), op);
            a.add((Object)level2);
        }
        if (ac.getEscalationLevel3Enabled()) {
            BLinkTemplate linkTemplate3 = new BLinkTemplate(BAlarmRecipient.TYPE, (Slot)BAlarmClass.escalatedAlarm3, (Slot)BAlarmRecipient.routeAlarm);
            Tab level3 = new Tab((BHxView)BHxKnobFE.INSTANCE, entsecHxLex.getText("escalationLevel", new Object[]{"3"}), op.make("level3", (BObject)linkTemplate3, null), op);
            a.add((Object)level3);
        }
        try {
            Sys.loadModule((String)"kitControl");
            BLinkTemplate relayLinkTemplate = new BLinkTemplate(BTypeSpec.make((String)"kitControl", (String)"AlarmCountToRelay").getResolvedType(), (Slot)BAlarmClass.inAlarmCount, ((BComponent)BTypeSpec.make((String)"kitControl", (String)"AlarmCountToRelay").getInstance()).getSlot("alarmCount"));
            Tab relayLinks = new Tab((BHxView)BHxAlarmClassRelaysFE.INSTANCE, entsecHxLex.getText("relayLinks"), op.make("relayLinks", (BObject)relayLinkTemplate, null), op);
            a.add((Object)relayLinks);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (Tab[])a.trim();
    }
}

