/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.photoID;

import com.tridium.hx.ErrorDialog;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.SaveCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.photoID.orion.BOrionImageFormat;
import com.tridiumx.entsec.photoID.orion.BPersonPortrait;
import com.tridiumx.entsecHx.orionToolsHx.BHxSmartRefFE;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"entsec:Person"}, app="entsec", requiredPermissions="rR")})
@NiagaraSingleton
public class BHxPortraitUploadView
extends BHxView {
    public static final Lexicon lex = Lexicon.make(BHxPortraitUploadView.class);
    public static final BHxPortraitUploadView INSTANCE = new BHxPortraitUploadView();
    public static final Type TYPE = Sys.loadType(BHxPortraitUploadView.class);
    protected static final Logger LOG = Logger.getLogger("photoID");
    private SmartCommand saveCommand = new Save(this);
    private SmartCommand tableCommand;
    private Command errorCommand;

    public Type getType() {
        return TYPE;
    }

    protected BHxPortraitUploadView() {
        this.registerEvent((Event)this.saveCommand);
        this.errorCommand = new ErrorCommand(this);
        this.registerEvent((Event)this.errorCommand);
    }

    public BRef getPersonRef(HxOp op) throws Exception {
        BPerson person = (BPerson)op.get();
        return BRef.make((BIOrionObject)person);
    }

    public void write(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        Object redirect = op.getRequest().getSession().getAttribute("redirect");
        if (redirect instanceof BOrd) {
            SmartCommand.redirect((String)op.toUri((BOrd)redirect), (HxOp)op);
            op.getRequest().getSession().removeAttribute("redirect");
        } else if (redirect instanceof Exception) {
            op.addOnload(this.errorCommand.getInvokeCode(op));
        }
        op.addStyleSheet(BOrd.make((String)"module://smartTableHx/rc/smartTable.css"));
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/smartTable.js"));
        op.setMultiPartForm();
        String name = "Image";
        String text = lex.getText("uploadPortriat.label", new Object[]{name});
        out.w((Object)"<div ");
        out.attr("class", "smartTable-setup-panel").w((Object)">");
        HxTabUtil.writeTitle((String)text, (HxOp)op);
        HxTabUtil.writeCommands((SmartCommand[])new SmartCommand[]{this.saveCommand}, (boolean)true, (HxOp)op);
        out.w((Object)"</div>");
        out.w((Object)"&nbsp;");
        out.w((Object)"<div ");
        out.attr("class", "smartTable-setup-panel").w((Object)">");
        out.w((Object)"<table>");
        out.w((Object)"<tr ");
        out.w((Object)"><td class='smartTable-setup-label'>");
        out.safe((Object)BPerson.TYPE.getDisplayName((Context)op));
        out.w((Object)"</td>");
        out.w((Object)"<td>");
        this.getPersonTab(op).write();
        out.w((Object)"</td></tr>");
        out.w((Object)"<tr ");
        out.w((Object)"><td class='smartTable-setup-label'>");
        out.safe((Object)lex.getText("file"));
        out.w((Object)"</td>");
        out.w((Object)"<td>");
        BHxPortraitUploadView.writeFileBrowser(op);
        out.w((Object)"</td></tr>");
        out.w((Object)"</table>");
        out.w((Object)"</div>");
    }

    public Tab getPersonTab(HxOp op) throws Exception {
        BRef personRef = this.getPersonRef(op);
        HxOp fieldOp = op.make(SlotPath.escape((String)BPerson.TYPE.getDisplayName((Context)op)), (BObject)personRef, null);
        fieldOp.setReadonly(true);
        return new Tab((BHxView)BHxSmartRefFE.INSTANCE, SlotPath.escape((String)BPerson.TYPE.getDisplayName((Context)op)), fieldOp);
    }

    public static void writeFileBrowser(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<input type='file'");
        out.w((Object)"id='fileName' name='fileName' size='40'");
        out.w((Object)"onchange='");
        SaveCommand.setModified((HxOp)op);
        out.w((Object)"var ext = this.value.toLowerCase();  ext = ext.substring(ext.length-3,ext.length);");
        out.w((Object)"if(ext != &quot;jpg&quot; && ext != &quot;png&quot;) {");
        out.w((Object)"alert(&quot;You selected a .&quot;+ext+&quot; file. ");
        out.w((Object)"Please select a .jpg or .png file instead.&quot;);");
        out.w((Object)"this.value=&quot;&quot;;}'");
        out.w((Object)"/>");
    }

    public boolean process(HxOp op) throws Exception {
        if (super.process(op)) {
            return true;
        }
        return this.getPersonTab(op).process();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BObject save(HxOp op) throws Exception {
        try {
            BIFile file = op.getFile("fileName");
            String filename = op.getFormValue("fileName");
            if (file == null) {
                throw new IllegalStateException("File Not Found");
            }
            int index = filename.lastIndexOf("\\");
            if (index != -1) {
                filename = filename.substring(index + 1, filename.length());
            }
            int dotIndex = filename.lastIndexOf(".");
            String ext = filename.substring(dotIndex + 1).toLowerCase();
            BPersonPortrait personPortrait = new BPersonPortrait();
            personPortrait.init(BPersonPortrait.person, (BValue)this.getPersonRef(op));
            personPortrait.setImage(BBlob.make((byte[])file.read()));
            personPortrait.setImageFormat(BOrionImageFormat.make((String)ext));
            BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
            BPerson person = null;
            OrionSession session = null;
            try {
                session = service.createSession((Context)op);
                session.persist((BIOrionObject)personPortrait);
                person = (BPerson)personPortrait.getPerson().getTarget(session);
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
            op.getRequest().getSession().setAttribute("redirect", person.getHandle());
            return op.get();
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "Failed to save Portrait", e);
            op.getRequest().getSession().setAttribute("redirect", (Object)e);
            return op.get();
        }
    }

    public static String getStackTrace(Exception ex) {
        StringWriter errors = new StringWriter();
        PrintWriter printWriter = new PrintWriter(errors);
        ex.printStackTrace(printWriter);
        printWriter.flush();
        return errors.toString();
    }

    public class ErrorCommand
    extends Command {
        public ErrorCommand(BHxView view) {
            super(view);
        }

        public void handle(HxOp op) throws Exception {
            Exception e = (Exception)op.getRequest().getSession().getAttribute("redirect");
            new ErrorDialog(lex.getText("HxPortraitUploadView.saveError"), lex.getText("HxPortraitUploadView.failedUploadPortrait"), BHxPortraitUploadView.getStackTrace(e)).open(op);
        }
    }

    public static class TableCommand
    extends SmartCommand {
        public TableCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "upTable";
        }

        public String getDisplayName(HxOp op) {
            BComponent c = (BComponent)op.get();
            return c.getDisplayName((Context)op);
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            BComponent c = (BComponent)op.get();
            this.redirect(op, op.toUri(BOrd.make((String)("station:|" + c.getSlotPath()))));
        }
    }

    public static class Save
    extends SaveCommand {
        public Save(BHxView view) {
            super(view);
        }

        public void onHandle(HxOp op) throws Exception {
            String filename = op.getFormValue("fileName");
            if (filename == null || filename.length() == 0) {
                throw new IllegalStateException("File Not Found");
            }
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"document.forms[0].submit();");
        }

        public boolean registerOnInputs() {
            return true;
        }
    }
}

