/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.photoID;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.OrionSession;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.photoID.BPhotoIDDevice;
import com.tridiumx.entsec.photoID.BPhotoIDNetwork;
import com.tridiumx.entsec.photoID.orion.BBadgeTemplate;
import com.tridiumx.entsecHx.photoID.BHxPortraitUploadView;
import com.tridiumx.entsecHx.photoID.CaptureWizard;
import com.tridiumx.entsecHx.photoID.CropWizard;
import java.security.AccessController;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraSingleton
public class BHxPortraitFE
extends BHxFieldEditor {
    public static final BHxPortraitFE INSTANCE = new BHxPortraitFE();
    public static final Type TYPE = Sys.loadType(BHxPortraitFE.class);
    public static final Lexicon lex = Lexicon.make(BHxPortraitFE.class);
    public static final int PORTRAIT_HEIGHT = AccessController.doPrivileged(() -> (int)Integer.getInteger("entsec.portraitHeight", 250));
    public static BImage blank = BImage.make((String)"module://icons/x16/blank.png");
    public SmartCommand captureWizard;
    public SmartCommand cropWizard;
    protected SmartCommand upload = new Upload((BHxView)this);
    protected SmartCommand clearImage;

    public Type getType() {
        return TYPE;
    }

    protected BHxPortraitFE() {
        this.registerEvent((Event)this.upload);
        this.captureWizard = new CaptureWizard((BHxView)this);
        this.registerEvent((Event)this.captureWizard);
        this.clearImage = new ClearImage((BHxView)this);
        this.registerEvent((Event)this.clearImage);
        this.cropWizard = new CropWizard((BHxView)this);
        this.registerEvent((Event)this.cropWizard);
    }

    public String preview(HxOp op) throws Exception {
        BImage value = this.getImage(op);
        StringBuffer out = new StringBuffer();
        out.append("<img height='16'");
        if (value != null) {
            out.append("src='").append(value.toString()).append("' ");
        }
        out.append(" />");
        return out.toString();
    }

    public BImage getImage(HxOp op) {
        BOrd ord = (BOrd)op.get();
        return BImage.make((BOrd)ord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(HxOp op) throws Exception {
        boolean inUse;
        boolean isNull;
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/smartTable.js"));
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/save.js"));
        BImage value = this.getImage(op);
        HtmlWriter out = op.getHtmlWriter();
        BHxSmartTableView.writeFormValue((String)"image", (String)value.toString(), (HxOp)op);
        out.w((Object)"<img");
        this.scope("mainImage", out, op);
        value.sync();
        if (value.getHeight() > (double)PORTRAIT_HEIGHT) {
            out.attr("style", "height:" + PORTRAIT_HEIGHT + "px");
        }
        boolean bl = isNull = value == null || value.isNull() || value.toString().equals("null") || value.toString().equals("module://icons/x16/blank.png");
        if (!isNull) {
            out.w((Object)"src='").w((Object)value.toString()).w((Object)"' ");
        } else {
            out.w((Object)"src='module://icons/x16/blank.png' ");
        }
        out.w((Object)"/>&nbsp;&nbsp;");
        boolean bl2 = inUse = !isNull;
        if (op.canWrite()) {
            out.w((Object)"<span style=' cursor: pointer; vertical-align: top;'>");
            BPhotoIDNetwork network = (BPhotoIDNetwork)Sys.getService((Type)BPhotoIDNetwork.TYPE);
            if (((BPhotoIDDevice[])network.getChildren(BPhotoIDDevice.class)).length > 0) {
                HxTabUtil.writeImageCommand((SmartCommand)this.captureWizard, (HxOp)op);
            }
            BPerson person = (BPerson)CropWizard.getOrionObject(op);
            OrionSession session = null;
            try {
                session = person.getOrionDatabase().createSession((Context)op);
                if (session.exists((BIOrionObject)person)) {
                    HxTabUtil.writeImageCommand((SmartCommand)this.upload, (HxOp)op);
                }
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
            HxTabUtil.writeImageCommand((SmartCommand)this.cropWizard, (boolean)inUse, (HxOp)op);
            HxTabUtil.writeImageCommand((SmartCommand)this.clearImage, (boolean)inUse, (HxOp)op);
            out.w((Object)"</span>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTemplateData(HxOp op) {
        BBadgeTemplate badgeTemplate = (BBadgeTemplate)op.getRequest().getSession().getAttribute("saveBadgeTemplate");
        if (badgeTemplate == null) {
            return;
        }
        BPerson person = (BPerson)CropWizard.getOrionObject(op);
        BOrionDatabase db = person.getOrionDatabase();
        OrionSession session = null;
        try {
            session = db.createSession((Context)op);
            BBadgeTemplate dbTemplate = (BBadgeTemplate)session.read((BIOrionObject)badgeTemplate.newCopy());
            if (dbTemplate == null) {
                session.insert((BIOrionObject)badgeTemplate);
            } else {
                session.update((BIOrionObject)badgeTemplate);
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    public BObject save(HxOp op) throws Exception {
        this.saveTemplateData(op);
        String image = op.getFormValue("image");
        BOrd ord = BOrd.make((String)image);
        if (ord.toString().equals(blank.toString())) {
            return BOrd.NULL;
        }
        return ord;
    }

    public static String imageCachePreventor(String ord) {
        return ord + "|view:?time=" + BAbsTime.now().getMillis() + ".png";
    }

    public static void setMainImage(String imageOrd, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"save.modified();");
        out.w((Object)"if('").w((Object)imageOrd).w((Object)"'");
        out.w((Object)" == '").w((Object)blank.toString()).w((Object)"')");
        out.w((Object)"document.getElementById('").w((Object)op.scope("mainImage"));
        out.w((Object)"').style.visibility='hidden' ; ");
        out.w((Object)"else ");
        out.w((Object)"document.getElementById('").w((Object)op.scope("mainImage"));
        out.w((Object)"').style.visibility='visible' ; ");
        out.w((Object)"document.getElementById('").w((Object)op.scope("mainImage")).w((Object)"').setAttribute(");
        out.w((Object)"'src','ord?").w((Object)BHxPortraitFE.imageCachePreventor(imageOrd)).w((Object)"');");
        out.w((Object)"hx.setFormValue('").w((Object)op.scope("image")).w((Object)"','");
        out.w((Object)imageOrd).w((Object)"');");
        if (imageOrd.equals("null") || imageOrd.equals("module://icons/x16/blank.png")) {
            SmartCommand.hide((String)op.scope("cropWizard"), (HxOp)op);
            SmartCommand.hide((String)op.scope("clearImage"), (HxOp)op);
        } else {
            BImage image = BImage.make((String)imageOrd);
            image.sync();
            if (image.getHeight() > (double)PORTRAIT_HEIGHT) {
                double ratio = image.getWidth() / image.getHeight();
                out.w((Object)"$$('").w((Object)op.scope("mainImage")).w((Object)("').style.height='" + PORTRAIT_HEIGHT + "px';"));
                out.w((Object)"$$('").w((Object)op.scope("mainImage")).w((Object)("').style.width='" + (double)PORTRAIT_HEIGHT * ratio + "';"));
            } else {
                out.w((Object)"$$('").w((Object)op.scope("mainImage")).w((Object)("').style.height='" + image.getHeight() + "px';"));
                out.w((Object)"$$('").w((Object)op.scope("mainImage")).w((Object)("').style.width='" + image.getWidth() + "px';"));
            }
            SmartCommand.show((String)op.scope("clearImage"), (HxOp)op);
            SmartCommand.show((String)op.scope("cropWizard"), (HxOp)op);
        }
    }

    public BPhotoIDDevice[] getPhotoIDDevices(HxOp op) {
        BPhotoIDNetwork network = (BPhotoIDNetwork)Sys.getService((Type)BPhotoIDNetwork.TYPE);
        Array a = new Array(BPhotoIDDevice.class);
        a.addAll((Object[])((BPhotoIDDevice[])network.getDevices()));
        return (BPhotoIDDevice[])a.trim();
    }

    public HtmlWriter scope(String name, HtmlWriter out, HxOp op) {
        out.w((Object)" name='").w((Object)op.scope(name)).w((Object)"'");
        out.w((Object)" id='").w((Object)op.scope(name)).w((Object)"' ");
        return out;
    }

    public class ClearImage
    extends SmartCommand {
        public ClearImage(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "clearImage";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            BHxPortraitFE.setMainImage(blank.toString(), op);
        }
    }

    public class Upload
    extends SmartCommand {
        public Upload(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "uploadPortriat";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            BOrd ord = BOrd.make((String)(op.getOrdWithoutViewQuery() + "|view:" + BHxPortraitUploadView.TYPE));
            this.redirect(op, ord);
        }
    }
}

