/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.photoID;

import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridiumx.entsec.photoID.BIPhotoIDClientDevice;
import com.tridiumx.entsec.photoID.BPhotoIDDevice;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;

@NiagaraType(agent={@AgentOn(types={"entsec:IPhotoIDClientDevice"}, app="entsec", requiredPermissions="rR")})
@NiagaraSingleton
public class BHxPhotoIDWakeUpView
extends BHxView {
    public static final BHxPhotoIDWakeUpView INSTANCE = new BHxPhotoIDWakeUpView();
    public static final Type TYPE = Sys.loadType(BHxPhotoIDWakeUpView.class);
    private String quote = "'";
    private static final LexiconModule lex = LexiconModule.make((String)"entsecHx");
    private static final Logger log = Logger.getLogger("BHxPhotoIDWakeUpView");

    public Type getType() {
        return TYPE;
    }

    protected BHxPhotoIDWakeUpView() {
    }

    public static void wakeUp(BIPhotoIDClientDevice clientDevice, long timeInMillis, HxOp op) {
        try {
            BHxPhotoIDWakeUpView view = INSTANCE;
            op.setAttribute("timeInMillis", (Object)timeInMillis);
            if (clientDevice != null) {
                log.log(Level.FINE, "clientDevice wakeUp at " + timeInMillis + " seconds");
            }
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<div ");
            HxTabUtil.scope((String)"wakeUpClientDiv", (HtmlWriter)out, (HxOp)op);
            out.w((Object)">");
            view.write(op.make("wakeUpClientDiv", (BObject)((BValue)clientDevice), null));
            out.w((Object)"</div>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void wakeUp(BIPhotoIDClientDevice clientDevice, HxOp op) {
        try {
            BHxPhotoIDWakeUpView view = INSTANCE;
            op.setAttribute("timeInMillis", (Object)BLong.DEFAULT.getLong());
            if (clientDevice != null) {
                log.log(Level.FINE, "clientDevice wakeUp");
            }
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<div ");
            HxTabUtil.scope((String)"wakeUpClientDiv", (HtmlWriter)out, (HxOp)op);
            out.w((Object)">");
            view.write(op.make("wakeUpClientDiv", (BObject)((BValue)clientDevice), null));
            out.w((Object)"</div>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void write(HxOp op) throws Exception {
        BPhotoIDDevice device = (BPhotoIDDevice)op.get();
        long timeInMillis = (Long)op.getAttribute("timeInMillis");
        if (op.getAttribute("timeInMillis") != null) {
            log.log(Level.FINE, "write method called");
        }
        op.addStyleSheet(BOrd.make((String)"module://smartTableHx/rc/smartTable.css"));
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/smartTable.js"));
        String quote = HxUtil.getInnerQuote((HxOp)op);
        op.addJavaScript(BOrd.make((String)"module://entsecHx/rc/photoID/photoIdWakeUp.js"));
        String invokeCode = "photoIdWakeUp.wakeupPhotoId(" + device.get("entsecAsureIDPort") + ", " + timeInMillis + ", " + quote + lex.getHtmlSafeText("PhotoIdWakeUpView.wakeUp.invalid.response", (Context)op) + quote + ");";
        op.addOnload(invokeCode);
    }

    private String quote(String str) {
        return this.quote + str + this.quote;
    }

    public static class WakeUpDialog
    extends Dialog {
        private BIPhotoIDClientDevice clientDevice;

        public WakeUpDialog(String title, Command command) {
            super(title, command);
        }

        public void open(BIPhotoIDClientDevice clientDevice, HxOp op) throws Exception {
            this.clientDevice = clientDevice;
            this.open(op);
            this.clientDevice = null;
        }

        protected void writeContent(HxOp op) throws Exception {
            super.writeContent(op);
            BHxPhotoIDWakeUpView.wakeUp(this.clientDevice, op);
            op.getHtmlWriter().w((Object)"Waiting...");
        }

        public Command[] getCommands() {
            return new Command[]{new Dialog.Cancel((Dialog)this)};
        }
    }
}

