/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx.replicate;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.OrionSession;
import com.tridium.orion.sql.PropertyValue;
import com.tridiumx.entsec.intrusion.BIntrusionZone;
import com.tridiumx.entsec.intrusion.orion.BIntrusionZoneRec;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BObjectImportStatus;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BSysJoinJob;
import com.tridiumx.entsecHx.orionToolsHx.replicate.JoinAction;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SubordinateConnection;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinManifest;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinType;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.util.BUuid;

public class SysJoinTypeIntrusionZoneRec
extends SysJoinType {
    private static final String UUID = "uuid";

    public SysJoinTypeIntrusionZoneRec() {
        super(INTRUSIONZONE_TYPE);
    }

    @Override
    protected void match(OrionSession supSession, SubordinateConnection jaceConn, SysJoinManifest manifest) {
        for (int i = 0; i < this.actions.length; ++i) {
            JoinAction action = this.actions[i];
            BIntrusionZoneRec jaceRec = (BIntrusionZoneRec)action.getJaceObject();
            BUuid jaceUuid = (BUuid)this.getKey((BIOrionObject)jaceRec);
            this.setActionByJaceId((BSimple)jaceUuid, action);
            action.setStatus(BObjectImportStatus.newObject);
            BIntrusionZoneRec supervisorRec = (BIntrusionZoneRec)supSession.read(BIntrusionZoneRec.ORION_TYPE, (BSimple)jaceRec.getUuid());
            if (supervisorRec != null) {
                action.setMatch(supervisorRec);
                action.setStatus(BObjectImportStatus.matchedObject);
                continue;
            }
            supervisorRec = (BIntrusionZoneRec)supSession.read(BIntrusionZoneRec.ORION_TYPE, new PropertyValue(BIntrusionZoneRec.intrusionZoneName, (BValue)BString.make((String)jaceRec.getIntrusionZoneName())));
            if (supervisorRec == null) continue;
            action.setMatch(supervisorRec);
            action.setStatus(BObjectImportStatus.matchedObject);
            action.setWarningDescription(SysJoinTypeIntrusionZoneRec.getLexiconText("join.warning.matchingByNameOnly"));
        }
    }

    @Override
    public void join(OrionSession supSession, SubordinateConnection jaceConn, BSysJoinJob job, SysJoinManifest manifest) {
        for (int i = 0; i < this.actions.length; ++i) {
            BIOrionObject jaceObj = this.actions[i].getJaceObject();
            BIOrionObject clonedObj = this.copyObject(jaceObj);
            if (this.actions[i].getStatus().equals((Object)BObjectImportStatus.matchedObject)) {
                BIntrusionZoneRec subordinateRec = (BIntrusionZoneRec)jaceObj;
                BIntrusionZoneRec supervisorRec = (BIntrusionZoneRec)this.actions[i].getMatch();
                if (!supervisorRec.getUuid().equals((Object)subordinateRec.getUuid())) {
                    if (Logger.getLogger("entsec").isLoggable(Level.FINE)) {
                        job.log().message("Fixing Intrusion Zone uuid mismatch for " + supervisorRec.getIntrusionZoneName() + "; " + supervisorRec.getUuid() + " != " + subordinateRec);
                    }
                    try {
                        BFoxSession foxSession = jaceConn.getProxy();
                        BOrd mappedOrd = subordinateRec.getMappedOrd();
                        RemoteUtil.invokeRemote((String)subordinateRec.getStationName(), (BOrd)mappedOrd, (Action)BIntrusionZone.changeUuid, (BValue)supervisorRec.getUuid());
                        OrionSession subordinateSession = jaceConn.getSession();
                        int counter = 0;
                        while (!subordinateSession.exists((BIOrionObject)supervisorRec.newCopy())) {
                            Thread.sleep(100L);
                            if (++counter <= 100) continue;
                            throw new IllegalStateException("Intrusion Zone uuid cannot be changed:" + supervisorRec + "!=" + supervisorRec);
                        }
                        if (Log.getLog((String)"entsec").isTraceOn()) {
                            job.log().message("Fixing Intrusion Zone uuid mismatch for " + supervisorRec.getIntrusionZoneName() + "complete");
                        }
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new BajaRuntimeException("Fixing Intrusion Zone uuid mismatch problem:", (Throwable)e);
                    }
                }
            }
            supSession.persist(clonedObj);
        }
    }

    @Override
    public BSimple getKey(BIOrionObject obj) {
        return (BSimple)((BOrionObject)obj).get(UUID);
    }
}

