/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx.replicate;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.orionTools.replicate.BReplicableObject;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BObjectImportStatus;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BSysJoinJob;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BTypeImportStatus;
import com.tridiumx.entsecHx.orionToolsHx.replicate.JoinAction;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SubordinateConnection;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinManifest;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinTypeAccFloorJoin;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinTypeAccFloorRec;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinTypeAccReaderJoin;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinTypeAccReaderRec;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinTypeAccessRight;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinTypeBadge;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinTypeInfoTemplate;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinTypeIntrusionPin;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinTypeIntrusionPinJoin;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinTypeIntrusionZoneGroup;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinTypeIntrusionZoneRec;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinTypeKeypadFormat;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinTypeNiagaraIntegrationID;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinTypePerson;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinTypePersonAccJoin;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinTypePersonInfo;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinTypeSimple;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinTypeThreatLevel;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinTypeThreatLevelBadgeJoin;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinTypeThreatLevelGroupRec;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinTypeThreatLevelStationJoin;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinTypeWiegandFormat;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.baja.nre.util.Array;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

public abstract class SysJoinType {
    private static final String TENANT_ID = "tenantId";
    private static final String TENANT_MATCH = "tenantName";
    private static final String INFOTEMPLATE_ID = "infoTemplateId";
    private static final String INFOTEMPLATE_MATCH = "infoTemplateName";
    private static final String KEYPAD_ID = "keypadFormatId";
    private static final String KEYPAD_MATCH = "keypadFormatName";
    public static final BTypeSpec ACCREADER_SPEC = BTypeSpec.make((String)"entsec:AccReaderRec");
    public static final BTypeSpec ACCFLOOR_SPEC = BTypeSpec.make((String)"entsec:AccFloorRec");
    public static final BTypeSpec TENANT_SPEC = BTypeSpec.make((String)"entsec:Tenant");
    public static final BTypeSpec PERSONINFO_SPEC = BTypeSpec.make((String)"entsec:PersonInfo");
    public static final BTypeSpec INFOTEMPLATE_SPEC = BTypeSpec.make((String)"entsec:InfoTemplate");
    public static final BTypeSpec KEYPAD_SPEC = BTypeSpec.make((String)"entsec:KeypadFormat");
    public static final BTypeSpec WIEGAND_SPEC = BTypeSpec.make((String)"entsec:WiegandFormat");
    public static final BTypeSpec PERSON_SPEC = BTypeSpec.make((String)"entsec:Person");
    public static final BTypeSpec BADGE_SPEC = BTypeSpec.make((String)"entsec:Badge");
    public static final BTypeSpec NIAGARA_INT_SPEC = BTypeSpec.make((String)"entsec:NiagaraIntegrationID");
    public static final BTypeSpec ACCESSRIGHT_SPEC = BTypeSpec.make((String)"entsec:AccessRight");
    public static final BTypeSpec PERSONACCJOIN_SPEC = BTypeSpec.make((String)"entsec:PersonAccJoin");
    public static final BTypeSpec ACCREADERJOIN_SPEC = BTypeSpec.make((String)"entsec:AccReaderJoin");
    public static final BTypeSpec ACCFLOORJOIN_SPEC = BTypeSpec.make((String)"entsec:AccFloorJoin");
    public static final BTypeSpec INTRUSIONPIN_SPEC = BTypeSpec.make((String)"entsec:IntrusionPin");
    public static final BTypeSpec INTRUSIONPINJOIN_SPEC = BTypeSpec.make((String)"entsec:IntrusionPinJoin");
    public static final BTypeSpec INTRUSIONZONE_SPEC = BTypeSpec.make((String)"entsec:IntrusionZoneRec");
    public static final BTypeSpec INTRUSIONZONEGROUP_SPEC = BTypeSpec.make((String)"entsec:IntrusionZoneGroup");
    public static final BTypeSpec THREATLEVELGROUP_SPEC = BTypeSpec.make((String)"entsec:ThreatLevelGroupRec");
    public static final BTypeSpec THREATLEVELBADGEJOIN_SPEC = BTypeSpec.make((String)"entsec:ThreatLevelBadgeJoin");
    public static final BTypeSpec THREATLEVELSTATIONJOIN_SPEC = BTypeSpec.make((String)"entsec:ThreatLevelStationJoin");
    public static final BTypeSpec THREATLEVEL_SPEC = BTypeSpec.make((String)"entsec:ThreatLevel");
    public static final OrionType ACCREADER_TYPE = (OrionType)ACCREADER_SPEC.getResolvedType();
    public static final OrionType ACCFLOOR_TYPE = (OrionType)ACCFLOOR_SPEC.getResolvedType();
    public static final OrionType TENANT_TYPE = (OrionType)TENANT_SPEC.getResolvedType();
    public static final OrionType PERSONINFO_TYPE = (OrionType)PERSONINFO_SPEC.getResolvedType();
    public static final OrionType INFOTEMPLATE_TYPE = (OrionType)INFOTEMPLATE_SPEC.getResolvedType();
    public static final OrionType KEYPAD_TYPE = (OrionType)KEYPAD_SPEC.getResolvedType();
    public static final OrionType WIEGAND_TYPE = (OrionType)WIEGAND_SPEC.getResolvedType();
    public static final OrionType PERSON_TYPE = (OrionType)PERSON_SPEC.getResolvedType();
    public static final OrionType BADGE_TYPE = (OrionType)BADGE_SPEC.getResolvedType();
    public static final OrionType NIAGARA_INT_TYPE = (OrionType)NIAGARA_INT_SPEC.getResolvedType();
    public static final OrionType ACCESSRIGHT_TYPE = (OrionType)ACCESSRIGHT_SPEC.getResolvedType();
    public static final OrionType PERSONACCJOIN_TYPE = (OrionType)PERSONACCJOIN_SPEC.getResolvedType();
    public static final OrionType ACCREADERJOIN_TYPE = (OrionType)ACCREADERJOIN_SPEC.getResolvedType();
    public static final OrionType ACCFLOORJOIN_TYPE = (OrionType)ACCFLOORJOIN_SPEC.getResolvedType();
    public static final OrionType INTRUSIONPIN_TYPE = (OrionType)INTRUSIONPIN_SPEC.getResolvedType();
    public static final OrionType INTRUSIONPINJOIN_TYPE = (OrionType)INTRUSIONPINJOIN_SPEC.getResolvedType();
    public static final OrionType INTRUSIONZONE_TYPE = (OrionType)INTRUSIONZONE_SPEC.getResolvedType();
    public static final OrionType INTRUSIONZONEGROUP_TYPE = (OrionType)INTRUSIONZONEGROUP_SPEC.getResolvedType();
    public static final OrionType THREATLEVELGROUP_TYPE = (OrionType)THREATLEVELGROUP_SPEC.getResolvedType();
    public static final OrionType THREATLEVELBADGEJOIN_TYPE = (OrionType)THREATLEVELBADGEJOIN_SPEC.getResolvedType();
    public static final OrionType THREATLEVELSTATIONJOIN_TYPE = (OrionType)THREATLEVELSTATIONJOIN_SPEC.getResolvedType();
    public static final OrionType THREATLEVEL_TYPE = (OrionType)THREATLEVEL_SPEC.getResolvedType();
    public static final OrionType[] DISPLAYED_THREAT_TYPES = new OrionType[]{TENANT_TYPE, KEYPAD_TYPE, WIEGAND_TYPE, PERSON_TYPE, INFOTEMPLATE_TYPE, BADGE_TYPE, NIAGARA_INT_TYPE, ACCESSRIGHT_TYPE, INTRUSIONZONE_TYPE, INTRUSIONPIN_TYPE, ACCREADER_TYPE, ACCFLOOR_TYPE, THREATLEVELGROUP_TYPE, THREATLEVEL_TYPE};
    public static final OrionType[] DISPLAYED_NON_THREAT_TYPES = new OrionType[]{TENANT_TYPE, KEYPAD_TYPE, WIEGAND_TYPE, PERSON_TYPE, BADGE_TYPE, NIAGARA_INT_TYPE, ACCESSRIGHT_TYPE, INTRUSIONZONE_TYPE, INTRUSIONPIN_TYPE, ACCREADER_TYPE, ACCFLOOR_TYPE};
    public static final OrionType[] ALL_TYPES = new OrionType[]{ACCREADER_TYPE, ACCFLOOR_TYPE, INTRUSIONZONE_TYPE, INTRUSIONZONEGROUP_TYPE, TENANT_TYPE, KEYPAD_TYPE, WIEGAND_TYPE, PERSON_TYPE, INFOTEMPLATE_TYPE, PERSONINFO_TYPE, BADGE_TYPE, NIAGARA_INT_TYPE, THREATLEVELGROUP_TYPE, ACCESSRIGHT_TYPE, INTRUSIONPIN_TYPE, PERSONACCJOIN_TYPE, ACCREADERJOIN_TYPE, ACCFLOORJOIN_TYPE, INTRUSIONPINJOIN_TYPE, THREATLEVELBADGEJOIN_TYPE, THREATLEVELSTATIONJOIN_TYPE, THREATLEVEL_TYPE};
    private static final Map<OrionType, String> lexText = new HashMap<OrionType, String>();
    private static final Lexicon lex;
    protected static int CHUNK_SIZE;
    protected static int EXECUTE_SIZE;
    private OrionType orionType;
    private Map<BSimple, JoinAction> actionByJaceId = new HashMap<BSimple, JoinAction>();
    private Property[] summaryProps;
    private BTypeImportStatus importStatus = BTypeImportStatus.notConfigured;
    protected JoinAction[] actions;

    protected SysJoinType(OrionType orionType) {
        this.orionType = orionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(SubordinateConnection jaceConn, SysJoinManifest manifest) {
        this.summaryProps = null;
        Array temp = new Array(Property.class, 5);
        Property[] props = this.orionType.getProperties();
        for (int i = 0; i < props.length; ++i) {
            if ((props[i].getDefaultFlags() & 8) == 0 || props[i].getType().is(BRef.TYPE)) continue;
            temp.add((Object)props[i]);
        }
        this.summaryProps = (Property[])temp.trim();
        Array arr = new Array(JoinAction.class);
        Cursor<BObject> c = this.getSubordinateRecordsCursor(jaceConn);
        long count = 0L;
        while (c.next()) {
            ++count;
            arr.add((Object)new JoinAction((BIOrionObject)c.get()));
        }
        this.actions = (JoinAction[])arr.trim();
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        OrionSession supSession = null;
        try {
            supSession = service.createSession(null);
            this.match(supSession, jaceConn, manifest);
        }
        finally {
            if (supSession != null) {
                supSession.close();
                supSession = null;
            }
        }
    }

    public Cursor<BObject> getSubordinateRecordsCursor(SubordinateConnection jaceConn) {
        return jaceConn.getSession().scan(this.orionType);
    }

    public BTypeImportStatus getImportStatus() {
        return this.importStatus;
    }

    public String getImportDescription() {
        if (this.getImportStatus().equals((Object)BTypeImportStatus.notConfigured)) {
            return this.getImportStatus().toString();
        }
        if (this.actions.length == 0) {
            return lex.getText("join.noObjects");
        }
        int errors = 0;
        int newObjects = 0;
        int matchedObjects = 0;
        int deletedObjects = 0;
        int warnings = 0;
        for (int i = 0; i < this.actions.length; ++i) {
            switch (this.actions[i].getStatus().getOrdinal()) {
                case 0: {
                    ++errors;
                    break;
                }
                case 1: {
                    ++newObjects;
                    break;
                }
                case 2: {
                    ++matchedObjects;
                    break;
                }
                case 3: {
                    ++deletedObjects;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (this.actions[i].getWarningDescription() == null) continue;
            ++warnings;
        }
        int n = 0;
        StringBuffer sb = new StringBuffer();
        if (errors > 0) {
            sb.append(errors).append(' ').append(lex.getText("join.errors"));
            ++n;
        }
        if (newObjects > 0) {
            if (n > 0) {
                sb.append(", ");
            }
            sb.append(newObjects).append(' ').append(lex.getText("join.newObjects"));
            ++n;
        }
        if (matchedObjects > 0) {
            if (n > 0) {
                sb.append(", ");
            }
            sb.append(matchedObjects).append(' ').append(lex.getText("join.matchedObjects"));
            ++n;
        }
        if (deletedObjects > 0) {
            if (n > 0) {
                sb.append(", ");
            }
            sb.append(deletedObjects).append(' ').append(lex.getText("join.deletedObjects"));
            ++n;
        }
        if (warnings > 0) {
            if (n > 0) {
                sb.append(", ");
            }
            sb.append(warnings).append(' ').append(lex.getText("join.warnings"));
            ++n;
        }
        return sb.toString();
    }

    public void setImportStatus(BTypeImportStatus importStatus) {
        this.importStatus = importStatus;
    }

    public Property[] getSummaryProperties() {
        return this.summaryProps;
    }

    public int getRowCount() {
        if (this.actions == null) {
            return 0;
        }
        return this.actions.length;
    }

    public JoinAction get(int index) {
        return this.actions[index];
    }

    public boolean hasErrors() {
        for (int i = 0; i < this.actions.length; ++i) {
            if (!this.actions[i].getStatus().equals((Object)BObjectImportStatus.error)) continue;
            return true;
        }
        return false;
    }

    protected abstract void match(OrionSession var1, SubordinateConnection var2, SysJoinManifest var3);

    public abstract void join(OrionSession var1, SubordinateConnection var2, BSysJoinJob var3, SysJoinManifest var4);

    public abstract BSimple getKey(BIOrionObject var1);

    protected final BIOrionObject copyObject(BIOrionObject oldObj) {
        BReplicableObject newObj = (BReplicableObject)oldObj.getOrionType().getInstance();
        newObj.copyFrom(oldObj);
        return newObj;
    }

    public static void adjustRef(BOrionObject childJaceObj, String refName, SysJoinType parentJoin) {
        BRef ref = (BRef)childJaceObj.get(refName);
        if (!ref.isBound()) {
            return;
        }
        JoinAction action = parentJoin.getActionByJaceId(ref.getId());
        if (action == null) {
            return;
        }
        if (action.getStatus().equals((Object)BObjectImportStatus.matchedObject)) {
            BSimple supKey = action.getMatchKey();
            ref = BRef.make((BTypeSpec)parentJoin.getOrionType().getTypeSpec(), (BSimple)supKey);
            childJaceObj.set(refName, (BValue)ref);
        }
    }

    public JoinAction getActionByJaceId(BSimple jaceId) {
        return this.actionByJaceId.get(jaceId);
    }

    public void setActionByJaceId(BSimple jaceId, JoinAction action) {
        this.actionByJaceId.put(jaceId, action);
    }

    public OrionType getOrionType() {
        return this.orionType;
    }

    public static SysJoinType makeFor(OrionType type) {
        if (type.getTypeSpec().equals((Object)ACCREADER_SPEC)) {
            return new SysJoinTypeAccReaderRec();
        }
        if (type.getTypeSpec().equals((Object)ACCFLOOR_SPEC)) {
            return new SysJoinTypeAccFloorRec();
        }
        if (type.getTypeSpec().equals((Object)TENANT_SPEC)) {
            return new SysJoinTypeSimple(type, TENANT_ID, TENANT_MATCH);
        }
        if (type.getTypeSpec().equals((Object)PERSONINFO_SPEC)) {
            return new SysJoinTypePersonInfo();
        }
        if (type.getTypeSpec().equals((Object)INFOTEMPLATE_SPEC)) {
            return new SysJoinTypeInfoTemplate(type, INFOTEMPLATE_ID, INFOTEMPLATE_MATCH);
        }
        if (type.getTypeSpec().equals((Object)KEYPAD_SPEC)) {
            return new SysJoinTypeKeypadFormat();
        }
        if (type.getTypeSpec().equals((Object)WIEGAND_SPEC)) {
            return new SysJoinTypeWiegandFormat();
        }
        if (type.getTypeSpec().equals((Object)PERSON_SPEC)) {
            return new SysJoinTypePerson();
        }
        if (type.getTypeSpec().equals((Object)BADGE_SPEC)) {
            return new SysJoinTypeBadge();
        }
        if (type.getTypeSpec().equals((Object)NIAGARA_INT_SPEC)) {
            return new SysJoinTypeNiagaraIntegrationID();
        }
        if (type.getTypeSpec().equals((Object)ACCESSRIGHT_SPEC)) {
            return new SysJoinTypeAccessRight();
        }
        if (type.getTypeSpec().equals((Object)PERSONACCJOIN_SPEC)) {
            return new SysJoinTypePersonAccJoin();
        }
        if (type.getTypeSpec().equals((Object)ACCREADERJOIN_SPEC)) {
            return new SysJoinTypeAccReaderJoin();
        }
        if (type.getTypeSpec().equals((Object)ACCFLOORJOIN_SPEC)) {
            return new SysJoinTypeAccFloorJoin();
        }
        if (type.getTypeSpec().equals((Object)INTRUSIONPIN_SPEC)) {
            return new SysJoinTypeIntrusionPin();
        }
        if (type.getTypeSpec().equals((Object)INTRUSIONPINJOIN_SPEC)) {
            return new SysJoinTypeIntrusionPinJoin();
        }
        if (type.getTypeSpec().equals((Object)INTRUSIONZONEGROUP_SPEC)) {
            return new SysJoinTypeIntrusionZoneGroup();
        }
        if (type.getTypeSpec().equals((Object)INTRUSIONZONE_SPEC)) {
            return new SysJoinTypeIntrusionZoneRec();
        }
        if (type.getTypeSpec().equals((Object)THREATLEVELGROUP_SPEC)) {
            return new SysJoinTypeThreatLevelGroupRec();
        }
        if (type.getTypeSpec().equals((Object)THREATLEVELBADGEJOIN_SPEC)) {
            return new SysJoinTypeThreatLevelBadgeJoin();
        }
        if (type.getTypeSpec().equals((Object)THREATLEVELSTATIONJOIN_SPEC)) {
            return new SysJoinTypeThreatLevelStationJoin();
        }
        if (type.getTypeSpec().equals((Object)THREATLEVEL_SPEC)) {
            return new SysJoinTypeThreatLevel();
        }
        throw new IllegalStateException();
    }

    public static OrionType[] getDisplayedTypes() {
        if (BEnterpriseSecurityService.isThreatAvailable()) {
            return DISPLAYED_THREAT_TYPES;
        }
        return DISPLAYED_NON_THREAT_TYPES;
    }

    public static String getLexiconText(OrionType type) {
        return lexText.get(type);
    }

    public static String getLexiconText(String lexiconKey, Object[] args) {
        String value = lex.get(lexiconKey);
        if (value == null) {
            return lexiconKey;
        }
        return MessageFormat.format(value, args);
    }

    public static String getLexiconText(String lexiconKey) {
        return lex.get(lexiconKey);
    }

    static {
        lexText.put(TENANT_TYPE, "join.tenant");
        lexText.put(KEYPAD_TYPE, "join.keypadFormat");
        lexText.put(WIEGAND_TYPE, "join.wiegandFormat");
        lexText.put(PERSON_TYPE, "join.person");
        lexText.put(BADGE_TYPE, "join.badge");
        lexText.put(NIAGARA_INT_TYPE, "join.niagaraIntegrationID");
        lexText.put(ACCESSRIGHT_TYPE, "join.accessRight");
        lexText.put(INTRUSIONPIN_TYPE, "join.intrusionPin");
        lexText.put(INTRUSIONZONE_TYPE, "join.intrusionZone");
        lexText.put(ACCREADER_TYPE, "join.accessReader");
        lexText.put(ACCFLOOR_TYPE, "join.accessFloor");
        lexText.put(THREATLEVELGROUP_TYPE, "join.threatLevelGroup");
        lexText.put(THREATLEVEL_TYPE, "join.threatLevel");
        lexText.put(INFOTEMPLATE_TYPE, "join.infoTemplate");
        lex = Lexicon.make((String)"entsecHx");
        CHUNK_SIZE = 500;
        EXECUTE_SIZE = 10000;
    }
}

