/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx.replicate;

import com.tridium.authn.AuthenticationClient;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraStation;
import com.tridium.orion.BAbstractOrionApp;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.orionTools.replicate.Replicator;
import java.net.ConnectException;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.security.BIUserCredentials;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;

public class SubordinateConnection {
    private final BNiagaraStation station;
    private final BOrd appOrd;
    private final BFoxSession proxy;
    private OrionSession session = null;

    public SubordinateConnection(BNiagaraStation station, BOrd appOrd) {
        this.station = station;
        this.appOrd = appOrd;
        this.proxy = SubordinateConnection.makeFoxProxySession(station);
        try {
            this.proxy.engageNoRetry(this.getEngageKey());
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    private static BFoxSession makeFoxProxySession(BNiagaraStation toStation) {
        BFoxSession foxSession = null;
        try {
            if (toStation.getSession() instanceof BFoxSession) {
                throw new ConnectException("The password cannot be retrieved from session.");
            }
            BFoxClientConnection conn = toStation.getClientConnection();
            foxSession = BFoxSession.make((String)toStation.getStationName(), (BHost)conn.getRemoteHost(), (int)conn.getPort(), (boolean)conn.getUseFoxs());
            BIUserCredentials credentials = toStation.getClientConnection().getCredentials();
            foxSession.getConnection().setCredentials(credentials);
            foxSession.getConnection().setAuthenticationClient((AuthenticationClient)toStation.getClientConnection());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return foxSession;
    }

    public BFoxSession getProxy() {
        return this.proxy;
    }

    public OrionSession getSession() {
        if (this.session == null) {
            BAbstractOrionApp app = (BAbstractOrionApp)this.appOrd.get((BObject)this.proxy);
            app.lease();
            this.session = Replicator.makeOrionSession((BAbstractOrionApp)app);
        }
        return this.session;
    }

    public BNiagaraStation getStation() {
        return this.station;
    }

    public void close() {
        if (this.session != null && this.session.isOpen()) {
            this.session.close();
            this.session = null;
        }
        if (this.proxy.isEngaged(this.getEngageKey())) {
            this.proxy.disengage(this.getEngageKey());
        }
    }

    private String getEngageKey() {
        return "subordinateConnection" + this.appOrd + Integer.toHexString(this.hashCode());
    }
}

