/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx.replicate;

import com.tridium.nre.util.tuple.Pair;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.model.SortingUtil;
import com.tridium.orion.priv.util.CountingUtil;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.BatchStatement;
import com.tridium.orion.sql.TableBuilder;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonZoneJoin;
import com.tridiumx.entsec.access.orion.BSupervisorZoneJoin;
import com.tridiumx.entsec.orionTools.BTenant;
import com.tridiumx.entsec.orionTools.replicate.Replicator;
import com.tridiumx.entsec.photoID.orion.BBadgeTemplate;
import com.tridiumx.entsec.photoID.orion.BPersonPortrait;
import com.tridiumx.entsec.photoID.orion.BPhotoIDTemplateRec;
import com.tridiumx.entsec.photoID.orion.BTenantPhotoIDTemplateJoin;
import com.tridiumx.entsec.threat.BThreatLevelGroupRec;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BSysJoinJob;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SubordinateConnection;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinManifest;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinType;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.baja.hx.HxOp;
import javax.baja.query.BQuery;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.AddConstraint;
import javax.baja.rdb.ddl.Constraint;
import javax.baja.rdb.ddl.CreateTable;
import javax.baja.rdb.ddl.DdlCommand;
import javax.baja.rdb.ddl.DropConstraint;

public class JoinConstraints {
    private static final String THREAT_LEVEL_GROUP = BAccessRight.threatLevelGroup.getName();
    private static final String TENANT = "tenant";
    private static final String PERSON = "person";
    private final BSysJoinJob sysJoinJob;
    private final OrionSession jaceSession;
    private final TableBuilder tbPerson;
    private final TableBuilder tbSupZone;
    private final TableBuilder tbPersonZone;
    private final TableBuilder tbThreatLevelGroup;
    private final TableBuilder tbAccessRight;
    private final TableBuilder tbTenant;
    private final Constraint fkSupZone;
    private final Constraint fkPersonZone;
    private final Constraint fkThreatLevelGroup;
    private final Constraint fkThreatLevelTenant;
    private static final OrionType[] photoIdOrionTypes = new OrionType[]{BPhotoIDTemplateRec.ORION_TYPE, BTenantPhotoIDTemplateJoin.ORION_TYPE, BBadgeTemplate.ORION_TYPE, BPersonPortrait.ORION_TYPE};

    public JoinConstraints(BSysJoinJob sysJoinJob, OrionSession jaceSession, RdbmsContext rcx) {
        this.sysJoinJob = sysJoinJob;
        this.jaceSession = jaceSession;
        this.tbPerson = new TableBuilder(jaceSession.getOrionDatabase(), BPerson.ORION_TYPE);
        this.tbSupZone = new TableBuilder(jaceSession.getOrionDatabase(), BSupervisorZoneJoin.ORION_TYPE);
        this.tbPersonZone = new TableBuilder(jaceSession.getOrionDatabase(), BPersonZoneJoin.ORION_TYPE);
        this.tbThreatLevelGroup = new TableBuilder(jaceSession.getOrionDatabase(), BThreatLevelGroupRec.ORION_TYPE);
        this.tbAccessRight = new TableBuilder(jaceSession.getOrionDatabase(), BAccessRight.ORION_TYPE);
        this.tbTenant = new TableBuilder(jaceSession.getOrionDatabase(), BTenant.ORION_TYPE);
        this.fkSupZone = this.findForeignKey(this.tbSupZone, this.tbPerson);
        this.fkPersonZone = this.findForeignKey(this.tbPersonZone, this.tbPerson);
        this.fkThreatLevelGroup = this.findForeignKey(this.tbAccessRight, this.tbThreatLevelGroup);
        this.fkThreatLevelTenant = this.findForeignKey(this.tbThreatLevelGroup, this.tbTenant);
    }

    private Constraint findForeignKey(TableBuilder tb, TableBuilder fkTb) {
        CreateTable create = (CreateTable)tb.createTable()[0];
        Constraint[] constraints = create.getConstraints();
        for (int i = 0; i < constraints.length; ++i) {
            if (constraints[i].getConstraintType() != 2 || !fkTb.getTableName().equals(constraints[i].getRefTable())) continue;
            return constraints[i];
        }
        throw new IllegalStateException();
    }

    private void dropConstraint(String tableName, Constraint constraint) {
        this.sysJoinJob.logMessage("JOIN: dropping constraint " + constraint.getName() + " on table " + tableName);
        try {
            this.jaceSession.invokeDdl((DdlCommand)new DropConstraint(tableName, constraint.getName()));
        }
        catch (Exception e) {
            this.sysJoinJob.logError(e.getMessage(), e);
            e.printStackTrace();
        }
    }

    private void addConstraint(String tableName, Constraint constraint) {
        this.sysJoinJob.logMessage("JOIN: recreating constraint " + constraint.getName() + " on table " + tableName);
        try {
            this.jaceSession.invokeDdl((DdlCommand)new AddConstraint(tableName, constraint));
        }
        catch (Exception e) {
            this.sysJoinJob.logError(e.getMessage(), e);
            e.printStackTrace();
        }
    }

    private void adjustJoin(SysJoinType joinPerson, String refName, OrionType joinType) {
        this.sysJoinJob.logMessage("JOIN: updating join for " + joinType);
        BatchStatement jaceUpdate = this.jaceSession.batchUpdate(joinType);
        jaceUpdate.setChunkSize(Replicator.CHUNK_SIZE);
        OrionCursor jaceCursor = this.jaceSession.scan(joinType);
        while (jaceCursor.next()) {
            BOrionObject rec = (BOrionObject)jaceCursor.get();
            SysJoinType.adjustRef(rec, refName, joinPerson);
            if (!rec.isModified()) continue;
            jaceUpdate.add((BIOrionObject)rec);
            if (jaceUpdate.size() <= Replicator.EXECUTE_SIZE) continue;
            jaceUpdate.execute();
        }
        jaceUpdate.execute();
    }

    private boolean isTableEmpty(OrionType orionType) {
        int count = CountingUtil.getCount((BQuery)BSqlQuery.make((OrionType)orionType), (OrionSession)this.jaceSession);
        return count == 0;
    }

    private boolean doesTableExist(OrionType orionType) {
        try {
            this.isTableEmpty(orionType);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    void dropJoinConstraints() {
        this.dropConstraint(this.tbSupZone.getTableName(), this.fkSupZone);
        this.dropConstraint(this.tbPersonZone.getTableName(), this.fkPersonZone);
        this.dropConstraint(this.tbThreatLevelGroup.getTableName(), this.fkThreatLevelTenant);
    }

    void adjustJoinRecords(HxOp op, SubordinateConnection jaceConn, SysJoinManifest manifest) {
        SysJoinType joinPerson = manifest.getConfigForType(jaceConn, SysJoinType.PERSON_TYPE, manifest);
        SysJoinType joinTenant = manifest.getConfigForType(jaceConn, SysJoinType.TENANT_TYPE, manifest);
        SysJoinType joinThreatLevelGroup = manifest.getConfigForType(jaceConn, SysJoinType.THREATLEVELGROUP_TYPE, manifest);
        this.adjustJoin(joinPerson, PERSON, BSupervisorZoneJoin.ORION_TYPE);
        this.adjustJoin(joinPerson, PERSON, BPersonZoneJoin.ORION_TYPE);
        this.adjustJoin(joinTenant, TENANT, BThreatLevelGroupRec.ORION_TYPE);
    }

    void addJoinConstraints() {
        this.addConstraint(this.tbSupZone.getTableName(), this.fkSupZone);
        this.addConstraint(this.tbPersonZone.getTableName(), this.fkPersonZone);
        this.addConstraint(this.tbThreatLevelGroup.getTableName(), this.fkThreatLevelTenant);
    }

    public void dropPhotoIDTables() {
        OrionType[] orionTypes = new OrionType[]{};
        try {
            orionTypes = SortingUtil.sortTypes((BOrionDatabase)this.jaceSession.getOrionDatabase(), (OrionType[])photoIdOrionTypes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LinkedHashMap<String, Pair> orionTypesMap = new LinkedHashMap<String, Pair>();
        for (int i = orionTypes.length - 1; i >= 0; --i) {
            OrionType orionType = orionTypes[i];
            if (!this.doesTableExist(orionType)) continue;
            TableBuilder tb = new TableBuilder(this.jaceSession.getOrionDatabase(), orionType);
            if (this.isTableEmpty(orionType)) {
                DdlCommand[] ddl = tb.dropTable();
                LinkedHashSet<DdlCommand> ddlCommandSet = new LinkedHashSet<DdlCommand>();
                for (int j = ddl.length - 1; j >= 0; --j) {
                    ddlCommandSet.add(ddl[j]);
                }
                orionTypesMap.put(tb.getTableName(), new Pair((Object)orionType, ddlCommandSet));
                continue;
            }
            this.sysJoinJob.logDebug("JOIN: detected non-empty PhotoID table: " + tb.getTableName() + ", please ensure the table is empty");
            this.sysJoinJob.logMessage("JOIN: detected non-empty PhotoID exist, Join cannot continue, If you would like to join this subordinate to a supervisor, please ensure all PhotoID Tables are empty first");
            return;
        }
        if (orionTypesMap.isEmpty()) {
            this.sysJoinJob.logMessage("JOIN: confirmed that no PhotoID tables exist");
        } else {
            boolean droppedTables = true;
            for (Map.Entry ddlEntry : orionTypesMap.entrySet()) {
                String tableName = (String)ddlEntry.getKey();
                OrionType orionType = (OrionType)((Pair)ddlEntry.getValue()).getFirst();
                Set ddlCommands = (Set)((Pair)ddlEntry.getValue()).getSecond();
                try {
                    ddlCommands.forEach(arg_0 -> ((OrionSession)this.jaceSession).invokeDdl(arg_0));
                    this.sysJoinJob.logDebug("JOIN: detected empty PhotoID table: " + tableName + " dropped");
                }
                catch (Exception e) {
                    this.sysJoinJob.logDebug("JOIN: detected PhotoID table: " + tableName + " can not be dropped");
                    if (!this.isTableEmpty(orionType)) {
                        this.sysJoinJob.logMessage("JOIN: detected non-empty PhotoID exist, Join cannot continue, If you would like to join this subordinate to a supervisor, please ensure all PhotoID Tables are empty first");
                        return;
                    }
                    droppedTables = false;
                }
            }
            if (droppedTables) {
                this.sysJoinJob.logMessage("JOIN: detected empty PhotoID exist, tables dropped.");
            }
        }
    }
}

