/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx.replicate;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.fox.BFoxOrionDatabase;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.orionTools.BIOrdMappable;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BObjectImportStatus;
import com.tridiumx.entsecHx.orionToolsHx.replicate.BTypeImportStatus;
import com.tridiumx.entsecHx.orionToolsHx.replicate.JoinAction;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SubordinateConnection;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinManifest;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinType;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.hx.table.Table;
import javax.baja.hx.table.TableModel;
import javax.baja.hx.table.TableRenderer;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;

@NiagaraType(agent={@AgentOn(types={"entsec:NiagaraReplicationDeviceExt"})})
@NiagaraSingleton
public class BDataImportManager
extends BHxView {
    public static final BDataImportManager INSTANCE = new BDataImportManager();
    public static final Type TYPE = Sys.loadType(BDataImportManager.class);
    public static final Lexicon viewLex = Lexicon.make(BDataImportManager.class);
    public static final Lexicon hxLex = Lexicon.make(BHxView.class);
    private Command showDetailsCmd = new ShowDetailsCommand(this);

    public Type getType() {
        return TYPE;
    }

    protected BDataImportManager() {
        this.registerEvent((Event)this.showDetailsCmd);
    }

    public void write(HxOp op) throws Exception {
        op.addStyleSheet(BOrd.make((String)"module://entsecHx/rc/orionToolsHx/SysJoinManager.css"));
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/smartTable.js"));
        Lexicon lex = op.getLexicon(this.getType().getModule().getModuleName());
        OrionType dataType = this.getDataType(op);
        if (dataType == null) {
            this.errorPage(lex.getText("error.type.required"), op);
            return;
        }
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("selectedRow")).w((Object)"'>");
        out.w((Object)"<div class='sys-join-commands'>");
        out.w((Object)"<input ");
        out.w((Object)"onclick=\" setTimeout('$$(&quot;ok&quot;).disabled=disabled=&quot;disabled&quot;; $$(&quot;cancel&quot;).disabled=disabled=&quot;disabled&quot;', 1);\"");
        out.w((Object)" type='submit' name='ok' value='").safe((Object)hxLex.getText("command.ok")).w((Object)"'/>");
        out.w((Object)"<input ");
        out.w((Object)"onclick=\" setTimeout('$$(&quot;ok&quot;).disabled=disabled=&quot;disabled&quot;; $$(&quot;cancel&quot;).disabled=disabled=&quot;disabled&quot;', 1);\"");
        out.w((Object)" type='submit' name='cancel' value='").safe((Object)hxLex.getText("command.cancel")).w((Object)"'/>");
        out.w((Object)"</div>");
        TypeTableModel tableModel = new TypeTableModel(dataType, op);
        Table table = new Table((TableModel)tableModel);
        table.setRenderer((TableRenderer)new TypeTableRenderer());
        table.write(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BObject save(HxOp op) {
        OrionType dataType = this.getDataType(op);
        if (dataType == null) {
            return op.get();
        }
        SysJoinManifest manifest = SysJoinManifest.getForSession(op);
        try (SubordinateConnection jaceConn = manifest.makeSubordinateConnection();){
            if (op.getFormValue("ok") != null) {
                SysJoinType config = manifest.getConfigForType(jaceConn, dataType, manifest);
                config.setImportStatus(BTypeImportStatus.configured);
                op.setRedirect("/ord?station:|" + ((BComponent)op.get()).getSlotPathOrd());
            } else if (op.getFormValue("cancel") != null) {
                manifest.removeConfigForType(dataType);
                op.setRedirect("/ord?station:|" + ((BComponent)op.get()).getSlotPathOrd());
            }
        }
        return op.get();
    }

    public OrionType getDataType(HxOp op) {
        String dataTypeSpec = null;
        ViewQuery vq = op.getViewQuery();
        if (vq != null) {
            dataTypeSpec = vq.getParameter("dataType", null);
        }
        if (dataTypeSpec == null) {
            return null;
        }
        OrionType dataType = null;
        try {
            dataType = (OrionType)BTypeSpec.make((String)dataTypeSpec).getResolvedType();
        }
        catch (Exception ex) {
            return null;
        }
        return dataType;
    }

    private void errorPage(String msg, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        Lexicon lex = op.getLexicon(this.getType().getModule().getModuleName());
        out.w((Object)"<div class='sys-join-error' style='margin-bottom: 20px;'>");
        out.w((Object)"<img src='module://icons/x32/error.png'/>");
        out.w((Object)"&nbsp;");
        out.w((Object)msg);
        out.w((Object)"</div>");
        BComponent target = (BComponent)op.get();
        out.w((Object)"<a href='station:|").w((Object)HxUtil.encodeURLForHref((String)target.getSlotPathOrd().toString())).w((Object)"'>");
        out.w((Object)"<span class='sys-join-error-hyperlink'>");
        out.safe((Object)lex.getText("back.to.join"));
        out.w((Object)"</span>");
        out.w((Object)"</a>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JoinAction getSelection(HxOp op) {
        String rowStr = op.getFormValue("selectedRow");
        if (rowStr == null) {
            return null;
        }
        int row = -1;
        try {
            row = Integer.parseInt(rowStr);
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
        if (row == -1) {
            return null;
        }
        OrionType dataType = this.getDataType(op);
        SysJoinManifest manifest = SysJoinManifest.getForSession(op);
        SysJoinType typeConfig = null;
        try (SubordinateConnection jaceConn = manifest.makeSubordinateConnection();){
            typeConfig = manifest.getConfigForType(jaceConn, dataType, manifest);
        }
        return typeConfig.get(row);
    }

    private class MatchDialog
    extends Dialog {
        public MatchDialog(Command handler) {
            super(LexiconText.make((String)Sys.getModuleForClass(BDataImportManager.class).getModuleName(), (String)"sys.join.matchDialogTitle"), handler);
        }

        public Command[] getCommands() {
            String moduleName = Sys.getModuleForClass(BDataImportManager.class).getModuleName();
            return new Command[]{new Dialog.DialogCommand("ok"){

                public String getDisplayName(HxOp op) {
                    return Lexicon.make((String)"hx", (Context)op).getText("ok");
                }

                public String getInvokeCode(HxOp op) {
                    return "hx.closeDialog(null,null,null);";
                }
            }};
        }

        public String getTitle(HxOp op) {
            JoinAction action = BDataImportManager.this.getSelection(op);
            if (action == null) {
                return "Error";
            }
            return action.getJaceObject().toDisplayString((Context)op);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            JoinAction action = BDataImportManager.this.getSelection(op);
            if (action == null) {
                out.w((Object)"Error: no selection.");
                return;
            }
            BIOrionObject toImport = action.getJaceObject();
            BIOrionObject match = null;
            Object oMatch = action.getMatch();
            if (oMatch instanceof BRef) {
                BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
                OrionSession session = null;
                try {
                    session = service.createSession(null);
                    match = action.getMatch(session);
                }
                finally {
                    if (session != null) {
                        session.close();
                        session = null;
                    }
                }
            } else if (oMatch instanceof BIOrionObject) {
                match = (BIOrionObject)oMatch;
            }
            if (match == null) {
                this.writeSingleDetails(toImport, op);
            } else {
                this.writeMatchDetails(toImport, match, op);
            }
        }

        public void writeSingleDetails(BIOrionObject toImport, HxOp op) throws Exception {
            this.writeObjectDetails(toImport, op);
        }

        public void writeMatchDetails(BIOrionObject toImport, BIOrionObject match, HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<table cellspacing='0' cellpadding='0'>");
            out.w((Object)"<tr>");
            out.w((Object)"<td class='sys-join-match-heading'>");
            out.safe((Object)viewLex.getText("importFromJace"));
            out.w((Object)"</td>");
            out.w((Object)"<td class='sys-join-match-heading'>");
            out.safe((Object)viewLex.getText("matchOnServer"));
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td style='border-right: solid black 1px; padding-right: 10px;'>");
            this.writeObjectDetails(toImport, op);
            out.w((Object)"</td>");
            out.w((Object)"<td style='padding-left: 10px;'>");
            this.writeObjectDetails(match, op);
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void writeObjectDetails(BIOrionObject obj, HxOp op) throws Exception {
            out = op.getHtmlWriter();
            out.w((Object)"<table cellspacing='0' cellpadding='0'>");
            props = obj.getOrionType().getProperties();
            for (i = 0; i < props.length; ++i) {
                if ((props[i].getDefaultFlags() & 8) == 0 && (!(obj instanceof BIOrdMappable) || !props[i].getType().equals(BUuid.TYPE))) continue;
                out.w((Object)"<tr>");
                out.w((Object)"<td class='sys-join-match-label'>").safe((Object)props[i].getDefaultDisplayName((Context)op)).w((Object)"</td>");
                value = "";
                if (obj.get(props[i]) instanceof BRef) {
                    ref = (BRef)obj.get(props[i]);
                    if (obj.getOrionDatabase() instanceof BFoxOrionDatabase) {
                        manifest = SysJoinManifest.getForSession(op);
                        jaceConn = manifest.makeSubordinateConnection();
                        try {
                            refObject = ref.getTarget(jaceConn.getSession());
                            if (refObject == null) ** GOTO lbl39
                            value = refObject.toDisplayString((Context)op);
                        }
                        finally {
                            jaceConn.close();
                        }
                    } else {
                        service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
                        session = null;
                        try {
                            session = service.createSession((Context)op);
                            refObject = ref.getTarget(session);
                            if (refObject == null) ** GOTO lbl39
                            value = refObject.toDisplayString((Context)op);
                        }
                        finally {
                            if (session != null) {
                                session.close();
                                session = null;
                            }
                        }
                    }
                } else {
                    value = obj.get(props[i]).toString((Context)op);
                }
lbl39:
                // 5 sources

                out.w((Object)"<td class='sys-join-match-value'>").safe((Object)value).w((Object)"</td>");
                out.w((Object)"</tr>");
            }
            out.w((Object)"</table>");
        }
    }

    private class ShowDetailsCommand
    extends Command {
        Dialog dialog;

        public ShowDetailsCommand(BHxView owner) {
            super(owner);
            this.dialog = new MatchDialog(this);
        }

        public String getDisplayName(HxOp op) {
            return op.getLexicon(BDataImportManager.this.getType().getModule().getModuleName()).getText("sys.join.showDetails");
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dialog.isSubmit(op)) {
                this.dialog.open(op);
                return;
            }
            this.refresh(op);
        }
    }

    private class TypeTableRenderer
    extends TableRenderer {
        private TypeTableRenderer() {
        }

        public void writeCellValue(Object value, int group, int row, int col, HxOp op) throws Exception {
            super.writeCellValue(value, group, row, col, op);
            int colCount = this.getModel().getColumnCount();
            if (col == colCount - 1) {
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)"&nbsp;");
                out.w((Object)"<img src='module://icons/x16/magnifyingGlass.png' style='align: right;' ");
                out.w((Object)"onclick='");
                out.w((Object)"document.forms[0].").w((Object)op.scope("selectedRow")).w((Object)".value=\"").w(row).w((Object)"\";");
                out.w((Object)BDataImportManager.this.showDetailsCmd.getInvokeCode(op)).w((Object)"'");
                out.w((Object)">");
            }
        }
    }

    private class TypeTableModel
    extends TableModel {
        private OrionType dataType;
        private SysJoinType typeConfig;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TypeTableModel(OrionType dataType, HxOp op) throws Exception {
            this.dataType = dataType;
            SysJoinManifest manifest = SysJoinManifest.getForSession(op);
            try (SubordinateConnection jaceConn = manifest.makeSubordinateConnection();){
                this.typeConfig = manifest.getConfigForType(jaceConn, dataType, manifest);
            }
        }

        public int getColumnCount() {
            return this.typeConfig.getSummaryProperties().length + 1;
        }

        public String getColumnName(int col, HxOp op) {
            Property[] summaryProps = this.typeConfig.getSummaryProperties();
            if (col < summaryProps.length) {
                return summaryProps[col].getDefaultDisplayName((Context)op);
            }
            if (col == summaryProps.length) {
                return viewLex.getText("status");
            }
            return "Error-" + col;
        }

        public int getRowCount(int group) {
            return this.typeConfig.getRowCount();
        }

        public Object getValueAt(int group, int row, int col, HxOp op) {
            JoinAction action = this.typeConfig.get(row);
            Property[] summaryProps = this.typeConfig.getSummaryProperties();
            if (col < summaryProps.length) {
                BIOrionObject rowObj = action.getJaceObject();
                return rowObj.get(summaryProps[col]);
            }
            if (col == summaryProps.length) {
                if (action.getStatus().equals((Object)BObjectImportStatus.error)) {
                    return (Object)((Object)action.getStatus()) + ": " + action.getErrorDescription();
                }
                if (action.getWarningDescription() == null) {
                    return action.getStatus();
                }
                return (Object)((Object)action.getStatus()) + ": " + action.getWarningDescription();
            }
            return "Error-" + col;
        }
    }
}

