/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx;

import com.tridium.bql.filter.BFilterSet;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.OrionSession;
import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridium.orion.priv.dt.DynamicTableResultModel;
import com.tridium.orion.priv.ui.BDynamicTableOptions;
import com.tridium.orion.sql.BPage;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.HxOptionsManager;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.BHxTabbedView;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.orionTools.BIOrdMappable;
import com.tridiumx.entsecHx.orionHx.BHxDynamicTableView;
import com.tridiumx.entsecHx.orionToolsHx.BHxAppView;
import com.tridiumx.entsecHx.orionToolsHx.HxRemoteUtil;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxBatchEditFieldSheet;
import javax.baja.agent.AgentFilter;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconModule;

public class OrionBatchEditCommand
extends SmartCommand {
    protected BatchEditDialog dlg = new BatchEditDialog(this.getDisplayName(null), (Command)this);

    public OrionBatchEditCommand(BHxView view) {
        super(view);
    }

    public OrionBatchEditCommand(BHxView view, Lexicon lex) {
        super(view, LexiconModule.make((BModule)lex.module));
    }

    public String getName(HxOp op) {
        return "quickEdit";
    }

    public BCommandEnablePolicy getEnablePolicy() {
        return BCommandEnablePolicy.anySelection;
    }

    public Object[] getSubjects(HxOp op) {
        return ((BHxDynamicTableView)this.getView()).getSubjects(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(HxOp op) throws Exception {
        if (!this.dlg.isSubmit(op)) {
            this.dlg.open(op);
            return;
        }
        BDynamicTable dt = (BDynamicTable)op.get();
        BOrionObject template = this.getBatchTemplate(op);
        BComponent savedTemplate = (BComponent)this.getPropertyTab(template, op).save();
        Object[] subjects = null;
        String applyTo = op.getFormValue("applyTo");
        if (op.getFormValue("applyTo").equals("all")) {
            BDynamicTableOptions options = (BDynamicTableOptions)new HxOptionsManager(op).load(BDynamicTableOptions.TYPE);
            BFilterSet filterSet = options.getFilterSet(dt);
            if (filterSet == null) {
                filterSet = BDynamicTableOptions.rebuildFilterSet((BDynamicTable)dt, (BFilterSet)filterSet, (Context)op);
            }
            BDynamicTableOptions.updateFilterSet((BFilterSet)filterSet);
            BOrionDatabase db = dt.getOrionDatabase();
            OrionSession session = null;
            try {
                session = db.getOrionDatabase().createSession((Context)op);
                DynamicTableResultModel results = null;
                int offset = 0;
                int batchSize = 500;
                do {
                    results = ((BHxDynamicTableView)this.getView()).runQuery(dt, -1, false, new BPage(offset, batchSize), filterSet, (Context)op);
                    for (int i = 0; i < results.getRowCount(); ++i) {
                        BOrionObject o = (BOrionObject)results.getResolvedSubject(i);
                        BHxTabbedView.PropertyTab tab = this.getPropertyTab(o, op);
                        BComponent saved = (BComponent)tab.save();
                        this.saveRow(saved, o, template, session, op);
                    }
                    offset += batchSize;
                } while (results.getRowCount() > 0);
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
        }
        subjects = ((BHxDynamicTableView)this.getView()).getSubjects(op);
        BOrionDatabase db = dt.getOrionDatabase();
        OrionSession session = null;
        try {
            session = db.getOrionDatabase().createSession((Context)op);
            for (int i = 0; i < subjects.length; ++i) {
                BOrionObject o = (BOrionObject)subjects[i];
                BHxTabbedView.PropertyTab tab = this.getPropertyTab(o, op);
                BComponent saved = (BComponent)tab.save();
                this.saveRow(saved, o, template, session, op);
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
        ((BHxSmartTableView)this.getView()).reloadTable(op);
    }

    public void saveRow(BComponent saved, BOrionObject subject, BOrionObject template, OrionSession session, HxOp op) throws Exception {
        if (saved instanceof BIOrionObject) {
            session.update((BIOrionObject)saved);
        }
    }

    public boolean process(HxOp op) throws Exception {
        if (!this.matchesScope(op)) {
            return false;
        }
        BOrionObject o = this.getBatchTemplate(op);
        return this.getPropertyTab(o, op).process();
    }

    public Tab getTab(BOrionObject o, HxOp op) {
        BFacets facets = BFacets.make((BFacets)BHxTabbedView.noHeader);
        HxOp fieldOp = op.make(this.getName(op), (BObject)o, facets);
        AgentFilter filter = BHxFieldEditor.getAgentFilter((AgentFilter)AgentFilter.is((Type)BHxAppView.TYPE), (Context)op);
        BHxAppView view = (BHxAppView)Sys.getRegistry().getAgents(o.getType().getTypeInfo()).filter(filter).getDefault().getInstance();
        return new Tab((BHxView)view, fieldOp);
    }

    public BHxTabbedView.PropertyTab getPropertyTab(BOrionObject o, HxOp op) throws Exception {
        Tab tab = this.getTab(o, op);
        BHxAppView view = (BHxAppView)tab.view;
        BHxTabbedView.PropertyTab propertyTab = view.getPropertyTab(tab.op);
        propertyTab.view = BHxBatchEditFieldSheet.INSTANCE;
        String[] fieldList = this.getProperties((BComponent)o, propertyTab.op);
        if (fieldList != null) {
            BFacets facets = BHxFieldSheet.getFieldsProvidedFacets((String[])fieldList);
            propertyTab.op = propertyTab.op.mergeFacets(facets);
        }
        return propertyTab;
    }

    public String[] getProperties(BComponent o, HxOp op) {
        return null;
    }

    public BOrionObject getBatchTemplate(HxOp op) {
        BOrionObject o = (BOrionObject)((BHxDynamicTableView)this.getView()).getSubject(true, op);
        return o;
    }

    public BComponent getMappable(BIOrionObject o, HxOp op) {
        BIOrdMappable mappable = (BIOrdMappable)o;
        BOrd ord = ((BIOrdMappable)o).getMappedOrd();
        if (mappable.getStationName().equals(Sys.getStation().getStationName())) {
            try {
                return (BComponent)ord.get();
            }
            catch (UnresolvedException e) {
                return null;
            }
        }
        BComponent c = HxRemoteUtil.getRemoteComponent(ord, mappable.getStationName(), op);
        if (c != null) {
            c.lease();
        }
        return c;
    }

    protected class BatchEditDialog
    extends Dialog {
        public BatchEditDialog(String title, Command handler) {
            super(title, handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            int length = SmartCommand.getSelectionList((HxOp)op).length;
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<table align='center'>");
            out.w((Object)"<tr><td>");
            out.w((Object)"<input ");
            out.attr("type", "radio");
            HxTabUtil.scope((String)"applyTo", (HtmlWriter)out, (HxOp)op);
            out.w((Object)" checked");
            out.attr(" value", op.scope("selection"));
            out.w((Object)">");
            out.safe((Object)OrionBatchEditCommand.this.lexModule.getText("applyToSelection", (Context)op, new Object[]{"" + length}));
            out.w((Object)"</td><td>");
            out.w((Object)"<input ");
            out.attr("type", "radio");
            HxTabUtil.scope((String)"applyTo", (HtmlWriter)out, (HxOp)op);
            out.attr(" value", op.scope("all"));
            out.w((Object)">");
            out.safe((Object)OrionBatchEditCommand.this.lexModule.getText("allRecordsInThisFilter", (Context)op));
            out.w((Object)"</td></tr>");
            out.w((Object)"</table>");
            HxTabUtil.getSpacerDiv((HxOp)op);
            BOrionObject o = OrionBatchEditCommand.this.getBatchTemplate(op);
            OrionBatchEditCommand.this.getPropertyTab(o, op).write();
        }

        public Command[] getCommands() {
            return new Command[]{new ConfirmSubmit(), this.makeCancelCommand()};
        }

        protected class ConfirmSubmit
        extends Dialog.Submit {
            public ConfirmSubmit() {
                super((Dialog)BatchEditDialog.this);
            }

            public String getInvokeCode(HxOp op) {
                StringBuffer b = new StringBuffer();
                b.append("if($$(&quot;").append(op.scope("applyTo")).append("&quot;).checked || confirm(&quot;");
                b.append(OrionBatchEditCommand.this.lexModule.getText("confirmAllRecordsInThisFilter", (Context)op));
                b.append("&quot;)){");
                b.append(super.getInvokeCode(op));
                b.append("}");
                return b.toString();
            }
        }
    }
}

