/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx;

import com.tridium.authn.AuthenticationClient;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import java.net.ConnectException;
import java.util.HashMap;
import javax.baja.hx.HxOp;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.naming.BOrd;
import javax.baja.security.BICredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.web.BWebService;

public abstract class HxRemoteUtil {
    private static Object lock = new Object();
    private static CleanupThread cleanupThread;
    private static HashMap<String, BFoxSession> sessions;
    private static BAbsTime lastActivity;
    public static BRelTime WAIT_TIME;

    public static BFoxSession getEngagedFoxSession(String stationName, HxOp op) {
        BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BNiagaraStation station = (BNiagaraStation)nn.getNiagaraStation(stationName);
        if (station == null) {
            return null;
        }
        BIUserCredentials credentials = station.getClientConnection().getCredentials();
        BIpHost host = (BIpHost)station.getRemoteHost();
        BFoxSession remoteSession = BFoxSession.make(null, (BHost)host, (int)station.getFoxPort(), (boolean)station.getClientConnection().getUseFoxs());
        remoteSession.setCredentials((BICredentials)credentials);
        remoteSession.getConnection().setAuthenticationClient((AuthenticationClient)station.getClientConnection());
        try {
            HxRemoteUtil.engage(remoteSession);
            HxRemoteUtil.startCleanup();
            return remoteSession;
        }
        catch (ConnectException e) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BComponent getRemoteComponent(BOrd remoteSlotPathOrd, String stationName, HxOp op) {
        BFoxSession foxSession = HxRemoteUtil.getEngagedFoxSession(stationName, op);
        if (foxSession == null) {
            return null;
        }
        return RemoteUtil.getRemoteComponent((BFoxSession)foxSession, (String)remoteSlotPathOrd.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRemoteUrl(BOrd remoteSlotPathOrd, String stationName, HxOp op) {
        BFoxSession foxSession = HxRemoteUtil.getEngagedFoxSession(stationName, op);
        if (foxSession == null) {
            return null;
        }
        String url = op.toUri(BOrd.make((String)("station:|" + remoteSlotPathOrd)));
        String interest = "HxRemoteUtil.getRemoteUrl" + BUuid.make().toString();
        try {
            BWebService remoteWebService = (BWebService)foxSession.getService(BWebService.TYPE);
            remoteWebService.lease();
            url = HxRemoteUtil.getUrl(url, remoteWebService, foxSession.getHost().getHostname(), op);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (foxSession != null) {
                foxSession.disengage(interest);
            }
        }
        return url;
    }

    public static String getUrl(String url, BWebService webService, String hostName, HxOp op) {
        if (op.getRequest().isSecure() && webService.getHttpsEnabled() || !webService.getHttpEnabled() && webService.getHttpsEnabled()) {
            int httpsPort = webService.getHttpsPort().getPublicServerPort();
            if (httpsPort != 443) {
                int index = url.indexOf("/ord?");
                url = ":" + httpsPort + url.substring(index);
            }
            url = "https://" + hostName + url;
        } else {
            int httpPort = webService.getHttpPort().getPublicServerPort();
            if (httpPort != 80) {
                int index = url.indexOf("/ord?");
                if (index == -1) {
                    index = url.indexOf("/");
                }
                url = ":" + httpPort + url.substring(index);
            }
            url = "http://" + hostName + url;
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startCleanup() {
        lastActivity = BAbsTime.now();
        Object object = lock;
        synchronized (object) {
            if (cleanupThread == null) {
                cleanupThread = new CleanupThread("HxRemoteUtil.CleanupThread");
                cleanupThread.start();
            }
        }
    }

    public static void engage(BFoxSession remoteSession) throws Exception {
        String key = "HxRemoteUtil." + remoteSession.getStationName() + "." + remoteSession.getUsername();
        remoteSession.engageNoRetry(key);
        sessions.put(key, remoteSession);
    }

    static {
        sessions = new HashMap();
        lastActivity = BAbsTime.END_OF_TIME;
        WAIT_TIME = BRelTime.make((long)120000L);
    }

    private static class CleanupThread
    extends Thread {
        public CleanupThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    if (BAbsTime.now().isAfter(lastActivity.add(WAIT_TIME))) {
                        Object[] a = sessions.keySet().toArray();
                        for (int i = 0; i < a.length; ++i) {
                            String key = a[i].toString();
                            BFoxSession remoteSession = (BFoxSession)sessions.get(key);
                            remoteSession.disengage(key);
                            sessions.remove(key);
                        }
                        if (sessions.size() == 0) {
                            cleanupThread = null;
                            return;
                        }
                    }
                    Thread.sleep(WAIT_TIME.getMillis());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

