/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx;

import com.tridium.hx.ErrorDialog;
import com.tridium.orion.OrionSession;
import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridium.smartTableHx.SmartCommand;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.orionTools.BTenant;
import com.tridiumx.entsec.orionTools.EntsecTenantUtil;
import com.tridiumx.entsecHx.orionHx.BHxDynamicTableView;
import com.tridiumx.entsecHx.orionToolsHx.BHxAppTableView;
import com.tridiumx.entsecHx.orionToolsHx.Delete;
import com.tridiumx.entsecHx.orionToolsHx.FilteredRedirectCommand;
import com.tridiumx.entsecHx.orionToolsHx.match.MatchCommand;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"entsec:Tenants"}, requiredPermissions="rR")})
@NiagaraSingleton
public class BHxTenantsView
extends BHxAppTableView {
    public static final BHxTenantsView INSTANCE = new BHxTenantsView();
    public static final Type TYPE = Sys.loadType(BHxTenantsView.class);
    protected SmartCommand matchCommand = new MatchCommand((BHxView)this);
    protected SmartCommand showExpirationsCommand;
    protected SmartCommand showReadersCommand;
    protected SmartCommand tenantDeleteCommand;

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxTenantsView() {
        this.registerEvent((Event)this.matchCommand);
        this.showExpirationsCommand = new ShowExpirationsCommand((BHxView)this);
        this.registerEvent((Event)this.showExpirationsCommand);
        this.showReadersCommand = new ShowReadersCommand((BHxView)this);
        this.registerEvent((Event)this.showReadersCommand);
        this.tenantDeleteCommand = new TenantDeleteCommand((BHxView)this);
        this.registerEvent((Event)this.tenantDeleteCommand);
    }

    public String getPageTitle(HxOp op) throws Exception {
        String title = super.getPageTitle(op);
        if (!EntsecTenantUtil.hasAllAvailableTenants((Context)op)) {
            return lex.getText("activeTenantFilterTitle", new Object[]{title});
        }
        return title;
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        Array a = new Array((Object[])super.getButtonCommands(op));
        a.add((Object)this.matchCommand);
        try {
            BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
            a.add((Object)this.showReadersCommand);
            a.add((Object)this.showExpirationsCommand);
        }
        catch (Exception service) {
            // empty catch block
        }
        for (int i = 0; i < a.size(); ++i) {
            if (!(a.get(i) instanceof Delete)) continue;
            a.set(i, (Object)this.tenantDeleteCommand);
        }
        return (SmartCommand[])a.trim();
    }

    public static class ShowReadersCommand
    extends FilteredRedirectCommand.RefFilter {
        public ShowReadersCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "showReaders";
        }

        @Override
        public BDynamicTable getReport(HxOp op) {
            BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
            return service.getPersonReaderReport();
        }

        @Override
        public Type getRefType(HxOp op) {
            return BTenant.TYPE;
        }
    }

    public static class ShowExpirationsCommand
    extends FilteredRedirectCommand.RefFilter {
        public ShowExpirationsCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "showExpirations";
        }

        @Override
        public BDynamicTable getReport(HxOp op) {
            BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
            return service.getPersonAccessRightReport();
        }

        @Override
        public Type getRefType(HxOp op) {
            return BTenant.TYPE;
        }
    }

    public class TenantDeleteCommand
    extends Delete {
        public TenantDeleteCommand(BHxView view) {
            super(view);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HxOp op) throws Exception {
            Lexicon tenantLex = Lexicon.make(BHxTenantsView.class);
            if (!EntsecTenantUtil.hasAllTenants((Context)op)) {
                if (EntsecTenantUtil.hasSingleUserTenant((Context)op)) {
                    new ErrorDialog(tenantLex.getText("error"), (Command)this, (Throwable)new Exception(tenantLex.getText("cannotDeleteLastUserTenant"))).open(op);
                    return;
                }
                BDynamicTable dt = (BDynamicTable)op.get();
                OrionSession session = null;
                try {
                    session = dt.getOrionDatabase().createSession((Context)op);
                    Object[] subjects = ((BHxDynamicTableView)this.getView()).getSubjects(op);
                    String references = this.makeReferences(subjects, session, op);
                    if (references != null && references.length() > 0) {
                        HxOp errorOp = op.make("error", (OrdTarget)op);
                        errorOp.mergeFacets(BFacets.make((String)"forceDetails", (boolean)true));
                        new ErrorDialog(tenantLex.getText("error"), (Command)this, (Throwable)new Exception(tenantLex.getText("cannotDeleteBecauseCantSeeAllTenants")), references).open(errorOp);
                        return;
                    }
                }
                finally {
                    if (session != null) {
                        session.close();
                        session = null;
                    }
                }
            }
            super.handle(op);
        }
    }
}

