/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionSession;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.orionTools.BRefList;
import com.tridiumx.entsec.orionTools.BTenantFilterOptions;
import com.tridiumx.entsec.orionTools.EntsecTenantUtil;
import com.tridiumx.entsec.user.BEntsecUserConfig;
import com.tridiumx.entsecHx.orionToolsHx.BHxAppView;
import javax.baja.hx.HxOp;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;

@NiagaraType(agent={@AgentOn(types={"entsec:Tenant"}, requiredPermissions="rR")})
@NiagaraSingleton
public class BHxTenantView
extends BHxAppView {
    public static final BHxTenantView INSTANCE = new BHxTenantView();
    public static final Type TYPE = Sys.loadType(BHxTenantView.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxTenantView() {
    }

    @Override
    public Tab[] getFieldEditors(HxOp op) throws Exception {
        return BHxTenantView.getDefaultFieldEditors(op);
    }

    @Override
    public void checkSave(BIOrionObject editObj, OrionSession session, HxOp op) throws Exception {
        super.checkSave(editObj, session, op);
        if (!session.exists(editObj)) {
            boolean inactiveFilter = EntsecTenantUtil.hasAllAvailableTenants((Context)op);
            boolean allUserTenants = EntsecTenantUtil.hasAllUserTenants((Context)op);
            if (!inactiveFilter) {
                BTenantFilterOptions options = BTenantFilterOptions.getOptions((Context)op);
                BRefList tenantList = options.getTenants();
                tenantList = BRefList.make((BRefList)tenantList, (BIOrionObject[])new BIOrionObject[]{editObj});
                options.setTenants(tenantList);
            }
            if (!allUserTenants) {
                BUser user = op.getUser();
                BEntsecUserConfig config = (BEntsecUserConfig)user.getMixIn(BEntsecUserConfig.TYPE);
                BRefList tenantList = config.getTenants();
                tenantList = BRefList.make((BRefList)tenantList, (BIOrionObject[])new BIOrionObject[]{editObj});
                config.setTenants(tenantList);
            }
        }
    }
}

