/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.orionToolsHx;

import com.tridium.orion.BIOrionDatabaseObject;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.ConfirmDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.PermissionsUtil;
import com.tridiumx.entsec.orionTools.BAppTable;
import com.tridiumx.entsec.orionTools.BRefList;
import com.tridiumx.entsec.orionTools.BTenant;
import com.tridiumx.entsec.orionTools.EntsecTenantUtil;
import com.tridiumx.entsecHx.orionToolsHx.BHxSmartRefFE;
import com.tridiumx.entsecHx.orionToolsHx.BHxSmartRefListTable;
import com.tridiumx.entsecHx.orionToolsHx.SummaryCommand;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.xml.XWriter;

@NiagaraType(agent={@AgentOn(types={"entsec:RefList"}, requiredPermissions="r")})
@NiagaraSingleton
public class BHxSmartRefListFE
extends BHxFieldEditor {
    public static final BHxSmartRefListFE INSTANCE = new BHxSmartRefListFE();
    public static final Type TYPE = Sys.loadType(BHxSmartRefListFE.class);
    public static final String UPDATE = "update";
    protected SmartCommand chooser = new Chooser((BHxView)this);
    protected SmartCommand summary;
    protected SmartCommand clear;
    protected SmartCommand hyperlink;

    public Type getType() {
        return TYPE;
    }

    protected BHxSmartRefListFE() {
        this.registerEvent((Event)this.chooser);
        this.summary = new Summary((BHxView)this);
        this.registerEvent((Event)this.summary);
        this.clear = new Clear((BHxView)this);
        this.registerEvent((Event)this.clear);
        this.hyperlink = new Hyperlink((BHxView)this);
        this.registerEvent((Event)this.hyperlink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(HxOp op) throws Exception {
        op.addStyleSheet(BOrd.make((String)"module://smartTableHx/rc/smartTable.css"));
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/smartTable.js"));
        BOrionDatabase db = BHxSmartRefListFE.getOrionDatabase(op);
        BRefList refList = (BRefList)op.get();
        int width = op.getFacets().geti("fieldWidth", 36);
        boolean showPreview = op.getFacets().getb("showPreview", true);
        boolean trim = op.getFacets().getb("trim", false);
        boolean multiLine = op.getFacets().getb("multiLine", false);
        boolean allowNull = op.getFacets().getb("allowNull", true);
        if (trim) {
            OrionSession session = null;
            try {
                session = db.createSession(null);
                refList = refList.trim(session);
                if (BHxSmartRefListFE.isUnmountedSingleTenant(session, op)) {
                    refList = EntsecTenantUtil.getTenantList((Context)op);
                }
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
        }
        HtmlWriter out = op.getHtmlWriter();
        OrionType refOrionType = (OrionType)refList.getTargetTypeSpec().getResolvedType();
        if (!PermissionsUtil.canAdminReadOrionType((OrionType)refOrionType, (BOrionDatabase)db, (Context)op)) {
            op.setReadonly(true);
        }
        boolean canReadRef = PermissionsUtil.canReadOrionType((OrionType)refOrionType, (BOrionDatabase)db, (Context)op);
        BHxSmartTableView.writeFormValue((String)"value", (String)refList.encodeToString(), (HxOp)op);
        String handle = BHxSmartRefListFE.getHandles(refList, op);
        BHxSmartTableView.writeFormValue((String)"handle", (String)handle, (HxOp)op);
        if (multiLine) {
            out.w((Object)"<table><tr>");
        }
        if (!showPreview) {
            out.w((Object)"<span style='display:none;'>");
        } else if (multiLine) {
            out.w((Object)"<td valign='top' style='width:16px;'>");
        } else {
            out.w((Object)"<span style='width:16px;'>");
        }
        out.w((Object)"<span ");
        if (canReadRef) {
            out.attr("title", this.hyperlink.getDisplayName(op));
            out.attr("style", "cursor:pointer;");
            out.w((Object)("onclick='" + this.hyperlink.getInvokeCode(op)));
            out.w((Object)"'");
        }
        out.w((Object)"> ");
        HxUtil.makeImageJS((BImage)BImage.make((BIcon)refOrionType.getInstance().getIcon()), (HxOp)op);
        out.w((Object)"</span>");
        if (!showPreview) {
            out.w((Object)"</span><span style='display:none;'>");
        } else if (multiLine) {
            out.w((Object)"</td><td valign='top' style='width:16px;'>");
        } else {
            out.w((Object)"</span><span style='width:16px;'>");
        }
        if (!multiLine) {
            out.w((Object)" <input ");
            out.attr(" type", "text");
            out.attr(" size", "" + width);
            out.attr(" readonly", "readonly");
            out.attr(" locked", "locked");
            HxTabUtil.scope((String)"preview", (HtmlWriter)out, (HxOp)op);
            out.attr(" value", BHxSmartRefListFE.getPreviewString(refList, db, op));
            out.w((Object)"/>");
        } else {
            out.w((Object)" <textarea ");
            out.attr("rows", "8");
            out.attr("cols", "24");
            out.w((Object)" WRAP=OFF ");
            out.attr("readonly", "readonly");
            out.attr("style", "font-family:tahoma; font-size:11px;");
            out.attr("locked", "locked");
            HxTabUtil.scope((String)"preview", (HtmlWriter)out, (HxOp)op);
            out.w((Object)">");
            out.safe((Object)BHxSmartRefListFE.getPreviewString(refList, db, op));
            out.w((Object)"</textarea>");
        }
        if (multiLine) {
            out.w((Object)"</td><td valign='top' style='width:16px;'>");
        } else {
            out.w((Object)"</span><span style='width:16px;'>");
        }
        out.w((Object)"<span ");
        HxTabUtil.scope((String)"chooser", (HtmlWriter)out, (HxOp)op);
        out.attr("title", this.chooser.getDisplayName(op));
        if (op.canWrite()) {
            out.attr("style", "cursor:pointer;");
        } else {
            out.attr("style", "cursor:pointer;display:none;");
        }
        out.w((Object)("onclick='" + this.chooser.getInvokeCode(op)));
        out.w((Object)"'> ");
        HxUtil.makeImageJS((BImage)this.chooser.getIcon(op), (HxOp)op);
        out.w((Object)"</span>");
        if (!showPreview) {
            out.w((Object)"</span><span style='display:none;'>");
        } else if (multiLine) {
            out.w((Object)"</td><td valign='top' style='width:16px;'>");
        } else {
            out.w((Object)"</span><span style='width:16px;'>");
        }
        if (canReadRef) {
            out.w((Object)"<span ");
            HxTabUtil.scope((String)"summary", (HtmlWriter)out, (HxOp)op);
            out.attr("title", this.summary.getDisplayName(op));
            if (!refList.isBound()) {
                out.attr("style", "display:none;cursor:pointer");
            } else {
                out.attr("style", "cursor:pointer;");
            }
            out.w((Object)("onclick='" + this.summary.getInvokeCode(op)));
            out.w((Object)"'> ");
            HxUtil.makeImageJS((BImage)this.summary.getIcon(op), (HxOp)op);
            out.w((Object)"</span>");
        }
        if (!showPreview) {
            out.w((Object)"</span><span style='display:none;'>");
        } else if (multiLine) {
            out.w((Object)"</td><td valign='top' style='width:16px;'>");
        } else {
            out.w((Object)"</span><span style='width:16px;'>");
        }
        out.w((Object)"<span ");
        HxTabUtil.scope((String)"clear", (HtmlWriter)out, (HxOp)op);
        if (!refList.isBound() || !op.canWrite()) {
            out.attr("style", "display:none;cursor:pointer");
        } else {
            out.attr("style", "cursor:pointer;");
        }
        out.attr("title", this.clear.getDisplayName(op));
        out.attr("style", "cursor:pointer;");
        out.w((Object)("onclick='" + this.clear.getInvokeCode(op)));
        out.w((Object)"'>");
        if (allowNull) {
            out.w((Object)" ");
            HxUtil.makeImageJS((BImage)this.clear.getIcon(op), (HxOp)op);
        }
        out.w((Object)"</span>");
        if (!showPreview) {
            out.w((Object)"</span>");
        } else if (multiLine) {
            out.w((Object)"</td></tr></table>");
        } else {
            out.w((Object)"</span>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPreviewString(BRefList refList, BOrionDatabase db, HxOp op) {
        OrionType refOrionType = (OrionType)refList.getTargetTypeSpec().getResolvedType();
        boolean canReadRef = PermissionsUtil.canReadOrionType((OrionType)refOrionType, (BOrionDatabase)db, (Context)op);
        boolean multiLine = op.getFacets().getb("multiLine", false);
        if (!canReadRef) {
            return "--not privileged--";
        }
        if (!refList.isBound()) {
            return HxTabUtil.getNoneText((Context)op);
        }
        if (!multiLine) {
            return refList.toString((Context)op);
        }
        OrionSession session = null;
        try {
            session = db.createSession(null);
            String delim = "\n";
            if (HxUtil.isPost((HxOp)op)) {
                delim = "\\n";
            }
            String string = refList.toDisplayString(delim, 10, "Click Summary for more.", session, (Context)op);
            return string;
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    public static void setPreview(BRefList refList, HxOp testOp, HxOp op) throws Exception {
        boolean multiLine = testOp.getFacets().getb("multiLine", false);
        BOrionDatabase db = BHxSmartRefListFE.getOrionDatabase(op);
        String value = XWriter.safeToString((String)BHxSmartRefListFE.getPreviewString(refList, db, testOp), (boolean)false);
        SmartCommand.setFormValue((String)testOp.scope("preview"), (Object)value, (boolean)true, (boolean)true, (HxOp)op);
    }

    public static String getHandles(BRefList refList, HxOp op) throws Exception {
        BOrionDatabase db = BHxSmartRefListFE.getOrionDatabase(op);
        return refList.getHandlesAsString(db.getOrdInSpace());
    }

    public BRefList decodeFromString(HxOp op) throws Exception {
        String refForm = op.getFormValue("value");
        return (BRefList)BRefList.NULL.decodeFromString(refForm);
    }

    public BObject save(HxOp op) throws Exception {
        BRefList tenantList;
        BRefList refList = this.decodeFromString(op);
        if (refList.getTargetTypeSpec().getResolvedType().is(BTenant.TYPE) && op.getFacets().getb("tenantRequired", true) && (!op.getUser().getPermissions().isSuperUser() || op.getFacets().getb("suTenantRequired", true)) && (tenantList = EntsecTenantUtil.getTenantList((Context)op)) != null && tenantList.isBound() && !refList.isBound()) {
            String module = BHxSmartRefFE.TYPE.getModule().getModuleName();
            throw new LocalizableException(module, "error.mustBeAssigned", new Object[]{refList.getTargetTypeSpec().getResolvedType().getDisplayName((Context)op)});
        }
        return refList;
    }

    public BOrionTypeId getOrionTypeId(HxOp op) {
        return ((BRefList)op.get()).getTargetOrionTypeId();
    }

    public static boolean isUnmountedSingleTenant(OrionSession session, HxOp op) {
        BRefList refList = (BRefList)op.get();
        if (refList.getTargetTypeSpec().getResolvedType().is(BTenant.TYPE) && EntsecTenantUtil.hasSingleTenant((Context)op)) {
            if (!op.getFacets().getb("suTenantRequired", true) && BHxSmartRefFE.isSelfUser(op)) {
                return false;
            }
            op.setReadonly(true);
            if (refList.isBound()) {
                return false;
            }
            if (!BHxSmartRefFE.isMountedOrionObject(session, op) && !BHxSmartRefFE.isMountedInComponentSpace(op)) {
                return true;
            }
        }
        return false;
    }

    public boolean process(HxOp op) throws Exception {
        if (super.process(op)) {
            return true;
        }
        if (this.chooser.process(op)) {
            return true;
        }
        if (this.summary.process(op)) {
            return true;
        }
        return this.clear.process(op);
    }

    public static BOrionDatabase getOrionDatabase(HxOp op) {
        BObject o = op.get();
        HxOp t = op;
        while (!(t.get() instanceof BIOrionDatabaseObject)) {
            o = t.get();
            t = t.getBaseOrdTarget();
        }
        return ((BIOrionDatabaseObject)t.get()).getOrionDatabase();
    }

    public Tab getDialogTab(HxOp op) {
        BAppTable table = new BAppTable();
        table.setRowType(this.getOrionTypeId(op));
        table.setResolveBase((BObject)BHxSmartRefListFE.getOrionDatabase(op));
        table.setDbOrd(BHxSmartRefListFE.getOrionDatabase(op).getAbsoluteOrd());
        HxOp fieldOp = op.make("refChooser", (BObject)table, BHxSmartTableView.makeHeightFacets((int)300));
        fieldOp.mergeFacets(op.getFacets());
        op.getRequest().setAttribute(fieldOp.scope("parentOp"), (Object)op);
        return new Tab((BHxView)BHxSmartRefListTable.INSTANCE, fieldOp);
    }

    public Tab getTestTab(HxOp op) throws Exception {
        BRefList list = this.decodeFromString(op);
        HxOp refChooserOp = op.make("refChooser", (OrdTarget)op);
        HxOp fieldOp = refChooserOp.make("test", (BObject)list, op.getFacets());
        fieldOp.mergeFacets(BFacets.make((String)"multiLine", (boolean)false));
        fieldOp.mergeFacets(BFacets.make((String)"allowNull", (boolean)false));
        fieldOp.mergeFacets(BFacets.make((String)"showPreview", (boolean)true));
        fieldOp.setReadonly(true);
        return new Tab((BHxView)INSTANCE, fieldOp);
    }

    public class Chooser
    extends SmartCommand {
        private ChooserDialog dlg;

        public Chooser(BHxView view) {
            super(view);
            this.dlg = new ChooserDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "refChooser";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean process(HxOp op) throws Exception {
            if (!this.matchesScope(op)) {
                return false;
            }
            if (super.process(op)) {
                return true;
            }
            if (BHxSmartRefListFE.this.getDialogTab(op).process()) {
                return true;
            }
            return BHxSmartRefListFE.this.getTestTab(op).process();
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            Tab tab = BHxSmartRefListFE.this.getDialogTab(op);
            BHxSmartRefListTable sView = (BHxSmartRefListTable)tab.view;
            BIOrionObject[] o = (BIOrionObject[])sView.getSubjects(tab.op);
            Tab testTab = BHxSmartRefListFE.this.getTestTab(op);
            boolean isBound = false;
            BRefList refList = (BRefList)testTab.save();
            if (o.length == 0) {
                if (testTab.op.getFormValue("handle").length() > 0) {
                    isBound = true;
                }
                BHxSmartRefListFE.setPreview(refList, op, op);
                SmartCommand.setFormValue((String)op.scope("value"), (Object)testTab.op.getFormValue("value"), (HxOp)op);
                SmartCommand.setFormValue((String)op.scope("handle"), (Object)testTab.op.getFormValue("handle"), (HxOp)op);
            } else {
                refList = BRefList.make((BRefList)refList, (BIOrionObject[])o);
                HtmlWriter out = op.getHtmlWriter();
                BHxSmartRefListFE.setPreview(refList, op, op);
                if (refList.isBound()) {
                    isBound = true;
                }
                SmartCommand.setFormValue((String)op.scope("value"), (Object)refList.encodeToString(), (HxOp)op);
                SmartCommand.setFormValue((String)op.scope("handle"), (Object)BHxSmartRefListFE.getHandles(refList, op), (HxOp)op);
            }
            if (isBound) {
                SmartCommand.show((String)op.scope("summary"), (HxOp)op);
            } else {
                SmartCommand.hide((String)op.scope("summary"), (HxOp)op);
            }
            SmartCommand.tryException((HxOp)op);
            SmartCommand.show((String)op.scope("clear"), (HxOp)op);
            SmartCommand.catchException((HxOp)op);
            BHxSmartRefFE.setModified(op);
        }

        class ChooserDialog
        extends Dialog {
            public ChooserDialog(String title, Command handler) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                BHxSmartRefListFE.this.getTestTab(op).write();
                Tab tab = BHxSmartRefListFE.this.getDialogTab(op);
                tab.write();
            }
        }
    }

    public class Hyperlink
    extends SmartCommand {
        public Hyperlink(BHxView view) {
            super(view, smartTableHxLexModule);
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public String getName(HxOp op) {
            return "hyperlink";
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(HxOp op) throws Exception {
            String value = op.getFormValue("value");
            BRefList refList = (BRefList)BRefList.NULL.decodeFromString(value);
            BIOrionObject[] o = null;
            OrionSession session = null;
            try {
                session = BHxSmartRefListFE.getOrionDatabase(op).createSession((Context)op);
                o = refList.getTargets(session);
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
            if (o == null || o[0] == null) {
                return;
            }
            BOrd ord = BOrd.make((String)("station:|" + o[0].getHandle()));
            this.redirect(op, op.toUri(ord));
        }
    }

    public class Summary
    extends SummaryCommand {
        public Summary(BHxView view) {
            super(view);
        }

        @Override
        public BObject getResolvedSubject(HxOp op) throws Exception {
            String value = op.getFormValue("value");
            BRefList refList = (BRefList)BRefList.NULL.decodeFromString(value);
            return refList;
        }
    }

    public class Clear
    extends SmartCommand {
        private ConfirmDialog dlg;

        public Clear(BHxView view) {
            super(view);
            this.dlg = new ConfirmDialog(this.getDisplayName(null), (Command)this, Lexicon.make(((Object)((Object)this)).getClass()).getText("clearRefQuestion"));
        }

        public String getName(HxOp op) {
            return "clear";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            boolean confirm = op.getFacets().getb("confirmClear", false);
            if (confirm && !this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            BRefList refList = (BRefList)op.get();
            BRefList nullRef = BRefList.make((BTypeSpec)refList.getTargetTypeSpec());
            BHxSmartRefListFE.setPreview(nullRef, op, op);
            SmartCommand.setFormValue((String)op.scope("value"), (Object)nullRef.encodeToString(), (HxOp)op);
            SmartCommand.setFormValue((String)op.scope("handle"), (Object)"", (HxOp)op);
            SmartCommand.hide((String)op.scope("summary"), (HxOp)op);
            SmartCommand.hide((String)op.scope("clear"), (HxOp)op);
            BHxSmartRefFE.setModified(op);
        }
    }
}

