/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.nrio.device.handlers.content;

import com.tridium.nrio.points.BNrio16ProxyExt;
import com.tridiumx.entsecHx.factory.handlers.ContentHandler;
import com.tridiumx.entsecHx.nrio.device.BHxNrio16PointManagerView;
import com.tridiumx.entsecHx.nrio.util.INrioLexicon;
import com.tridiumx.entsecHx.nrio.util.NrioCCPMap;
import javax.baja.control.BControlPoint;
import javax.baja.gx.BImage;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;

public class PasteIoPointsContentHandler
extends ContentHandler
implements INrioLexicon {
    @Override
    public void writeContent(HxOp op) throws Exception {
        int i;
        HtmlWriter out = op.getHtmlWriter();
        BComponent[] copyPoints = this.getCopyItems();
        BComponent[] cutPoints = this.getCutItems();
        if (copyPoints.length == 0 && cutPoints.length == 0) {
            out.w((Object)"<b>").safe(pasteNoPointsAvailableMsg, false).w((Object)"</b>");
            return;
        }
        out.w((Object)"<b>").safe(pasteIoPointsStepComment, false).w((Object)"</b><br /><br />");
        for (i = 0; i < copyPoints.length; ++i) {
            this.writeCopyEntry(i, copyPoints[i], op);
        }
        for (i = 0; i < cutPoints.length; ++i) {
            this.writeCutEntry(i, cutPoints[i], op);
        }
    }

    private BComponent[] getCopyItems() {
        NrioCCPMap map = NrioCCPMap.getMap();
        NrioCCPMap.CopyMark copyMark = map.getCopyMark();
        if (copyMark == null) {
            return new BComponent[0];
        }
        Object[] targetOrds = map.getCopyMark().objects;
        if (targetOrds == null) {
            return new BComponent[0];
        }
        Array components = new Array(BComponent.class);
        for (int i = 0; i < targetOrds.length; ++i) {
            components.add((Object)BOrd.make((String)targetOrds[i].toString()).get().asComponent());
        }
        return (BComponent[])components.trim();
    }

    private BComponent[] getCutItems() {
        NrioCCPMap map = NrioCCPMap.getMap();
        NrioCCPMap.CutMark cutMark = map.getCutMark();
        if (cutMark == null) {
            return new BComponent[0];
        }
        Object[] targetOrds = map.getCutMark().objects;
        if (targetOrds == null) {
            return new BComponent[0];
        }
        Array components = new Array(BComponent.class);
        for (int i = 0; i < targetOrds.length; ++i) {
            components.add((Object)BOrd.make((String)targetOrds[i].toString()).get().asComponent());
        }
        return (BComponent[])components.trim();
    }

    private void writeCopyEntry(int index, BComponent point, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<input ");
        out.attr("type", "checkbox");
        out.attr("name", "copyPointHandleOrd" + index);
        out.attr("value", "station:|" + point.getHandleOrd());
        out.w((Object)" />&nbsp;");
        HxUtil.makeImageJS((BImage)BImage.make((BIcon)point.getIcon()), (HxOp)op);
        out.w((Object)"&nbsp;");
        out.safe(point.getDisplayName((Context)op), false).w((Object)"&nbsp;&nbsp;(&nbsp;").safe(this.getPointCategory((BControlPoint)point, op), false).w((Object)"&nbsp;)");
        out.w((Object)"<br />");
    }

    private void writeCutEntry(int index, BComponent point, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<input ");
        out.attr("type", "checkbox");
        out.attr("name", "cutPointHandleOrd" + index);
        out.attr("value", "station:|" + point.getHandleOrd());
        out.w((Object)" />&nbsp;");
        HxUtil.makeImageJS((BImage)BImage.make((BIcon)point.getIcon()), (HxOp)op);
        out.w((Object)"&nbsp;");
        out.safe(point.getDisplayName((Context)op), false).w((Object)"&nbsp;&nbsp;(&nbsp;").safe(this.getPointCategory((BControlPoint)point, op), false).w((Object)"&nbsp;)");
        out.w((Object)"<br />");
    }

    private String getPointCategory(BControlPoint point, HxOp op) {
        return BHxNrio16PointManagerView.getExtensionType((BNrio16ProxyExt)point.getProxyExt(), op);
    }
}

