/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.nrio.device;

import com.tridium.nrio.points.BNrio16ProxyExt;
import com.tridium.nrio.points.BNrioBooleanInputProxyExt;
import com.tridium.nrio.points.BNrioCounterInputProxyExt;
import com.tridium.nrio.points.BNrioRelayOutputProxyExt;
import com.tridium.nrio.points.BNrioResistiveInputProxyExt;
import com.tridium.nrio.points.BNrioVoltageInputProxyExt;
import com.tridium.nrio.points.BNrioVoltageOutputProxyExt;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsecHx.factory.SmartCommandArray;
import com.tridiumx.entsecHx.factory.device.BHxGenericManagerView;
import com.tridiumx.entsecHx.factory.handlers.StepHandler;
import com.tridiumx.entsecHx.nrio.commands.ModuleHyperlinkCommand;
import com.tridiumx.entsecHx.nrio.device.BHxNrio16ManageDeviceHyperlinks;
import com.tridiumx.entsecHx.nrio.device.handlers.command.ConfigureIoPointCommandHandler;
import com.tridiumx.entsecHx.nrio.device.handlers.command.CopyIoPointsCommandHandler;
import com.tridiumx.entsecHx.nrio.device.handlers.command.CutIoPointsCommandHandler;
import com.tridiumx.entsecHx.nrio.device.handlers.command.DeleteIoPointsCommandHandler;
import com.tridiumx.entsecHx.nrio.device.handlers.command.PasteIoPointsCommandHandler;
import com.tridiumx.entsecHx.nrio.device.handlers.command.RenameIoPointCommandHandler;
import com.tridiumx.entsecHx.nrio.device.handlers.content.ConfigureIoPointContentHandler;
import com.tridiumx.entsecHx.nrio.device.handlers.content.CopyIoPointsContentHandler;
import com.tridiumx.entsecHx.nrio.device.handlers.content.CutIoPointsContentHandler;
import com.tridiumx.entsecHx.nrio.device.handlers.content.DeleteIoPointsContentHandler;
import com.tridiumx.entsecHx.nrio.device.handlers.content.PasteIoPointsContentHandler;
import com.tridiumx.entsecHx.nrio.device.handlers.content.RenameIoPointContentHandler;
import com.tridiumx.entsecHx.nrio.device.handlers.content.SelectIoPointContentHandler;
import com.tridiumx.entsecHx.nrio.device.handlers.content.SelectIoTypeContentHander;
import com.tridiumx.entsecHx.nrio.device.handlers.step.ConfigureIoPointStepHandler;
import com.tridiumx.entsecHx.nrio.device.handlers.step.CopyIoPointsStepHandler;
import com.tridiumx.entsecHx.nrio.device.handlers.step.CutIoPointsStepHandler;
import com.tridiumx.entsecHx.nrio.device.handlers.step.DeleteIoPointsStepHandler;
import com.tridiumx.entsecHx.nrio.device.handlers.step.ManageIoPointsStepHandler;
import com.tridiumx.entsecHx.nrio.device.handlers.step.PasteIoPointsStepHandler;
import com.tridiumx.entsecHx.nrio.device.handlers.step.RenameIoPointStepHandler;
import com.tridiumx.entsecHx.nrio.device.handlers.step.SelectIoPointStepHandler;
import com.tridiumx.entsecHx.nrio.device.handlers.step.SelectIoTypeStepHandler;
import com.tridiumx.entsecHx.nrio.util.INrioLexicon;
import com.tridiumx.entsecHx.nrio.util.INrioPointCategories;
import com.tridiumx.entsecHx.securityUtilHx.manager.BHxManageDeviceHyperlinks;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.BTypeSpec;

@NiagaraType(agent={@AgentOn(types={"nrio:Nrio16Points"}, app="entsec", requiredPermissions="rR")})
@NiagaraSingleton
public class BHxNrio16PointManagerView
extends BHxGenericManagerView
implements INrioLexicon,
INrioPointCategories {
    public static final BHxNrio16PointManagerView INSTANCE = new BHxNrio16PointManagerView();
    public static final Type TYPE = Sys.loadType(BHxNrio16PointManagerView.class);
    private StepHandler managePointsStepHandler;
    private StepHandler selectIoTypeStepHandler;
    private StepHandler selectIoPointStepHandler;
    private StepHandler configurePointStepHandler;
    private StepHandler renamePointStepHandler;
    private StepHandler deleteIoPointsStepHandler;
    private StepHandler cutIoPointsStepHandler;
    private StepHandler copyIoPointsStepHandler;
    private StepHandler pasteIoPointsStepHandler;
    private SmartCommand moduleHyperlinkCommand;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BHxNrio16PointManagerView() {
        this.setupPointManagement();
        this.setupPointAddition();
        this.setupPointRenaming();
        this.setupPointDeletion();
        this.setupPointCutting();
        this.setupPointCopying();
        this.setupPointPasting();
        this.sequenceSteps();
        this.registerHandlers();
        this.moduleHyperlinkCommand = new ModuleHyperlinkCommand((BHxView)this);
        this.registerEvent((Event)this.moduleHyperlinkCommand);
    }

    public void write(HxOp op) throws Exception {
        op.setDynamic();
        super.write(op);
    }

    public void update(HxOp op) throws Exception {
        super.update(op);
    }

    @Override
    public BHxManageDeviceHyperlinks getHyperlinkView(BTypeSpec typeSpec, HxOp op) throws Exception {
        return BHxNrio16ManageDeviceHyperlinks.INSTANCE;
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        return SmartCommandArray.make(super.getButtonCommands(op)).appendBack(this.moduleHyperlinkCommand);
    }

    public static void writeTypeHyperlinks(BComponent parent, Type type, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        Object[] devices = parent.getChildren(type.getTypeClass());
        for (int i = 0; i < devices.length; ++i) {
            BControlPoint controlPoint = (BControlPoint)devices[i];
            if (Flags.isHidden((BComplex)controlPoint.getParent(), (Slot)controlPoint.getPropertyInParent())) continue;
            BNrio16ProxyExt ext = (BNrio16ProxyExt)controlPoint.getProxyExt();
            out.w((Object)"<tr>");
            out.w((Object)"<td class='smartTable-setup-label'>");
            out.w((Object)BHxNrio16PointManagerView.getExtensionType(ext, op));
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)BHxNrio16PointManagerView.getInstanceAndStatusValue(ext, op));
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            HxUtil.makeImageJS((BImage)BImage.make((BIcon)controlPoint.getIcon()), (HxOp)op);
            String childLink = "station:|" + controlPoint.getSlotPathOrd();
            out.w((Object)" ").w((Object)"<a href='").w((Object)childLink).w((Object)"'>");
            HxTabUtil.safeString((HtmlWriter)out, (Object)controlPoint.getDisplayName((Context)op));
            out.w((Object)"</a>");
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
        }
    }

    public static String getExtensionType(BNrio16ProxyExt ext, HxOp op) {
        Type type = ext.getType();
        if (type.is(BNrioVoltageInputProxyExt.TYPE)) {
            return TextUtil.toFriendly((String)"voltageInput");
        }
        if (type.is(BNrioResistiveInputProxyExt.TYPE)) {
            UnitDatabase db = UnitDatabase.getDefault();
            BFacets pointFacets = ext.getPointFacets();
            if (pointFacets.get("units") == null) {
                return TextUtil.toFriendly((String)"unknownType");
            }
            BUnit units = (BUnit)pointFacets.get("units");
            UnitDatabase.Quantity quantity = db.getQuantity(units);
            if (quantity.getName().equals("electric resistance")) {
                return TextUtil.toFriendly((String)"resistiveInput");
            }
            return TextUtil.toFriendly((String)"temperatureInput");
        }
        if (type.is(BNrioBooleanInputProxyExt.TYPE)) {
            return TextUtil.toFriendly((String)"digitalInput");
        }
        if (type.is(BNrioCounterInputProxyExt.TYPE)) {
            return TextUtil.toFriendly((String)"highSpeedCounter");
        }
        if (type.is(BNrioVoltageOutputProxyExt.TYPE)) {
            return TextUtil.toFriendly((String)"voltageOutput");
        }
        if (type.is(BNrioRelayOutputProxyExt.TYPE)) {
            return TextUtil.toFriendly((String)"relayOutput");
        }
        return ext.getParent().getDisplayName((Context)op);
    }

    private static String getInstanceAndStatusValue(BNrio16ProxyExt ext, HxOp op) {
        BControlPoint cp = ext.getParentPoint();
        String ioDescription = null;
        String spanId = null;
        if (cp instanceof BBooleanPoint && !(cp instanceof BBooleanWritable) || cp instanceof BNumericPoint && !(cp instanceof BNumericWritable)) {
            ioDescription = universalInput + " " + ext.getInstance();
            spanId = "ui" + ext.getInstance();
        } else if (cp instanceof BBooleanWritable) {
            ioDescription = relayOutput + " " + ext.getInstance();
            spanId = "ro" + ext.getInstance();
        } else {
            ioDescription = analogOutput + " " + ext.getInstance();
            spanId = "ao" + ext.getInstance();
        }
        return "<b>[ " + ioDescription + " : <span id='" + spanId + "'>" + cp + "</span> ]</b>";
    }

    @Override
    public Tab[] getTabs(HxOp op) throws Exception {
        Tab[] tabs = super.getTabs(op);
        for (int i = 0; i < tabs.length; ++i) {
            if (tabs[i].title.equals("Boolean Points")) {
                tabs[i].title = booleanPointsTabTitle;
                continue;
            }
            if (!tabs[i].title.equals("Numeric Points")) continue;
            tabs[i].title = numericPointsTabTitle;
        }
        return tabs;
    }

    public String getPageTitle(HxOp op) throws Exception {
        return pointManagerPageTitle;
    }

    @Override
    protected String getManagerCommandDisplayName() {
        return pointManagerManageCmdLabel;
    }

    @Override
    protected BIcon getManagerCommandIcon() {
        return BIcon.std((String)pointManagerManageCmdIcon);
    }

    private void setupPointManagement() {
        this.managePointsStepHandler = new ManageIoPointsStepHandler(this);
    }

    private void setupPointAddition() {
        this.selectIoTypeStepHandler = new SelectIoTypeStepHandler(this);
        this.selectIoTypeStepHandler.registerContentHandler(new SelectIoTypeContentHander());
        this.selectIoPointStepHandler = new SelectIoPointStepHandler(this);
        this.selectIoPointStepHandler.registerContentHandler(new SelectIoPointContentHandler());
        this.configurePointStepHandler = new ConfigureIoPointStepHandler(this);
        this.configurePointStepHandler.registerContentHandler(new ConfigureIoPointContentHandler()).registerCommandHandler(new ConfigureIoPointCommandHandler((BHxView)this));
    }

    private void setupPointRenaming() {
        this.renamePointStepHandler = new RenameIoPointStepHandler(this);
        this.renamePointStepHandler.registerContentHandler(new RenameIoPointContentHandler()).registerCommandHandler(new RenameIoPointCommandHandler((BHxView)this));
    }

    private void setupPointDeletion() {
        this.deleteIoPointsStepHandler = new DeleteIoPointsStepHandler(this);
        this.deleteIoPointsStepHandler.registerContentHandler(new DeleteIoPointsContentHandler()).registerCommandHandler(new DeleteIoPointsCommandHandler((BHxView)this));
    }

    private void setupPointCutting() {
        this.cutIoPointsStepHandler = new CutIoPointsStepHandler(this);
        this.cutIoPointsStepHandler.registerContentHandler(new CutIoPointsContentHandler()).registerCommandHandler(new CutIoPointsCommandHandler((BHxView)this));
    }

    private void setupPointCopying() {
        this.copyIoPointsStepHandler = new CopyIoPointsStepHandler(this);
        this.copyIoPointsStepHandler.registerContentHandler(new CopyIoPointsContentHandler()).registerCommandHandler(new CopyIoPointsCommandHandler((BHxView)this));
    }

    private void setupPointPasting() {
        this.pasteIoPointsStepHandler = new PasteIoPointsStepHandler(this);
        this.pasteIoPointsStepHandler.registerContentHandler(new PasteIoPointsContentHandler()).registerCommandHandler(new PasteIoPointsCommandHandler((BHxView)this));
    }

    private void sequenceSteps() {
        this.managePointsStepHandler.addNextStep(this.selectIoTypeStepHandler).addNextStep(this.renamePointStepHandler).addNextStep(this.deleteIoPointsStepHandler).addNextStep(this.cutIoPointsStepHandler).addNextStep(this.copyIoPointsStepHandler).addNextStep(this.pasteIoPointsStepHandler);
        this.selectIoTypeStepHandler.addNextStep(this.selectIoPointStepHandler);
        this.selectIoPointStepHandler.addNextStep(this.configurePointStepHandler);
    }

    private void registerHandlers() {
        this.registerStepHandler(this.managePointsStepHandler);
        this.registerStepHandler(this.selectIoTypeStepHandler);
        this.registerStepHandler(this.selectIoPointStepHandler);
        this.registerStepHandler(this.configurePointStepHandler);
        this.registerStepHandler(this.renamePointStepHandler);
        this.registerStepHandler(this.deleteIoPointsStepHandler);
        this.registerStepHandler(this.cutIoPointsStepHandler);
        this.registerStepHandler(this.copyIoPointsStepHandler);
        this.registerStepHandler(this.pasteIoPointsStepHandler);
    }
}

