/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.nrio.commands;

import com.tridium.nrio.BNrio16Module;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class ModuleHyperlinkCommand
extends SmartCommand {
    private Dialog dlg = new ModuleHyperlinkDialog(Lexicon.make((String)"entsecHx").getText("nrio16.goToModule.label"), (Command)this);

    public ModuleHyperlinkCommand(BHxView view) {
        super(view);
    }

    public String getName(HxOp op) {
        return "nrio16.goToModule";
    }

    public BCommandEnablePolicy getEnablePolicy() {
        return BCommandEnablePolicy.always;
    }

    public boolean readonlyEnablePolicy(HxOp op) {
        return true;
    }

    public void handle(HxOp op) throws Exception {
        super.handle(op);
        if (!this.dlg.isSubmit(op)) {
            this.dlg.open(op);
            return;
        }
        this.redirect(op, op.getFormValue("hyperlinkUri"));
    }

    private BComponent getParentComponent(Type parentType, HxOp op) throws Exception {
        BComponent component = op.getComponent();
        while (!component.getType().is(parentType)) {
            component = component.getParent();
        }
        return component.asComponent();
    }

    private class ModuleHyperlinkDialog
    extends Dialog {
        public ModuleHyperlinkDialog(String title, Command handler) {
            super(title, handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            super.writeContent(op);
            Object[] modules = ModuleHyperlinkCommand.this.getParentComponent(BNrioNetwork.TYPE, op).getChildren(BNrio16Module.class);
            BComponent currentModule = ModuleHyperlinkCommand.this.getParentComponent(BNrio16Module.TYPE, op);
            HtmlWriter out = op.getHtmlWriter();
            HxTabUtil.startTable((HtmlWriter)out, (HxOp)op);
            HxTabUtil.startRow((HtmlWriter)out, (HxOp)op);
            out.w((Object)"Go to: ");
            HxTabUtil.nextColumn((HtmlWriter)out, (HxOp)op);
            out.w((Object)"<select ");
            out.attr("name", op.scope("hyperlinkUri"));
            out.w((Object)">");
            for (int i = 0; i < modules.length; ++i) {
                BNrio16Module module = (BNrio16Module)modules[i];
                if (module == currentModule) continue;
                out.w((Object)"<option ");
                if (op.get().getType().is(BNrio16Module.TYPE)) {
                    out.attr("value", op.toUri(module.getOrdInSession()));
                } else {
                    out.attr("value", op.toUri(module.getPoints().getOrdInSession()));
                }
                out.w((Object)">");
                out.safe((Object)module.getDisplayName((Context)op));
                out.w((Object)"</option>");
            }
            out.w((Object)"</select>");
            HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
            HxTabUtil.endTable((HtmlWriter)out, (HxOp)op);
        }
    }
}

