/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.ldapHx.ui.searchfilter;

import com.tridium.smartTableHx.TableContents;
import com.tridiumx.entsecHx.ldapHx.ui.searchfilter.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BLdapSearchFilter
extends BComponent {
    public static final Type TYPE = Sys.loadType(BLdapSearchFilter.class);
    private List<BLdapSearchFilter> searchFilters;
    private BLdapSearchFilter parentFilter;
    private String joinOperator;
    private String depthIndexId;
    private static final String SEARCH_ALL = "(objectclass=*)";
    public static final Lexicon lex = Lexicon.make(BLdapSearchFilter.class);

    public Type getType() {
        return TYPE;
    }

    private BLdapSearchFilter(String joinOperator) {
        this.joinOperator = joinOperator;
        this.searchFilters = new ArrayList<BLdapSearchFilter>();
    }

    public static BLdapSearchFilter getInstance() throws Exception {
        return BLdapSearchFilter.getInstance(SEARCH_ALL);
    }

    public static BLdapSearchFilter getInstance(String searchFilterString) throws Exception {
        return BLdapSearchFilter.getInstance(searchFilterString, "-1");
    }

    public static BLdapSearchFilter getInstance(String searchFilterString, String depthIndexId) throws Exception {
        if (searchFilterString == null || searchFilterString.trim().equals("")) {
            return new BLdapSearchFilter(searchFilterString);
        }
        BLdapSearchFilter searchFilterGroup = null;
        searchFilterString = Utils.clearEnclosingBraces(searchFilterString);
        List<String> tempSearchFilterStrings = Utils.getImmediateSubFilters(searchFilterString.substring(0));
        searchFilterGroup = new BLdapSearchFilter(tempSearchFilterStrings.get(0));
        int startIndex = 1;
        searchFilterGroup.setDepthIndexId(BLdapSearchFilter.generateDepthIndexId(depthIndexId));
        if (searchFilterGroup != null) {
            for (int i = startIndex; i < tempSearchFilterStrings.size(); ++i) {
                String tempDepthIndexId = BLdapSearchFilter.generateDepthIndexId(depthIndexId) + "." + (i - 2);
                BLdapSearchFilter tempFilter = BLdapSearchFilter.getInstance(tempSearchFilterStrings.get(i), tempDepthIndexId);
                searchFilterGroup.addFilter(tempFilter);
            }
        }
        return searchFilterGroup;
    }

    private static String generateDepthIndexId(String depthIndexId) {
        String returnValue = null;
        if (depthIndexId.indexOf(".") == -1) {
            returnValue = String.valueOf(Integer.valueOf(depthIndexId) + 1);
        } else {
            int indexOfLastDot = depthIndexId.lastIndexOf(".");
            String deptIndexPrefix = depthIndexId.substring(0, indexOfLastDot + 1);
            int nextIndex = Integer.valueOf(depthIndexId.substring(indexOfLastDot + 1)) + 1;
            returnValue = deptIndexPrefix + nextIndex;
        }
        return returnValue;
    }

    public String getJoinOperator() {
        return this.joinOperator;
    }

    public void setJoinOperator(String joinOperator) {
        this.joinOperator = joinOperator;
    }

    public String getDepthIndexId() {
        return this.depthIndexId;
    }

    public void setDepthIndexId(String depthIndexId) {
        this.depthIndexId = depthIndexId;
    }

    public boolean isUnaryJoinOperator() {
        return Utils.isUnaryOperator(this.joinOperator);
    }

    public List<BLdapSearchFilter> getSearchFilters() {
        return this.searchFilters;
    }

    public void removeFilter(BLdapSearchFilter searchFilter) {
        this.searchFilters.remove((Object)searchFilter);
        this.buildDepthIndices();
    }

    public void buildDepthIndices() {
        BLdapSearchFilter searchFilter = null;
        for (int i = 0; i < this.searchFilters.size(); ++i) {
            searchFilter = this.searchFilters.get(i);
            searchFilter.setDepthIndexId(this.depthIndexId + "." + i);
            searchFilter.buildDepthIndices();
        }
    }

    public void removeFilter(String depthIndexId) {
        int startIndex = depthIndexId.indexOf(this.depthIndexId);
        if (startIndex == -1) {
            throw new BajaRuntimeException(lex.getText("searchfilter.inavalid.childnode", new Object[]{depthIndexId}));
        }
        if (depthIndexId.equals("0")) {
            if (this.joinOperator.trim().equals(SEARCH_ALL)) {
                throw new BajaRuntimeException(this.getLexicon().getText("searchfilter.delete.default.root.node"));
            }
            this.joinOperator = SEARCH_ALL;
            this.searchFilters.clear();
            return;
        }
        depthIndexId = depthIndexId.substring(startIndex + 2);
        BLdapSearchFilter prevFilter = null;
        List<BLdapSearchFilter> prevSubFilters = null;
        BLdapSearchFilter nextFilter = this;
        List<BLdapSearchFilter> nextSubFilters = this.searchFilters;
        String[] indices = depthIndexId.split("\\.");
        boolean isParentNonUnaryOperator = false;
        for (int i = 0; i < indices.length; ++i) {
            int nextElementIndex = Integer.valueOf(indices[i]);
            if (nextElementIndex >= nextSubFilters.size()) {
                throw new BajaRuntimeException(lex.getText("searchfilter.delete.invalid.index"));
            }
            prevFilter = nextFilter;
            prevSubFilters = nextSubFilters;
            nextFilter = nextSubFilters.get(nextElementIndex);
            nextSubFilters = nextFilter.getSearchFilters();
        }
        if (prevSubFilters != null && prevSubFilters.contains((Object)nextFilter)) {
            prevFilter.removeFilter(nextFilter);
        }
    }

    public boolean validate() throws Exception {
        boolean returnValue;
        block1: {
            BLdapSearchFilter searchFilter;
            returnValue = this.isCurrentFilterValid();
            if (!returnValue) break block1;
            Iterator<BLdapSearchFilter> iterator = this.getSearchFilters().iterator();
            while (iterator.hasNext() && (returnValue = (searchFilter = iterator.next()).validate())) {
            }
        }
        return returnValue;
    }

    private boolean isCurrentFilterValid() throws Exception {
        boolean returnValue = false;
        returnValue = Utils.isUnaryOperator(this.getJoinOperator()) ? this.getSearchFilters().size() == 1 : (Utils.isOperator(this.getJoinOperator()) ? this.getSearchFilters().size() >= 2 : (!this.getDepthIndexId().equals("0") ? Utils.isOperator(this.getParentFilter().getJoinOperator()) : true));
        return returnValue;
    }

    public TableContents makeSmartTableContents(String tableId, TableContents contents) throws Exception {
        TableContents.Tr tr = new TableContents.Tr();
        tr.id = this.getDepthIndexId();
        TableContents.Td item = new TableContents.Td(this.getPrintableStringWithPadding(this.joinOperator));
        if (!this.isCurrentFilterValid()) {
            item.additionalClassName = "row-fault";
        }
        tr.td.add(item);
        contents.tr.add(tr);
        BLdapSearchFilter ldapSearchFilter = null;
        for (int i = 0; i < this.searchFilters.size(); ++i) {
            ldapSearchFilter = this.searchFilters.get(i);
            ldapSearchFilter.makeSmartTableContents(tableId, contents);
        }
        return contents;
    }

    private String getPrintableStringWithPadding(String joinOperator) {
        StringBuilder returnValue = new StringBuilder();
        int noOfPaddingSpaces = this.getDepthIndexId().split("\\.").length;
        for (int i = 1; i < noOfPaddingSpaces; ++i) {
            returnValue.append(" >      ");
        }
        returnValue.append(joinOperator);
        return returnValue.toString();
    }

    public String getPrintFormattedString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        if (this.joinOperator != null) {
            builder.append(this.joinOperator);
        }
        for (BLdapSearchFilter ldapSearchFilter : this.searchFilters) {
            builder.append(ldapSearchFilter.getPrintFormattedString());
        }
        builder.append(")");
        return builder.toString();
    }

    public BLdapSearchFilter getParentFilter() throws Exception {
        return this.parentFilter;
    }

    public void setParentFilter(BLdapSearchFilter parentFilter) throws Exception {
        this.parentFilter = parentFilter;
    }

    public BLdapSearchFilter locateSubFilterByDepthIndex(String depthIndexId) {
        String[] indices = depthIndexId.split("\\.");
        int firstIndexOfDot = depthIndexId.indexOf(".");
        if (indices.length == 1) {
            return this;
        }
        int nextElementIndex = Integer.valueOf(indices[1]);
        if (nextElementIndex >= this.getSearchFilters().size()) {
            throw new BajaRuntimeException(lex.getText("searchfilter.delete.invalid.index"));
        }
        return this.getSearchFilters().get(nextElementIndex).locateSubFilterByDepthIndex(depthIndexId.substring(firstIndexOfDot + 1));
    }

    public void addFilter(BLdapSearchFilter searchFilter) throws Exception {
        searchFilter.setParentFilter(this);
        this.getSearchFilters().add(searchFilter);
        this.buildDepthIndices();
    }

    public boolean checkIfEmpty() {
        boolean returnValue = false;
        if (this.getDepthIndexId() == null || this.getJoinOperator() == null || this.getJoinOperator().isEmpty()) {
            returnValue = true;
        }
        return returnValue;
    }
}

