/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.ldapHx.ui.searchfilter;

import com.tridium.hx.ErrorDialog;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.SaveCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.TableContents;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridiumx.entsecHx.ldapHx.ui.searchfilter.BHxLdapSearchFilterFE;
import com.tridiumx.entsecHx.ldapHx.ui.searchfilter.BLdapSearchFilter;
import com.tridiumx.entsecHx.ldapHx.ui.searchfilter.util.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraSingleton
public class BHxLdapUserSearchQueryBuilderView
extends BHxSmartTableView {
    public static final BHxLdapUserSearchQueryBuilderView INSTANCE = new BHxLdapUserSearchQueryBuilderView();
    public static final Type TYPE = Sys.loadType(BHxLdapUserSearchQueryBuilderView.class);
    public static final Lexicon lex = Lexicon.make(BHxLdapUserSearchQueryBuilderView.class);
    private SmartCommand addFilter = new AddCommand(this);
    private SmartCommand deleteFilter;
    private SmartCommand editFilter;

    public Type getType() {
        return TYPE;
    }

    protected BHxLdapUserSearchQueryBuilderView() {
        this.registerEvent((Event)this.addFilter);
        this.deleteFilter = new DeleteCommand(this);
        this.registerEvent((Event)this.deleteFilter);
        this.editFilter = new EditCommand(this);
        this.registerEvent((Event)this.editFilter);
    }

    public SmartCommand[] getButtonCommands(HxOp hxOp) {
        return new SmartCommand[]{this.addFilter, this.editFilter, this.deleteFilter};
    }

    public BComponent getComponent(HxOp op) throws Exception {
        return BHxLdapSearchFilterFE.getLdapSearchFilterComponent(op);
    }

    public void write(HxOp hxOp) throws Exception {
        super.write(hxOp);
    }

    public void writeTableHeader(HxOp hxOp) throws Exception {
        HtmlWriter out = hxOp.getHtmlWriter();
        out.w((Object)"<th>");
        out.safe((Object)"Search Filter String");
        out.w((Object)"</th>");
    }

    public TableContents writeContents(HxOp hxOp) throws Exception {
        TableContents contents = new TableContents(hxOp.scope("records"));
        contents.writeSafe = true;
        BLdapSearchFilter searchFilter = BHxLdapSearchFilterFE.getLdapSearchFilterComponent(hxOp);
        return searchFilter.makeSmartTableContents(hxOp.scope("records"), contents);
    }

    private class EditCommand
    extends SearchFilterCommand {
        public EditCommand(BHxLdapUserSearchQueryBuilderView bLdapUserSearchQueryBuilderView) {
            super(bLdapUserSearchQueryBuilderView);
        }

        public String getName(HxOp hxOp) {
            return "edit";
        }

        @Override
        protected void execute(HxOp hxOp, String[] selectedItems, SearchFilterCommand searchFilterCommand) throws Exception {
            String relativeDepthIndexOfSelectedFilterComponent;
            String joinOperator = hxOp.getFormValue("joinOperator");
            String expression = this.getNewExpressionFromTheWizard(hxOp, joinOperator, searchFilterCommand);
            BLdapSearchFilter ldapSearchFilterComponent = BHxLdapSearchFilterFE.getLdapSearchFilterComponent(hxOp);
            BLdapSearchFilter selectedFilterComponent = ldapSearchFilterComponent.locateSubFilterByDepthIndex(selectedItems[0]);
            String depthIndexOfSelectedFilterComponent = selectedFilterComponent.getDepthIndexId();
            BLdapSearchFilter parentForSelectedFilterComponent = selectedFilterComponent.getParentFilter();
            if (parentForSelectedFilterComponent == null) {
                parentForSelectedFilterComponent = ldapSearchFilterComponent;
            }
            String string = relativeDepthIndexOfSelectedFilterComponent = (relativeDepthIndexOfSelectedFilterComponent = depthIndexOfSelectedFilterComponent.replaceFirst(parentForSelectedFilterComponent.getDepthIndexId(), "")).startsWith(".") ? relativeDepthIndexOfSelectedFilterComponent.substring(1) : relativeDepthIndexOfSelectedFilterComponent;
            if (Utils.isOperator(expression) && Utils.isOperator(selectedFilterComponent.getJoinOperator()) && selectedFilterComponent.getSearchFilters().size() != 0) {
                selectedFilterComponent.setJoinOperator(expression);
            } else {
                BLdapSearchFilter newSubFilter = BLdapSearchFilter.getInstance(expression);
                if (!selectedItems[0].equals("0")) {
                    newSubFilter.setParentFilter(ldapSearchFilterComponent.locateSubFilterByDepthIndex(selectedItems[0]).getParentFilter());
                    ldapSearchFilterComponent.removeFilter(selectedItems[0]);
                    parentForSelectedFilterComponent.getSearchFilters().add(Integer.valueOf(relativeDepthIndexOfSelectedFilterComponent), newSubFilter);
                    parentForSelectedFilterComponent.buildDepthIndices();
                } else {
                    BHxLdapSearchFilterFE.setLdapSearchFilterComponent(newSubFilter, hxOp);
                    ldapSearchFilterComponent = newSubFilter;
                }
            }
            this.saveChangesAndReloadTable(hxOp, ldapSearchFilterComponent);
        }
    }

    private class DeleteCommand
    extends SmartCommand {
        public DeleteCommand(BHxLdapUserSearchQueryBuilderView bLdapUserSearchQueryBuilderView) {
            super((BHxView)bLdapUserSearchQueryBuilderView);
        }

        public String getName(HxOp hxOp) {
            return "delete";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public void handle(HxOp hxOp) throws Exception {
            String[] selectedItems = DeleteCommand.getSelectionList((HxOp)hxOp);
            BLdapSearchFilter searchFilter = BHxLdapSearchFilterFE.getLdapSearchFilterComponent(hxOp);
            try {
                searchFilter.removeFilter(selectedItems[0]);
                SaveCommand.setModified((HxOp)hxOp);
                BHxLdapSearchFilterFE.setLdapSearchFilterComponent(searchFilter, hxOp);
                BHxLdapUserSearchQueryBuilderView.this.reloadTable(hxOp);
            }
            catch (BajaRuntimeException e) {
                new ErrorDialog("Cannot Delete", (Throwable)e).open(hxOp);
            }
        }
    }

    private class AddCommand
    extends SearchFilterCommand {
        public AddCommand(BHxLdapUserSearchQueryBuilderView bLdapUserSearchQueryBuilderView) {
            super(bLdapUserSearchQueryBuilderView);
        }

        public String getName(HxOp hxOp) {
            return "add";
        }

        @Override
        protected void execute(HxOp hxOp, String[] selectedItems, SearchFilterCommand searchFilterCommand) throws Exception {
            String joinOperator = hxOp.getFormValue("joinOperator");
            String expression = this.getNewExpressionFromTheWizard(hxOp, joinOperator, searchFilterCommand);
            BLdapSearchFilter newSubFilter = BLdapSearchFilter.getInstance(expression);
            BLdapSearchFilter ldapSearchFilterComponent = BHxLdapSearchFilterFE.getLdapSearchFilterComponent(hxOp);
            if (ldapSearchFilterComponent.getJoinOperator().equals("*")) {
                ldapSearchFilterComponent = newSubFilter;
                ldapSearchFilterComponent.buildDepthIndices();
            } else {
                BLdapSearchFilter selectedFilterComponent = ldapSearchFilterComponent.locateSubFilterByDepthIndex(selectedItems[0]);
                if (!Utils.isOperator(selectedFilterComponent.getJoinOperator())) {
                    throw new BajaRuntimeException(this.lexModule.getText("searchfilter.add.error.parent.not.operator", (Context)hxOp));
                }
                selectedFilterComponent = this.getOperator(hxOp, selectedFilterComponent);
                if (searchFilterCommand == null) {
                    ldapSearchFilterComponent.addFilter(newSubFilter);
                }
                selectedFilterComponent.addFilter(newSubFilter);
            }
            this.saveChangesAndReloadTable(hxOp, ldapSearchFilterComponent);
        }

        private BLdapSearchFilter getOperator(HxOp hxOp, BLdapSearchFilter selectedFilterComponent) throws Exception {
            BLdapSearchFilter returnValue = Utils.isOperator(selectedFilterComponent.getJoinOperator()) ? selectedFilterComponent : selectedFilterComponent.getParentFilter();
            return returnValue;
        }
    }

    abstract class SearchFilterCommand
    extends SmartCommand {
        private SearchWizardDialog dlg;

        public SearchFilterCommand(BHxLdapUserSearchQueryBuilderView view) {
            super((BHxView)view);
            this.dlg = new SearchWizardDialog(this.getDisplayName(null), (Command)this);
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public void handle(HxOp hxOp) throws Exception {
            String[] selectedItems = SearchFilterCommand.getSelectionList((HxOp)hxOp);
            if (!this.dlg.isSubmit(hxOp)) {
                this.dlg.open(hxOp);
                return;
            }
            try {
                this.execute(hxOp, selectedItems, this);
            }
            catch (BajaRuntimeException e) {
                new ErrorDialog("Search filter", (Throwable)e).open(hxOp);
                return;
            }
        }

        protected abstract void execute(HxOp var1, String[] var2, SearchFilterCommand var3) throws Exception;

        protected void saveChangesAndReloadTable(HxOp hxOp, BLdapSearchFilter ldapSearchFilterComponent) throws Exception {
            SaveCommand.setModified((HxOp)hxOp);
            BHxLdapSearchFilterFE.setLdapSearchFilterComponent(ldapSearchFilterComponent, hxOp);
            BHxLdapUserSearchQueryBuilderView.this.reloadTable(hxOp);
        }

        protected String getNewExpressionFromTheWizard(HxOp hxOp, String joinOperator, SearchFilterCommand searchFilterCommand) {
            String expression;
            if (joinOperator.equals("Expression")) {
                expression = hxOp.getFormValue("searchFilterExpression");
                if (expression == null || expression.trim().length() == 0) {
                    throw new BajaRuntimeException(this.lexModule.getText("searchfilter.error.expression.value.empty", (Context)hxOp));
                }
            } else {
                expression = joinOperator;
            }
            return expression;
        }

        class SearchWizardDialog
        extends Dialog {
            public SearchWizardDialog(String title, Command handler) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                op.setDynamic();
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)"<table>");
                out.w((Object)"<tr>");
                out.w((Object)"<td align='center' colspan='2' align='center' class='smartTable-header'>");
                ArrayList<String> attributes = new ArrayList<String>();
                attributes.addAll(Utils.getOperatorKeys());
                attributes.add("Expression");
                this.writeDropDown(op, "joinOperator", attributes, this.getOnChangeHandler(op), false);
                out.w((Object)"</td>");
                out.w((Object)"</tr>");
                out.w((Object)"</table>");
                out.w((Object)"<table>");
                out.w((Object)"<tr>");
                out.w((Object)"<td align='right' class='smartTable-setup-label '>");
                out.safe((Object)SearchFilterCommand.this.lexModule.getText("searchfilter.label", (Context)op));
                out.w((Object)"&nbsp;&nbsp;&nbsp;");
                out.w((Object)"</td>");
                out.w((Object)"<td align='left' class='smartTable-header'>");
                out.w((Object)"<input ");
                out.w((Object)"disabled ");
                out.attr("id", "searchFilterExpression");
                out.attr("type", "text");
                HxTabUtil.scope((String)"searchFilterExpression", (HtmlWriter)out, (HxOp)op);
                out.attr("searchFilterExpression", "");
                out.w((Object)"/>");
                out.w((Object)"</td>");
                out.w((Object)"</tr>");
                out.w((Object)"</table>");
            }

            private void writeDropDown(HxOp op, String id, List<String> options, String onChangeHandler, boolean isDisabled) throws IOException {
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)"<select ").attr("name", op.scope(id));
                if (isDisabled) {
                    out.w((Object)"disabled ");
                }
                out.attr("id", id);
                if (onChangeHandler != null) {
                    out.attr("onchange", this.getOnChangeHandler(op));
                }
                out.w((Object)">");
                for (int i = 0; i < options.size(); ++i) {
                    out.w((Object)"<option value='").w((Object)options.get(i)).w((Object)"'");
                    out.w((Object)" id='").w((Object)op.scope("add")).w((Object)"'");
                    out.w((Object)">");
                    out.w((Object)options.get(i));
                    out.w((Object)"</option>");
                }
                out.w((Object)"</select>");
            }

            private String getOnChangeHandler(HxOp op) {
                StringBuilder onChange = new StringBuilder();
                onChange.append("(                                                                            ");
                onChange.append("   function(){                                                               ");
                onChange.append("     var x = document.getElementById('joinOperator').value;                  ");
                onChange.append("     var disableFlag = (x=='Expression') ? false : true;                     ");
                onChange.append("     document.getElementById('searchFilterExpression').disabled=disableFlag; ");
                onChange.append("   }                                                                         ");
                onChange.append(")                                                                            ");
                onChange.append("()                                                                           ");
                return onChange.toString();
            }
        }
    }
}

