/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.ldapHx.join;

import com.tridium.hx.progress.HxProgressJobDialog;
import com.tridium.hx.util.HxUtils;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.SmartCommand;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.ldap.BLdapAttributeProperties;
import com.tridiumx.entsec.ldap.BLdapJoinAllJob;
import com.tridiumx.entsec.ldap.util.ExportPersonsDataUtility;
import com.tridiumx.entsecHx.access.BHxPersonnelView;
import com.tridiumx.entsecHx.securityUtilHx.job.BHxAbstractJobView;
import com.tridiumx.ldapDriver.BLdapServer;
import com.tridiumx.ldapDriver.attributes.BLdapAttributesDeviceExt;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BQuery;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"entsec:Personnel"}, requiredPermissions="r")})
@NiagaraSingleton
public class BHxLdapJoinManager
extends BHxPersonnelView
implements HxProgressJobDialog.IHxProgressDialogParent {
    static final Lexicon secUtilLex = Lexicon.make(BHxLdapJoinManager.class);
    public static final BHxLdapJoinManager INSTANCE = new BHxLdapJoinManager();
    public static final Type TYPE = Sys.loadType(BHxLdapJoinManager.class);
    SmartCommand joinAllCommand;
    SmartCommand joinSelectedCommand;
    HxProgressJobDialog.ProgressEvent joinSelectedProgressEvent;
    HxProgressJobDialog.ProgressEvent joinAllProgressEvent = HxProgressJobDialog.makeProgress((String)secUtilLex.getText("joinAll.label"), (BHxView)this, (HxProgressJobDialog.IHxProgressDialogParent)this);
    JoinAllProgressCommand joinAllProgressCommand;
    JoinSelectedProgressCommand joinSelectedProgressCommand;
    HashMap<String, String> attributeMap;
    Object[] personList;
    BLdapServer selectedLdapServer;
    ArrayList<String> distinguishNames;

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxLdapJoinManager() {
        this.registerEvent((Event)this.joinAllProgressEvent);
        this.joinAllProgressCommand = new JoinAllProgressCommand((BHxView)this, this.joinAllProgressEvent);
        this.registerEvent((Event)this.joinAllProgressCommand);
        this.joinAllProgressEvent.setJobCompleteHandler((HxProgressJobDialog.IJobCompleteHandler)this.joinAllProgressCommand);
        this.joinAllCommand = new JoinAllCommand((BHxView)this, this.joinAllProgressCommand);
        this.registerEvent((Event)this.joinAllCommand);
        this.joinSelectedProgressEvent = HxProgressJobDialog.makeProgress((String)secUtilLex.getText("joinSelected.label"), (BHxView)this, (HxProgressJobDialog.IHxProgressDialogParent)this);
        this.registerEvent((Event)this.joinSelectedProgressEvent);
        this.joinSelectedProgressCommand = new JoinSelectedProgressCommand((BHxView)this, this.joinSelectedProgressEvent);
        this.registerEvent((Event)this.joinSelectedProgressCommand);
        this.joinSelectedProgressEvent.setJobCompleteHandler((HxProgressJobDialog.IJobCompleteHandler)this.joinSelectedProgressCommand);
        this.joinSelectedCommand = new JoinSelectedUsersCommand((BHxView)this, this.joinSelectedProgressCommand);
        this.registerEvent((Event)this.joinSelectedCommand);
    }

    public String getPageTitle(HxOp op) {
        return secUtilLex.getText("Ldap Export Manager");
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.filterCommand, this.columnsCommand, this.refresh, this.joinAllCommand, this.joinSelectedCommand};
    }

    public void update(HxOp op) throws Exception {
        super.update(op);
        String name = op.scope("job");
        BJob job = (BJob)op.getRequest().getSession().getAttribute("job");
        String ordStr = op.getFormValue(name);
        if (ordStr != null) {
            HxUtils.forceUpdate((BRelTime)BRelTime.make((long)750L), (HxOp)op);
        }
        this.joinSelectedProgressEvent.getDialog().updateContent(op);
        this.joinAllProgressEvent.getDialog().updateContent(op);
    }

    public BJob submitJob(HxProgressJobDialog dialog, HxOp op) {
        BJob job = (BJob)op.getRequest().getSession().getAttribute("job");
        op.getRequest().getSession().removeAttribute("job");
        BOrd jobOrd = job.submit((Context)op);
        return (BJob)BOrd.make((String)("station:|" + jobOrd)).get();
    }

    public BJob submitDiscoveryJob(HxOp op) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getAllPersons() {
        BSqlQuery personQuery = BSqlQuery.make((OrionType)BPerson.ORION_TYPE);
        ArrayList<BOrionObject> orionObjects = new ArrayList<BOrionObject>();
        OrionSession orionSession = null;
        try {
            orionSession = ExportPersonsDataUtility.getOrionSession();
            OrionCursor orionCursor = orionSession.select((BQuery)personQuery);
            while (orionCursor.next()) {
                BOrionObject orionObject = (BOrionObject)orionCursor.get();
                orionObjects.add(orionObject);
            }
        }
        finally {
            ExportPersonsDataUtility.closeOrionSession((OrionSession)orionSession);
        }
        Object[] objects = orionObjects.toArray();
        return objects;
    }

    public HashMap<String, String> getAttributesMappedList(BLdapServer selectedLdapServer) {
        String tableCol = "";
        this.distinguishNames = new ArrayList();
        this.attributeMap = new HashMap();
        BLdapAttributesDeviceExt attributeList = selectedLdapServer.getAttributes();
        BLdapAttributeProperties[] attrProperties = (BLdapAttributeProperties[])attributeList.getChildren(BLdapAttributeProperties.class);
        for (int j = 0; j < attrProperties.length; ++j) {
            String mappedORD = this.formAttributesMapString(attrProperties[j].getMappedORD().toString());
            mappedORD = mappedORD.replace("entsec_", "");
            if (attrProperties[j].getIsRDN()) {
                this.distinguishNames.add(attrProperties[j].getAttrName());
            }
            this.attributeMap.put(attrProperties[j].getAttrName(), mappedORD);
        }
        return this.attributeMap;
    }

    private String formAttributesMapString(String mappedORD) {
        String[] mappedORDSpilt = TextUtil.split((String)mappedORD, (char)'/');
        StringBuilder builder = new StringBuilder();
        for (int i = 2; i < mappedORDSpilt.length; ++i) {
            if (builder.length() > 0) {
                builder.append(";");
            }
            builder.append(mappedORDSpilt[i]);
        }
        return builder.toString();
    }

    public static class JoinSelectedProgressCommand
    extends Command
    implements HxProgressJobDialog.IJobCompleteHandler {
        HxProgressJobDialog.ProgressEvent joinSelectedProgressEvent;

        public JoinSelectedProgressCommand(BHxView view, HxProgressJobDialog.ProgressEvent joinSelectedProgressEvent) {
            super(view);
            this.joinSelectedProgressEvent = joinSelectedProgressEvent;
        }

        public void invoke(BJob job, HxOp op) throws Exception {
            if (job.getJobState().equals((Object)BJobState.failed) || job.getJobState().equals((Object)BJobState.canceled)) {
                BHxAbstractJobView.openErrorDialog(job, this, op);
            } else if (job.getJobState().equals((Object)BJobState.success)) {
                BHxAbstractJobView.openSuccessDialog(job, this, op);
            }
        }

        public void handle(HxOp op) throws Exception {
            this.joinSelectedProgressEvent.handle(op);
        }
    }

    class JoinSelectedUsersCommand
    extends SmartCommand {
        Command joinSelectedProgressCommand;

        public JoinSelectedUsersCommand(BHxView view, Command joinSelectedProgressCommand) {
            super(view);
            this.joinSelectedProgressCommand = joinSelectedProgressCommand;
        }

        public String getName(HxOp op) {
            return "JoinSelectedUsers";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            String ldapServerName = (String)op.getRequest().getSession().getAttribute("ldapServerName");
            BLdapServer selectedLdapServer = ExportPersonsDataUtility.getSelectedLdapServer((String)ldapServerName);
            HashMap<String, String> hashAttributes = BHxLdapJoinManager.this.getAttributesMappedList(selectedLdapServer);
            BHxLdapJoinManager.this.personList = BHxLdapJoinManager.this.getSubjects(op);
            BLdapJoinAllJob job = new BLdapJoinAllJob(hashAttributes, op, BHxLdapJoinManager.this.personList, selectedLdapServer, BHxLdapJoinManager.this.distinguishNames);
            op.getRequest().getSession().setAttribute("job", (Object)job);
            this.joinSelectedProgressCommand.handle(op);
        }
    }

    public static class JoinAllProgressCommand
    extends Command
    implements HxProgressJobDialog.IJobCompleteHandler {
        HxProgressJobDialog.ProgressEvent joinAllProgressEvent;

        public JoinAllProgressCommand(BHxView view, HxProgressJobDialog.ProgressEvent joinAllProgressEvent) {
            super(view);
            this.joinAllProgressEvent = joinAllProgressEvent;
        }

        public void invoke(BJob job, HxOp op) throws Exception {
            if (job.getJobState().equals((Object)BJobState.failed) || job.getJobState().equals((Object)BJobState.canceled)) {
                BHxAbstractJobView.openErrorDialog(job, this, op);
            } else if (job.getJobState().equals((Object)BJobState.success)) {
                BHxAbstractJobView.openSuccessDialog(job, this, op);
            }
        }

        public void handle(HxOp op) throws Exception {
            this.joinAllProgressEvent.handle(op);
        }
    }

    class JoinAllCommand
    extends SmartCommand {
        Command joinAllProgressCommand;

        public JoinAllCommand(BHxView view, Command joinAllProgressCommand) {
            super(view);
            this.joinAllProgressCommand = joinAllProgressCommand;
        }

        public String getName(HxOp op) {
            return "JoinAllUsers";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            Object[] devices = BHxLdapJoinManager.this.getSubjects(op);
            String ldapServerName = (String)op.getRequest().getSession().getAttribute("ldapServerName");
            BLdapServer selectedLdapServer = ExportPersonsDataUtility.getSelectedLdapServer((String)ldapServerName);
            HashMap<String, String> hashAttributes = BHxLdapJoinManager.this.getAttributesMappedList(selectedLdapServer);
            BHxLdapJoinManager.this.personList = BHxLdapJoinManager.this.getAllPersons();
            BLdapJoinAllJob job = new BLdapJoinAllJob(hashAttributes, op, BHxLdapJoinManager.this.personList, selectedLdapServer, BHxLdapJoinManager.this.distinguishNames);
            op.getRequest().getSession().setAttribute("job", (Object)job);
            this.joinAllProgressCommand.handle(op);
        }
    }
}

