/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.ldapHx.discover;

import com.tridium.hx.ErrorDialog;
import com.tridium.hx.fieldeditors.BHxDefaultFE;
import com.tridium.hx.progress.HxProgressJobDialog;
import com.tridium.hx.util.HxUtils;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionService;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.JobLogDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.fieldeditors.BHxSmartDefaultFE;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.ldap.importconfig.BLdapForceImportJob;
import com.tridiumx.entsec.ldap.importconfig.BLdapImportConfig;
import com.tridiumx.entsec.ldap.importconfig.BLdapImportJob;
import com.tridiumx.entsec.ldap.util.ExportPersonsDataUtility;
import com.tridiumx.entsec.ldap.util.LdapValidationUtil;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import com.tridiumx.entsecHx.ldapHx.LdapUtil;
import com.tridiumx.entsecHx.ldapHx.discover.BLdapDevicePingJob;
import com.tridiumx.entsecHx.ldapHx.join.BLdapRollbackJob;
import com.tridiumx.entsecHx.ldapHx.ui.IPAddressUtil;
import com.tridiumx.entsecHx.ldapHx.ui.LdapImportDialogPreferences;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractDiscoverView;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractManagerView;
import com.tridiumx.entsecHx.securityUtilHx.job.BHxAbstractJobView;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxQueryTableView;
import com.tridiumx.ldapDriver.BLdapNetwork;
import com.tridiumx.ldapDriver.BLdapSearchControlScope;
import com.tridiumx.ldapDriver.BLdapServer;
import com.tridiumx.ldapDriver.attributes.BLdapAttributesDeviceExt;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BProjection;
import javax.baja.query.BQuery;
import javax.baja.query.util.Predicates;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BTypeSpec;
import javax.baja.util.CannotValidateException;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconModule;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;

@NiagaraType
@NiagaraSingleton
public class BHxLdapDeviceView
extends BHxAbstractManagerView {
    static final Lexicon secUtilLex = Lexicon.make(BHxLdapDeviceView.class);
    public static final BHxLdapDeviceView INSTANCE = new BHxLdapDeviceView();
    public static final Type TYPE = Sys.loadType(BHxLdapDeviceView.class);
    PingDevices pingDevices;
    AddDevice addDevice = new AddDevice((BHxView)this);
    EditDevice editDevice;
    DeleteDevice deleteDevice;
    JoinCommand joinCommand;
    SmartCommand rollBackCommand;
    HxProgressJobDialog.ProgressEvent rollbackProgressEvent;
    RollbackProgressCommand rollbackProgressCommand;
    SmartCommand forceImportCommand;
    HxProgressJobDialog.ProgressEvent forceImportProgressEvent;
    ForceImportProgressCommand forceImportProgressCommand;
    HxProgressJobDialog.ProgressEvent pingDeviceEvent;

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxLdapDeviceView() {
        this.registerEvent((Event)this.addDevice);
        this.editDevice = new EditDevice((BHxView)this);
        this.registerEvent((Event)this.editDevice);
        this.deleteDevice = new DeleteDevice((BHxView)this);
        this.registerEvent((Event)this.deleteDevice);
        this.pingDevices = new PingDevices((BHxView)this);
        this.registerEvent((Event)this.pingDevices);
        this.joinCommand = new JoinCommand((BHxView)this);
        this.registerEvent((Event)this.joinCommand);
        this.pingDeviceEvent = HxProgressJobDialog.makeProgress((String)secUtilLex.getText("ping.label"), (BHxView)this, (HxProgressJobDialog.IHxProgressDialogParent)this);
        this.registerEvent((Event)this.pingDeviceEvent);
        this.rollbackProgressEvent = HxProgressJobDialog.makeProgress((String)secUtilLex.getText("Recovery.label"), (BHxView)this, (HxProgressJobDialog.IHxProgressDialogParent)this);
        this.registerEvent((Event)this.rollbackProgressEvent);
        this.rollbackProgressCommand = new RollbackProgressCommand((BHxView)this, this.rollbackProgressEvent);
        this.registerEvent((Event)this.rollbackProgressCommand);
        this.rollbackProgressEvent.setJobCompleteHandler((HxProgressJobDialog.IJobCompleteHandler)this.rollbackProgressCommand);
        this.rollBackCommand = new RollBackCommand((BHxView)this, this.rollbackProgressCommand);
        this.registerEvent((Event)this.rollBackCommand);
        this.forceImportProgressEvent = HxProgressJobDialog.makeProgress((String)secUtilLex.getText("Import.label"), (BHxView)this, (HxProgressJobDialog.IHxProgressDialogParent)this);
        this.registerEvent((Event)this.forceImportProgressEvent);
        this.forceImportProgressCommand = new ForceImportProgressCommand((BHxView)this, this.forceImportProgressEvent);
        this.registerEvent((Event)this.forceImportProgressCommand);
        this.forceImportProgressEvent.setJobCompleteHandler((HxProgressJobDialog.IJobCompleteHandler)this.forceImportProgressCommand);
        this.forceImportCommand = new ForceImportCommand((BHxView)this, this.forceImportProgressCommand);
        this.registerEvent((Event)this.forceImportCommand);
    }

    @Override
    public String getPageTitle(HxOp op) {
        return secUtilLex.getText("LdapServers");
    }

    @Override
    public BTypeSpec getDeviceTypeSpec(HxOp op) {
        return BTypeSpec.make((String)"ldapDriver", (String)"LdapServer");
    }

    public Type getQueryType(HxOp op) {
        if (op.get() instanceof BLdapNetwork) {
            return ((BDeviceNetwork)op.get()).getDeviceType();
        }
        return null;
    }

    @Override
    public BQuery getQuery(HxOp op) {
        BComponent component = (BComponent)op.get();
        BQuery query = QueryUtil.makeQuery((BTypeSpec)this.getDeviceTypeSpec(op));
        query.select(new BProjection());
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(BString.TYPE.getTypeSpec(), "displayName", secUtilLex.getText("displayName")));
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(BString.TYPE.getTypeSpec(), "connectionUrl", secUtilLex.getText("connectionUrl")));
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(BStatus.TYPE.getTypeSpec(), "status", secUtilLex.getText("status")));
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(BString.TYPE.getTypeSpec(), "enabled", secUtilLex.getText("enabled")));
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(BString.TYPE.getTypeSpec(), "faultCause", secUtilLex.getText("faultCause")));
        QueryUtil.addHiddenColumns((BQuery)query);
        query.add("base", (BValue)component.getAbsoluteOrd());
        query = QueryUtil.getWorkingCopy((BQuery)query, (Context)op);
        return query;
    }

    @Override
    public BQuery getDiscoverQuery(HxOp op) {
        return null;
    }

    @Override
    public BHxAbstractDiscoverView getDiscoverView(HxOp op) {
        return null;
    }

    @Override
    public BTypeSpec getLearnRowTypeSpec(HxOp op) {
        return null;
    }

    @Override
    public Tab getLearnTab(HxOp op) {
        return new Tab((BHxView)BHxDefaultFE.INSTANCE, op.make("null", (BObject)BString.DEFAULT, null));
    }

    @Override
    public BJob submitDiscoveryJob(HxOp op) {
        return null;
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.addDevice, this.editDevice, this.deleteDevice, this.pingDevices, this.forceImportCommand, this.hyperlinkCommand, this.filterCommand, this.refresh, this.exportCommand};
    }

    public BComponent getContainer(HxOp op) {
        return (BComponent)op.get();
    }

    @Override
    public void update(HxOp op) throws Exception {
        super.update(op);
        String name = op.scope("job");
        BJob job = (BJob)op.getRequest().getSession().getAttribute("job");
        String ordStr = op.getFormValue(name);
        if (ordStr != null) {
            HxUtils.forceUpdate((BRelTime)BRelTime.make((long)750L), (HxOp)op);
        }
        this.rollbackProgressEvent.getDialog().updateContent(op);
        this.forceImportProgressEvent.getDialog().updateContent(op);
    }

    @Override
    public BJob submitJob(HxProgressJobDialog dialog, HxOp op) {
        BJob job = super.submitJob(dialog, op);
        if (job != null) {
            return job;
        }
        Object[] devices = BHxLdapDeviceView.getSubjects(op);
        if (dialog.getTitle().equals(this.pingDeviceEvent.getDialog().getTitle())) {
            BOrd ord = new BLdapDevicePingJob(devices, op).submit(null);
            return (BJob)ord.get(op.get());
        }
        BJob job1 = (BJob)op.getRequest().getSession().getAttribute("job");
        op.getRequest().getSession().removeAttribute("job");
        BOrd jobOrd = job1.submit((Context)op);
        return (BJob)BOrd.make((String)("station:|" + jobOrd)).get();
    }

    static BObject readProperty(String name, HxOp op, Property prop) throws CannotValidateException {
        return BHxLdapDeviceView.readProperty(name, op, (BObject)prop.getDefaultValue());
    }

    static BObject readProperty(String name, HxOp op, BObject defaultVal) throws CannotValidateException {
        String hostString;
        if (name.equalsIgnoreCase("Connection$20Host") && !IPAddressUtil.isNumericAddr(hostString = op.getFormValue(name + ".value")) && !IPAddressUtil.isHostname(hostString)) {
            throw new CannotValidateException(lex.getText("ldap.connection.hostame.invalid", new Object[]{hostString}));
        }
        try {
            BHxSmartDefaultFE editor = BHxSmartDefaultFE.INSTANCE;
            try {
                editor = BHxFieldEditor.makeFor((BObject)defaultVal, (Context)op.make((OrdTarget)op));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return editor.save(op.make(name, new OrdTarget((OrdTarget)op, defaultVal)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static void writeProperty(String name, HxOp op, BComplex obj, Property prop, Lexicon lex) throws Exception {
        if (lex == null) {
            lex = Lexicon.make(obj.getClass());
        }
        BHxLdapDeviceView.writeProperty(name, op, (BObject)obj.get(prop), lex.get(prop.getName(), TextUtil.toFriendly((String)prop.getName())), obj.getSlotFacets((Slot)prop), false);
    }

    static void writeProperty(String name, HxOp op, BObject defaultVal, String displayName, BFacets facets, boolean readonly) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        BHxSmartDefaultFE editor = BHxSmartDefaultFE.INSTANCE;
        try {
            editor = BHxFieldEditor.makeFor((BObject)defaultVal, (Context)op.make((OrdTarget)op).mergeFacets(facets));
        }
        catch (Exception exception) {
            // empty catch block
        }
        OrdTarget target = new OrdTarget((OrdTarget)op, defaultVal);
        HxOp fieldOp = op.make(name, defaultVal, facets);
        fieldOp.setReadonly(readonly);
        out.w((Object)"<tr ");
        out.w((Object)"><td class='smartTable-setup-label'>");
        out.safe((Object)displayName);
        out.w((Object)"</td>");
        out.w((Object)"<td>");
        editor.write(fieldOp);
        out.w((Object)"</td></tr>");
    }

    private String getNewDisplayName(String displayName) {
        String newDisplayName = displayName;
        if (displayName.equals("Tls")) {
            newDisplayName = secUtilLex.get("BLdapConnection.tls");
        } else if (displayName.equals("Connection Pool Timeout")) {
            newDisplayName = lex.getText("BLdapConnection.connectionPoolTimeout");
        }
        return newDisplayName;
    }

    private OrionSession getOrionSession() {
        BOrionDatabase[] orionDatabases = BOrionService.getService().getOrionDatabases();
        if (orionDatabases.length > 0) {
            OrionSession orionSession = orionDatabases[0].createSession(null);
            orionSession.setAutoCommit(false);
            return orionSession;
        }
        return null;
    }

    private void closeOrionSession(OrionSession orionSession) {
        if (orionSession != null) {
            orionSession.close();
            orionSession = null;
        }
    }

    private com.tridiumx.entsec.access.orion.BLdapServer makeLdapServerEntry(BOrd ord) {
        com.tridiumx.entsec.access.orion.BLdapServer entsecLdapServer = new com.tridiumx.entsec.access.orion.BLdapServer();
        String ldapServerPath = BOrd.make((String)("station:|" + ord.encodeToString())).toString();
        entsecLdapServer.setOrd(ldapServerPath);
        entsecLdapServer.setLastSyncDate(BAbsTime.now());
        return entsecLdapServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private com.tridiumx.entsec.access.orion.BLdapServer getLdapServerEntry(BOrd ord) {
        OrionSession session = null;
        com.tridiumx.entsec.access.orion.BLdapServer ldapServer = null;
        try {
            session = this.getOrionSession();
            BSqlQuery query = BSqlQuery.make((OrionType)com.tridiumx.entsec.access.orion.BLdapServer.ORION_TYPE);
            BQuery q = query.where(Predicates.eq((String)"ord", (BSimple)ord));
            OrionCursor cursor = session.select(q);
            while (cursor.next()) {
                ldapServer = (com.tridiumx.entsec.access.orion.BLdapServer)cursor.get();
            }
            com.tridiumx.entsec.access.orion.BLdapServer bLdapServer = ldapServer;
            return bLdapServer;
        }
        finally {
            this.closeOrionSession(session);
        }
    }

    public void saveImportPreferences(BLdapServer server, HxOp op) {
        try {
            BString accountExpiryDateTimeAttributeVal;
            BString savedAccountExpiryDateTimeAttributeVal;
            BString activeStatusValuesVal;
            BString savedActiveStatusValues;
            BString statusAttributeVal;
            BString savedStatusAttribute;
            BBoolean allowNewInactiveUsersVal;
            BBoolean savedAllowNewInactiveUsers;
            BLdapImportConfig importConfig;
            BString groupAttributeVal;
            BString savedGroupAttribute;
            BLdapSearchControlScope searchScopeEnum;
            BLdapSearchControlScope savedSearchScopeEnum;
            BString userSearchFilterVal;
            BString savedUserSearchFilterVal;
            BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)BBoolean.DEFAULT, (Context)op);
            BString userSearchVal = (BString)server.get(BLdapServer.userSearchBase);
            editor = BHxFieldEditor.makeFor((BObject)userSearchVal, (Context)op);
            HxOp fieldOp = op.make("userSearchBase", (BObject)userSearchVal, null);
            BString savedUserSearch = (BString)editor.save(fieldOp);
            if (!savedUserSearch.equals((Object)fieldOp.get())) {
                server.set(BLdapServer.userSearchBase, (BValue)savedUserSearch, (Context)op);
            }
            if (!(savedUserSearchFilterVal = (BString)(editor = BHxFieldEditor.makeFor((BObject)(userSearchFilterVal = (BString)server.get(BLdapServer.userSearchFilter)), (Context)op)).save(fieldOp = op.make("userSearchFilter", (BObject)userSearchFilterVal, null))).equals((Object)fieldOp.get())) {
                server.set(BLdapServer.userSearchFilter, (BValue)savedUserSearchFilterVal, (Context)op);
            }
            if (!(savedSearchScopeEnum = (BLdapSearchControlScope)(editor = BHxFieldEditor.makeFor((BObject)(searchScopeEnum = (BLdapSearchControlScope)server.get(BLdapServer.searchScope)), (Context)op)).save(fieldOp = op.make("searchScope", (BObject)searchScopeEnum, server.getSlotFacets((Slot)BLdapServer.searchScope)))).equals((Object)fieldOp.get())) {
                server.set(BLdapServer.searchScope, (BValue)savedSearchScopeEnum, (Context)op);
            }
            if (!(savedGroupAttribute = (BString)(editor = BHxFieldEditor.makeFor((BObject)(groupAttributeVal = (BString)(importConfig = (BLdapImportConfig)server.getMixIn(BLdapImportConfig.TYPE)).get(BLdapImportConfig.groupAttribute)), (Context)op)).save(fieldOp = op.make("groupAttribute", (BObject)groupAttributeVal, null))).equals((Object)fieldOp.get())) {
                BLdapAttributesDeviceExt updatedLdapAttributesDeviceExt = (BLdapAttributesDeviceExt)server.get(BLdapServer.attributes);
                updatedLdapAttributesDeviceExt.set(BLdapAttributesDeviceExt.groupAttribute, (BValue)savedGroupAttribute, (Context)op);
                server.set(BLdapServer.attributes, (BValue)updatedLdapAttributesDeviceExt, (Context)op);
                importConfig.set(BLdapImportConfig.groupAttribute, (BValue)savedGroupAttribute, (Context)op);
            }
            if (!(savedAllowNewInactiveUsers = (BBoolean)(editor = BHxFieldEditor.makeFor((BObject)(allowNewInactiveUsersVal = (BBoolean)importConfig.get(BLdapImportConfig.allowNewInactiveUsers)), (Context)op)).save(fieldOp = op.make("allowNewInactiveUsers", (BObject)allowNewInactiveUsersVal, null))).equals((Object)fieldOp.get())) {
                importConfig.set(BLdapImportConfig.allowNewInactiveUsers, (BValue)savedAllowNewInactiveUsers, (Context)op);
            }
            if (!(savedStatusAttribute = (BString)(editor = BHxFieldEditor.makeFor((BObject)(statusAttributeVal = (BString)importConfig.get(BLdapImportConfig.statusAttribute)), (Context)op)).save(fieldOp = op.make("statusAttribute", (BObject)statusAttributeVal, null))).equals((Object)fieldOp.get())) {
                importConfig.set(BLdapImportConfig.statusAttribute, (BValue)savedStatusAttribute, (Context)op);
            }
            if (!(savedActiveStatusValues = (BString)(editor = BHxFieldEditor.makeFor((BObject)(activeStatusValuesVal = (BString)importConfig.get(BLdapImportConfig.activeStatusValues)), (Context)op)).save(fieldOp = op.make("activeStatusValues", (BObject)activeStatusValuesVal, null))).equals((Object)fieldOp.get())) {
                importConfig.set(BLdapImportConfig.activeStatusValues, (BValue)savedActiveStatusValues, (Context)op);
                importConfig.updateValidStatusList();
            }
            if (!(savedAccountExpiryDateTimeAttributeVal = (BString)(editor = BHxFieldEditor.makeFor((BObject)(accountExpiryDateTimeAttributeVal = (BString)importConfig.get(BLdapImportConfig.accountExpiryDateTimeAttribute)), (Context)op)).save(fieldOp = op.make("accountExpiryDateTimeAttribute", (BObject)accountExpiryDateTimeAttributeVal, null))).equals((Object)fieldOp.get())) {
                importConfig.set(BLdapImportConfig.accountExpiryDateTimeAttribute, (BValue)savedAccountExpiryDateTimeAttributeVal, (Context)op);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public static class ImportJobLogDialog
    extends JobLogDialog.JobLogDialogRefresh {
        private String redirect;

        public ImportJobLogDialog(Command command, BJob job, String title, String redirect, HxOp op) {
            super(command, job, title, null);
            this.redirect = redirect;
        }

        public Command[] getCommands() {
            return new Command[]{new JobLogDialog.JobLogDialogRefresh.DoneRefresh((JobLogDialog.JobLogDialogRefresh)this), new Approve()};
        }

        protected class Approve
        extends Dialog.Cancel {
            public Approve() {
                super((Dialog)ImportJobLogDialog.this);
            }

            public String getDisplayName(HxOp op) {
                return Lexicon.make(((Object)((Object)this)).getClass()).getText("AttributesMapping");
            }

            public String getInvokeCode(HxOp op) {
                StringBuffer b = new StringBuffer();
                b.append("hx.closeDialog(null,null,null);");
                BOrd redirectUrl = BOrd.make((String)("station:|" + ImportJobLogDialog.this.redirect));
                b.append("window.location=&quot;").append(op.toUri(redirectUrl)).append("&quot;;");
                return b.toString();
            }
        }
    }

    static class ConfirmDialog
    extends Dialog {
        String msg;

        public ConfirmDialog(String title, Command handler) {
            super(title, handler);
        }

        public Command[] getCommands() {
            return new Command[]{this.makeSubmitCommand(), this.makeCancelCommand()};
        }

        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<table>");
            out.w((Object)"<tr><td>");
            String text = TextUtil.replace((String)this.msg, (String)"\n", (String)"<br/>");
            text = TextUtil.replace((String)text, (String)"\r", (String)"");
            out.w((Object)"<b>").w((Object)text).w((Object)"&nbsp;</b>");
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
        }
    }

    class DeleteDevice
    extends BHxAbstractManagerView.Delete {
        OrionSession session;

        public DeleteDevice(BHxView view) {
            super(view);
        }

        @Override
        public boolean performComponentPreDeleteActivities(Object subject) {
            boolean returnValue = false;
            this.session = BHxLdapDeviceView.this.getOrionSession();
            this.session.setAutoCommit(false);
            BOrd ord = ((BComponent)subject).getSlotPathOrd();
            int delCount = ExportPersonsDataUtility.cleanDatabaseEntriesForLDAPServerDelete((BOrd)ord, (OrionSession)this.session);
            if (delCount > 0) {
                returnValue = true;
            }
            return returnValue;
        }

        @Override
        public void performComponentPostDeleteActivities(boolean isComponentRemoved) {
            if (this.session != null) {
                if (isComponentRemoved) {
                    this.session.commit();
                } else {
                    this.session.rollback();
                }
                this.session.close();
                this.session = null;
            }
        }
    }

    public static class ForceImportJobLogDialog
    extends JobLogDialog.JobLogDialogRefresh {
        public ForceImportJobLogDialog(Command command, BJob job, String title, HxOp op) {
            super(command, job, title, null);
        }

        public Command[] getCommands() {
            return new Command[]{new JobLogDialog.JobLogDialogRefresh.DoneRefresh((JobLogDialog.JobLogDialogRefresh)this), new JobLogDialog.Export((JobLogDialog)this), new AuditLogs()};
        }

        protected class AuditLogs
        extends Dialog.Cancel {
            public AuditLogs() {
                super((Dialog)ForceImportJobLogDialog.this);
            }

            public String getDisplayName(HxOp op) {
                return Lexicon.make(((Object)((Object)this)).getClass()).getText("AuditLogs");
            }

            public String getInvokeCode(HxOp op) {
                StringBuffer b = new StringBuffer();
                b.append("hx.closeDialog(null,null,null);");
                BOrd urll = BOrd.make((String)"service:entsec:EnterpriseSecurityService|slot:ldapAuditHistory");
                b.append("window.location=&quot;").append(op.toUri(urll)).append("&quot;;");
                return b.toString();
            }
        }
    }

    public static class ForceImportProgressCommand
    extends Command
    implements HxProgressJobDialog.IJobCompleteHandler {
        HxProgressJobDialog.ProgressEvent importProgressEvent;

        public ForceImportProgressCommand(BHxView view, HxProgressJobDialog.ProgressEvent importProgressEvent) {
            super(view);
            this.importProgressEvent = importProgressEvent;
        }

        public void invoke(BJob job, HxOp op) throws Exception {
            if (job.getJobState().equals((Object)BJobState.failed) || job.getJobState().equals((Object)BJobState.canceled)) {
                BLdapImportJob importJob = (BLdapImportJob)job;
                String rowId = (String)op.getRequest().getSession().getAttribute("rowId");
                if (!importJob.getMandatoryAttributesMapped()) {
                    new ImportJobLogDialog(this, job, null, rowId, op).open(op);
                    return;
                }
                BHxAbstractJobView.openErrorDialog(job, this, op);
                return;
            }
            if (job.getJobState().equals((Object)BJobState.success)) {
                job.log().message("See the LDAP audit history for more details");
                new ForceImportJobLogDialog(this, job, null, op).open(op);
            }
        }

        public void handle(HxOp op) throws Exception {
            this.importProgressEvent.handle(op);
        }
    }

    public class ForceImportCommand
    extends SmartCommand {
        LdapImportDialogPreferences confirm;
        Command importProgressCommand;

        public ForceImportCommand(BHxView view, Command importProgressCommand) {
            super(view);
            this.confirm = new LdapImportDialogPreferences((Command)this);
            this.importProgressCommand = importProgressCommand;
        }

        public String getName(HxOp op) {
            return "Import";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public boolean isDefaultAction() {
            return false;
        }

        public void handle(HxOp op) throws Exception {
            if (!LdapValidationUtil.hasImportPrivileges((BUser)op.getUser())) {
                new ErrorDialog(secUtilLex.getText("import.privilege.error"), (Throwable)new LocalizableRuntimeException(TYPE.getModule().getModuleName(), secUtilLex.getText("import.privilege.errorMsg"))).open(op);
                return;
            }
            String ldapServerName = "";
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            String rowId = "";
            if (selectionList.length == 1) {
                rowId = selectionList[0];
                ldapServerName = rowId.substring(rowId.lastIndexOf("/") + 1, rowId.length());
            }
            BLdapServer ldapServer = ExportPersonsDataUtility.getSelectedLdapServer((String)ldapServerName);
            if (!this.confirm.isSubmit(op)) {
                this.confirm.setLdapServer(ldapServer);
                this.confirm.open(op);
                return;
            }
            BHxLdapDeviceView.this.saveImportPreferences(ldapServer, op);
            BLdapForceImportJob job = new BLdapForceImportJob(ldapServer);
            op.getRequest().getSession().setAttribute("job", (Object)job);
            op.getRequest().getSession().setAttribute("rowId", (Object)rowId);
            this.importProgressCommand.handle(op);
        }
    }

    public static class RollbackProgressCommand
    extends Command
    implements HxProgressJobDialog.IJobCompleteHandler {
        HxProgressJobDialog.ProgressEvent rollbackProgressEvent;

        public RollbackProgressCommand(BHxView view, HxProgressJobDialog.ProgressEvent rollbackProgressEvent) {
            super(view);
            this.rollbackProgressEvent = rollbackProgressEvent;
        }

        public void invoke(BJob job, HxOp op) throws Exception {
            if (job.getJobState().equals((Object)BJobState.failed) || job.getJobState().equals((Object)BJobState.canceled)) {
                BHxAbstractJobView.openErrorDialog(job, this, op);
            } else if (job.getJobState().equals((Object)BJobState.success)) {
                BHxAbstractJobView.openSuccessDialog(job, this, op);
            }
        }

        public void handle(HxOp op) throws Exception {
            this.rollbackProgressEvent.handle(op);
        }
    }

    public class RollBackCommand
    extends SmartCommand {
        ConfirmDialog confirm;
        Command rollbackProgressCommand;

        public RollBackCommand(BHxView view, Command rollbackProgressCommand) {
            super(view);
            this.confirm = new ConfirmDialog(this.lexModule.getText("rollbackConfirmation.title", null), (Command)this);
            this.rollbackProgressCommand = rollbackProgressCommand;
        }

        public String getName(HxOp op) {
            return "Recovery";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public boolean isDefaultAction() {
            return false;
        }

        public void handle(HxOp op) throws Exception {
            String ldapServerName = "";
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            if (selectionList.length == 1) {
                String rowId = selectionList[0];
                ldapServerName = rowId.substring(rowId.lastIndexOf("/") + 1, rowId.length());
            }
            if (!this.confirm.isSubmit(op)) {
                this.confirm.msg = secUtilLex.getText("rollbackConfirmation");
                this.confirm.open(op);
                return;
            }
            BLdapRollbackJob job = new BLdapRollbackJob(op, ExportPersonsDataUtility.getSelectedLdapServer((String)ldapServerName));
            op.getRequest().getSession().setAttribute("job", (Object)job);
            this.rollbackProgressCommand.handle(op);
        }
    }

    public class JoinCommand
    extends SmartCommand
    implements HxProgressJobDialog.IJobCompleteHandler {
        public JoinCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "export";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public boolean isDefaultAction() {
            return false;
        }

        public void handle(HxOp op) throws Exception {
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            if (selectionList.length == 1) {
                String rowId = selectionList[0];
                String ldapServerName = rowId.substring(rowId.lastIndexOf("/") + 1, rowId.length());
                op.getRequest().getSession().setAttribute("ldapServerName", (Object)ldapServerName);
                if (!LdapValidationUtil.checkForAttributesMappingExists((String)ldapServerName)) {
                    new ErrorDialog(secUtilLex.getText("export.attributeMapping.error"), (Throwable)new LocalizableRuntimeException(TYPE.getModule().getModuleName(), "export.attributeMapping.errorMsg")).open(op);
                    return;
                }
                if (BHxLdapDeviceView.this.scopeRowIds(op)) {
                    rowId = TextUtil.split((String)rowId, (char)'~')[1];
                }
                String view = "HxLdapJoinManager";
                BOrd ord = BOrd.make((String)("station:|slot:/Services/AccessControlService/personnel|view:entsecHx:" + view));
                this.redirect(op, op.toUri(ord));
            }
        }

        public void invoke(BJob job, HxOp op) throws Exception {
            if (job.getJobState().equals((Object)BJobState.failed) || job.getJobState().equals((Object)BJobState.canceled)) {
                BHxAbstractJobView.openErrorDialog(job, (Command)this, secUtilLex.getText("ldapDeviceView.joinJobError"), op);
                return;
            }
            ((BHxAbstractManagerView)this.getView()).reloadTables(op);
        }
    }

    static class PingDevices
    extends SmartCommand {
        public PingDevices(BHxView view) {
            super(view, LexiconModule.make((BModule)BHxLdapDeviceView.secUtilLex.module));
        }

        public String getName(HxOp op) {
            return "pingDevices";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public void handle(HxOp op) throws Exception {
            super.handle(op);
            Object[] devices = BHxQueryTableView.getSubjects(op);
            for (int i = 0; i < devices.length; ++i) {
                if (!(devices[i] instanceof BDevice)) continue;
                BDevice device = (BDevice)devices[i];
                device.ping();
            }
            ((BHxAbstractManagerView)this.getView()).reloadTable(op);
        }
    }

    class EditDevice
    extends SmartCommand {
        EditDeviceDialog addDeviceDlg;

        public EditDevice(BHxView view) {
            super(view, LexiconModule.make((BModule)BHxLdapDeviceView.secUtilLex.module));
            this.addDeviceDlg = new EditDeviceDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "edit";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public boolean isDefaultAction() {
            return false;
        }

        public BComponent getSelectedComponent(HxOp op) {
            String[] sel = EditDevice.getSelectionList((HxOp)op);
            String slotPath = sel[0];
            BOrd ord = BOrd.make((String)("station:|" + slotPath));
            return (BComponent)ord.get(op.get());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(HxOp op) throws Exception {
            BComponent newC;
            if (!this.addDeviceDlg.isSubmit(op)) {
                this.addDeviceDlg.open(op);
                return;
            }
            BComponent oldComp = newC = this.getSelectedComponent(op);
            MgrColumn[] cols = LdapUtil.getMgrColumns(newC);
            String name = BHxLdapDeviceView.readProperty("name", op, (BObject)BString.DEFAULT).toString();
            for (int i = 0; i < cols.length; ++i) {
                BObject o = (BObject)cols[i].get((Object)newC);
                if (!(o instanceof BSimple) && !(o instanceof BStruct) || !cols[i].isEditable()) continue;
                String propName = SlotPath.escape((String)cols[i].getDisplayName());
                String newPropStr = op.getFormValue(propName + ".value");
                BValue originalPropValue = (BValue)o;
                BObject obj = BHxLdapDeviceView.readProperty(propName, op, (BObject)originalPropValue);
                cols[i].save(new MgrEditRow(newC, null, null), (BValue)obj, (Context)op);
            }
            if (!name.equals(newC.getName())) {
                BHxLdapDeviceView.this.getContainer(op).rename(newC.getPropertyInParent(), SlotPath.escape((String)name));
            }
            newC.lease();
            Thread.sleep(1000L);
            ((BHxAbstractManagerView)this.getView()).reloadTables(op);
            BOrd newOrd = newC.getSlotPathOrd();
            OrionSession session = BHxLdapDeviceView.this.getOrionSession();
            try {
                String[] sel = EditDevice.getSelectionList((HxOp)op);
                String slotPath = sel[0];
                BOrd oldORD = BOrd.make((String)("station:|" + slotPath));
                com.tridiumx.entsec.access.orion.BLdapServer entsecldapServer = BHxLdapDeviceView.this.getLdapServerEntry(oldORD);
                entsecldapServer.setOrd(BOrd.make((String)("station:|" + newOrd)).encodeToString());
                session.persist((BIOrionObject)entsecldapServer);
                session.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                session.rollback();
            }
            finally {
                op.getRequest().getSession().setAttribute("ldapServerName", (Object)name);
                BHxLdapDeviceView.this.closeOrionSession(session);
            }
        }

        class EditDeviceDialog
        extends Dialog {
            public EditDeviceDialog(String title, Command handler) {
                super(title, handler);
            }

            public Command[] getCommands() {
                return new Command[]{this.makeSubmitCommand(), this.makeCancelCommand()};
            }

            protected void writeContent(HxOp op) throws Exception {
                HtmlWriter out = op.getHtmlWriter();
                Lexicon lex = Lexicon.make(BHxLdapDeviceView.class);
                BHxSmartTableView.writeUnscopedFormValue((String)"step", (String)"addDevice", (HxOp)op);
                out.w((Object)"<table>");
                BComponent newC = EditDevice.this.getSelectedComponent(op);
                MgrColumn[] cols = LdapUtil.getMgrColumns(newC);
                BHxLdapDeviceView.writeProperty("name", op, (BObject)BString.make((String)SlotPath.unescape((String)newC.getName())), "Name", BFacets.NULL, false);
                for (int i = 0; i < cols.length; ++i) {
                    BObject o = (BObject)cols[i].get((Object)newC);
                    if (!(o instanceof BSimple) && !(o instanceof BStruct) || !cols[i].isEditable()) continue;
                    BHxLdapDeviceView.writeProperty(SlotPath.escape((String)cols[i].getDisplayName()), op, o, BHxLdapDeviceView.this.getNewDisplayName(cols[i].getDisplayName()), BFacets.make((String)"alwaysExpanded", (BIDataValue)BBoolean.TRUE), cols[i].isReadonly());
                }
                out.w((Object)"</table>");
            }
        }
    }

    class AddDevice
    extends SmartCommand {
        AddDeviceDialog addDeviceDlg;

        public AddDevice(BHxView view) {
            super(view, LexiconModule.make((BModule)BHxLdapDeviceView.secUtilLex.module));
            this.addDeviceDlg = new AddDeviceDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "new";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean isDefaultAction() {
            return false;
        }

        public String getDefaultDisplayName(HxOp op) {
            return this.getNewComponent(op).getType().getDisplayName((Context)op);
        }

        public BComponent getNewComponent(HxOp op) {
            Type newType = BHxLdapDeviceView.this.getQueryType(op);
            return (BComponent)newType.getInstance();
        }

        public boolean process(HxOp op) throws Exception {
            if (!this.matchesScope(op)) {
                return false;
            }
            if (super.process(op)) {
                return true;
            }
            SmartCommand[] cmds = (SmartCommand[])this.addDeviceDlg.getCommands();
            for (int i = 0; i < cmds.length; ++i) {
                if (!cmds[i].process(op)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(HxOp op) throws Exception {
            if (!this.addDeviceDlg.isSubmit(op)) {
                this.addDeviceDlg.open(op);
                return;
            }
            BComponent newC = this.getNewComponent(op);
            MgrColumn[] cols = LdapUtil.getMgrColumns(newC);
            String name = BHxLdapDeviceView.readProperty("name", op, (BObject)BString.DEFAULT).toString();
            for (int i = 0; i < cols.length; ++i) {
                String propName111 = SlotPath.escape((String)cols[i].getDisplayName());
                BObject o = (BObject)cols[i].get((Object)newC);
                if (!(o instanceof BSimple) && !(o instanceof BStruct) || !cols[i].isEditable()) continue;
                String propName = SlotPath.escape((String)cols[i].getDisplayName());
                String newPropStr = op.getFormValue(propName + ".value");
                BValue originalPropValue = (BValue)o;
                BObject obj = BHxLdapDeviceView.readProperty(propName, op, (BObject)originalPropValue);
                cols[i].save(new MgrEditRow(newC, null, null), (BValue)obj, null);
            }
            name = SlotPath.escape((String)name);
            BHxLdapDeviceView.this.getContainer(op).add(name, (BValue)newC);
            newC.lease();
            Thread.sleep(1000L);
            ((BHxAbstractManagerView)this.getView()).reloadTables(op);
            BOrd ord = newC.getSlotPathOrd();
            OrionSession session = BHxLdapDeviceView.this.getOrionSession();
            try {
                com.tridiumx.entsec.access.orion.BLdapServer entsecldapServer = BHxLdapDeviceView.this.makeLdapServerEntry(ord);
                session.insert((BIOrionObject)entsecldapServer);
                session.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                session.rollback();
            }
            finally {
                BHxLdapDeviceView.this.closeOrionSession(session);
            }
        }

        class AddDeviceDialog
        extends Dialog {
            public AddDeviceDialog(String title, Command handler) {
                super(title, handler);
            }

            public Command[] getCommands() {
                return new Command[]{this.makeSubmitCommand(), this.makeCancelCommand()};
            }

            protected void writeContent(HxOp op) throws Exception {
                HtmlWriter out = op.getHtmlWriter();
                BHxSmartTableView.writeUnscopedFormValue((String)"step", (String)"addDevice", (HxOp)op);
                out.w((Object)"<table>");
                BComponent newC = AddDevice.this.getNewComponent(op);
                MgrColumn[] cols = LdapUtil.getMgrColumns(newC);
                BHxLdapDeviceView.writeProperty("name", op, (BObject)BString.make((String)AddDevice.this.getDefaultDisplayName(op)), secUtilLex.getText("displayName"), BFacets.NULL, false);
                for (int i = 0; i < cols.length; ++i) {
                    BObject o = (BObject)cols[i].get((Object)newC);
                    if (!(o instanceof BSimple) && !(o instanceof BStruct) || !cols[i].isEditable()) continue;
                    BHxLdapDeviceView.writeProperty(SlotPath.escape((String)cols[i].getDisplayName()), op, o, BHxLdapDeviceView.this.getNewDisplayName(cols[i].getDisplayName()), BFacets.make((String)"alwaysExpanded", (BIDataValue)BBoolean.TRUE), cols[i].isReadonly());
                }
                out.w((Object)"</table>");
            }
        }
    }
}

