/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.ldapHx;

import com.tridium.ndriver.discover.BINDiscoveryLeaf;
import com.tridium.ndriver.discover.BNDiscoveryJob;
import com.tridium.ndriver.discover.BNDiscoveryLeaf;
import com.tridium.ndriver.ui.NMgrColumnUtil;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionService;
import com.tridium.orion.OrionSession;
import com.tridium.orion.sql.TableBuilder;
import com.tridiumx.entsec.access.orion.BAccessRightLdapGroupJoin;
import com.tridiumx.entsec.access.orion.BBadgeLdapServerJoin;
import com.tridiumx.entsec.access.orion.BLdapGroup;
import com.tridiumx.entsec.access.orion.BLdapServer;
import com.tridiumx.entsec.access.orion.BPersonLdapServerJoin;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import javax.baja.nre.util.Array;
import javax.baja.query.BQuery;
import javax.baja.rdb.ddl.DdlCommand;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.Property;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.MgrColumn;

public class LdapUtil {
    static final Lexicon secUtilLex = Lexicon.make(LdapUtil.class);

    public static MgrColumn[] getMgrColumns(BComponent component) {
        Array columns = new Array(MgrColumn.class);
        NMgrColumnUtil.getColumnsFor((BComplex)component, (Array)columns);
        MgrColumn[] mgrCol = new MgrColumn[columns.size()];
        Object[] columsArray = columns.array();
        for (int i = 0; i < columsArray.length; ++i) {
            if (columsArray[i] == null) continue;
            mgrCol[i] = (MgrColumn)columsArray[i];
        }
        return mgrCol;
    }

    public static void addLdapAttrDiscoveryQuery(BQuery query, Type deviceType) {
        BComplex c = deviceType.getInstance().asComplex();
        Property[] props = c.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            if (props[i].getName().equals("status") || props[i].getName().equals("enabled") || props[i].getName().equals("faultCause") || props[i].getName().equals("health") || props[i].getName().equals("alarmSourceInfo")) continue;
            QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(props[i].getType().getTypeSpec(), props[i].getName(), props[i].getName()));
        }
    }

    public static Type getLeafType(BComplex container) {
        return BINDiscoveryLeaf.TYPE;
    }

    public static Type getLeafType(Type jobType) {
        if (jobType.is(BNDiscoveryJob.TYPE)) {
            return BNDiscoveryLeaf.TYPE;
        }
        return null;
    }

    private static OrionSession getOrionSession() {
        BOrionDatabase[] orionDatabases = BOrionService.getService().getOrionDatabases();
        if (orionDatabases.length > 0) {
            OrionSession orionSession = orionDatabases[0].createSession(null);
            orionSession.setAutoCommit(false);
            return orionSession;
        }
        return null;
    }

    private static void closeOrionSession(OrionSession orionSession) {
        if (orionSession != null) {
            orionSession.close();
            orionSession = null;
        }
    }

    public static void deleteLdapNetwork() {
        OrionSession session = LdapUtil.getOrionSession();
        TableBuilder[] builders = new TableBuilder[]{new TableBuilder(session.getOrionDatabase(), BLdapServer.ORION_TYPE), new TableBuilder(session.getOrionDatabase(), BLdapGroup.ORION_TYPE), new TableBuilder(session.getOrionDatabase(), BPersonLdapServerJoin.ORION_TYPE), new TableBuilder(session.getOrionDatabase(), BAccessRightLdapGroupJoin.ORION_TYPE), new TableBuilder(session.getOrionDatabase(), BBadgeLdapServerJoin.ORION_TYPE)};
        try {
            int i;
            for (i = builders.length - 1; i >= 0; --i) {
                LdapUtil.dropTable(session, builders[i]);
            }
            for (i = 0; i < builders.length; ++i) {
                LdapUtil.createTable(session, builders[i]);
            }
        }
        finally {
            LdapUtil.closeOrionSession(session);
        }
    }

    private static void dropTable(OrionSession session, TableBuilder tb) {
        DdlCommand[] ddl = tb.dropTable();
        for (int i = 0; i < ddl.length; ++i) {
            try {
                session.invokeDdl(ddl[i]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void createTable(OrionSession session, TableBuilder tb) {
        DdlCommand[] ddl = tb.createTable();
        for (int i = 0; i < ddl.length; ++i) {
            try {
                session.invokeDdl(ddl[i]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

