/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.ldapHx;

import com.tridium.hx.ErrorDialog;
import com.tridium.hx.progress.HxProgressJobDialog;
import com.tridium.hx.util.HxUtils;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.JobLogDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.ldap.importconfig.BLdapForceImportJob;
import com.tridiumx.entsec.ldap.importconfig.BLdapImportConfig;
import com.tridiumx.entsec.ldap.util.ExportPersonsDataUtility;
import com.tridiumx.entsec.ldap.util.LdapValidationUtil;
import com.tridiumx.entsec.securityUtil.BPingJob;
import com.tridiumx.entsecHx.ldapHx.BHxLdapAttributesView;
import com.tridiumx.entsecHx.ldapHx.BHxLdapGroupsView;
import com.tridiumx.entsecHx.ldapHx.ui.IPAddressUtil;
import com.tridiumx.entsecHx.ldapHx.ui.LdapImportDialogPreferences;
import com.tridiumx.entsecHx.securityUtilHx.job.BHxAbstractJobView;
import com.tridiumx.entsecHx.securityUtilHx.manager.BHxManageDevicesView;
import com.tridiumx.entsecHx.securityUtilHx.manager.ManageDevicesCommand;
import com.tridiumx.ldapDriver.BLdapSearchControlScope;
import com.tridiumx.ldapDriver.BLdapServer;
import com.tridiumx.ldapDriver.attributes.BLdapAttributesDeviceExt;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.ping.BIPingable;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BTypeSpec;
import javax.baja.util.CannotValidateException;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"ldapDriver:LdapServer"}, app="entsec", requiredPermissions="r")})
@NiagaraSingleton
public class BHxLdapDeviceSystem
extends BHxManageDevicesView
implements HxProgressJobDialog.IHxProgressDialogParent {
    static final Lexicon lex = Lexicon.make(BHxLdapDeviceSystem.class);
    public static final BHxLdapDeviceSystem INSTANCE = new BHxLdapDeviceSystem();
    public static final Type TYPE = Sys.loadType(BHxLdapDeviceSystem.class);
    SmartCommand forceImportCommand;
    HxProgressJobDialog.ProgressEvent forceImportProgressEvent;
    ForceImportProgressCommand forceImportProgressCommand;
    SmartCommand pingCommand;
    HxProgressJobDialog.ProgressEvent progressEvent = HxProgressJobDialog.makeProgress((String)lex.getText("ping.label"), (BHxView)this, (HxProgressJobDialog.IHxProgressDialogParent)this);
    HxProgressJobDialog.ProgressEvent retrieveProgressEvent;
    ProgressCommand progressCommand;

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxLdapDeviceSystem() {
        this.registerEvent((Event)this.progressEvent);
        this.progressCommand = new ProgressCommand((BHxView)this, this.progressEvent);
        this.registerEvent((Event)this.progressCommand);
        this.progressEvent.setJobCompleteHandler((HxProgressJobDialog.IJobCompleteHandler)this.progressCommand);
        this.pingCommand = new PingCommand((BHxView)this, this.progressCommand);
        this.registerEvent((Event)this.pingCommand);
        this.forceImportProgressEvent = HxProgressJobDialog.makeProgress((String)lex.getText("Import.label"), (BHxView)this, (HxProgressJobDialog.IHxProgressDialogParent)this);
        this.registerEvent((Event)this.forceImportProgressEvent);
        this.forceImportProgressCommand = new ForceImportProgressCommand((BHxView)this, this.forceImportProgressEvent);
        this.registerEvent((Event)this.forceImportProgressCommand);
        this.forceImportProgressEvent.setJobCompleteHandler((HxProgressJobDialog.IJobCompleteHandler)this.forceImportProgressCommand);
        this.forceImportCommand = new ForceImportCommand((BHxView)this, this.forceImportProgressCommand);
        this.registerEvent((Event)this.forceImportCommand);
    }

    @Override
    public BTypeSpec getTypeSpec(HxOp op) {
        return BTypeSpec.make((String)"ldapDriver", (String)"LdapServer");
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        Array arr = new Array((Object[])super.getButtonCommands(op));
        for (int i = 0; i < arr.size(); ++i) {
            if (!(arr.get(i) instanceof ManageDevicesCommand)) continue;
            arr.remove(i);
        }
        arr.add(1, (Object)this.pingCommand);
        arr.add(2, (Object)this.forceImportCommand);
        return (SmartCommand[])arr.trim();
    }

    @Override
    public String[] getProperties(HxOp op) {
        BComponent c = (BComponent)op.get();
        Property[] props = c.getPropertiesArray();
        Array returnedProps = new Array(String.class);
        for (int i = 0; i < props.length; ++i) {
            Type propType = props[i].getType();
            if (propType.is(BDeviceExt.TYPE) || propType.is(BLink.TYPE)) continue;
            returnedProps.add((Object)props[i].getName());
        }
        return (String[])returnedProps.trim();
    }

    @Override
    public Tab[] getTabs(HxOp op) throws Exception {
        Object[] defaultTabs = super.getTabs(op);
        Array a = new Array(defaultTabs);
        BObject o = op.get();
        String ldapServerName = o.toString((Context)op);
        if (o instanceof BINavNode) {
            ldapServerName = ((BINavNode)o).getNavDisplayName((Context)op);
        }
        BComponent ext = (BComponent)((BComponent)op.get()).get("attributes");
        Tab attributes = new Tab((BHxView)BHxLdapAttributesView.INSTANCE, "Attributes", op.make("attributes", (BObject)ext, null), op);
        a.add((Object)attributes);
        ext = (BComponent)((BComponent)op.get()).get("groups");
        Tab groups = new Tab((BHxView)BHxLdapGroupsView.INSTANCE, "Groups", op.make("groups", (BObject)ext, null), op);
        op.getRequest().getSession().setAttribute("ldapServerName", (Object)ldapServerName);
        a.add((Object)groups);
        return (Tab[])a.trim();
    }

    public void update(HxOp op) throws Exception {
        super.update(op);
        String name = op.scope("job");
        String ordStr = op.getFormValue(name);
        if (ordStr != null) {
            HxUtils.forceUpdate((BRelTime)BRelTime.make((long)750L), (HxOp)op);
        }
        this.progressEvent.getDialog().updateContent(op);
        this.forceImportProgressEvent.getDialog().updateContent(op);
    }

    public BJob submitJob(HxProgressJobDialog dialog, HxOp op) {
        BJob job = (BJob)op.getRequest().getSession().getAttribute("job");
        op.getRequest().getSession().removeAttribute("job");
        BOrd jobOrd = job.submit((Context)op);
        return (BJob)BOrd.make((String)("station:|" + jobOrd)).get();
    }

    @Override
    public BObject save(HxOp op) throws Exception {
        String hostString = op.getFormValue("properties.ldapConnection.expanded.connectionHost.value");
        if (!IPAddressUtil.isNumericAddr(hostString) && !IPAddressUtil.isHostname(hostString)) {
            throw new CannotValidateException(lex.getText("ldap.connection.hostame.invalid", new Object[]{hostString}));
        }
        BLdapServer server = (BLdapServer)super.save(op);
        BLdapImportConfig importConfig = (BLdapImportConfig)server.getMixIn(BLdapImportConfig.TYPE);
        if (importConfig != null) {
            if (!"".equals(importConfig.getGroupAttribute().trim())) {
                server.getAttributes().setGroupAttribute(importConfig.getGroupAttribute());
            }
            importConfig.updateValidStatusList();
            importConfig.commitImportFrequency();
        }
        return server;
    }

    public void saveImportPreferences(BLdapServer server, HxOp op) {
        try {
            BString accountExpiryDateTimeAttributeVal;
            BString savedAccountExpiryDateTimeAttributeVal;
            BString activeStatusValuesVal;
            BString savedActiveStatusValues;
            BString statusAttributeVal;
            BString savedStatusAttribute;
            BBoolean allowNewInactiveUsersVal;
            BBoolean savedAllowNewInactiveUsers;
            BLdapImportConfig importConfig;
            BString groupAttributeVal;
            BString savedGroupAttribute;
            BLdapSearchControlScope searchScopeEnum;
            BLdapSearchControlScope savedSearchScopeEnum;
            BString userSearchFilterVal;
            BString savedUserSearchFilterVal;
            BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)BBoolean.DEFAULT, (Context)op);
            BString userSearchVal = (BString)server.get(BLdapServer.userSearchBase);
            editor = BHxFieldEditor.makeFor((BObject)userSearchVal, (Context)op);
            HxOp fieldOp = op.make("userSearchBase", (BObject)userSearchVal, null);
            BString savedUserSearch = (BString)editor.save(fieldOp);
            if (!savedUserSearch.equals((Object)fieldOp.get())) {
                server.set(BLdapServer.userSearchBase, (BValue)savedUserSearch, (Context)op);
            }
            if (!(savedUserSearchFilterVal = (BString)(editor = BHxFieldEditor.makeFor((BObject)(userSearchFilterVal = (BString)server.get(BLdapServer.userSearchFilter)), (Context)op)).save(fieldOp = op.make("userSearchFilter", (BObject)userSearchFilterVal, null))).equals((Object)fieldOp.get())) {
                server.set(BLdapServer.userSearchFilter, (BValue)savedUserSearchFilterVal, (Context)op);
            }
            if (!(savedSearchScopeEnum = (BLdapSearchControlScope)(editor = BHxFieldEditor.makeFor((BObject)(searchScopeEnum = (BLdapSearchControlScope)server.get(BLdapServer.searchScope)), (Context)op)).save(fieldOp = op.make("searchScope", (BObject)searchScopeEnum, server.getSlotFacets((Slot)BLdapServer.searchScope)))).equals((Object)fieldOp.get())) {
                server.set(BLdapServer.searchScope, (BValue)savedSearchScopeEnum, (Context)op);
            }
            if (!(savedGroupAttribute = (BString)(editor = BHxFieldEditor.makeFor((BObject)(groupAttributeVal = (BString)(importConfig = (BLdapImportConfig)server.getMixIn(BLdapImportConfig.TYPE)).get(BLdapImportConfig.groupAttribute)), (Context)op)).save(fieldOp = op.make("groupAttribute", (BObject)groupAttributeVal, null))).equals((Object)fieldOp.get())) {
                BLdapAttributesDeviceExt updatedLdapAttributesDeviceExt = (BLdapAttributesDeviceExt)server.get(BLdapServer.attributes);
                updatedLdapAttributesDeviceExt.set(BLdapAttributesDeviceExt.groupAttribute, (BValue)savedGroupAttribute, (Context)op);
                server.set(BLdapServer.attributes, (BValue)updatedLdapAttributesDeviceExt, (Context)op);
                importConfig.set(BLdapImportConfig.groupAttribute, (BValue)savedGroupAttribute, (Context)op);
            }
            if (!(savedAllowNewInactiveUsers = (BBoolean)(editor = BHxFieldEditor.makeFor((BObject)(allowNewInactiveUsersVal = (BBoolean)importConfig.get(BLdapImportConfig.allowNewInactiveUsers)), (Context)op)).save(fieldOp = op.make("allowNewInactiveUsers", (BObject)allowNewInactiveUsersVal, null))).equals((Object)fieldOp.get())) {
                importConfig.set(BLdapImportConfig.allowNewInactiveUsers, (BValue)savedAllowNewInactiveUsers, (Context)op);
            }
            if (!(savedStatusAttribute = (BString)(editor = BHxFieldEditor.makeFor((BObject)(statusAttributeVal = (BString)importConfig.get(BLdapImportConfig.statusAttribute)), (Context)op)).save(fieldOp = op.make("statusAttribute", (BObject)statusAttributeVal, null))).equals((Object)fieldOp.get())) {
                importConfig.set(BLdapImportConfig.statusAttribute, (BValue)savedStatusAttribute, (Context)op);
            }
            if (!(savedActiveStatusValues = (BString)(editor = BHxFieldEditor.makeFor((BObject)(activeStatusValuesVal = (BString)importConfig.get(BLdapImportConfig.activeStatusValues)), (Context)op)).save(fieldOp = op.make("activeStatusValues", (BObject)activeStatusValuesVal, null))).equals((Object)fieldOp.get())) {
                importConfig.set(BLdapImportConfig.activeStatusValues, (BValue)savedActiveStatusValues, (Context)op);
                importConfig.updateValidStatusList();
            }
            if (!(savedAccountExpiryDateTimeAttributeVal = (BString)(editor = BHxFieldEditor.makeFor((BObject)(accountExpiryDateTimeAttributeVal = (BString)importConfig.get(BLdapImportConfig.accountExpiryDateTimeAttribute)), (Context)op)).save(fieldOp = op.make("accountExpiryDateTimeAttribute", (BObject)accountExpiryDateTimeAttributeVal, null))).equals((Object)fieldOp.get())) {
                importConfig.set(BLdapImportConfig.accountExpiryDateTimeAttribute, (BValue)savedAccountExpiryDateTimeAttributeVal, (Context)op);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    static class ConfirmDialog
    extends Dialog {
        String msg;

        public ConfirmDialog(String title, Command handler) {
            super(title, handler);
        }

        public Command[] getCommands() {
            return new Command[]{this.makeSubmitCommand(), this.makeCancelCommand()};
        }

        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<table>");
            out.w((Object)"<tr><td>");
            String text = TextUtil.replace((String)this.msg, (String)"\n", (String)"<br/>");
            text = TextUtil.replace((String)text, (String)"\r", (String)"");
            out.w((Object)"<b>").w((Object)text).w((Object)"&nbsp;</b>");
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            out.w((Object)"</table>");
        }
    }

    public static class ForceImportJobLogDialog
    extends JobLogDialog.JobLogDialogRefresh {
        public ForceImportJobLogDialog(Command command, BJob job, String title, HxOp op) {
            super(command, job, title, null);
        }

        public Command[] getCommands() {
            return new Command[]{new JobLogDialog.JobLogDialogRefresh.DoneRefresh((JobLogDialog.JobLogDialogRefresh)this), new JobLogDialog.Export((JobLogDialog)this), new AuditLogs()};
        }

        protected class AuditLogs
        extends Dialog.Cancel {
            public AuditLogs() {
                super((Dialog)ForceImportJobLogDialog.this);
            }

            public String getDisplayName(HxOp op) {
                return Lexicon.make(((Object)((Object)this)).getClass()).getText("AuditLogs");
            }

            public String getInvokeCode(HxOp op) {
                StringBuffer b = new StringBuffer();
                b.append("hx.closeDialog(null,null,null);");
                BOrd urll = BOrd.make((String)"service:entsec:EnterpriseSecurityService|slot:ldapAuditHistory");
                b.append("window.location=&quot;").append(op.toUri(urll)).append("&quot;;");
                return b.toString();
            }
        }
    }

    public static class ForceImportProgressCommand
    extends Command
    implements HxProgressJobDialog.IJobCompleteHandler {
        HxProgressJobDialog.ProgressEvent importProgressEvent;

        public ForceImportProgressCommand(BHxView view, HxProgressJobDialog.ProgressEvent importProgressEvent) {
            super(view);
            this.importProgressEvent = importProgressEvent;
        }

        public void invoke(BJob job, HxOp op) throws Exception {
            if (job.getJobState().equals((Object)BJobState.failed) || job.getJobState().equals((Object)BJobState.canceled)) {
                job.log().message("See the LDAP audit history for more details");
                new ForceImportJobLogDialog(this, job, null, op).open(op);
            } else if (job.getJobState().equals((Object)BJobState.success)) {
                job.log().message("See the LDAP audit history for more details");
                new ForceImportJobLogDialog(this, job, null, op).open(op);
            }
        }

        public void handle(HxOp op) throws Exception {
            this.importProgressEvent.handle(op);
        }
    }

    public class ForceImportCommand
    extends SmartCommand {
        LdapImportDialogPreferences confirm;
        Command importProgressCommand;

        public ForceImportCommand(BHxView view, Command importProgressCommand) {
            super(view);
            this.confirm = new LdapImportDialogPreferences((Command)this);
            this.importProgressCommand = importProgressCommand;
        }

        public String getName(HxOp op) {
            return "DeviceImport";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public boolean isDefaultAction() {
            return false;
        }

        public void handle(HxOp op) throws Exception {
            if (!LdapValidationUtil.hasImportPrivileges((BUser)op.getUser())) {
                new ErrorDialog(this.lexModule.getText("import.privilege.error", (Context)op), (Throwable)new LocalizableRuntimeException(TYPE.getModule().getModuleName(), this.lexModule.getText("import.privilege.errorMsg", (Context)op))).open(op);
                return;
            }
            BObject o = op.get();
            String ldapServerName = o.toString((Context)op);
            if (o instanceof BINavNode) {
                ldapServerName = ((BINavNode)o).getNavDisplayName((Context)op);
            }
            BLdapServer ldapServer = ExportPersonsDataUtility.getSelectedLdapServer((String)SlotPath.escape((String)ldapServerName));
            if (!this.confirm.isSubmit(op)) {
                this.confirm.setLdapServer(ldapServer);
                this.confirm.open(op);
                return;
            }
            BHxLdapDeviceSystem.this.saveImportPreferences(ldapServer, op);
            BLdapForceImportJob job = new BLdapForceImportJob(ldapServer);
            op.getRequest().getSession().setAttribute("job", (Object)job);
            this.importProgressCommand.handle(op);
        }
    }

    public static class PingCommand
    extends SmartCommand {
        Command progressCommand;

        public PingCommand(BHxView view, Command progressCommand) {
            super(view);
            this.progressCommand = progressCommand;
        }

        public String getName(HxOp op) {
            return "ping";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public void handle(HxOp op) throws Exception {
            BPingJob job = new BPingJob((BIPingable)op.get());
            op.getRequest().getSession().setAttribute("job", (Object)job);
            this.progressCommand.handle(op);
        }
    }

    public static class ProgressCommand
    extends Command
    implements HxProgressJobDialog.IJobCompleteHandler {
        HxProgressJobDialog.ProgressEvent progressEvent;

        public ProgressCommand(BHxView view, HxProgressJobDialog.ProgressEvent progressEvent) {
            super(view);
            this.progressEvent = progressEvent;
        }

        public void invoke(BJob job, HxOp op) throws Exception {
            if (job.getJobState().equals((Object)BJobState.failed) || job.getJobState().equals((Object)BJobState.canceled)) {
                BHxAbstractJobView.openErrorDialog(job, this, op);
            } else if (job.getJobState().equals((Object)BJobState.success)) {
                BHxAbstractJobView.openSuccessDialog(job, this, op);
            }
        }

        public void handle(HxOp op) throws Exception {
            this.progressEvent.handle(op);
        }
    }
}

