/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.ldapHx;

import com.tridium.hx.progress.HxProgressJobDialog;
import com.tridium.ndriver.discover.BINDiscoveryHost;
import com.tridium.ndriver.discover.BINDiscoveryLeaf;
import com.tridium.ndriver.discover.BNDiscoveryPreferences;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.ConfirmDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.ldap.BLdapAttributeProperties;
import com.tridiumx.entsec.ldap.util.LdapValidationUtil;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import com.tridiumx.entsecHx.ldapHx.LdapUtil;
import com.tridiumx.entsecHx.ldapHx.discover.BHxLdapAttributesDiscoverView;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractDiscoverView;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractManagerView;
import com.tridiumx.entsecHx.securityUtilHx.job.BHxAbstractJobView;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxQueryTableView;
import com.tridiumx.ldapDriver.attributes.BLdapAttribute;
import java.util.ArrayList;
import javax.baja.data.BIDataValue;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.query.BExtent;
import javax.baja.query.BProjection;
import javax.baja.query.BQuery;
import javax.baja.query.BSingleExtent;
import javax.baja.status.BStatus;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraSingleton
public class BHxLdapAttributesView
extends BHxAbstractManagerView {
    static final Lexicon secUtilLex = Lexicon.make(BHxLdapAttributesView.class);
    public static final BHxLdapAttributesView INSTANCE = new BHxLdapAttributesView();
    public static final Type TYPE = Sys.loadType(BHxLdapAttributesView.class);
    public DiscoverCommand discoverCommand = new DiscoverCommand((BHxView)this);
    public SmartCommand deleteCommand;

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxLdapAttributesView() {
        this.registerEvent((Event)this.discoverCommand);
        this.deleteCommand = new Delete((BHxView)this);
        this.registerEvent((Event)this.deleteCommand);
    }

    @Override
    public String getPageTitle(HxOp op) {
        return secUtilLex.getText("LdapAttributesMgr");
    }

    @Override
    public BTypeSpec getDeviceTypeSpec(HxOp op) {
        return BLdapAttributeProperties.TYPE.getTypeSpec();
    }

    public Type getQueryType(HxOp op) {
        return BLdapAttribute.TYPE;
    }

    @Override
    public BQuery getQuery(HxOp op) {
        BComponent component = (BComponent)op.get();
        BQuery query = QueryUtil.makeQuery((BTypeSpec)this.getDeviceTypeSpec(op));
        query.select(new BProjection());
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(BString.TYPE.getTypeSpec(), "attrName", secUtilLex.getText("displayName")));
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(BString.TYPE.getTypeSpec(), "isMandatory", secUtilLex.getText("isMandatory")));
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(BStatus.TYPE.getTypeSpec(), "parentClass", secUtilLex.getText("parentClass")));
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(BStatus.TYPE.getTypeSpec(), "dataType", secUtilLex.getText("dataType")));
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(BStatus.TYPE.getTypeSpec(), "description", secUtilLex.getText("description")));
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(BStatus.TYPE.getTypeSpec(), "MappedORD", secUtilLex.getText("MappedORD")));
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(BBoolean.TYPE.getTypeSpec(), "isRDN", secUtilLex.getText("isRDN")));
        QueryUtil.addHiddenColumns((BQuery)query);
        query.add("base", (BValue)component.getAbsoluteOrd());
        query = QueryUtil.getWorkingCopy((BQuery)query, (Context)op);
        return query;
    }

    @Override
    public BQuery getDiscoverQuery(HxOp op) {
        BObject o;
        BOrd jobOrd;
        Type newType = this.getQueryType(op);
        BQuery query = new BQuery();
        query.from((BExtent)new BSingleExtent(this.getLearnRowTypeSpec(op)));
        query.select(new BProjection());
        LdapUtil.addLdapAttrDiscoveryQuery(query, newType);
        QueryUtil.addSlotFacetColumn((BQuery)query, (Type)BBoolean.TYPE, (String)"dbExistence", (String)secUtilLex.getText("AttributeExists"));
        QueryUtil.addHiddenColumns((BQuery)query);
        String jobOrdStr = op.getFormValue("discover.discoverJobOrd");
        if (jobOrdStr != null && (jobOrd = BOrd.make((String)jobOrdStr)) != null && (o = jobOrd.get()) instanceof BJob) {
            BJob job = (BJob)o;
            this.updateExistenceFacets(job, op);
            query.add("base", (BValue)job.getAbsoluteOrd());
        }
        return query;
    }

    public String[] getLearnFields(HxOp op) {
        Type newType = this.getQueryType(op);
        BComponent instance = newType.getInstance().asComponent();
        BComplex c = BTypeSpec.make((String)"ldapDriver:LdapAttributesDiscoveryLeaf").getInstance().asComplex();
        Property[] props = c.getPropertiesArray();
        String[] fields = new String[props.length + 1];
        for (int i = 0; i < props.length; ++i) {
            fields[i] = "" + props[i].getName();
        }
        return fields;
    }

    @Override
    public BHxAbstractDiscoverView getDiscoverView(HxOp op) {
        return BHxLdapAttributesDiscoverView.INSTANCE;
    }

    public BComponent getContainer(HxOp op) {
        return (BComponent)op.get();
    }

    @Override
    public BTypeSpec getLearnRowTypeSpec(HxOp op) {
        BComponent container = this.getContainer(op);
        return LdapUtil.getLeafType((BComplex)container).getTypeSpec();
    }

    @Override
    public BJob submitDiscoveryJob(HxOp op) {
        BComponent deviceSys = this.getContainer(op);
        BOrd ord = ((BINDiscoveryHost)deviceSys).submitDiscoveryJob((BNDiscoveryPreferences)deviceSys.get("discoveryPreferences"));
        return (BJob)ord.get((BObject)deviceSys);
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.discoverCommand, this.deleteCommand, this.filterCommand, this.refresh, this.exportCommand, this.learnMode};
    }

    public BComponent[] getAllDevices(Type deviceType, HxOp op) {
        ArrayList<BComponent> list = new ArrayList<BComponent>();
        this.getAllDevices(this.getContainer(op), deviceType, list);
        if (list.size() > 0) {
            return list.toArray(new BComponent[list.size()]);
        }
        return new BComponent[0];
    }

    private void getAllDevices(BComponent comp, Type deviceType, ArrayList<BComponent> list) {
        SlotCursor cursor = comp.loadSlots().getProperties();
        while (cursor.nextComponent()) {
            BComponent kid = cursor.get().asComponent();
            if (kid.getType().is(deviceType)) {
                list.add(kid);
                continue;
            }
            this.getAllDevices(kid, deviceType, list);
        }
    }

    void updateExistenceFacets(BJob job, HxOp op) {
        BComponent[] deviceArr = this.getAllDevices(this.getQueryType(op), op);
        SlotCursor c = job.getProperties();
        while (c.next(BINDiscoveryLeaf.class)) {
            Property prop = c.property();
            BFacets facets = job.getSlotFacets((Slot)prop);
            BINDiscoveryLeaf device = (BINDiscoveryLeaf)job.get(prop);
            BBoolean exists = BBoolean.FALSE;
            for (int i = 0; i < deviceArr.length; ++i) {
                if (!device.isExisting(deviceArr[i])) continue;
                exists = BBoolean.TRUE;
                break;
            }
            job.setFacets((Slot)prop, BFacets.make((BFacets)facets, (String)"dbExistence", (BIDataValue)exists));
        }
    }

    @Override
    public boolean showDiscoveryDialog(HxOp op) {
        BValue preferences = this.getContainer(op).get("discoveryPreferences");
        if (!(preferences instanceof BNDiscoveryPreferences)) {
            return false;
        }
        return !((BNDiscoveryPreferences)preferences).getDoNotAskAgain();
    }

    @Override
    public Tab getDiscoveryPreferencesTab(HxOp op) {
        BValue preferences = this.getContainer(op).get("discoveryPreferences");
        HxOp tabOp = op.make("additionalFields", (BObject)preferences, null);
        SmartCommand.matchReadonly((HxOp)tabOp, (HxOp)op);
        return new Tab((BHxView)BHxFieldSheet.INSTANCE, tabOp);
    }

    @Override
    public boolean process(HxOp op) throws Exception {
        if (this.getDiscoveryPreferencesTab(op).process()) {
            return true;
        }
        return super.process(op);
    }

    public class DiscoverCommand
    extends SmartCommand
    implements HxProgressJobDialog.IJobCompleteHandler {
        private Dialog discoverDialog;

        public DiscoverCommand(BHxView view) {
            super(view);
            this.discoverDialog = BHxLdapAttributesView.this.getDiscoverDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "discover";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return LdapValidationUtil.hasImportPrivileges((BUser)op.getUser());
        }

        public void invoke(BJob job, HxOp op) throws Exception {
            if (job.getJobState().equals((Object)BJobState.failed)) {
                BHxAbstractJobView.openErrorDialog(job, (Command)this, Lexicon.make(BHxAbstractManagerView.class).getText("discoveryError"), op);
            } else if (job.getJobState().equals((Object)BJobState.success)) {
                BHxLdapAttributesView.this.learnMode.update(true, op);
                op.removeCookie(SmartCommand.scopeWithOrd((String)"learnMode", (HxOp)op));
            }
            BHxLdapAttributesView.this.reloadTables(op);
        }

        public void handle(HxOp op) throws Exception {
            if (BHxLdapAttributesView.this.showDiscoveryDialog(op) && this.discoverDialog != null) {
                if (!this.discoverDialog.isSubmit(op)) {
                    this.discoverDialog.open(op);
                    return;
                }
                BHxLdapAttributesView.this.handleDiscoverDialog(op);
            }
            BHxLdapAttributesView.this.discoveryEvent.handle(op);
        }
    }

    public class Delete
    extends SmartCommand {
        private Dialog confirm;

        public Delete(BHxView view) {
            super(view);
            this.confirm = new ConfirmDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "delete";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return LdapValidationUtil.hasImportPrivileges((BUser)op.getUser());
        }

        public void handle(HxOp op) throws Exception {
            if (!this.confirm.isSubmit(op)) {
                this.confirm.open(op);
                return;
            }
            BComponent component = BHxLdapAttributesView.this.getComponent(op);
            Object[] subjects = BHxQueryTableView.getSubjects(op);
            Array deletedProps = new Array(Property.class);
            for (int i = 0; i < subjects.length; ++i) {
                Property p = ((BComponent)subjects[i]).getPropertyInParent();
                if (p == null) continue;
                if (p.isFrozen()) {
                    throw new LocalizableRuntimeException(TYPE.getTypeSpec().getModuleName(), "Cannot delete frozen Slot: " + p.getName());
                }
                this.checkRemove(p.getName(), op);
                component.remove(p, (Context)op);
                deletedProps.add((Object)p);
            }
            this.deleted((Property[])deletedProps.trim(), op);
        }

        public void deleted(Property[] props, HxOp op) throws Exception {
            BHxLdapAttributesView.this.rediscover(op);
        }

        public void checkRemove(String propertyName, HxOp op) {
        }
    }
}

