/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.help;

import com.tridium.hx.ErrorDialog;
import com.tridium.hx.HxHyperlinkInfo;
import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.file.BIFile;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BQuery;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BFacets;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class HelpCommand
extends SmartCommand {
    private DiagnosticsDialog dialog = new DiagnosticsDialog("Diagnostics", (Command)this);
    HashMap<String, String> navContext;

    public HelpCommand(BHxView view) {
        super(view);
    }

    public String getName(HxOp op) {
        return "help";
    }

    public String getInvokeCode(HxOp op) {
        String quote = HxUtil.getOuterQuote((HxOp)op);
        StringBuffer b = new StringBuffer();
        b.append("hx.setFormValue(" + quote + "diagnostics" + quote + ", event.ctrlKey);");
        b.append(this.getEnabledInvokeCode(op));
        return b.toString();
    }

    public BCommandEnablePolicy getEnablePolicy() {
        return BCommandEnablePolicy.always;
    }

    public void handle(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        String diagnostics = op.getFormValue("diagnostics");
        if (diagnostics.equals("true")) {
            if (!this.dialog.isSubmit(op)) {
                this.dialog.open(op);
            }
            return;
        }
        try {
            String doc = this.getHelpContext(op);
            String ext = ".html";
            BOrd ord = BOrd.make((String)("accessHelp:/" + doc + ext));
            if (BAccessControlService.LOG.isLoggable(Level.FINE) && Logger.getLogger("entsec.help").isLoggable(Level.FINE)) {
                out.w((Object)("var win = window.open('" + HxUtil.encodeURLForHref((String)op.toUri(ord)) + "','help');"));
                return;
            }
            this.redirect(op, ord);
        }
        catch (ModuleNotFoundException e) {
            new ErrorDialog("Help Not Found", (Command)this, (Throwable)new Exception("Help Module Not Found: " + e.getMessage())).open(op);
        }
    }

    private static HashMap<String, String> loadHelpContext(String fileName) throws Exception {
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        return HelpCommand.loadHelpContext(service.getBrandingManager().getHelpModule(), fileName);
    }

    private static HashMap<String, String> loadHelpContext(BOrd path, String fileName) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        BIFile file = (BIFile)BOrd.make((String)(path + "/nav/" + fileName)).get();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(file.getInputStream()));){
            String line = in.readLine();
            while (line != null) {
                if (line.indexOf("=") > -1 && !line.startsWith("#")) {
                    String[] tokens = TextUtil.split((String)line, (char)'=');
                    String key = TextUtil.split((String)tokens[1], (char)' ')[0];
                    String value = tokens[0];
                    if (key.length() > 0) {
                        hashMap.put(key, value);
                    }
                }
                line = in.readLine();
            }
        }
        return hashMap;
    }

    private String getHelpContext(HxOp op) throws Exception {
        String tab;
        if (this.navContext == null) {
            this.navContext = HelpCommand.loadHelpContext("nav.txt");
        }
        BOrd opOrd = op.getOrd();
        String ord = opOrd.toString();
        String type = op.get().getType().toString();
        String view = HxHyperlinkInfo.getView((BHxView)this.getView(), (HxOp)op).getType().toString();
        String rowType = null;
        ViewQuery viewQuery = op.getViewQuery();
        if (viewQuery != null && (tab = HxTabUtil.getParam((ViewQuery)viewQuery, (String)"tab")) != null) {
            view = tab;
        }
        if (opOrd.get().getType().is(BQuery.TYPE)) {
            BQuery query = (BQuery)opOrd.get();
            rowType = QueryUtil.getRowType((BQuery)query).toString();
        } else if (opOrd.get().getType().is(BDynamicTable.TYPE)) {
            BDynamicTable dt = (BDynamicTable)opOrd.get();
            rowType = dt.getRowType().toString();
        }
        String ordKey = "ord." + ord;
        String typeViewKey = "type.view." + type + "." + view;
        String rowTypeViewKey = "rowType.view." + rowType + "." + view;
        String typeKey = "type." + type;
        String viewKey = "view." + view;
        String rowTypeKey = "rowType." + rowType;
        if (BAccessControlService.LOG.isLoggable(Level.FINE) && Logger.getLogger("entsec.help").isLoggable(Level.FINE)) {
            StringBuffer b = new StringBuffer();
            String saveFile = null;
            String file = this.navContext.get(ordKey);
            if (file != null && saveFile == null) {
                saveFile = file;
                b.append("**");
            }
            b.append(ordKey);
            b.append("\n");
            file = this.navContext.get(typeViewKey);
            if (file != null && saveFile == null) {
                saveFile = file;
                b.append("**");
            }
            b.append(typeViewKey);
            b.append("\n");
            file = this.navContext.get(rowTypeViewKey);
            if (file != null && saveFile == null) {
                saveFile = file;
                b.append("**");
            }
            b.append(rowTypeViewKey);
            b.append("\n");
            file = this.navContext.get(typeKey);
            if (file != null && saveFile == null) {
                saveFile = file;
                b.append("**");
            }
            b.append(typeKey);
            b.append("\n");
            file = this.navContext.get(viewKey);
            if (file != null && saveFile == null) {
                saveFile = file;
                b.append("**");
            }
            b.append(viewKey);
            b.append("\n");
            file = this.navContext.get(rowTypeKey);
            if (file != null && saveFile == null) {
                saveFile = file;
                b.append("**");
            }
            b.append(rowTypeKey);
            b.append("\n");
            op = op.mergeFacets(BFacets.make((String)"forceDetails", (boolean)true));
            if (saveFile != null) {
                new ErrorDialog.SuccessDialog("Help Key Dialog (To remove turn off 'entsec.help' TRACE)", (Command)this, "Key: " + saveFile, b.toString()).open(op);
            } else {
                new ErrorDialog("Help Key Dialog (To remove turn off 'entsec.help' TRACE)", (Command)this, (Throwable)new Exception("Help Not Found"), b.toString()).open(op);
            }
        }
        String file = null;
        file = this.navContext.get(ordKey);
        if (file != null) {
            return file;
        }
        file = this.navContext.get(typeViewKey);
        if (file != null) {
            return file;
        }
        file = this.navContext.get(rowTypeViewKey);
        if (file != null) {
            return file;
        }
        file = this.navContext.get(typeKey);
        if (file != null) {
            return file;
        }
        file = this.navContext.get(viewKey);
        if (file != null) {
            return file;
        }
        file = this.navContext.get(rowTypeKey);
        if (file != null) {
            return file;
        }
        if (BAccessControlService.LOG.isLoggable(Level.FINE)) {
            System.out.println("*********help not found************");
            System.out.println(ordKey);
            System.out.println(typeViewKey);
            System.out.println(rowTypeViewKey);
            System.out.println(typeKey);
            System.out.println(viewKey);
            System.out.println(rowTypeKey);
            System.out.println("");
        }
        return "TOC";
    }

    public static void main(String[] args) {
        try {
            HashMap<String, String> helpMap = HelpCommand.loadHelpContext(BOrd.make((String)"module://genericSecHelp/help"), "nav.txt");
            Object[] values = helpMap.values().toArray();
            for (int i = 0; i < values.length; ++i) {
                String name = (String)values[i];
                BOrd ord = BOrd.make((String)("module://genericSecHelp/help/" + name + ".html"));
                try {
                    BIFile bIFile = (BIFile)ord.get();
                    continue;
                }
                catch (Exception e) {
                    System.out.println(name);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class DiagnosticsDialog
    extends Dialog {
        public DiagnosticsDialog(String title, Command handler) {
            super(title, handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<div style='white-space:nowrap; '>");
            out.w((Object)"<a href='spy:'>Spy</a>");
            out.w((Object)"<br/>");
            out.w((Object)"<b>Available Views</b>");
            out.w((Object)"<br/>");
            TypeInfo typeInfo = HxUtil.getDefaultView((HxOp)op).getAgentType();
            AgentList agentList = HxUtil.getViews((HxOp)op);
            for (int i = 0; i < agentList.size(); ++i) {
                out.safe((Object)agentList.get(i).getAgentType().toString());
                out.w((Object)"<br/>");
            }
            out.w((Object)"</div>");
        }
    }
}

