/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.filter;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.bql.util.BDynamicTimeRangeType;
import com.tridium.hx.fieldeditors.BHxAbsTimeFE;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.ToggleCommand;
import com.tridium.smartTableHx.filter.BHxFilterFE;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.filter.BSecAbsTimeFilter;
import com.tridiumx.entsecHx.securityUtilHx.fieldeditors.BHxSecTimeFE;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"entsec:SecAbsTimeFilterFE"})})
@NiagaraSingleton
public class BHxSecAbsTimeFilterFE
extends BHxFilterFE {
    public static final BHxSecAbsTimeFilterFE INSTANCE = new BHxSecAbsTimeFilterFE();
    public static final Type TYPE = Sys.loadType(BHxSecAbsTimeFilterFE.class);
    private SmartCommand pickerCommand = new PickerCommand((BHxView)this);
    private ToggleCommand advancedCommand;
    private static final Lexicon lex = Lexicon.make((String)"bql");

    public Type getType() {
        return TYPE;
    }

    protected BHxSecAbsTimeFilterFE() {
        this.registerEvent((Event)this.pickerCommand);
        this.advancedCommand = new AdvancedCommand((BHxView)this);
        this.registerEvent((Event)this.advancedCommand);
    }

    public void write(HxOp op) throws Exception {
        BSecAbsTimeFilter filter = (BSecAbsTimeFilter)op.get();
        BDynamicTimeRange range = filter.getDynamicTimeRange();
        BDynamicTimeRange dynamicRange = BDynamicTimeRange.make((BAbsTime)range.getFixedStartTime(), (BAbsTime)range.getFixedEndTime());
        HtmlWriter out = op.getHtmlWriter();
        boolean readonly = Flags.isReadonly((BComplex)filter.getParent().getParent(), (Slot)filter.getParent().getPropertyInParent());
        BHxFieldEditor timeRangeTypeEd = BHxFieldEditor.makeFor((BObject)filter.getTimeRangeType(), (Context)op);
        HxOp timeRangeTypeOp = op.make("timeRangeType", (BObject)filter.getTimeRangeType(), null);
        if (!op.canWrite() || readonly) {
            timeRangeTypeOp.setReadonly(true);
        }
        timeRangeTypeEd.write(timeRangeTypeOp);
        out.w((Object)"<span ");
        out.attr("name", op.scope("picker"));
        out.attr("id", op.scope("picker"));
        out.attr("style", "display:none;");
        out.w((Object)"> ");
        out.w((Object)"<span ");
        out.w((Object)" onclick='").w((Object)this.pickerCommand.getInvokeCode(op)).w((Object)"'");
        out.w((Object)">");
        HxUtil.makeImageJS((BImage)this.pickerCommand.getIcon(op), (HxOp)op);
        out.w((Object)"</span> ");
        out.w((Object)"<input ");
        out.attr("type", "text");
        out.attr("size", "30");
        out.attr("name", op.scope("picker"));
        out.attr("id", op.scope("picker"));
        out.attr("value", this.updateField(dynamicRange, op));
        out.attr("readonly", "readonly");
        out.attr("locked", "locked");
        out.w((Object)"/>");
        BHxSmartTableView.writeFormValue((String)"range", (String)dynamicRange.encodeToString(), (HxOp)op);
        out.w((Object)"</span>");
        HxTabUtil.writeImageCommand((SmartCommand)this.advancedCommand, (HxOp)op);
        HxTabUtil.addEvent((String)"change", (String)HxTabUtil.HIDE_ELEM, (boolean)HxTabUtil.CALL_NOW, (String)timeRangeTypeOp.scope("value"), (String)op.scope("picker"), (String)String.valueOf(0), (HxOp)op);
    }

    public BObject save(HxOp op) throws Exception {
        HxOp timeRangeTypeOp;
        BSecAbsTimeFilter filter = (BSecAbsTimeFilter)op.get();
        BHxFieldEditor timeRangeTypeEd = BHxFieldEditor.makeFor((BObject)filter.getTimeRangeType(), (Context)op);
        BDynamicTimeRangeType rangeType = (BDynamicTimeRangeType)timeRangeTypeEd.save(timeRangeTypeOp = op.make("timeRangeType", (BObject)filter.getTimeRangeType(), null));
        if (rangeType == BDynamicTimeRangeType.timeRange) {
            BDynamicTimeRange range = (BDynamicTimeRange)BDynamicTimeRange.DEFAULT.decodeFromString(op.getFormValue("range"));
            filter.initFromDynamicTimeRange(range);
        } else {
            filter.initFromDynamicTimeRange(BDynamicTimeRange.make((BDynamicTimeRangeType)rangeType));
        }
        return filter;
    }

    public boolean process(HxOp op) throws Exception {
        if (super.process(op)) {
            return true;
        }
        return this.advancedCommand.process(op);
    }

    public String updateField(BDynamicTimeRange range, HxOp op) {
        if (range.getRangeType() != BDynamicTimeRangeType.timeRange) {
            return "";
        }
        return this.formatTimeRange(range.getFixedStartTime(), range.getFixedEndTime(), op);
    }

    private String formatTimeRange(BAbsTime startTime, BAbsTime endTime, HxOp op) {
        StringBuffer s = new StringBuffer();
        if (startTime == null || startTime.isNull()) {
            s.append(lex.getText("dynamicTimeRangeFE.epoch"));
        } else {
            s.append(startTime.toString((Context)op));
        }
        s.append("  ").append(lex.getText("dynamicTimeRangeFE.to")).append("  ");
        if (endTime == null || endTime.isNull()) {
            s.append(lex.getText("dynamicTimeRangeFE.now"));
        } else {
            s.append(endTime.toString((Context)op));
        }
        return s.toString();
    }

    public Tab getAdvancedTab(HxOp op) {
        BSecAbsTimeFilter filter = (BSecAbsTimeFilter)op.get();
        boolean readonly = !op.canWrite() || Flags.isReadonly((BComplex)filter.getParent().getParent(), (Slot)filter.getParent().getPropertyInParent());
        BFacets facets = BHxFieldSheet.getFieldsProvidedFacets((String[])new String[]{"dailyTimeRange.startTime", "dailyTimeRange.endTime", "daysOfWeek", "schedule"});
        BFacets fieldEditorFacets = BHxFieldSheet.getFieldEditorsProvidedFacets((String[])new String[]{BHxSecTimeFE.TYPE.toString(), BHxSecTimeFE.TYPE.toString(), null, null});
        HxOp fieldOp = op.make("advanced", (BObject)filter, facets);
        fieldOp = fieldOp.mergeFacets(fieldEditorFacets);
        if (readonly) {
            fieldOp.setReadonly(true);
        }
        return new Tab((BHxView)BHxFieldSheet.INSTANCE, fieldOp, op);
    }

    public class AdvancedCommand
    extends ToggleCommand {
        private AdvancedDialog dlg;

        public AdvancedCommand(BHxView view) {
            super(view);
            this.dlg = new AdvancedDialog((Command)this, this.getDisplayName(null));
        }

        public String getName(HxOp op) {
            return "advancedTimePicker";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean readonlyEnablePolicy(HxOp op) {
            return true;
        }

        public boolean process(HxOp op) throws Exception {
            if (super.process(op)) {
                return true;
            }
            Tab tab = BHxSecAbsTimeFilterFE.this.getAdvancedTab(op);
            if (op.getPath().length() > op.getRequest().getHeader("x-niagara-hx-path").length()) {
                return false;
            }
            return tab.process();
        }

        public boolean isSelected(HxOp op) {
            BSecAbsTimeFilter filter = (BSecAbsTimeFilter)op.get();
            return !filter.isAdvancedDefault();
        }

        public boolean handle(boolean selected, HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return selected;
            }
            if (!op.canWrite()) {
                return selected;
            }
            BSecAbsTimeFilter filter = (BSecAbsTimeFilter)op.get();
            BHxSecAbsTimeFilterFE.this.getAdvancedTab(op).save();
            return this.isSelected(op);
        }

        public class AdvancedDialog
        extends Dialog {
            AdvancedDialog(Command handler, String title) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                BHxSecAbsTimeFilterFE.this.getAdvancedTab(op).write();
            }
        }
    }

    public class PickerCommand
    extends SmartCommand {
        private PickerDialog dlg;

        public PickerCommand(BHxView view) {
            super(view, smartTableHxLexModule);
            this.dlg = new PickerDialog((Command)this, this.getDisplayName(null));
        }

        public String getName(HxOp op) {
            return "timePicker";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            BSecAbsTimeFilter filter = (BSecAbsTimeFilter)op.get();
            filter = (BSecAbsTimeFilter)filter.newCopy();
            filter.setTimeRangeType(BDynamicTimeRangeType.timeRange);
            HxOp minOp = op.make("min", (BObject)filter.getStartTime(), null);
            filter.set(BSecAbsTimeFilter.startTime, (BValue)BHxAbsTimeFE.INSTANCE.save(minOp));
            HxOp maxOp = op.make("max", (BObject)filter.getEndTime(), null);
            filter.set(BSecAbsTimeFilter.endTime, (BValue)BHxAbsTimeFE.INSTANCE.save(maxOp));
            filter.setMinEnabled(op.getFormValue("minEnabledBackup") != null && op.getFormValue("minEnabledBackup").equals("true"));
            filter.setMaxEnabled(op.getFormValue("maxEnabledBackup") != null && op.getFormValue("maxEnabledBackup").equals("true"));
            HtmlWriter out = op.getHtmlWriter();
            BDynamicTimeRange range = filter.getDynamicTimeRange();
            SmartCommand.setFormValue((String)op.scope("preview"), (Object)BHxSecAbsTimeFilterFE.this.updateField(range, op), (HxOp)op);
            SmartCommand.setFormValue((String)op.scope("range"), (Object)range.encodeToString(), (HxOp)op);
        }

        public class PickerDialog
        extends Dialog {
            PickerDialog(Command handler, String title) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                BSecAbsTimeFilter filter = (BSecAbsTimeFilter)op.get();
                BDynamicTimeRange range = (BDynamicTimeRange)BDynamicTimeRange.DEFAULT.decodeFromString(op.getFormValue("range"));
                filter.initFromDynamicTimeRange(range);
                HtmlWriter out = op.getHtmlWriter();
                boolean readonly = !op.canWrite() || Flags.isReadonly((BComplex)filter.getParent().getParent(), (Slot)filter.getParent().getPropertyInParent());
                HxOp minOp = op.make("min", (BObject)filter.getStartTime(), null);
                out.w((Object)"<input ");
                out.attr("type", "checkbox");
                out.attr("name", op.scope("minEnabled"));
                out.attr("id", op.scope("minEnabled"));
                out.attr("onclick", "hx.setFormValue('" + op.scope("minEnabledBackup") + "', this.checked);");
                if (filter.getMinEnabled()) {
                    op.addOnload("hx.setFormValue('" + op.scope("minEnabledBackup") + "', 'true');");
                    out.attr("checked", "on");
                }
                if (readonly) {
                    minOp.setReadonly(true);
                    out.attr("disabled", "disabled");
                }
                out.w((Object)"/>");
                out.safe((Object)(" " + PickerCommand.this.lexModule.getText("min", (Context)op)));
                out.w((Object)"<span ");
                out.attr("style", "padding:2px");
                out.w((Object)">&nbsp;");
                out.w((Object)"</span>");
                BHxAbsTimeFE.INSTANCE.write(minOp);
                HxOp maxOp = op.make("max", (BObject)filter.getEndTime(), null);
                out.w((Object)"<br/>");
                out.w((Object)" <input ");
                out.attr("type", "checkbox");
                out.attr("name", op.scope("maxEnabled"));
                out.attr("id", op.scope("maxEnabled"));
                out.attr("onclick", "hx.setFormValue('" + op.scope("maxEnabledBackup") + "', this.checked);");
                if (filter.getMaxEnabled()) {
                    op.addOnload("hx.setFormValue('" + op.scope("maxEnabledBackup") + "', 'true');");
                    out.attr("checked", "on");
                }
                if (readonly) {
                    maxOp.setReadonly(true);
                    out.attr("disabled", "disabled");
                }
                out.w((Object)"/>");
                out.safe((Object)(" " + PickerCommand.this.lexModule.getText("max", (Context)op) + " "));
                BHxAbsTimeFE.INSTANCE.write(maxOp);
            }
        }
    }
}

