/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.factory.network;

import com.tridium.smartTableHx.SmartCommand;
import com.tridiumx.entsecHx.factory.SmartCommandArray;
import com.tridiumx.entsecHx.factory.network.BHxDeviceManagerView;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractDiscoverView;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractManagerView;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraSingleton
public class BHxDeviceDiscoveryView
extends BHxAbstractDiscoverView {
    public static final BHxDeviceDiscoveryView INSTANCE = new BHxDeviceDiscoveryView();
    public static final Type TYPE = Sys.loadType(BHxDeviceDiscoveryView.class);
    private Type deviceLearnType;
    private Type deviceType;
    private String uniqueProperty;
    private Type deviceNetworkType;
    private SmartCommand[] learnCommands;

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxDeviceDiscoveryView() {
    }

    @Override
    public BHxAbstractManagerView getAbstractManagerView(HxOp op) {
        return BHxDeviceManagerView.INSTANCE;
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        if (this.learnCommands != null) {
            SmartCommandArray commands = SmartCommandArray.make(super.getButtonCommands(op));
            commands.appendBack(this.learnCommands);
            for (int i = 0; i < this.learnCommands.length; ++i) {
                this.registerEvent((Event)this.learnCommands[i]);
            }
            return commands.getCommands();
        }
        return super.getButtonCommands(op);
    }

    @Override
    public String[] getDeviceFields(HxOp op) {
        Array fields = new Array(String.class);
        Property[] properties = this.deviceType.getInstance().asComplex().getFrozenPropertiesArray();
        for (int i = 0; i < properties.length; ++i) {
            fields.add((Object)properties[i].getName());
        }
        return (String[])fields.trim();
    }

    @Override
    public String[] getLearnFields(HxOp op) {
        Array fields = new Array(String.class);
        Property[] properties = this.deviceLearnType.getInstance().asComplex().getPropertiesArray();
        for (int i = 0; i < properties.length; ++i) {
            fields.add((Object)properties[i].getName());
        }
        return (String[])fields.trim();
    }

    @Override
    public BComponent getDeviceSubject(HxOp op) {
        BComplex entry = this.getLearnEntrySubject(op);
        if (entry == null) {
            throw new IllegalStateException("no device selected");
        }
        BComponent device = this.deviceType.getInstance().asComponent();
        Property[] learnProps = entry.getFrozenPropertiesArray();
        Property[] deviceProps = device.getFrozenPropertiesArray();
        this.checkDuplicate(this.uniqueProperty, entry.get(this.uniqueProperty));
        for (int i = 0; i < learnProps.length; ++i) {
            for (int j = 0; j < deviceProps.length; ++j) {
                if (!learnProps[i].getName().equals(deviceProps[j].getName())) continue;
                device.set(deviceProps[j], entry.get(learnProps[i]));
            }
        }
        return device;
    }

    private void checkDuplicate(String uniqueProperty, BValue value) {
        BDeviceNetwork network = (BDeviceNetwork)Sys.getService((Type)this.deviceNetworkType);
        BDevice[] devices = network.getDevices();
        for (int i = 0; i < devices.length; ++i) {
            if (!devices[i].get(uniqueProperty).equals((Object)value)) continue;
            throw new BajaRuntimeException("device already in use");
        }
    }

    @Override
    public void match(BComplex learnEntry, BComponent databaseDevice, HxOp op) {
        this.checkDuplicate(this.uniqueProperty, learnEntry.get(this.uniqueProperty));
        Property[] learnProps = learnEntry.getFrozenPropertiesArray();
        Property[] deviceProps = databaseDevice.getFrozenPropertiesArray();
        this.checkDuplicate(this.uniqueProperty, learnEntry.get(this.uniqueProperty));
        for (int i = 0; i < learnProps.length; ++i) {
            for (int j = 0; j < deviceProps.length; ++j) {
                if (!learnProps[i].getName().equals(deviceProps[j].getName())) continue;
                databaseDevice.set(deviceProps[j], learnEntry.get(learnProps[i]));
            }
        }
    }

    public void setDeviceLearnType(Type deviceLearnType) {
        this.deviceLearnType = deviceLearnType;
    }

    public void setDeviceType(Type deviceType) {
        this.deviceType = deviceType;
    }

    public void setDeviceNetworkType(Type deviceNetworkType) {
        this.deviceNetworkType = deviceNetworkType;
    }

    public void setUniqueProperty(String uniqueProperty) {
        this.uniqueProperty = uniqueProperty;
    }

    public void setLearnCommands(SmartCommand[] learnCommands) {
        this.learnCommands = learnCommands;
    }
}

