/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.backup;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.broker.BBrokerChannel;
import com.tridium.hx.ErrorDialog;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BDistributionFile;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BProviderStation;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.ConfirmDialog;
import com.tridium.smartTableHx.DynamicDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.TableContents;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridiumx.entsec.backup.BBackupFileTable;
import com.tridiumx.entsec.backup.BSystemRestoreJob;
import com.tridiumx.entsecHx.orionToolsHx.HxRemoteUtil;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.file.zip.BZipFile;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nd.SysDefSession;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.web.BWebService;

@NiagaraType(agent={@AgentOn(types={"entsec:BackupFileTable"}, app="entsec", requiredPermissions="rR")})
@NiagaraSingleton
public class BHxBackupFileTableView
extends BHxSmartTableView {
    public static final Lexicon lex = Lexicon.make(BHxBackupFileTableView.class);
    public static final BHxBackupFileTableView INSTANCE = new BHxBackupFileTableView();
    public static final Type TYPE = Sys.loadType(BHxBackupFileTableView.class);
    private static Logger backupLog = Logger.getLogger("entsecHx.backup");
    private static String REMOTESTATIONBACKUPURL = "/ord?service:entsec:EnterpriseSecurityService|slot:systemBackups|view:entsecHx:HxSystemBackupsView";
    private static String STATION_NAME_ATTRIBUTE = "stationName-";
    protected SmartCommand addCommand;
    protected SmartCommand restoreCommand = new RestoreCommand((BHxView)this);
    protected SmartCommand deleteCommand;
    protected SmartCommand renameCommand;
    protected SmartCommand summaryCommand;

    public Type getType() {
        return TYPE;
    }

    protected BHxBackupFileTableView() {
        this.registerEvent((Event)this.restoreCommand);
        this.deleteCommand = new DeleteCommand((BHxView)this);
        this.registerEvent((Event)this.deleteCommand);
        this.summaryCommand = new SummaryCommand((BHxView)this);
        this.registerEvent((Event)this.summaryCommand);
    }

    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.summaryCommand, this.restoreCommand, this.deleteCommand, this.exportCommand};
    }

    public BIFile getFile(HxOp op) {
        try {
            BBackupFileTable fileTable = new BBackupFileTable();
            return AccessController.doPrivileged(() -> (BIFile)fileTable.getBase().get());
        }
        catch (UnresolvedException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean supportsPagination(HxOp op) {
        return true;
    }

    public int minimumPageSize(HxOp op) {
        return 10;
    }

    public int defaultPageSize(HxOp op) {
        return 10;
    }

    public void writeTableHeader(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<th>");
        out.safe((Object)lex.getText("fileName"));
        out.w((Object)"</th>");
        out.w((Object)"<th>");
        out.safe((Object)lex.getText("timestamp"));
        out.w((Object)"</th>");
        out.w((Object)"<th>");
        out.safe((Object)lex.getText("backupType"));
        out.w((Object)"</th>");
        out.w((Object)"<th>");
        out.safe((Object)lex.getText("size"));
        out.w((Object)"</th>");
    }

    public TableContents writeContents(HxOp op) throws Exception {
        TableContents t = new TableContents(op.scope("records"));
        t.columns.td.add(new TableContents.Td(lex.getText("fileName")));
        t.columns.td.add(new TableContents.Td(lex.getText("timestamp")));
        t.columns.td.add(new TableContents.Td(lex.getText("backupType")));
        t.columns.td.add(new TableContents.Td(lex.getText("size")));
        BIFile file = this.getFile(op);
        if (file == null) {
            return t;
        }
        Array a = new Array(BIFile.class);
        this.getFiles(file, (Array<BIFile>)a, op);
        a = a.sort((Comparator)new LastModifiedComparitor());
        this.writeFiles((BIFile[])a.trim(), t, op);
        return t;
    }

    public void getFiles(BIFile file, Array<BIFile> a, HxOp op) {
        try {
            AccessController.doPrivileged(() -> {
                if (file.isDirectory()) {
                    BINavNode[] children = file.getNavChildren();
                    for (int i = 0; i < children.length; ++i) {
                        this.getFiles((BIFile)children[i], a, op);
                    }
                } else {
                    a.add((Object)file);
                }
                return null;
            });
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void writeFiles(BIFile[] files, TableContents contents, HxOp op) {
        for (int i = 0; i < files.length; ++i) {
            BIFile child = files[i];
            if (!child.getFileName().endsWith("zip") && !child.getFileName().endsWith("dist")) continue;
            TableContents.Tr tr = new TableContents.Tr();
            tr.id = child.getFilePath().toString();
            tr.td.add(new TableContents.Td(child.getFilePath().toString()));
            try {
                BAbsTime lastModified = AccessController.doPrivileged(() -> child.getLastModified());
                tr.td.add(new TableContents.Td("" + lastModified));
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            BImage image = BImage.make((String)lex.getText("systemBackup.icon"));
            if (child.getFileName().endsWith("zip")) {
                tr.td.add(new TableContents.Td("System"));
            } else {
                image = BImage.make((String)lex.getText("localBackup.icon"));
                tr.td.add(new TableContents.Td("Local"));
            }
            try {
                Long childSize = AccessController.doPrivileged(() -> child.getSize() / 1000L);
                long childSize1 = childSize;
                tr.td.add(new TableContents.Td("" + childSize + "k"));
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            tr.icons = new BImage[]{image};
            contents.tr.add(tr);
        }
    }

    public static void writeDistributions(BDistribution[] distributions, boolean local, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        if (!local) {
            out.w((Object)"<b>");
            out.safe((Object)lex.getText("systemDistributionFile"));
            out.w((Object)"<br/>");
            out.w((Object)"<br/>");
            out.w((Object)"<b>");
            out.safe((Object)lex.getText("whichStationQuestion"));
            out.w((Object)"<br/>");
            for (int i = 0; i < distributions.length; ++i) {
                String[] split = TextUtil.split((String)distributions[i].getDescription(), (char)'\"');
                String stationName = split[1];
                String hostName = split[3];
                String localStationName = Sys.getStation().getStationName();
                boolean selectedStation = false;
                if (localStationName.equals(stationName)) {
                    out.w((Object)"<input ").attr("name", op.scope(STATION_NAME_ATTRIBUTE + stationName)).w((Object)" ").attr("id", op.scope(STATION_NAME_ATTRIBUTE + stationName)).w((Object)" ").attr("type", "checkbox").w((Object)" ").attr("checked", "checked").w((Object)" ").w((Object)"/> ");
                    out.safe((Object)lex.getText("restoreToStationHost", new Object[]{stationName, hostName}));
                } else {
                    out.w((Object)"<input ").attr("name", op.scope(STATION_NAME_ATTRIBUTE + stationName)).w((Object)" ").attr("id", op.scope(STATION_NAME_ATTRIBUTE + stationName)).w((Object)" ").attr("type", "checkbox").w((Object)" ").w((Object)"/> ");
                    out.safe((Object)lex.getText("restoreToStationHost", new Object[]{stationName, hostName}));
                    String redirectURL = BHxBackupFileTableView.getRemoteStationURL(op, hostName, stationName);
                    redirectURL = redirectURL + REMOTESTATIONBACKUPURL;
                    out.w((Object)("<a href='" + HxUtil.encodeURLForHref((String)redirectURL) + "' "));
                    out.w((Object)">");
                    out.safe((Object)lex.getText("restore"));
                    out.w((Object)"</a>");
                }
                out.w((Object)"<br/>");
            }
        } else {
            if (distributions.length < 1) {
                throw new IllegalStateException("unknown installable");
            }
            out.w((Object)"<b>");
            out.safe((Object)lex.getText("localDistributionFile"));
            out.w((Object)"<br/>");
            out.w((Object)"<br/>");
            out.w((Object)"<br/>");
            out.safe((Object)lex.getText("installLocalQuestion"));
            out.w((Object)"<br/>");
            out.w((Object)"<br/>");
            out.safe((Object)distributions[0].getDescription());
        }
        out.w((Object)"</b>");
    }

    public static BIFile getSelectedFile(HxOp op) {
        try {
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            BOrd ord = BOrd.make((String)selectionList[0]);
            return AccessController.doPrivileged(() -> (BIFile)ord.get());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BDistribution[] getDistributions(BIFile file, HxOp op) {
        try {
            return AccessController.doPrivileged(() -> {
                Array a = new Array(BDistribution.class);
                if (file instanceof BZipFile) {
                    BComponent c = new BComponent();
                    BZipFile zipFile = (BZipFile)file;
                    zipFile.open();
                    BIFile[] files = zipFile.getZipSpace().listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        BDistributionFile backupFile = (BDistributionFile)files[i];
                        BDistribution dist = backupFile.makeDistribution();
                        a.add((Object)dist);
                    }
                    zipFile.close();
                } else {
                    BDistributionFile backupFile = (BDistributionFile)file;
                    BDistribution dist = backupFile.makeDistribution();
                    a.add((Object)dist);
                }
                return (BDistribution[])a.trim();
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeDistributionSummary(BDistribution[] distributions, BIFile file, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        HxTabUtil.startTable((HtmlWriter)out, (HxOp)op);
        HxTabUtil.startRow((String)lex.getText("fileName"), (HtmlWriter)out, (HxOp)op);
        out.safe((Object)file.getFileName());
        HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
        HxTabUtil.startRow((String)lex.getText("timestamp"), (HtmlWriter)out, (HxOp)op);
        AccessController.doPrivileged(() -> {
            out.safe((Object)("" + file.getLastModified()));
            return null;
        });
        HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
        HxTabUtil.endTable((HtmlWriter)out, (HxOp)op);
        out.w((Object)"<br/>");
        out.w((Object)"<br/>");
        HxTabUtil.startTable((HtmlWriter)out, (HxOp)op);
        HxTabUtil.startRow((String)lex.getText("description"), (HtmlWriter)out, (HxOp)op);
        HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
        for (int i = 0; i < distributions.length; ++i) {
            HxTabUtil.startRow((HtmlWriter)out, (HxOp)op);
            out.safe((Object)distributions[i].getDescription());
            HxTabUtil.endRow((HtmlWriter)out, (HxOp)op);
        }
        HxTabUtil.endTable((HtmlWriter)out, (HxOp)op);
    }

    public static String getRemoteStationURL(HxOp op, String hostname, String remStationName) {
        String scheme;
        BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        Object niagaraStation = null;
        boolean useHttps = false;
        BISession session = null;
        BNiagaraStation remStation1 = (BNiagaraStation)network.getNiagaraStation(remStationName);
        if (remStation1 != null) {
            session = remStation1.getSession();
        }
        BFoxSession foxSession = session instanceof BFoxSession ? (BFoxSession)session : null;
        int port = -1;
        BComponent details = null;
        boolean useFoxs = true;
        if (foxSession != null) {
            useFoxs = foxSession.getUseFoxs();
            details = (BComponent)foxSession.getConnection().session().getFromCache("httpDetails", key -> {
                BBrokerChannel channel = (BBrokerChannel)foxSession.getConnection().getChannels().get("station");
                return channel.getHttpConnectionDetails();
            });
        } else {
            BWebService webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
            details = webService.getHttpConnectionDetails(null);
            useFoxs = ((BBoolean)details.get("httpsEnabled")).getBoolean();
        }
        if (useFoxs) {
            useHttps = true;
            scheme = "https";
        } else {
            useHttps = false;
            scheme = "http";
        }
        int httpsPort = ((BInteger)details.get(lex.getText("httpsPort"))).getInt();
        int httpPort = ((BInteger)details.get(lex.getText("httpPort"))).getInt();
        int defaultPort = useHttps ? httpsPort : httpPort;
        port = BHxBackupFileTableView.getRemotePort(network, op, remStationName, useHttps);
        StringBuilder sb = new StringBuilder();
        sb.append(scheme);
        sb.append("://");
        sb.append(hostname);
        if (port != defaultPort) {
            sb.append(":").append(Integer.toString(port));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRemotePort(BNiagaraNetwork network, HxOp op, String remStationName, boolean useHttps) {
        SysDefSession session = null;
        int port = 0;
        try {
            session = network.createSysDefSession((Context)op);
            BProviderStation station = (BProviderStation)session.getStation(remStationName);
            if (station != null) {
                port = useHttps ? station.getHttpsPort() : station.getHttpPort();
            } else {
                BWebService remoteWebService = (BWebService)HxRemoteUtil.getRemoteComponent(BOrd.make((String)"service:web:WebService"), remStationName, op);
                if (remoteWebService != null) {
                    remoteWebService.lease(1);
                    port = useHttps ? remoteWebService.getHttpsPort().getPublicServerPort() : remoteWebService.getHttpPort().getPublicServerPort();
                }
            }
        }
        catch (Exception e) {
            backupLog.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        return port;
    }

    public static class LastModifiedComparitor
    implements Comparator<BIFile>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(BIFile f1, BIFile f2) {
            try {
                return AccessController.doPrivileged(() -> f1.getLastModified().compareTo((Object)f2.getLastModified()));
            }
            catch (Exception e) {
                return -1;
            }
        }

        @Override
        public boolean equals(Object obj) {
            return false;
        }
    }

    public static class DeleteCommand
    extends SmartCommand {
        private ConfirmDialog dlg = new ConfirmDialog(this.getDisplayName(null), (Command)this);

        public DeleteCommand(BHxView view) {
            super(view, smartTableHxLexModule);
        }

        public String getName(HxOp op) {
            return "delete";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
            for (int i = 0; i < selectionList.length; ++i) {
                BOrd ord = BOrd.make((String)selectionList[i]);
                AccessController.doPrivileged(() -> {
                    BIFile file = (BIFile)ord.get();
                    file.delete();
                    return null;
                });
            }
            ((BHxSmartTableView)this.getView()).reloadTable(op);
        }
    }

    public static class SummaryCommand
    extends SmartCommand {
        protected SummaryCommandDialog dlg = new SummaryCommandDialog((Command)this, this.getDisplayName(null));

        public SummaryCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "summary";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
        }

        protected class SummaryCommandDialog
        extends DynamicDialog {
            SummaryCommandDialog(Command handler, String title) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                BIFile file = BHxBackupFileTableView.getSelectedFile(op);
                BHxBackupFileTableView.writeDistributionSummary(BHxBackupFileTableView.getDistributions(file, op), file, op);
            }
        }
    }

    public static class RestoreCommand
    extends SmartCommand {
        protected RestoreCommandDialog dlg = new RestoreCommandDialog((Command)this, this.getDisplayName(null));

        public RestoreCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "restore";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            Array stationNames = new Array(String.class);
            BIFile file = BHxBackupFileTableView.getSelectedFile(op);
            boolean local = file instanceof BDistributionFile;
            BDistribution[] distributions = BHxBackupFileTableView.getDistributions(file, op);
            if (!local) {
                String localStationName;
                boolean useful = false;
                for (int i = 0; i < distributions.length; ++i) {
                    String[] split = TextUtil.split((String)distributions[i].getDescription(), (char)'\"');
                    String stationName = split[1];
                    if (op.getFormValue("stationName-" + stationName) == null) continue;
                    stationNames.add((Object)stationName);
                    useful = true;
                }
                if (!useful) {
                    new ErrorDialog(this.getDisplayName(op), (Command)this, (Throwable)new Exception("Please Select at least one station to restore."), null).open(op);
                    return;
                }
                if (stationNames.size() > 1) {
                    new ErrorDialog(this.getDisplayName(op), (Command)this, (Throwable)new Exception(this.lexModule.getText("restoreMultipleStation", (Context)op)), null).open(op);
                    return;
                }
                if (stationNames.size() == 1 && !(localStationName = Sys.getStation().getStationName()).equals(stationNames.get(0))) {
                    new ErrorDialog(this.getDisplayName(op), (Command)this, (Throwable)new Exception(this.lexModule.getText("restoreRemoteStationError", (Context)op)), null).open(op);
                    return;
                }
            }
            BSystemRestoreJob job = new BSystemRestoreJob(BHxBackupFileTableView.getSelectedFile(op), (String[])stationNames.trim(), true);
            op.getRequest().getSession().setAttribute("backupJob", (Object)job);
            HtmlWriter out = op.getHtmlWriter();
            op.getRequest().getSession().setAttribute("info", (Object)new BComponent());
            this.refresh(op);
        }

        protected class RestoreCommandDialog
        extends DynamicDialog {
            RestoreCommandDialog(Command handler, String title) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                BIFile file = BHxBackupFileTableView.getSelectedFile(op);
                BHxBackupFileTableView.writeDistributions(BHxBackupFileTableView.getDistributions(file, op), file instanceof BDistributionFile, op);
            }
        }
    }
}

