/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.schedule;

import com.tridium.hx.fieldeditors.BHxNumericFE;
import com.tridium.schedule.ScheduleUtil;
import com.tridium.schedule.ui.ScheduleColors;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.HxSaveCommand;
import com.tridium.smartTableHx.SaveCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridiumx.entsecHx.access.schedule.ViewUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.hx.BHxView;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.BIEncodable;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"schedule:BooleanSchedule"}, app="entsec", requiredPermissions="rR")})
@NiagaraSingleton
public class BHxWeeklyScheduler
extends BHxView {
    public static final BHxWeeklyScheduler INSTANCE = new BHxWeeklyScheduler();
    public static final Type TYPE = Sys.loadType(BHxWeeklyScheduler.class);
    protected static final Logger LOG = Logger.getLogger("schedule");
    protected SmartCommand delete;
    protected SmartCommand allDay;
    protected SmartCommand clearDay;
    protected SmartCommand clearWeek;
    protected SmartCommand save = new HxSaveCommand((BHxView)this);
    protected SmartCommand applyMF;
    protected SmartCommand copyDay;
    protected SmartCommand pasteDay;
    private final SmartCommand preSave;

    public Type getType() {
        return TYPE;
    }

    protected BHxWeeklyScheduler() {
        this.registerEvent((Event)this.save);
        this.preSave = new HxSaveCommand.HxPreSaveCommand((BHxView)this);
        this.registerEvent((Event)this.preSave);
        this.allDay = new ViewUtil.AllDay(this);
        this.registerEvent((Event)this.allDay);
        this.clearDay = new ViewUtil.ClearDay(this);
        this.registerEvent((Event)this.clearDay);
        this.clearWeek = new ClearWeek(this);
        this.registerEvent((Event)this.clearWeek);
        this.delete = new ViewUtil.Delete(this);
        this.registerEvent((Event)this.delete);
        this.applyMF = new ApplyMF(this);
        this.registerEvent((Event)this.applyMF);
        this.copyDay = new ViewUtil.CopyDay(this);
        this.registerEvent((Event)this.copyDay);
        this.pasteDay = new ViewUtil.PasteDay(this);
        this.registerEvent((Event)this.pasteDay);
    }

    public SmartCommand[] getButtonCommands(HxOp op) {
        if (op.getPath().isEmpty()) {
            return new SmartCommand[]{this.save, this.delete, this.allDay, this.applyMF, this.clearDay, this.clearWeek, this.copyDay, this.pasteDay};
        }
        return new SmartCommand[]{this.delete, this.allDay, this.applyMF, this.clearDay, this.clearWeek, this.copyDay, this.pasteDay};
    }

    public void write(HxOp op) throws Exception {
        Lexicon lex = ViewUtil.getScheduleLexicon(op);
        BWeeklySchedule schedule = (BWeeklySchedule)op.get();
        if (schedule.isMounted() && Flags.isReadonly((BComplex)schedule.getParent(), (Slot)schedule.getPropertyInParent())) {
            op.setReadonly(true);
        }
        op.mergeFacets(schedule.getFacets());
        ViewUtil.addHeaders(op);
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)BHxWeeklyScheduler.generateInlineCss(op));
        op.mergeFacets(BFacets.make((String)"noTitle", (boolean)true));
        ViewUtil.addOnloadReadOnly(op);
        if (op.canWrite()) {
            this.preSave.addOnload(op);
        }
        ViewUtil.addOnloadInit(op);
        ViewUtil.addOnloadNullStatus(op, lex);
        ViewUtil.writeCommands(this.getButtonCommands(op), op, out);
        ViewUtil.writeTemplateDiv(schedule, op, out);
        ViewUtil.writeScheduleTableStart(op, out);
        BWeekday weekday = BWeekday.getFirstDayOfWeek((Context)op);
        for (int count = 0; count < 7; ++count) {
            if (count > 0) {
                weekday = weekday.next();
            }
            out.w((Object)"<td style='width:13%;'>");
            ViewUtil.writeDayGridBoxStart(Integer.toString(count), weekday.getShortDisplayTag((Context)op), op, out);
            StringBuilder eventsString = new StringBuilder();
            for (BTimeSchedule time : (BTimeSchedule[])schedule.get(weekday).getChildren(BTimeSchedule.class)) {
                BTime start = time.getStart();
                BTime finish = time.getFinish();
                float top = ViewUtil.calcTop(start);
                float height = ViewUtil.calcHeight(finish, top);
                BStatusValue statusValue = time.getEffectiveValue();
                out.w((Object)"<div class='schedule-HxScheduler-dayEvent");
                out.w((Object)" value-").w((Object)ViewUtil.getValueString(statusValue)).w((Object)"'");
                out.w((Object)" style='");
                out.w((Object)"top: ").w(top).w((Object)"%;");
                if (height > 0.1f) {
                    out.w((Object)" height: calc(").w(height).w((Object)"% - 3px);'");
                } else {
                    out.w((Object)" height: 3px;'");
                }
                if (op.canWrite()) {
                    out.attr(" onmousedown", "schedule.onselectedmousedown(this, event, '" + op.getPath() + "');");
                    out.attr(" onmousemove", "schedule.onselectedmousemove(this, event, '" + op.getPath() + "');");
                    out.attr(" onmouseup", "schedule.onselectedmouseup(this, event, '" + op.getPath() + "');");
                    out.attr(" oncontextmenu", "smartTable.forceRightClick=true;schedule.contextMenu(this, event, '" + op.getPath() + "'); smartTable.forceRightClick=false; return false;");
                    out.attr(" ontouchstart", "schedule.onselectedmousedown(this, event, '" + op.getPath() + "');");
                    out.attr(" ontouchmove", "schedule.onselectedmousemove(this, event, '" + op.getPath() + "');");
                    out.attr(" ontouchend", "schedule.onselectedmouseup(this, event, '" + op.getPath() + "');");
                } else {
                    out.attr(" onmousedown", "schedule.onreadonlyselectedmousedown(this, event, '" + op.getPath() + "');");
                    out.attr(" oncontextmenu", "smartTable.disableSelection(event); return false;");
                    out.attr(" ontouchstart", "schedule.onreadonlyselectedmousedown(this, event, '" + op.getPath() + "');");
                }
                boolean isStatusNull = statusValue.getStatus().isNull();
                BValue valueValue = statusValue.getValueValue();
                String valueWithoutUnits = ViewUtil.getValueWithoutUnits(valueValue, op);
                out.attr(" value", valueWithoutUnits);
                out.attr(" nullstatus", String.valueOf(isStatusNull));
                out.w((Object)">");
                HxOp valueOp = op.make("value", new OrdTarget((OrdTarget)op, (BObject)statusValue));
                valueOp.mergeFacets(schedule.getFacets());
                if (isStatusNull) {
                    out.safe((Object)lex.getText("day.null"));
                } else {
                    out.safe((Object)valueValue.toString((Context)valueOp));
                }
                out.w((Object)"</div>");
                ViewUtil.appendFormValue(eventsString, start, finish, isStatusNull, valueWithoutUnits);
            }
            out.w((Object)"</div>");
            out.w((Object)"</div>");
            out.w((Object)"</td>");
            SmartCommand.setFormValue((String)op.scope("day" + count), (Object)eventsString.toString(), (boolean)true, (boolean)false, (boolean)true, (HxOp)op);
        }
        ViewUtil.writeTimeColumn(null, op);
        ViewUtil.writeScheduleTableEnd(false, op, out, lex);
    }

    public BObject save(HxOp op) throws Exception {
        BWeeklySchedule schedule = (BWeeklySchedule)op.get();
        BStatusValue defaultStatusValue = schedule.getDefaultOutput();
        boolean[] modified = new boolean[7];
        BWeeklySchedule scheduleNew = (BWeeklySchedule)schedule.newCopy();
        BWeekday weekday = BWeekday.getFirstDayOfWeek((Context)op);
        for (int count = 0; count < 7; ++count) {
            if (count > 0) {
                weekday = weekday.next();
            }
            BDaySchedule daySchedule = scheduleNew.get(weekday);
            String form = op.getUnsafeFormValue("day" + count);
            modified[count] = BHxWeeklyScheduler.saveEvents(daySchedule, form, defaultStatusValue, op);
        }
        ScheduleUtil.validateSchedule((BAbstractSchedule)scheduleNew, (Context)op);
        boolean anyModification = false;
        weekday = BWeekday.getFirstDayOfWeek((Context)op);
        for (int count = 0; count < 7; ++count) {
            if (count > 0) {
                weekday = weekday.next();
            }
            BDaySchedule daySchedule = schedule.get(weekday);
            BDaySchedule dayScheduleCopy = scheduleNew.get(weekday);
            op.getUnsafeFormValue("day" + count);
            anyModification |= modified[count];
            if (!modified[count]) continue;
            try {
                ScheduleUtil.stationSideAuditableCopyFrom((BAbstractSchedule)daySchedule, (BAbstractSchedule)dayScheduleCopy, (Context)op);
                continue;
            }
            catch (Exception e) {
                daySchedule.copyFrom((BAbstractSchedule)dayScheduleCopy, (Context)op);
                LOG.warning("Schedule saved, but detailed audit is not available");
            }
        }
        if (anyModification) {
            schedule.setLastModified(BAbsTime.now());
            schedule.execute();
        }
        return schedule;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean saveEvents(BDaySchedule daySchedule, String form, BStatusValue defaultStatusValue, HxOp op) throws Exception {
        void var16_27;
        BTimeSchedule[] timeSchedules;
        if (form == null) {
            return false;
        }
        boolean modified = false;
        String[] split = TextUtil.split((String)form, (char)'|');
        int length = split.length - 1;
        if (length == -1) {
            length = 0;
        }
        BTime[] start = new BTime[length];
        BTime[] finish = new BTime[length];
        boolean[] nullStatus = new boolean[length];
        BValue[] value = new BValue[length];
        boolean[] found = new boolean[length];
        for (int j = 0; j < length; ++j) {
            String[] split2 = TextUtil.split((String)split[j], (char)',');
            start[j] = (BTime)BTime.DEFAULT.decodeFromString(split2[0]);
            finish[j] = (BTime)BTime.DEFAULT.decodeFromString(split2[1]);
            nullStatus[j] = ((BBoolean)BBoolean.DEFAULT.decodeFromString(split2[2])).getBoolean();
            BIEncodable encodable = (BIEncodable)defaultStatusValue.getValueValue();
            String strValue = split2[3];
            if (encodable instanceof BEnum && !(encodable instanceof BBoolean)) {
                int n = Integer.parseInt(ViewUtil.safeDecoding(strValue));
                BEnumRange range = ((BEnum)encodable).getRange();
                value[j] = BDynamicEnum.make((int)n, (BEnumRange)range);
            } else if (encodable instanceof BDouble) {
                BDouble bDouble = (BDouble)encodable.decodeFromString(ViewUtil.safeDecoding(strValue));
                BHxNumericFE valueEditor = BHxNumericFE.INSTANCE;
                HxOp valueOp = op.make("value", new OrdTarget((OrdTarget)op, (BObject)bDouble));
                valueOp.mergeFacets(((BWeeklySchedule)op.get()).getFacets());
                value[j] = valueEditor.getValue(valueOp, BHxNumericFE.Convert.storage);
            } else {
                value[j] = (BValue)encodable.decodeFromString(ViewUtil.safeDecoding(strValue));
            }
            found[j] = false;
        }
        BTimeSchedule[] times = (BTimeSchedule[])daySchedule.getChildren(BTimeSchedule.class);
        for (String string : times) {
            boolean timeFound = false;
            for (int k = 0; k < length; ++k) {
                if (!string.getStart().equals((Object)start[k]) || !string.getFinish().equals((Object)finish[k])) continue;
                if (!string.getEffectiveValue().getValueValue().equals((Object)value[k])) {
                    modified = true;
                    string.getEffectiveValue().setValueValue(value[k]);
                }
                if (string.getEffectiveValue().getStatus().isNull() != nullStatus[k]) {
                    string.getEffectiveValue().setStatusNull(nullStatus[k]);
                    modified = true;
                }
                found[k] = true;
                timeFound = true;
            }
            if (timeFound) continue;
            modified = true;
            if (daySchedule.isMounted()) {
                daySchedule.remove(string.getPropertyInParent(), (Context)op);
                continue;
            }
            daySchedule.remove(string.getPropertyInParent());
        }
        for (int j = 0; j < length; ++j) {
            if (found[j]) continue;
            modified = true;
            BStatusValue newValue = (BStatusValue)defaultStatusValue.newCopy();
            newValue.setValueValue(value[j]);
            newValue.setStatusNull(nullStatus[j]);
            daySchedule.add(start[j], finish[j], newValue);
        }
        BTimeSchedule[] bTimeScheduleArray = timeSchedules = (BTimeSchedule[])daySchedule.getChildren(BTimeSchedule.class);
        int n = bTimeScheduleArray.length;
        boolean bl = false;
        while (var16_27 < n) {
            BTimeSchedule timeSchedule = bTimeScheduleArray[var16_27];
            if (!(timeSchedule.getStart().isBefore(timeSchedule.getFinish()) || timeSchedule.getStart().equals((Object)BTime.MIDNIGHT) || timeSchedule.getFinish().equals((Object)BTime.MIDNIGHT))) {
                modified = true;
                daySchedule.remove(timeSchedule.getName());
            }
            ++var16_27;
        }
        return modified;
    }

    private static Map<String, ScheduleColors> generateAllColorValues(HxOp op) {
        BWeeklySchedule schedule = (BWeeklySchedule)op.get();
        BWeeklySchedule scheduleCopy = (BWeeklySchedule)schedule.getType().getInstance();
        scheduleCopy.setFacets(schedule.getFacets());
        BValue value = schedule.getDefaultOutput().getValueValue();
        HashMap<String, ScheduleColors> valueToColors = new HashMap<String, ScheduleColors>();
        if (value instanceof BBoolean) {
            BStatusBoolean valueValue = new BStatusBoolean(true);
            scheduleCopy.add(null, (BValue)valueValue);
            valueToColors.put(ViewUtil.getValueString((BStatusValue)valueValue), new ScheduleColors((BStatusValue)valueValue));
            valueValue = new BStatusBoolean(false);
            scheduleCopy.add(null, (BValue)valueValue);
            valueToColors.put(ViewUtil.getValueString((BStatusValue)valueValue), new ScheduleColors((BStatusValue)valueValue));
        } else if (value instanceof BEnum) {
            int maxOrdinal = ScheduleColors.DEFAULT_ENUM_COLORS.length;
            for (int i = 0; i < maxOrdinal; ++i) {
                BStatusEnum valueValue = new BStatusEnum((BEnum)BDynamicEnum.make((int)i));
                scheduleCopy.add(null, (BValue)valueValue);
                valueToColors.put(ViewUtil.getValueString((BStatusValue)valueValue), new ScheduleColors((BStatusValue)valueValue));
            }
            Lexicon lex = ViewUtil.getScheduleLexicon(op);
            int counter = maxOrdinal;
            String key = lex.get("EnumSchedule.colors." + counter);
            while (key != null) {
                BStatusEnum valueValue = new BStatusEnum((BEnum)BDynamicEnum.make((int)counter));
                scheduleCopy.add(null, (BValue)valueValue);
                valueToColors.putIfAbsent(ViewUtil.getValueString((BStatusValue)valueValue), new ScheduleColors((BStatusValue)valueValue));
                key = lex.get("EnumSchedule.colors." + ++counter);
            }
            BObject rangeValue = schedule.getFacets().get("colors");
            if (rangeValue instanceof BEnumRange) {
                int[] ordinals;
                BEnumRange colorRange = (BEnumRange)rangeValue;
                for (int ordinal : ordinals = colorRange.getOrdinals()) {
                    BStatusEnum valueValue = new BStatusEnum(colorRange.get(ordinal));
                    scheduleCopy.add(null, (BValue)valueValue);
                    valueToColors.putIfAbsent(ViewUtil.getValueString((BStatusValue)valueValue), new ScheduleColors((BStatusValue)valueValue));
                }
            }
        }
        BStatusValue valueValue = (BStatusValue)scheduleCopy.getDefaultOutput().newCopy();
        valueValue.setStatusNull(true);
        scheduleCopy.add(null, (BValue)valueValue);
        valueToColors.putIfAbsent(ViewUtil.getValueString(valueValue), new ScheduleColors(valueValue));
        valueValue = (BStatusValue)scheduleCopy.getDefaultOutput().newCopy();
        valueValue.setStatusNull(false);
        scheduleCopy.add(null, (BValue)valueValue);
        valueToColors.putIfAbsent(ViewUtil.getValueString(valueValue), new ScheduleColors(valueValue));
        return valueToColors;
    }

    private static String getCssSelector(String valueString) {
        return ".schedule-HxScheduler-dayEvent.value-" + valueString;
    }

    private static String generateInlineCss(HxOp op) {
        Map<String, ScheduleColors> allColors = BHxWeeklyScheduler.generateAllColorValues(op);
        StringBuilder sb = new StringBuilder();
        sb.append("<style>\n");
        for (Map.Entry<String, ScheduleColors> entry : allColors.entrySet()) {
            sb.append(BHxWeeklyScheduler.getCssSelector(entry.getKey())).append('{').append(entry.getValue().getCss((Context)op)).append("}\n");
        }
        sb.append("</style>\n");
        return sb.toString();
    }

    public static class ClearWeek
    extends SmartCommand {
        public ClearWeek(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "clearWeek";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.alwaysOrAnySelection;
        }

        public String getEnabledInvokeCode(HxOp op) {
            String quote = HxUtil.getOuterQuote((HxOp)op);
            return "schedule.clearWeek(this, event, " + quote + op.getPath() + quote + ");";
        }
    }

    public static class ApplyMF
    extends SmartCommand {
        public ApplyMF(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "applyMF";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public String getEnabledInvokeCode(HxOp op) {
            String quote = HxUtil.getOuterQuote((HxOp)op);
            return "schedule.applyMF(this, event, " + quote + op.getPath() + quote + ");";
        }
    }

    public class Save
    extends SaveCommand {
        public Save(BHxView view) {
            super(view);
        }

        public void onHandle(HxOp op) throws Exception {
            BHxWeeklyScheduler.this.save(op);
        }
    }
}

