/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.schedule;

import com.tridium.hx.progress.HxProgressJobDialog;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.schedule.BNiagaraScheduleDeviceExt;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.SmartCommand;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.schedule.BScheduleAddInfo;
import com.tridiumx.entsec.access.schedule.BScheduleExportInfo;
import com.tridiumx.entsec.access.schedule.nd.BDistributedScheduleLearnResult;
import com.tridiumx.entsec.access.schedule.util.MatchUtil;
import com.tridiumx.entsec.orionTools.replicate.BNiagaraReplicationDeviceExt;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import com.tridiumx.entsecHx.access.schedule.BHxDistributedScheduleDiscoverView;
import com.tridiumx.entsecHx.orionToolsHx.replicate.SysJoinManifest;
import com.tridiumx.entsecHx.securityUtilHx.UpLevelCommand;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractDiscoverView;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractManagerView;
import com.tridiumx.entsecHx.securityUtilHx.job.BHxAbstractJobView;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxQueryTableView;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"niagaraDriver:NiagaraScheduleDeviceExt"}, app="entsec", requiredPermissions="rR")})
@NiagaraSingleton
public class BHxDistributedScheduleView
extends BHxAbstractManagerView {
    static final Lexicon entsecHxLex = Lexicon.make(BHxDistributedScheduleDiscoverView.class);
    public static final BHxDistributedScheduleView INSTANCE = new BHxDistributedScheduleView();
    public static final Type TYPE = Sys.loadType(BHxDistributedScheduleView.class);
    private String addDiscoveredTitle;
    private String exportSchedulesTitle;
    public AddDiscovered addDiscovered;
    public ExportSchedules exportSchedules;
    public HxProgressJobDialog.ProgressEvent addDiscoveredEvent;
    public HxProgressJobDialog.ProgressEvent exportSchedulesEvent;
    private UpLevelScheduleExtCommand upLevelScheduleExtCommand;

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxDistributedScheduleView() {
        this.addDiscoveredTitle = this.concreteLex.getText(this.concreteLexPrefix + ".addingDiscovered");
        this.addDiscovered = new AddDiscovered((BHxView)this);
        this.registerEvent((Event)this.addDiscovered);
        this.addDiscoveredEvent = HxProgressJobDialog.makeProgress((String)this.addDiscoveredTitle, (BHxView)this, (HxProgressJobDialog.IHxProgressDialogParent)this);
        this.registerEvent((Event)this.addDiscoveredEvent);
        this.addDiscoveredEvent.setJobCompleteHandler((HxProgressJobDialog.IJobCompleteHandler)this.addDiscovered);
        this.exportSchedulesTitle = this.concreteLex.getText(this.concreteLexPrefix + ".exportingSchedules");
        this.exportSchedules = new ExportSchedules((BHxView)this);
        this.registerEvent((Event)this.exportSchedules);
        this.exportSchedulesEvent = HxProgressJobDialog.makeProgress((String)this.exportSchedulesTitle, (BHxView)this, (HxProgressJobDialog.IHxProgressDialogParent)this);
        this.registerEvent((Event)this.exportSchedulesEvent);
        this.exportSchedulesEvent.setJobCompleteHandler((HxProgressJobDialog.IJobCompleteHandler)this.exportSchedules);
        this.upLevelScheduleExtCommand = new UpLevelScheduleExtCommand((BHxView)this);
        this.registerEvent((Event)this.upLevelScheduleExtCommand);
    }

    @Override
    public HxProgressJobDialog.ProgressEvent[] getProgressEvents() {
        return new HxProgressJobDialog.ProgressEvent[]{this.discoveryEvent, this.addDiscoveredEvent, this.exportSchedulesEvent};
    }

    @Override
    public BQuery getDiscoverQuery(HxOp op) {
        BQuery query = super.getDiscoverQuery(op);
        BProjectionColumn toDisplayPathStringCol = (BProjectionColumn)query.getProjection().get("displayName");
        if (toDisplayPathStringCol == null) {
            TypeSpecPath typeSpecPath = TypeSpecPath.DISPLAY_NAME;
            QueryUtil.addColumn((BQuery)query, (TypeSpecPath)typeSpecPath);
            query.getProjection().reorderToTop(query.getProjection().getProperty("displayName"));
            QueryUtil.reorderColumns((BQuery)query);
        }
        return query;
    }

    @Override
    public BQuery getQuery(HxOp op) {
        BProjectionColumn displayNameCol;
        BQuery query = super.getQuery(op);
        if (query.getProjection().get("in") != null) {
            query.getProjection().remove("in");
        }
        if ((displayNameCol = (BProjectionColumn)query.getProjection().get("toDisplayPathString")) == null) {
            String path = "toDisplayPathString";
            TypeSpecPath typeSpecPath = new TypeSpecPath(BString.TYPE.getTypeSpec(), path, entsecHxLex.getText("supervisorId"));
            QueryUtil.addColumn((BQuery)query, (TypeSpecPath)typeSpecPath);
            QueryUtil.reorderColumns((BQuery)query);
        }
        query.set("base", (BValue)BOrd.make((String)"station:|slot:/"));
        return query;
    }

    @Override
    public BHxAbstractDiscoverView getDiscoverView(HxOp op) {
        return BHxDistributedScheduleDiscoverView.INSTANCE;
    }

    @Override
    public BTypeSpec getDeviceTypeSpec(HxOp op) {
        return BBooleanSchedule.TYPE.getTypeSpec();
    }

    @Override
    public BTypeSpec getLearnRowTypeSpec(HxOp op) {
        return BDistributedScheduleLearnResult.TYPE.getTypeSpec();
    }

    @Override
    public boolean needsRediscovering(HxOp op) {
        return true;
    }

    public Type[] getIncludeTypes() {
        return new Type[]{BBooleanSchedule.TYPE};
    }

    @Override
    public BJob submitDiscoveryJob(HxOp op) {
        BNiagaraScheduleDeviceExt niagaraExt = (BNiagaraScheduleDeviceExt)this.getComponent(op);
        MatchUtil.createActions((BNiagaraScheduleDeviceExt)niagaraExt);
        Action action = niagaraExt.getAction("submitDistributedDiscover");
        if (action != null) {
            BOrd ord = (BOrd)niagaraExt.invoke(action, (BValue)MatchUtil.getDiscoveryQuery((Type[])this.getIncludeTypes()));
            BJob job = (BJob)ord.get((BObject)niagaraExt);
            return job;
        }
        return null;
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.discover, this.learnMode, this.exportSchedules, this.refresh, this.hyperlinkCommand, this.deleteCommand, this.renameCommand, this.filterCommand, this.exportCommand, this.upLevelScheduleExtCommand};
    }

    @Override
    public BJob submitJob(HxProgressJobDialog dialog, HxOp op) {
        BJob job = null;
        if (dialog.getTitle().equals(this.addDiscoveredTitle)) {
            BNiagaraScheduleDeviceExt niagaraExt = (BNiagaraScheduleDeviceExt)this.getComponent(op);
            MatchUtil.createActions((BNiagaraScheduleDeviceExt)niagaraExt);
            Action action = niagaraExt.getAction("submitDistributedAdd");
            if (action != null) {
                BScheduleAddInfo info = (BScheduleAddInfo)op.getRequest().getSession().getAttribute(op.scope("addInfo"));
                BOrd ord = (BOrd)niagaraExt.invoke(action, (BValue)info);
                job = (BJob)ord.get((BObject)niagaraExt);
                return job;
            }
            return null;
        }
        if (dialog.getTitle().equals(this.exportSchedulesTitle)) {
            BNiagaraScheduleDeviceExt niagaraExt = (BNiagaraScheduleDeviceExt)this.getComponent(op);
            MatchUtil.createActions((BNiagaraScheduleDeviceExt)niagaraExt);
            Action action = niagaraExt.getAction("submitDistributedExport");
            if (action != null) {
                BScheduleExportInfo info = (BScheduleExportInfo)op.getRequest().getSession().getAttribute(op.scope("exportInfo"));
                BOrd ord = (BOrd)niagaraExt.invoke(action, (BValue)info);
                job = (BJob)ord.get((BObject)niagaraExt);
                return job;
            }
            return null;
        }
        return super.submitJob(dialog, op);
    }

    public class UpLevelScheduleExtCommand
    extends UpLevelCommand {
        public UpLevelScheduleExtCommand(BHxView view) {
            super(view);
        }

        @Override
        public String getDisplayName(HxOp op) {
            if (this.redirectToManifest(op)) {
                return entsecHxLex.getText("back.to.join");
            }
            return op.get().asComponent().getParent().getDisplayName((Context)op);
        }

        public boolean redirectToManifest(HxOp op) {
            if (!SysJoinManifest.isAvailable(op)) {
                return false;
            }
            BNiagaraStation station = (BNiagaraStation)op.get().asComponent().getParent();
            SysJoinManifest manifest = SysJoinManifest.getForSession(op);
            if (!station.getStationName().equals(manifest.getStation().getStationName())) {
                return false;
            }
            BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
            return service.getMonitorSysDefSecurity().isSecuritySubordinate(station.getStationName());
        }

        @Override
        public BOrd getOrd(HxOp op) {
            if (!this.redirectToManifest(op)) {
                return super.getOrd(op);
            }
            BNiagaraStation station = (BNiagaraStation)op.get().asComponent().getParent();
            BNiagaraReplicationDeviceExt ext = (BNiagaraReplicationDeviceExt)station.getMixIn(BNiagaraReplicationDeviceExt.TYPE);
            return BOrd.make((String)("station:|" + ext.getSlotPathOrd()));
        }
    }

    public class ExportSchedules
    extends SmartCommand
    implements HxProgressJobDialog.IJobCompleteHandler {
        public ExportSchedules(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "exportSchedules";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public void invoke(BJob job, HxOp op) throws Exception {
            if (job.getJobState().equals((Object)BJobState.failed)) {
                BHxAbstractJobView.openErrorDialog(job, (Command)this, op);
                return;
            }
            if (job.getJobState().equals((Object)BJobState.success)) {
                BHxDistributedScheduleView.this.rediscover(op);
                return;
            }
        }

        public void handle(HxOp op) throws Exception {
            Object[] subjects = BHxQueryTableView.getSubjects(op);
            BScheduleExportInfo exportInfo = new BScheduleExportInfo();
            BVector supervisorIdsVector = new BVector();
            for (int i = 0; i < subjects.length; ++i) {
                BComponent subject = (BComponent)subjects[i];
                supervisorIdsVector.add("s" + i, (BValue)BString.make((String)subject.getSlotPathOrd().toString()));
            }
            exportInfo.setSupervisorIds(supervisorIdsVector);
            op.getRequest().getSession().setAttribute(op.scope("exportInfo"), (Object)exportInfo);
            BHxDistributedScheduleView.this.exportSchedulesEvent.handle(op);
            op.getHtmlWriter().w((Object)"setTimeout('hx.poll();', 750);");
        }
    }

    public class AddDiscovered
    extends SmartCommand
    implements HxProgressJobDialog.IJobCompleteHandler {
        public AddDiscovered(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "addDiscovered";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void invoke(BJob job, HxOp op) throws Exception {
            if (job.getJobState().equals((Object)BJobState.failed)) {
                BHxAbstractJobView.openErrorDialog(job, (Command)this, op);
            } else if (job.getJobState().equals((Object)BJobState.success)) {
                BHxDistributedScheduleView.this.rediscover(op);
            }
        }

        public void handle(HxOp op) throws Exception {
            BHxDistributedScheduleView.this.addDiscoveredEvent.handle(op);
            op.getHtmlWriter().w((Object)"setTimeout('hx.poll();', 750);");
        }
    }
}

