/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.access.schedule;

import com.tridium.hx.ErrorDialog;
import com.tridium.schedule.ScheduleValidator;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.HxSaveCommand;
import com.tridium.smartTableHx.SaveCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.TableContents;
import com.tridiumx.entsecHx.access.schedule.ViewUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.schedule.BCustomSchedule;
import javax.baja.schedule.BDateRangeSchedule;
import javax.baja.schedule.BDateSchedule;
import javax.baja.schedule.BScheduleReference;
import javax.baja.schedule.BWeekAndDaySchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BEnumSet;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconModule;
import javax.baja.util.LexiconText;

@NiagaraType
abstract class BAbstractEventsTable
extends BHxSmartTableView {
    public static final Type TYPE = Sys.loadType(BAbstractEventsTable.class);
    protected static final Lexicon scheduleLex = Lexicon.make((String)"schedule");
    private static final String[] weekdays = new String[]{scheduleLex.getText("weekday.anyWeekday"), BWeekday.sunday.getDisplayTag(null), BWeekday.monday.getDisplayTag(null), BWeekday.tuesday.getDisplayTag(null), BWeekday.wednesday.getDisplayTag(null), BWeekday.thursday.getDisplayTag(null), BWeekday.friday.getDisplayTag(null), BWeekday.saturday.getDisplayTag(null)};
    private static final String[] weeks = new String[]{scheduleLex.getText("week.anyWeek"), scheduleLex.getText("week.week") + ' ' + 1, scheduleLex.getText("week.week") + ' ' + 2, scheduleLex.getText("week.week") + ' ' + 3, scheduleLex.getText("week.week") + ' ' + 4, scheduleLex.getText("week.week") + ' ' + 5, scheduleLex.getText("dayofmonth.last7days")};
    private static final String[] days = new String[32];
    private static final String[] months = new String[]{scheduleLex.getText("month.anyMonth"), BMonth.january.getShortDisplayTag(null), BMonth.february.getShortDisplayTag(null), BMonth.march.getShortDisplayTag(null), BMonth.april.getShortDisplayTag(null), BMonth.may.getShortDisplayTag(null), BMonth.june.getShortDisplayTag(null), BMonth.july.getShortDisplayTag(null), BMonth.august.getShortDisplayTag(null), BMonth.september.getShortDisplayTag(null), BMonth.october.getShortDisplayTag(null), BMonth.november.getShortDisplayTag(null), BMonth.december.getShortDisplayTag(null)};
    private static final String[] complexMonths = new String[]{scheduleLex.getText("month.anyMonth"), BMonth.january.getShortDisplayTag(null), BMonth.february.getShortDisplayTag(null), BMonth.march.getShortDisplayTag(null), BMonth.april.getShortDisplayTag(null), BMonth.may.getShortDisplayTag(null), BMonth.june.getShortDisplayTag(null), BMonth.july.getShortDisplayTag(null), BMonth.august.getShortDisplayTag(null), BMonth.september.getShortDisplayTag(null), BMonth.october.getShortDisplayTag(null), BMonth.november.getShortDisplayTag(null), BMonth.december.getShortDisplayTag(null), scheduleLex.getText("month.jan_mar_may_jul_sep_nov"), scheduleLex.getText("month.feb_apr_jun_aug_oct_dec")};
    private static final BFacets options;
    public static BEnumRange eventTypesForWeekly;
    public static BEnumRange eventTypes;
    private static final String EDIT_ERROR_ATTRIBUTE = "hx.scheduler.eventEditError";
    private static final String NEW_EVENT_ATTRIBUTE = "hx.scheduler.newEvent";
    protected SmartCommand tableCommand;
    protected SmartCommand delete = new Delete((BHxView)this);
    protected SmartCommand edit;
    protected SmartCommand save;
    protected SmartCommand moveUp;
    protected SmartCommand moveDown;
    protected SmartCommand add;
    protected SmartCommand rename;
    protected SmartCommand preSave;
    protected Command editNew;

    public Type getType() {
        return TYPE;
    }

    protected BAbstractEventsTable() {
        this.registerEvent((Event)this.delete);
        this.edit = new Edit((BHxView)this);
        this.registerEvent((Event)this.edit);
        this.rename = new Rename((BHxView)this);
        this.registerEvent((Event)this.rename);
        this.add = new Add((BHxView)this);
        this.registerEvent((Event)this.add);
        this.save = new HxSaveCommand((BHxView)this);
        this.registerEvent((Event)this.save);
        this.preSave = new HxSaveCommand.HxPreSaveCommand((BHxView)this);
        this.registerEvent((Event)this.preSave);
        this.moveUp = new MoveUp((BHxView)this);
        this.registerEvent((Event)this.moveUp);
        this.moveDown = new MoveDown((BHxView)this);
        this.registerEvent((Event)this.moveDown);
        this.tableCommand = new TableCommand((BHxView)this);
        this.registerEvent((Event)this.tableCommand);
        this.editNew = new EditNew((BHxView)this);
        this.registerEvent((Event)this.editNew);
    }

    public void writeTableHeader(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        Lexicon lex = ViewUtil.getScheduleLexicon(op);
        out.w((Object)"<th>");
        out.safe((Object)lex.getText("name"));
        out.w((Object)"</th>");
        out.w((Object)"<th>");
        out.safe((Object)lex.getText("summary"));
        out.w((Object)"</th>");
    }

    abstract BCompositeSchedule getSchedule(HxOp var1);

    abstract BAbstractSchedule[] getEvents(HxOp var1);

    abstract BAbstractSchedule getAbstractSchedule(BAbstractSchedule var1, HxOp var2);

    abstract BAbstractSchedule getNewSchedule(BAbstractSchedule var1, HxOp var2);

    abstract BAbstractSchedule getEventScheduleFromContainer(EditSpecialEventHandler var1, BCompositeSchedule var2, HxOp var3);

    abstract BAbstractSchedule getEventSchedule(EditSpecialEventHandler var1, BCompositeSchedule var2, HxOp var3);

    public void write(HxOp op) throws Exception {
        op.jQuery();
        op.addStyleSheet(BOrd.make((String)"module://schedule/com/tridium/schedule/hx/schedule.css"));
        op.addJavaScript(BOrd.make((String)"module://schedule/com/tridium/schedule/hx/schedule.js"));
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/save.js"));
        this.preSave.addOnload(op);
        super.write(op);
    }

    public TableContents writeContents(HxOp op) throws Exception {
        BAbstractSchedule[] events;
        TableContents contents = new TableContents(op.scope("records"));
        Lexicon lex = ViewUtil.getScheduleLexicon(op);
        contents.columns.td.add(new TableContents.Td(lex.getText("name")));
        contents.columns.td.add(new TableContents.Td(lex.getText("summary")));
        for (BAbstractSchedule event : events = this.getEvents(op)) {
            TableContents.Tr tr = new TableContents.Tr();
            tr.id = op.scope(event.getName());
            tr.td.add(new TableContents.Td(event.getDisplayName((Context)op)));
            tr.td.add(new TableContents.Td(this.getAbstractSchedule(event, op).toString((Context)op)));
            contents.tr.add(tr);
        }
        return contents;
    }

    public SmartCommand[] getButtonCommands(HxOp op) {
        if (op.getPath().isEmpty()) {
            return new SmartCommand[]{this.save, this.add, this.edit, this.moveUp, this.moveDown, this.rename, this.delete, this.exportCommand};
        }
        return new SmartCommand[]{this.add, this.edit, this.moveUp, this.moveDown, this.rename, this.delete, this.exportCommand};
    }

    public void fixLastSpecialEvent(String oldName, String newName, HxOp op) throws Exception {
        String lastSpecialEvent = op.getFormValue("lastSpecialEvent");
        if (Objects.equals(lastSpecialEvent, oldName)) {
            SmartCommand.setFormValue((String)op.scope("lastSpecialEvent"), (Object)newName, (HxOp)op);
        }
    }

    private static String generateName(String base, BAbstractSchedule schedule) {
        String gen = base;
        int i = 0;
        while (schedule.getProperty(gen) != null) {
            gen = base + ++i;
        }
        return gen;
    }

    public BAbstractSchedule getEvent(HxOp op, String propName) {
        return (BAbstractSchedule)this.getParentOfEvents(op).get(propName);
    }

    public BCompositeSchedule getParentOfEvents(HxOp op) {
        return this.getSchedule(op);
    }

    private static String getPropName(String id) {
        String[] parts = id.split("\\.");
        return parts.length > 0 ? parts[parts.length - 1] : "";
    }

    private static void writeDay(String name, int selected, HxOp op) throws Exception {
        BAbstractEventsTable.writeDay(name, new int[]{selected}, false, op);
    }

    private static void writeDay(String name, int[] selected, boolean allowMultiple, HxOp op) throws Exception {
        for (int i = 0; i < selected.length; ++i) {
            if (selected[i] <= 0) continue;
            int n = i;
            selected[n] = selected[n] - 1;
        }
        BAbstractEventsTable.writeList(days, name, selected, allowMultiple, op);
    }

    private static void writeWeek(int selected, HxOp op) throws Exception {
        BAbstractEventsTable.writeWeek(new int[]{selected}, false, op);
    }

    private static void writeWeek(int[] selected, boolean allowMultiple, HxOp op) throws Exception {
        for (int i = 0; i < selected.length; ++i) {
            if (selected[i] <= 0) continue;
            int n = i;
            selected[n] = selected[n] - 1;
        }
        BAbstractEventsTable.writeList(weeks, "week", selected, allowMultiple, op);
    }

    private static void writeYear(String name, int selected, HxOp op) throws Exception {
        BAbstractEventsTable.writeYear(name, new int[]{selected}, false, op);
    }

    private static void writeYear(String name, int[] selected, boolean allowMultiple, HxOp op) throws Exception {
        for (int i = 0; i < selected.length; ++i) {
            if (selected[i] <= 0) continue;
            int n = i;
            selected[n] = selected[n] - BAbsTime.now().getYear();
        }
        BAbstractEventsTable.writeList(BAbstractEventsTable.getYearList(), name, selected, allowMultiple, op);
    }

    private static void writeList(String[] list, String name, int selected, HxOp op) throws Exception {
        BAbstractEventsTable.writeList(list, name, new int[]{selected}, false, op);
    }

    private static void writeList(String[] list, String name, int[] selected, boolean allowMultiple, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<select ");
        out.attr("style", "float:left");
        if (allowMultiple) {
            out.attr("onchange", "schedule.multiSelectChanged(this)");
            out.w((Object)" multiple ");
            out.attr("size", Math.min(13, list.length));
        }
        out.attr("name", op.scope(name)).w((Object)">");
        for (int i = 0; i < list.length; ++i) {
            out.w((Object)"<option value='").w(i - 1).w((Object)"'");
            for (int selectedItem : selected) {
                if (i != selectedItem + 1) continue;
                out.w((Object)" selected='selected'");
            }
            out.w((Object)">").w((Object)list[i]).w((Object)"</option>");
        }
        out.w((Object)"</select>");
    }

    private static void writeList(String[] list, String selected, HxOp op) throws Exception {
        BAbstractEventsTable.writeList(list, new String[]{selected}, false, op);
    }

    private static void writeList(String[] list, String[] selected, boolean allowMultiple, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<select ");
        out.attr("style", "float:left");
        if (allowMultiple) {
            out.attr("onchange", "schedule.multiSelectChanged(this)");
            out.w((Object)" multiple ");
            out.attr("size", Math.min(13, list.length));
        }
        out.attr("name", op.scope("reference")).w((Object)">");
        out.w((Object)"<option value='none'");
        out.w((Object)">").w((Object)"None").w((Object)"</option>");
        for (String item : list) {
            out.w((Object)"<option value='").w((Object)item).w((Object)"'");
            for (String selectedItem : selected) {
                if (!item.equals(selectedItem)) continue;
                out.w((Object)" selected='selected'");
            }
            out.w((Object)">").w((Object)item).w((Object)"</option>");
        }
        out.w((Object)"</select>");
    }

    private static String[] getCalendarRefList() {
        ArrayList<String> a = new ArrayList<String>();
        BOrd query = BOrd.make((String)"station:|slot:/|bql: select slotPathOrd from schedule:CalendarSchedule where parent.type != schedule:AbstractSchedule");
        BITable t = (BITable)query.get();
        Column col = t.getColumns().get(0);
        TableCursor c = t.cursor();
        while (c.next()) {
            a.add(c.cell(col).toString(null));
        }
        return a.toArray(new String[a.size()]);
    }

    public static String[] getYearList() {
        String[] years = new String[11];
        years[0] = scheduleLex.getText("year.anyYear");
        int y = BAbsTime.now().getYear();
        for (int i = 1; i < years.length; ++i) {
            years[i] = Integer.toString(y + i - 1);
        }
        return years;
    }

    static {
        BAbstractEventsTable.days[0] = scheduleLex.getText("dayofmonth.anyDay");
        for (int i = 1; i < days.length; ++i) {
            BAbstractEventsTable.days[i] = Integer.toString(i);
        }
        options = BFacets.make((String)"lexicon", (String)Sys.getModuleForClass(BAbstractEventsTable.class).getModuleName());
        eventTypesForWeekly = BEnumRange.make(null, (int[])new int[]{0, 1, 2, 3, 4}, (String[])new String[]{"dateSchedule", "dateRangeSchedule", "weekAndDaySchedule", "customSchedule", "scheduleReference"}, (int)5, (BFacets)options);
        eventTypes = BEnumRange.make(null, (int[])new int[]{0, 1, 2, 3, 3}, (String[])new String[]{"dateSchedule", "dateRangeSchedule", "weekAndDaySchedule", "customSchedule"}, (int)4, (BFacets)options);
    }

    public class EditHandlerDelegate {
        private final EditSpecialEventHandler handler;
        private final EditDialog dlg;

        protected EditHandlerDelegate(EditSpecialEventHandler handler) {
            this.handler = handler;
            this.dlg = new EditDialog(handler);
        }

        public void doHandle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            BCompositeSchedule specialEvents = BAbstractEventsTable.this.getParentOfEvents(op);
            BAbstractSchedule specialEvent = BAbstractEventsTable.this.getEventScheduleFromContainer(this.handler, specialEvents, op);
            if (specialEvent instanceof BDateSchedule) {
                int weekday = Integer.parseInt(op.getFormValue("weekday"));
                int day = Integer.parseInt(op.getFormValue("day"));
                int month = Integer.parseInt(op.getFormValue("month"));
                int year = Integer.parseInt(op.getFormValue("year"));
                if (day != -1) {
                    ++day;
                }
                if (year != -1) {
                    year += BAbsTime.now().getYear();
                }
                BDateSchedule ds = (BDateSchedule)specialEvent;
                ds.setWeekday(weekday);
                ds.setDay(day);
                ds.setMonth(month);
                ds.setYear(year);
            } else if (specialEvent instanceof BDateRangeSchedule) {
                int day = Integer.parseInt(op.getFormValue("day"));
                int month = Integer.parseInt(op.getFormValue("month"));
                int year = Integer.parseInt(op.getFormValue("year"));
                if (day != -1) {
                    ++day;
                }
                if (year != -1) {
                    year += BAbsTime.now().getYear();
                }
                BDateRangeSchedule ds = (BDateRangeSchedule)specialEvent;
                BDateSchedule start = ds.getStart();
                start.setDay(day);
                start.setMonth(month);
                start.setYear(year);
                day = Integer.parseInt(op.getFormValue("day2"));
                month = Integer.parseInt(op.getFormValue("month2"));
                year = Integer.parseInt(op.getFormValue("year2"));
                if (day != -1) {
                    ++day;
                }
                if (year != -1) {
                    year += BAbsTime.now().getYear();
                }
                BDateSchedule end = ds.getEnd();
                end.setDay(day);
                end.setMonth(month);
                end.setYear(year);
            } else if (specialEvent instanceof BWeekAndDaySchedule) {
                int weekday = Integer.parseInt(op.getFormValue("weekday"));
                int week = Integer.parseInt(op.getFormValue("week"));
                int month = Integer.parseInt(op.getFormValue("month"));
                BWeekAndDaySchedule ds = (BWeekAndDaySchedule)specialEvent;
                ds.setWeekday(weekday);
                if (week != -1) {
                    ++week;
                }
                ds.setWeek(week);
                ds.setMonth(month);
            } else if (specialEvent instanceof BCustomSchedule) {
                int i;
                int[] weeks = this.getIntArrayFromForm("weekMultiple", op);
                int[] weekdays = this.getIntArrayFromForm("weekdayMultiple", op);
                int[] days = this.getIntArrayFromForm("dayMultiple", op);
                int[] months = this.getIntArrayFromForm("monthMultiple", op);
                int year = Integer.parseInt(op.getFormValue("year"));
                if (days != null) {
                    for (i = 0; i < days.length; ++i) {
                        if (days[i] == -1) continue;
                        int n = i;
                        days[n] = days[n] + 1;
                    }
                }
                if (year != -1) {
                    year += BAbsTime.now().getYear();
                }
                if (weeks != null) {
                    for (i = 0; i < weeks.length; ++i) {
                        if (weeks[i] == -1) continue;
                        int n = i;
                        weeks[n] = weeks[n] + 1;
                    }
                }
                BCustomSchedule ds = (BCustomSchedule)specialEvent;
                if (weekdays != null) {
                    ds.getWeekdays().clear();
                    for (int weekday : weekdays) {
                        if (weekday == -1) continue;
                        ds.getWeekdays().add(weekday);
                    }
                }
                if (weeks != null) {
                    ds.getWeeksOfMonth().clear();
                    for (int week : weeks) {
                        if (week == -1) continue;
                        ds.getWeeksOfMonth().add(week);
                    }
                }
                if (days != null) {
                    ds.getDaysOfMonth().clear();
                    for (int day : days) {
                        if (day == -1) continue;
                        ds.getDaysOfMonth().add(day);
                    }
                }
                if (months != null) {
                    ds.getMonths().clear();
                    for (int month : months) {
                        if (month == -1) continue;
                        ds.getMonths().add(month);
                    }
                }
                ds.getYear().initYear(year).setAlwaysEffective(year < 0);
            } else if (specialEvent instanceof BScheduleReference) {
                BScheduleReference ds = (BScheduleReference)specialEvent;
                String ref = op.getUnsafeFormValue("reference");
                if ("none".equals(ref)) {
                    ds.setRef(BOrd.NULL);
                } else {
                    ds.setRef(BOrd.make((String)ref));
                }
            }
            Exception err = null;
            try {
                ScheduleValidator.validate((BAbstractSchedule)specialEvent, (Context)op);
            }
            catch (Exception x) {
                err = x;
            }
            if (err == null) {
                this.handler.onEditValidated(specialEvents, BAbstractEventsTable.this.getEventSchedule(this.handler, specialEvents, op), op);
                SaveCommand.setModified((HxOp)op);
            } else {
                HtmlWriter out = op.getHtmlWriter();
                op.getRequest().getSession().setAttribute(BAbstractEventsTable.EDIT_ERROR_ATTRIBUTE, (Object)err);
                String quote = HxUtil.getInnerQuote((HxOp)op);
                out.w((Object)SmartCommand.getInvokeCode((Command)this.handler.asCommand(), (String)quote, (HxOp)op));
            }
        }

        private int[] getIntArrayFromForm(String formName, HxOp op) {
            String formValue = op.getFormValue(formName);
            if (formValue == null) {
                return null;
            }
            String[] form = TextUtil.split((String)formValue, (char)';');
            int[] ints = new int[form.length];
            for (int i = 0; i < form.length; ++i) {
                ints[i] = Integer.parseInt(form[i]);
            }
            return ints;
        }

        private class EditDialog
        extends Dialog {
            EditDialog(EditSpecialEventHandler handler) {
                super(handler.getDialogTitle(), handler.asCommand());
            }

            protected void writeContent(HxOp op) throws Exception {
                HtmlWriter out = op.getHtmlWriter();
                Exception err = (Exception)op.getRequest().getSession().getAttribute(BAbstractEventsTable.EDIT_ERROR_ATTRIBUTE);
                if (err != null) {
                    out.w((Object)"<div ").attr("class", "schedule-HxScheduler-editValidationError").w((Object)">").w((Object)err.getMessage()).w((Object)"</div>");
                    op.getRequest().getSession().removeAttribute(BAbstractEventsTable.EDIT_ERROR_ATTRIBUTE);
                }
                out.w((Object)"<table><tr><td ").attr("style", "text-align:top").w((Object)">");
                out.w((Object)"<span ").attr("style", "text-align:top").w((Object)">");
                BCompositeSchedule specialEvents = BAbstractEventsTable.this.getParentOfEvents(op);
                BAbstractSchedule specialEvent = EditHandlerDelegate.this.handler.getEventSchedule(specialEvents, op);
                BAbstractSchedule daysSchedule = null;
                if (specialEvent != null) {
                    daysSchedule = BAbstractEventsTable.this.getAbstractSchedule(specialEvent, op);
                }
                if (daysSchedule instanceof BDateSchedule) {
                    BDateSchedule ds = (BDateSchedule)daysSchedule;
                    BAbstractEventsTable.writeList(weekdays, "weekday", ds.getWeekday(), op);
                    BAbstractEventsTable.writeDay("day", ds.getDay(), op);
                    BAbstractEventsTable.writeList(months, "month", ds.getMonth(), op);
                    BAbstractEventsTable.writeYear("year", ds.getYear(), op);
                } else if (daysSchedule instanceof BDateRangeSchedule) {
                    BDateRangeSchedule ds = (BDateRangeSchedule)daysSchedule;
                    BDateSchedule start = ds.getStart();
                    BDateSchedule end = ds.getEnd();
                    out.w((Object)"<span ").attr("style", "display:block").w((Object)">");
                    BAbstractEventsTable.writeDay("day", start.getDay(), op);
                    BAbstractEventsTable.writeList(months, "month", start.getMonth(), op);
                    BAbstractEventsTable.writeYear("year", start.getYear(), op);
                    out.w((Object)"</span>");
                    out.w((Object)"<span ").attr("style", "display:block").w((Object)">");
                    out.w((Object)"<br/>");
                    out.w((Object)"<br/>");
                    out.safe((Object)scheduleLex.getText("daterange.through"));
                    out.w((Object)"<br/>");
                    out.w((Object)"<br/>");
                    out.w((Object)"</span>");
                    out.w((Object)"<span ").attr("style", "display:block").w((Object)">");
                    BAbstractEventsTable.writeDay("day2", end.getDay(), op);
                    BAbstractEventsTable.writeList(months, "month2", end.getMonth(), op);
                    BAbstractEventsTable.writeYear("year2", end.getYear(), op);
                    out.w((Object)"</span>");
                } else if (daysSchedule instanceof BWeekAndDaySchedule) {
                    BWeekAndDaySchedule ds = (BWeekAndDaySchedule)daysSchedule;
                    BAbstractEventsTable.writeList(weekdays, "weekday", ds.getWeekday(), op);
                    BAbstractEventsTable.writeWeek(ds.getWeek(), op);
                    BAbstractEventsTable.writeList(complexMonths, "month", ds.getMonth(), op);
                } else if (daysSchedule instanceof BCustomSchedule) {
                    BCustomSchedule ds = (BCustomSchedule)daysSchedule;
                    BEnumSet set = ds.getDaysOfMonth().getSet();
                    int[] ordinals = !set.isNull() ? set.getOrdinals() : new int[]{-1};
                    BAbstractEventsTable.writeDay("day", ordinals, true, op);
                    set = ds.getMonths().getSet();
                    ordinals = !set.isNull() ? set.getOrdinals() : new int[]{-1};
                    BAbstractEventsTable.writeList(months, "month", ordinals, true, op);
                    set = ds.getWeekdays().getSet();
                    ordinals = !set.isNull() ? set.getOrdinals() : new int[]{-1};
                    BAbstractEventsTable.writeList(weekdays, "weekday", ordinals, true, op);
                    set = ds.getWeeksOfMonth().getSet();
                    ordinals = !set.isNull() ? set.getOrdinals() : new int[]{-1};
                    BAbstractEventsTable.writeWeek(ordinals, true, op);
                    BAbstractEventsTable.writeYear("year", ds.getYear().getYear(), op);
                } else if (daysSchedule instanceof BScheduleReference) {
                    BScheduleReference ds = (BScheduleReference)daysSchedule;
                    BAbstractEventsTable.writeList(BAbstractEventsTable.getCalendarRefList(), ds.getRef().toString(), op);
                }
                out.w((Object)"</span></td></tr></table>");
            }
        }
    }

    private class EditNew
    extends Command
    implements EditSpecialEventHandler {
        private final EditHandlerDelegate delegate;

        private EditNew(BHxView view) {
            super(view);
            this.delegate = new EditHandlerDelegate(this);
        }

        public void handle(HxOp op) throws Exception {
            this.delegate.doHandle(op);
        }

        @Override
        public String getDialogTitle() {
            return BAbstractEventsTable.this.add.getDisplayName(null);
        }

        @Override
        public BAbstractSchedule getEventSchedule(BCompositeSchedule specialEvents, HxOp op) {
            NewSpecialEventInfo args = this.getNewEventInfo(op);
            return args.newEvent;
        }

        @Override
        public void onEditValidated(BCompositeSchedule specialEvents, BAbstractSchedule event, HxOp op) throws Exception {
            NewSpecialEventInfo args = this.getNewEventInfo(op);
            this.clearNewEventInfo(op);
            String id = SlotPath.escape((String)args.displayName);
            String summary = event.toString((Context)op);
            specialEvents.add(id, (BValue)event, (Context)op);
            HtmlWriter out = op.getHtmlWriter();
            String cls = "ux-table-row";
            out.w((Object)"var table = hx.$('").w((Object)op.scope("records")).w((Object)"');");
            out.w((Object)"var row=table.insertRow(table.rows.length);");
            out.w((Object)"row.id='").w((Object)op.scope(id)).w((Object)"';");
            out.w((Object)"row.className='").w((Object)cls).w((Object)"';");
            out.w((Object)"var cell=row.insertCell(row.cells.length);");
            out.w((Object)"cell.textContent=\"");
            out.w((Object)HxUtil.escapeJsStringLiteral((String)args.displayName));
            out.w((Object)"\";");
            out.w((Object)"cell=row.insertCell(row.cells.length);");
            out.w((Object)"cell.textContent=\"");
            out.w((Object)HxUtil.escapeJsStringLiteral((String)summary));
            out.w((Object)"\";");
            out.w((Object)"smartTable.syntheticMouseDown(row.firstChild);");
        }

        @Override
        public Command asCommand() {
            return this;
        }

        private NewSpecialEventInfo getNewEventInfo(HxOp op) {
            NewSpecialEventInfo args = (NewSpecialEventInfo)op.getRequest().getSession().getAttribute(BAbstractEventsTable.NEW_EVENT_ATTRIBUTE);
            if (args == null) {
                throw new IllegalStateException();
            }
            return args;
        }

        private void clearNewEventInfo(HxOp op) {
            op.getRequest().getSession().removeAttribute(BAbstractEventsTable.NEW_EVENT_ATTRIBUTE);
        }
    }

    public class Edit
    extends SmartCommand
    implements EditSpecialEventHandler {
        private final EditHandlerDelegate delegate;

        public Edit(BHxView view) {
            super(view, LexiconModule.make((String)"queryTable"));
            this.delegate = new EditHandlerDelegate(this);
        }

        public void handle(HxOp op) throws Exception {
            this.delegate.doHandle(op);
        }

        public boolean isDefaultAction() {
            return true;
        }

        public String getName(HxOp op) {
            return "edit";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        @Override
        public String getDialogTitle() {
            return this.getDisplayName(null);
        }

        @Override
        public BAbstractSchedule getEventSchedule(BCompositeSchedule specialEvents, HxOp op) {
            String[] propNames = SmartCommand.getSelectionList((HxOp)op);
            String name = propNames[0];
            int pathLength = op.getPath().length();
            int prefixLength = pathLength == 0 ? 0 : pathLength + 1;
            return (BAbstractSchedule)specialEvents.get(name.substring(prefixLength));
        }

        @Override
        public void onEditValidated(BCompositeSchedule specialEvents, BAbstractSchedule event, HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            String summary = BAbstractEventsTable.this.getAbstractSchedule(event, op).toString((Context)op);
            out.w((Object)"var elem = hx.$('").w((Object)op.scope(event.getName())).w((Object)"');");
            out.w((Object)"elem.firstChild.nextSibling.textContent='").safe((Object)HxUtil.escapeJsStringLiteral((String)summary));
            out.w((Object)"';");
        }

        @Override
        public Command asCommand() {
            return this;
        }
    }

    protected static interface EditSpecialEventHandler {
        public String getDialogTitle();

        public BAbstractSchedule getEventSchedule(BCompositeSchedule var1, HxOp var2);

        public void onEditValidated(BCompositeSchedule var1, BAbstractSchedule var2, HxOp var3) throws Exception;

        public Command asCommand();
    }

    public class Rename
    extends SmartCommand {
        private final RenameDialog dlg;

        public Rename(BHxView view) {
            super(view);
            this.dlg = new RenameDialog((Command)this, this.getDisplayName(null));
        }

        public String getName(HxOp op) {
            return "rename";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            SaveCommand.setModified((HxOp)op);
            String[] propNames = Rename.getSelectionList((HxOp)op);
            int pathLength = op.getPath().length();
            int prefixLength = pathLength == 0 ? 0 : pathLength + 1;
            BAbstractSchedule specialEvent = BAbstractEventsTable.this.getEvent(op, propNames[0].substring(prefixLength));
            BString value = BString.make((String)specialEvent.getName());
            BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)value, (Context)op);
            BObject newValue = editor.save(op.make("displayName", (BObject)value, null));
            if (!newValue.toString().equals(value.toString())) {
                String displayName = newValue.toString();
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)"var elem = hx.$('").w((Object)op.scope(specialEvent.getName())).w((Object)"');");
                out.w((Object)"elem.firstChild.textContent='").safe((Object)HxUtil.escapeJsStringLiteral((String)displayName));
                out.w((Object)"';");
                BAbstractEventsTable.this.fixLastSpecialEvent(specialEvent.getName(), SlotPath.escape((String)displayName), op);
                out.w((Object)"smartTable.remove(elem);");
                out.w((Object)"elem.id='").safe((Object)op.scope(SlotPath.escape((String)displayName)));
                out.w((Object)"';");
                out.w((Object)"smartTable.add(elem);");
                BAbstractEventsTable.this.getParentOfEvents(op).rename(specialEvent.getPropertyInParent(), SlotPath.escape((String)displayName), (Context)op);
                out.w((Object)"smartTable.unselectFromElem(hx.$('").w((Object)op.scope("records")).w((Object)"'));");
            }
        }

        private class RenameDialog
        extends Dialog {
            RenameDialog(Command handler, String title) {
                super(title, handler);
            }

            protected void writeContent(HxOp op) throws Exception {
                String[] propNames = SmartCommand.getSelectionList((HxOp)op);
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)"<table>");
                out.w((Object)"<tr><td ");
                out.attr("class", "smartTable-setup-label");
                out.w((Object)">");
                out.safe((Object)Rename.this.lexModule.getText("displayName", (Context)op));
                out.w((Object)"</td><td>");
                int pathLength = op.getPath().length();
                int prefixLength = pathLength == 0 ? 0 : pathLength + 1;
                BAbstractSchedule specialEvent = BAbstractEventsTable.this.getEvent(op, propNames[0].substring(prefixLength));
                BString value = BString.make((String)specialEvent.getDisplayName((Context)op));
                BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)value, (Context)op);
                editor.write(op.make("displayName", (BObject)value, null));
                out.w((Object)"</td></tr>");
                out.w((Object)"</table>");
            }
        }
    }

    private static class NewSpecialEventInfo {
        private final String displayName;
        private final BAbstractSchedule newEvent;

        private NewSpecialEventInfo(String displayName, BAbstractSchedule newEvent) {
            this.displayName = displayName;
            this.newEvent = newEvent;
        }
    }

    public class Add
    extends SmartCommand {
        private final AddDialog dlg;
        private String eventValue;

        public Add(BHxView view) {
            super(view, LexiconModule.make((String)"queryTable"));
            this.dlg = new AddDialog((Command)this, this.getDisplayName(null));
        }

        public String getName(HxOp op) {
            return "add";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            BString value = BString.make((String)"");
            BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)value, (Context)op);
            this.eventValue = editor.save(op.make("displayName", (BObject)value, null)).toString();
            BCompositeSchedule parentOfEvents = BAbstractEventsTable.this.getParentOfEvents(op);
            if (parentOfEvents.get(this.eventValue) != null) {
                Lexicon lex = ViewUtil.getScheduleLexicon(op);
                ScheduleErrorDialog dialog = new ScheduleErrorDialog(UiLexicon.bajaui().getText("dialog.error"), lex.getText("composite.nameAlreadyInUse"));
                dialog.open(op);
                return;
            }
            Type scheduleType = op.get().getType();
            value = BDynamicEnum.make((int)0, (BEnumRange)(scheduleType.is(BWeeklySchedule.TYPE) ? eventTypesForWeekly : eventTypes));
            editor = BHxFieldEditor.makeFor((BObject)value, (Context)op);
            BDynamicEnum type = (BDynamicEnum)editor.save(op.make("type", (BObject)value, null));
            BDateSchedule abs = null;
            switch (type.getOrdinal()) {
                case 0: {
                    abs = new BDateSchedule();
                    break;
                }
                case 1: {
                    abs = new BDateRangeSchedule();
                    break;
                }
                case 2: {
                    abs = new BWeekAndDaySchedule();
                    break;
                }
                case 3: {
                    abs = new BCustomSchedule();
                    break;
                }
                case 4: {
                    abs = new BScheduleReference();
                }
            }
            BAbstractSchedule dailySchedule = BAbstractEventsTable.this.getNewSchedule((BAbstractSchedule)abs, op);
            String displayName = this.eventValue;
            this.eventValue = null;
            op.getRequest().getSession().setAttribute(BAbstractEventsTable.NEW_EVENT_ATTRIBUTE, (Object)new NewSpecialEventInfo(displayName, dailySchedule));
            HtmlWriter out = op.getHtmlWriter();
            String quote = HxUtil.getInnerQuote((HxOp)op);
            out.w((Object)SmartCommand.getInvokeCode((Command)BAbstractEventsTable.this.editNew, (String)quote, (HxOp)op));
        }

        private class AddDialog
        extends Dialog {
            AddDialog(Command handler, String title) {
                super(title, handler);
            }

            public Command[] getCommands() {
                return new Command[]{new ConfirmSubmit(), new EventCancel()};
            }

            protected void writeContent(HxOp op) throws Exception {
                BString value;
                BCompositeSchedule specialEvents = BAbstractEventsTable.this.getParentOfEvents(op);
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)"<table>");
                out.w((Object)"<tr><td ");
                out.attr("class", "smartTable-setup-label");
                out.w((Object)">");
                out.safe((Object)Add.this.lexModule.getText("displayName", (Context)op));
                out.w((Object)"</td><td>");
                if (Add.this.eventValue == null) {
                    Add.this.eventValue = Add.this.lexModule.getText("Event", (Context)op);
                    value = BString.make((String)BAbstractEventsTable.generateName(Add.this.eventValue, (BAbstractSchedule)specialEvents));
                } else {
                    value = BString.make((String)Add.this.eventValue);
                }
                BHxFieldEditor editor = BHxFieldEditor.makeFor((BObject)value, (Context)op);
                editor.write(op.make("displayName", (BObject)value, null));
                out.w((Object)"</td></tr>");
                out.w((Object)"<tr><td ");
                out.attr("class", "smartTable-setup-label");
                out.w((Object)">");
                out.safe((Object)Add.this.lexModule.getText("type", (Context)op));
                out.w((Object)"</td><td>");
                Type scheduleType = op.get().getType();
                value = BDynamicEnum.make((int)0, (BEnumRange)(scheduleType.is(BWeeklySchedule.TYPE) ? eventTypesForWeekly : eventTypes));
                editor = BHxFieldEditor.makeFor((BObject)value, (Context)op);
                editor.write(op.make("type", (BObject)value, null));
                out.w((Object)"</td></tr>");
                out.w((Object)"</table>");
            }

            private class EventCancel
            extends Dialog.Cancel {
                private EventCancel() {
                    super((Dialog)AddDialog.this);
                }

                public String getInvokeCode(HxOp op) {
                    Add.this.eventValue = null;
                    return super.getInvokeCode(op);
                }
            }

            private class ConfirmSubmit
            extends Dialog.Submit {
                private ConfirmSubmit() {
                    super((Dialog)AddDialog.this, "submit", LexiconText.make((String)"bajaui", (String)"wizard.next.label"));
                }

                public String getInvokeCode(HxOp op) {
                    return "hx.closeDialog(&quot;" + op.getPath() + "&quot;,&quot;" + AddDialog.this.getHandler().getId() + "&quot;, event);";
                }
            }
        }

        public class ScheduleErrorDialog
        extends ErrorDialog {
            public ScheduleErrorDialog(String title, String message) {
                super("Error", null, message);
            }

            public Command[] getCommands() {
                return new Command[]{new MyCancel()};
            }

            protected class MyCancel
            extends Dialog.Cancel {
                public MyCancel() {
                    super((Dialog)ScheduleErrorDialog.this);
                }

                public String getInvokeCode(HxOp op) {
                    StringBuilder b = new StringBuilder();
                    try {
                        b.append(SmartCommand.getInvokeCode((Command)BAbstractEventsTable.this.add, (String)"&quot;", (HxOp)op));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    b.append("hx.closeDialog(null,null,null);");
                    return b.toString();
                }
            }
        }
    }

    public class Save
    extends SaveCommand {
        public Save(BHxView view) {
            super(view);
        }

        public void onHandle(HxOp op) throws Exception {
            BAbstractEventsTable.this.save(op);
            this.refresh(op);
        }
    }

    public class Delete
    extends SmartCommand {
        public Delete(BHxView view) {
            super(view, smartTableHxLexModule);
        }

        public String getName(HxOp op) {
            return "delete";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.anySelection;
        }

        public void handle(HxOp op) throws Exception {
            SaveCommand.setModified((HxOp)op);
            HtmlWriter out = op.getHtmlWriter();
            int pathLength = op.getPath().length();
            int prefixLength = pathLength == 0 ? 0 : pathLength + 1;
            for (String propName : Delete.getSelectionList((HxOp)op)) {
                String simpleName = propName.substring(prefixLength);
                BAbstractEventsTable.this.fixLastSpecialEvent(simpleName, "", op);
                BAbstractEventsTable.this.getParentOfEvents(op).remove(simpleName);
                out.w((Object)"var elem = hx.$('").w((Object)propName).w((Object)"');");
                out.w((Object)"smartTable.remove(elem);");
                out.w((Object)"smartTable.setForm('").w((Object)op.scope("")).w((Object)"');");
                out.w((Object)"elem.parentNode.removeChild(elem);");
            }
            String quote = HxUtil.getInnerQuote((HxOp)op);
            out.w((Object)("smartTable.fixCommands(" + quote + op.getPath() + quote + ");"));
            out.w((Object)"smartTable.unselectFromElem(hx.$('").w((Object)op.scope("records")).w((Object)"'));");
        }
    }

    public class MoveDown
    extends SmartCommand {
        public MoveDown(BHxView view) {
            super(view, LexiconModule.make((String)"queryTable"));
        }

        public String getName(HxOp op) {
            return "moveDown";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public String getEnablePolicyInvokeCode(HxOp op) {
            if (!op.canWrite() && !this.readonlyEnablePolicy(op)) {
                return "false";
            }
            String quote = HxUtil.getOuterQuote((HxOp)op);
            return "schedule.checkDisableDown(" + quote + op.getPath() + quote + ");";
        }

        public void handle(HxOp op) throws Exception {
            SaveCommand.setModified((HxOp)op);
            HtmlWriter out = op.getHtmlWriter();
            String selectedId = MoveDown.getSelectionList((HxOp)op)[0];
            String propName = BAbstractEventsTable.getPropName(selectedId);
            List<Property> props = Arrays.asList(BAbstractEventsTable.this.getParentOfEvents(op).getDynamicPropertiesArray());
            for (int i = 0; i < props.size() - 1; ++i) {
                Property p = props.get(i);
                if (!p.getName().equals(propName)) continue;
                int j = i + 1;
                Property otherProp = props.get(j);
                Collections.swap(props, i, j);
                out.w((Object)"var elem = hx.$('").w((Object)op.scope(otherProp.getName())).w((Object)"');");
                out.w((Object)"var otherElem = hx.$('").w((Object)selectedId).w((Object)"');");
                out.w((Object)"var parent = elem.parentNode;");
                out.w((Object)"parent.insertBefore(elem, otherElem);");
                String quote = HxUtil.getInnerQuote((HxOp)op);
                out.w((Object)("smartTable.fixCommands(" + quote + op.getPath() + quote + ");"));
                BAbstractEventsTable.this.getParentOfEvents(op).reorder(props.toArray(new Property[props.size()]));
                return;
            }
        }
    }

    public class MoveUp
    extends SmartCommand {
        public MoveUp(BHxView view) {
            super(view, LexiconModule.make((String)"queryTable"));
        }

        public String getName(HxOp op) {
            return "moveUp";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public String getEnablePolicyInvokeCode(HxOp op) {
            if (!op.canWrite() && !this.readonlyEnablePolicy(op)) {
                return "false";
            }
            String quote = HxUtil.getOuterQuote((HxOp)op);
            return "schedule.checkDisableUp(" + quote + op.getPath() + quote + ");";
        }

        public void handle(HxOp op) throws Exception {
            SaveCommand.setModified((HxOp)op);
            HtmlWriter out = op.getHtmlWriter();
            String selectedId = MoveUp.getSelectionList((HxOp)op)[0];
            String propName = BAbstractEventsTable.getPropName(selectedId);
            List<Property> props = Arrays.asList(BAbstractEventsTable.this.getParentOfEvents(op).getDynamicPropertiesArray());
            for (int i = 1; i < props.size(); ++i) {
                Property p = props.get(i);
                if (!p.getName().equals(propName)) continue;
                int j = i - 1;
                Property otherProp = props.get(j);
                Collections.swap(props, i, j);
                out.w((Object)"var elem = hx.$('").w((Object)selectedId).w((Object)"');");
                out.w((Object)"var otherElem = hx.$('").w((Object)op.scope(otherProp.getName())).w((Object)"');");
                out.w((Object)"var parent = elem.parentNode;");
                out.w((Object)"parent.insertBefore(elem, otherElem);");
                String quote = HxUtil.getInnerQuote((HxOp)op);
                out.w((Object)("smartTable.fixCommands(" + quote + op.getPath() + quote + ");"));
                BAbstractEventsTable.this.getParentOfEvents(op).reorder(props.toArray(new Property[props.size()]));
                return;
            }
        }
    }

    public static class TableCommand
    extends SmartCommand {
        public TableCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "table";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            String ord = op.getOrd().toString();
            int index = ord.indexOf("|view");
            ord = ord.substring(0, index);
            this.redirect(op, op.toUri(BOrd.make((String)ord)));
        }
    }
}

